
package FDL.workingmap;
import FDL.term.Term;

public interface WMApi0 {

    /*
     *	Term = Parameter list # Term list
     *	
     *	Parameter = obid | String {value} # String {type}
     *
     *	Common parameter types :
     *	  "s" : string
     *	  "t" : token
     *	  "n" : natural
     *	  "b" : boolean
     *  String and token are similar. However, intent is that
     *	strings are arbitrary one-use text, while tokens are 
     *  multi-use short text.
     */ 


    public ObjectId createObjectId() throws Exception;

    // All objects have an associated term
    public void put(ObjectId obid, Term t) throws Exception;
    public Term get(ObjectId obid) throws Exception;
 

    /* 
     *	Minimal functionality is the ability to create ObjectId's
     *	and store and retrieve terms. Using these three primitives
     *	one can implement their own organization of data within the fdl.
     *	However, one would anticipate certain organizational methods
     *	which would be common to broad categories of formal data.
     *	The following methods implement some basic organizational
     *	constructs. 
     *	  
     *	Advantages to using common methods :
     *	  - make use of common fdl tools available for browsing and
     *      exporting data.
     *	  - reduce communication overhead by using fewer more complex
     *	    methods compared to primitive methods.
     */

    /* 
     *	There are certain broad categories of objects that I would anticipate 
     *	would be common to all formal data. 
     *	
     *	currently recognized kinds include :
     *	   TERM - default
     *	   COM  - comment
     *	   DEF  - definition/abstraction	OMDOC-definition
     *	   STM  - statement/lemma		OMDOC-assertion
     *	   PRF  - proof				OMDOC-proof
     *	   INF  - inference step
     *	   CODE - code
     *	   AXM  - axiom/rule
     *	
     */

    public ObjectId createObject(String kind) throws Exception;

   /* 
     *	Properties : objects have a property list.
     *
     *  System recognizes certain distinguished properties in other contexts.
     *  NAME, DESCRIPTION, GEOMETRY
     *	
     *	Token keys are for non-domain specific common properties.
     *	  - it will be an error to use a token that is not predeclared.
     *	    That list of predeclared tokens has not yet been specified.
     *	
     *	Domain specific properties should use obid keys to avoid clashes.
     */

    public void putProperty(ObjectId obid, String key, Term t)
	throws Exception;
    public void putProperty(ObjectId obid, ObjectId key, Term t)
	throws Exception;
    public Term getProperty(ObjectId obid, String key) throws Exception;
    public Term getProperty(ObjectId obid, ObjectId key) throws Exception;

    // shortcuts to make and modify objects.
    public ObjectId makeObject
	(String kind, ObjectProperty[] props, Term source)
	throws Exception;
    public void modifyObject
	(ObjectId obid, String kind, ObjectProperty[] props, Term source)
	throws Exception;

    /*
     *	marshalls/unmarshalls all data (kind, properties, term) into term.
     *	
     */
    public void putObjectContents(ObjectId obid, Term t) throws Exception;
    public Term getObjectContents(ObjectId obid) throws Exception;


    /* 
     *	Directories - a directed graph of objects.
     *
     *  Conformance facilitates browsing.
     *  
     */

    public ObjectId mkDir (String name) throws Exception;

    // boa == before or after, if no place then put at beginning(before) 
    // or end(after).
    public void dirInsert 
	(boolean boa, ObjectId place, ObjectId dir, ObjectId obid)
	throws Exception;
    public void dirInsert
	(boolean boa, ObjectId dir, ObjectId obid)
	throws Exception;

    // couple of shortcuts to make and insert dir in one call:
    public ObjectId mkDir
	(boolean boa, ObjectId place, ObjectId dir, String name)
	throws Exception;
    public ObjectId mkDir
	(boolean boa, ObjectId dir, String name)
	throws Exception;

    // removes an arbitrary occurence of obid in dir.
    public void dirRemove (ObjectId dir, ObjectId obid) throws Exception;

    // follows path of object names(NAME property) from root.
    // Fails if ambiguous; ie multple objects in with same name in a dir on path.
    public ObjectId dirDescendent (ObjectId dir, String[] path) throws Exception;
    public ObjectId dirDescendent (String[] path) throws Exception;

    /*
     *  Coming Soon :
     *   - transaction : allow mulitiple calls to occur in transaction 
     *      atomicity : failure of any call in a transaction leaves fdl unchanged
     *                  ie undoes any completed calls.
     * 
     *   - eval : term -> (term list) -> term
     * 
     *	 - term structures for representing proof trees.
     *      
     *   and more api extensions!
     */

    /*	OMDOC
     *	
     *	This api allows uploading content into FDL.
     *  In particulare this api or some extension will be used 
     *	to upload OMDOC content.
     */
    
    
    // ObjectId # name # directory_p
    //public ObjectInfo [] listDir (ObjectId dir);

}

