;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************

#+cltl2(in-system-package)
#-cltl2(in-package *system-package-name*)

#+allegro
(defunml (|run_shell| (s))
    (string -> bool)

  ;;(setf -s s) (break "rs")
  (zerop (excl::run-shell-command s :wait t)))

#-allegro
(defunml (|run_shell| (s))
    (string -> bool)

  (raise-error (error-message '(|run_shell| not implemented))))



(defun init-appl-base ()

  (init-com-base)
  
  (setf *component-kind* '|appl|)
  (pushnew :fdl-appl *features*)
  )


(defun init-appl-restart ()

  (init-com-restart t)
  
  (db-init (db-root-path t (find-db-path)))
  )

(defun do-init-appl (files)
  (init-appl-base)
  (when files (omlcomp files))

  (set-reload-global-alist)
  (init-appl-restart)

  ;; sets lib_env
  (print-client-banner *component-kind*)
  )

(defun do-disk-init-appl (files)
  (init-appl-base)
  (when files (omlcomp files))
  (format t "~%(in-package \"~a\")(dodisk-appl 'WWW )" *system-package-name*)
  (format t "~%(in-package \"~a\")(dodisk-appl 'WWW t) ; overwrites current~%" *system-package-name*)
  (format t "~%(in-package \"~a\")(dodisk-appl 'FDL )" *system-package-name*)
  (format t "~%(in-package \"~a\")(dodisk-appl 'FDL t) ; overwrites current~%" *system-package-name*)
  )

(defun do-appl-restart ()
  (init-appl-restart)
  #-cltl2(in-package cl-user::*system-package-name*)
  #+cltl2(in-system-package)

  ;; sets lib_env
  (print-client-banner *component-kind*)

  (print-config-data)

  #+cmu
  (read-eval-print-loop)
  )

(defun dodisk-appl (kind &optional overwrite)
  (setf *component-kind* kind)
  (dodisk #'do-appl-restart overwrite)
  )

(defun go-www ()
  (go-client))

