%
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************
%


let kind_of_oid = object_state_kind;;
let add_def_disp_ap = begin_ap "add_def_disp";;
let add_def_disp parent place oid =
  lib_eval (oid_ap (token_ap (oid_ap add_def_disp_ap parent) place) oid)
;;  
 
let oid_slot = make_edit_parameter `SLOT` `NIL` `OID` "";;
let nat_slot = make_edit_parameter `SLOT` `NIL` `NATURAL` "";;
let tok_slot = make_edit_parameter `SLOT` `NIL` `TOKEN` "";;
let bool_slot = make_edit_parameter `SLOT` `NIL` `BOOL` "";;
let string_slot = make_edit_parameter `SLOT` `NIL` `STRING` "";;


%let int_to_tok = tok_of_int;;%

let set_xhost = set_xhost_wcookie "";;

let ref_eval posure = lib_eval (posure_ap (begin_ap "ref_eval") posure);;
let ref_eval_to_term posure = lib_eval_to_term (posure_ap (begin_ap "ref_eval_to_term") posure);;
let ref_eval_to_bool posure = lib_eval_to_bool (posure_ap (begin_ap "ref_eval_to_bool") posure);;
let ref_eval_to_object_ids posure =
  (lib_eval_to_oids_unmarshall (posure_ap (begin_ap "ref_eval_to_object_ids_marshalled") posure));;

let imark_term m = make_term (`!MARK`,[make_token_parameter `MARK`]) [[],m];;

let stm_objc_proofs_ap = (null_ap (itext_term "\\oid. stm_objc_proofs (oc oid) "));;
let stm_objc_proofs oid = lib_eval_to_object_ids (oid_ap stm_objc_proofs_ap oid);;

let stm_objc_src_proofs_ap = (null_ap (itext_term "\\oid. stm_objc_src_proofs (oc oid) "));;
let stm_objc_src_proofs oid = lib_eval_to_object_ids (oid_ap stm_objc_src_proofs_ap oid);;



let statements thyoid = 
 filter (\m. (`STM` = object_state_kind m))
     (descendents thyoid nil)
;;

let proofs_ap = (begin_ap "accumulate (\\acc s. append (stm_objc_src_proofs (oc s)) acc) nil ");;
let proofs thyoid = lib_eval_to_object_ids (oids_ap proofs_ap (statements thyoid));;

let extracted_ap =
  (begin_ap
    "accumulate (\\acc p. (if (lex_equal_terms (prf_objc_extract (oc p)) iextract_not_term) then acc else (p . acc)) ? acc) nil "
);;

let extracted thyoid = lib_eval_to_object_ids (oids_ap extracted_ap (proofs thyoid));;

let not_extracted_ap =
 (begin_ap
  "accumulate (\\acc p. (if (lex_equal_terms (prf_objc_extract (oc p)) iextract_not_term) then (p . acc) else acc) ? (p .acc)) nil "
 );;

let not_extracted thyoid = lib_eval_to_object_ids (oids_ap not_extracted_ap (proofs thyoid));;


let inactive_proofs thyoid =
  filter (\p. not (object_state_active p)) (proofs thyoid)
;;

let activate_proofs_ap = (begin_ap "\\oids. filter (\\p. ((activate p); false) ? true) oids ");;

% returns list of those which failed to activate %
let activate_proofs thyoid =
  lib_eval_to_object_ids (oids_ap activate_proofs_ap (inactive_proofs thyoid))
;;


let putedesc oid = put_property oid `DESCRIPTION` nuprl5_edit_description_term;;
let putldesc oid = put_property oid `DESCRIPTION` nuprl5_library_description_term;;
let putrdesc oid = put_property oid `DESCRIPTION` nuprl5_refiner_description_term;;
let putledesc oid = put_property oid `DESCRIPTION` nuprl5_lib_and_edit_description_term;;
let putrledesc oid = put_property oid `DESCRIPTION` nuprl5_ref_lib_and_edit_description_term;;


let putlang lang oid = put_property oid `LANGUAGE` (itoken_term lang);;
let putmllang oid = put_property oid `LANGUAGE` (itoken_term `ML`);;


let dump_theory_v4_ap =
  (begin_ap "\\fname olist. dump_theory_v4 fname (map (\\to. (name_of_oid to, to)) olist)")
;;

let dump_theory_v4 fname l =
 lib_eval (oids_ap (string_ap dump_theory_v4_ap fname) l)
;;


let get_static_oids kind oids =
 flatten (map (\oid. filter (\oid. kind = kind_of_oid oid)
                            (oid . (static_oids_of_term (get_substance_term oid))))
	       oids)
;;

let get_static_abstraction_oids = get_static_oids `ABS` ;;
let get_static_statement_oids = get_static_oids `STM`;;
let get_static_code_oids = get_static_oids `CODE`;;


let object_active_p = ostate_active_p;;

let name_of_oid = name_property;;

let make_directory_object_wcontents name term =
 lib_eval_to_object_id
  (term_ap (token_ap (begin_ap "make_directory_object_wcontents") name)
	   term)
;;
