%
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************
%

let true_ce = edit_ce_string_to_expression "true";;
let slot_ce = edit_ce_string_to_expression "slot";;


%
;;;;	
;;;;	get_oid : find most likely relevant oid and push on term stack.
;;;;	
;;;;	mltoploop_set	: term -> unit
;;;;	 construct command to be evaluated and place in prompt of ml top loop
;;;;	 if toploop has command already then push it on cmd stack
;;;;		
%

let iml_tlx_cons_op = (`!ml_tlx_cons`, []);;
let iml_tlx_cons_term a b = make_term iml_tlx_cons_op [([], a); ([], b)];;


let ml_build_oid_ap f oid =
 (iml_tlx_cons_term (itext_term "let oid = first_oid_of_term ")
  (iml_tlx_cons_term (ioid_term oid)
   (iml_tlx_cons_term (itext_term " in (")
    (iml_tlx_cons_term f
     (itext_term " oid)")))))
;;




