%
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************
%

% metaprl connection %

let iinf_goal_term goal annos =
  make_term (`!inf_goal`, []) [[], goal; [], annos]
;;
			       
let imp_null_goal_term =
 iinf_goal_term
   (imp_msequent_term imp_nil_term
		      (make_term (imp_implementation_op
				  [(make_parameter_list_parameter [(make_string_parameter "unit")])])
					       []))
   (make_term iannotation_cons_op [])
;;

% cmds to call lib %

let mp_create_stm_ap = null_ap (itext_term "mp_create_stm ");;
let mp_create_stm oid name = lib_eval (token_ap (oid_ap mp_create_stm_ap oid) name);;

let mp_create_rw_ap = null_ap (itext_term "mp_create_rw ");;
let mp_create_rw oid name = lib_eval (token_ap (oid_ap mp_create_rw_ap oid) name);;

let mp_save_ap = null_ap (itext_term "mp_save ");;
let mp_save oid = (oid_ap mp_save_ap oid);;

let mp_save_thy_ap = null_ap (itext_term "mp_save_thy ");;
let mp_save_thy toks = (tokens_ap mp_save_thy_ap toks);;

let putsymaddr oid dirname name =
    put_properties oid [ `SYMBOLICADDRESS`, (symbolic_address_term [`Modules`; dirname; name])]
;;										     
let import_thy_ap  = null_ap (itext_term "libmp_import_theorems  ");;
let edd_import_thy oid = lib_eval (oid_ap import_thy_ap oid);;

let mp_import_proofs_ap  = null_ap (itext_term "libmp_import_proofs  ");;
let mp_import_thms_ap  = null_ap (itext_term "libmp_import_theorems  ");;
let metaprl_import_proofs oid = 
  lib_eval (oid_ap mp_import_thms_ap oid);
  lib_eval (oid_ap mp_import_proofs_ap oid)
;;

let mp_import_proofs_all_ap  = null_ap (itext_term "libmp_import_proofs_all  ");;
let mp_import_thms_all_ap  = null_ap (itext_term "libmp_import_theorems_all  ");;
let metaprl_import_all () = 
  lib_eval mp_import_thms_all_ap;
  lib_eval mp_import_proofs_all_ap 
;;

let ocaml_language_term = itoken_term `OCAML`;;
let putmprdesc oid = put_property oid `DESCRIPTION` metaprl_refiner_description_term;;
let putocamllang oid = put_property oid `LANGUAGE` ocaml_language_term;;

let dyn_mkmpobj kind place dir name =
  let upperkind = tok_upcase kind in
  let kind = if upperkind = `ML` then `CODE` else
             if upperkind = `RW` then `ABS` else
	     upperkind in		   
  let oid = make_named_leaf_after dir place name kind in
   putsymaddr oid (name_property dir) name;
   put_name_property oid name;
   (if (`DISP` = kind) then putedesc oid);
   (if (`PREC` = kind) then putedesc oid);
   (if (`CODE` = kind) then (putocamllang oid; putmprdesc oid));
   (if (`STM` = kind) then (putmprdesc oid; mp_create_stm oid name));
   (if (`ABS` = kind) then (putmprdesc oid; mp_create_rw oid name));
   oid
;;

let lib_compile_mp_ap = null_ap (itext_term "compile_mp_obj ");;
let lib_compile_mp oid = lib_eval_to_term (oid_ap lib_compile_mp_ap oid);;


% jprover code %
% I don't know if we need the editor to know about the jprover code%

let dest_jprover_term term =
 ((string_of_istring_term (subterm_of_term term 1)),
  (subterm_of_term term 2),
  (subterm_of_term term 3))
;;
