
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************

#+cltl2(in-system-package)
#-cltl2(in-package *system-package-name*)

;;;;	
;;;;	
;;;;	OED : old edit and display.
;;;;	
;;;;	Use new dtrees with old edit code.
;;;;	  - expend some effort allow nuprl4 and 5 to share edit code.
;;;;	      * however, may have to leave v4 behind if it becomes unmanageable.
;;;;	  
;;;;	
;;;;	
;;;;	
;;;;	Known problems : 
;;;;	
;;;;	  - unless all abs exported to edd abstraction-condition-p will not work same.
;;;;	    could export abbreviated abs, ie conditions and model.
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	oed-edd
;;;;	
;;;;	plan is that oed-layt, oed-edit, and oed-xwin will contain shared code
;;;;	while edd-oed contains v5 compatability code  
;;;;	and edit-oed contains v4 compatiability code.
;;;;	
;;;;	
;;;;	
;;;;	





;;;;	
;;;;	interface to v5 code.
;;;;	
;;;;	
;;;;	


(defun map-library (f)		
  (definition-table-map (resource 'ostates)
      (current-transaction-stamp)

    #'(lambda (oid def)
	(when (and def
		   (not (ostate-def-not-p def))
		   (active-of-iobject-state-term (state-of-ostate-def def)))
	  (funcall f
		   oid
		   (name-property-of-ostate-def def)
		   (kind-of-iobject-state-term (state-of-ostate-def def)))))))
		 

(defun oids-with-name (n)
  (let ((acc nil))
    (map-library #'(lambda (oid name kind)
		     ;;(setf -name name -oid oid -kind kind) (break)
		     (when (eql name n) (push oid acc))))
    (sort-oids-by-time acc)))
		 
(defunml (|oids_with_name| (n))
    (tok -> (object_id list))
  (oids-with-name n)
  )

(defun defined-term-of-obj (&rest rest)
  (declare (ignore rest))
  nil)


(defun object-name-of-dform (dform)
  (name-of-dforms (dforms-of-dform dform)))


(defun internal-edit-error (s)
  (system-error (error-message '(edit) s)))


(defun scan-num () (scan-decimal-num))
(defun scan-ichar (ich) (scan-byte ich))
(defun scan-at-end-p () (scan-eof-p))
(defun scan-next-char (&optional (skip-whitespace-p t)) (scan-next skip-whitespace-p))
(defun scan-at-unescaped-ichar-p (ich) (scan-at-byte-p ich))

;; v4 did not check escape bit but should be ok.
(defun scan-at-ichar-p (ich) (scan-at-byte-p ich))

(defun scan-istring (escaped-ichars)
  (do ((acc nil))
      ((or (and (not (scan-escape-p))
		(member (scan-cur-byte) escaped-ichars))
	   (scan-eof-p))
       (nreverse acc))
    (push (scan-cur-byte) acc)
    (scan-next nil)))

(defmacro with-error-backtrace (prefix &body body)
  `(with-backtrace ,prefix ,@body))

(defmacro with-error-prefix (prefix &body body)
  `(with-backtrace ,prefix ,@body))


(defun abstraction-condition-p (term condition)
  ;;(when (eql `|button| (id-of-term term)) (setf -term term -condition condition) (break "acp"))
  (member condition (conditions-of-abstraction-term term)))

(defun dform-condition-p (dform condition)
  (member condition (conditions-of-dform dform)))

(defun dform-orphaned-p (dform)
  (let ((dforms (dforms-of-dform dform)))
    (and dforms
	 (definition-valid-p dforms (resource 'dforms)) )))


(defun conditions-of-dtree (d) (labels-of-dtree d))

(defun set-equal (x y &key (test #'eql))
  (labels ((f (x y)
	     (if (null x)
		 (null y)
		 (and (member (car x) y :test test)
		      (f (cdr x)
			 (remove-if #'(lambda (z) (funcall test (car x) z)) 
				    y))))))
    (f x y)))

;;;;	
;;;;	
;;;;	import of code from v4 
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	

(defvar *character-token-array* (let ((a (make-array 256)))
				  (dotimes (i 256)
				    (setf (aref a i)
					  (intern (make-string 1 :initial-element (ichar->char i))
						  *system-package*)))
				  a))

(defun implode (l)
  ;;(when (characterp (car l)) (break))
  (let ((len (length l)))
    (if (onep len)
	(if (integerp (car l))
	    (aref *character-token-array* (car l))
	    (car l))
	(let ((s (make-string len)))
	  (dotimeslist (i c l)
            (setf (aref s i)
		  (if (integerp c)
		      (ichar->char c)
		      (char (string c) 0))))
    
	  (intern s *system-package*)))))



(defun list-to-istring (l itemf
			&optional (m-istring (list ispace))
				  (l-istring (list ilparen))
				  (r-istring (list irparen)))
  (labels
    ((rest-to-istring (l)
       (if (null l)
	   (copy-list r-istring)	;; copy because caller may destructively modify result.
	   (nconc (copy-list m-istring)
		  (funcall itemf (car l))
		  (rest-to-istring (cdr l))))))

    (if l
	(nconc (copy-list l-istring) 
	       (funcall itemf (car l))
	       (rest-to-istring (cdr l)))
	(append l-istring (copy-list r-istring)))))



(defvar *escaped-ichars*
  (list ispace inewline itab
	ilparen irparen ilsquare irsquare ilcurly ircurly
	icolon isemicolon icomma idot iescape))
  
(defun nescape-istring-escape (istring escaped-ichars)
  (do ((ichars istring))
      ((null ichars))
    (cond
      ((and (cdr ichars) (member (cadr ichars) escaped-ichars))
       (setf (cdr ichars) (cons iescape (cdr ichars)))
       (setf ichars (cddr ichars)))
      (t (setf ichars (cdr ichars)))))

  (if (member (car istring) escaped-ichars)
      (cons iescape istring)
      istring))

;; need to add escapes.
(defun escaped-istring (s &optional (escaped-ichars *escaped-ichars*))
  (nescape-istring-escape (istring s) escaped-ichars))


(defun printable-ichar-p (ich)
  (member ich
	  '#.(istring
	      "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789/'`~!@#$%^&*[]+\
={}()_-:;.,<>?\"\\|")))


(defun numeric-ichar-p (ich)
  (member ich '#.(istring "0123456789")))

(defun numeric-ichar-to-int (ich)
  (position ich '#.(istring "0123456789")))

(defun alpha-ichar-p (ich)
  (member ich '#.(istring "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ")))

(defun alphanumeric-ichar-p (ich)
  (member ich
	  '#.(istring
	      "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789")))


(defvar *identifier-ichars*
  	  '#.(istring
	      "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789/'`~!@#$%^&*[]+={}()_-:;.,<>?\"\\|"))

(defun set-identifier-chars (s)
  (setf *identifier-ichars* (istring s)))

(defun identifier-ichar-p (ich)
  (member ich *identifier-ichars*))


(defvar *delimiter-ichars* (list ispace))

(defun delimiter-ichar-p (ich)
  (member ich *delimiter-ichars*))

(defun set-delimiter-chars (s)
  (setf *delimiter-ichars* (istring s)))

(defun scan-comma ()
  (unless (scan-at-ichar-p icomma)
    (scan-error '(comma) "Scanner expecting comma."))
  (scan-next-char nil))

(defun scan-term-sig ()
  (let ((parameters-p nil)
	(arities-p nil))
    (labels
	((scan-opid ()
	   (intern (scan-string *ascii-escape-sbits*)))

	 (scan-parameters ()
	   (when (scan-at-unescaped-ichar-p ilcurly)
	     (setf parameters-p t)
	     (scan-delimited-list #'(lambda ()
				      (intern-system (scan-string  *ascii-escape-sbits*)))
				  ilcurly ircurly
				  #'scan-comma)))
	 (scan-arities ()
	   (when (scan-at-unescaped-ichar-p ilparen)
	     (setf arities-p t)
	     (scan-delimited-list #'scan-num
				  ilparen irparen
				  #'(lambda () (scan-ichar isemicolon))))))

    (with-error-backtrace "ScanTermSig"
      (let ((opid (scan-opid))
	    (parms (scan-parameters))
	    (arities (scan-arities)))
	(when (or arities-p parameters-p)
	  (values (list* opid parms arities) arities-p)))))))

(defun parse-term-sig (istring)
  (with-string-scanner ((implode-to-string istring))
    (mlet* (((term-sig arities-p) (scan-term-sig)))
      (when term-sig
	(when arities-p
	  ;;(break)
	  (values term-sig
		  (subseq istring 0 (scan-position))))))))

(defun term-sig-to-term (term-sig)
  (instantiate-term
   (instantiate-operator (id-of-term-sig term-sig)
			 (do ((i 1 (1+ i))
			      (typeids (parameters-of-term-sig term-sig)
				       (cdr typeids))
			      (acc nil))
			     ((null typeids) (nreverse acc))
			   (let ((type (lookup-typeid (car typeids))))
			     (if type
				 (push (instantiate-parameter
					(get-display-meta-variable-id
					 (concatenate 'string "p" (write-to-string i)))
					type)
				       acc)
				 (raise-error
				  (error-message '(oed term-sig term typeid not)
						 (car typeids)))))))
   (do ((i 1 (1+ i))
	(arities (arities-of-term-sig term-sig) (cdr arities))
	(bound-terms nil))
       ((null arities) (nreverse bound-terms))
     (push (instantiate-bound-term (itemplate-term
				    (concatenate 'string "t" (write-to-string i)))
				   (do ((j 1 (1+ j))
					(bindings nil))
				       ((= j (1+ (car arities))) (nreverse bindings))
				     (push (get-display-meta-variable-id
					    (concatenate 'string "v"
							 (write-to-string j)
							 (write-to-string i)))
					   bindings)))
	   bound-terms))))



(defvar *slot-index* 0)

(defmacro with-slot-index (&body body)
  `(progn (setf *slot-index* 0)
    ,@body))

(defun get-slot-value ()
  (slot-parameter-value (princ-to-string (incf *slot-index*))))

(defun make-placeholder (descriptor)
  (declare (ignore descriptor))
  (iplaceholder-term))

(defun make-free-placeholder ()
  (iplaceholder-term))

(defun template-term-to-placeholder-term (term)
  (labels
      ((visit-operator (op)
	 (maybe-instantiate-operator
	  op
	  (id-of-operator op)
	  (mapcar #'(lambda (p)
		      (cond
			((display-meta-parameter-p p)
			 (instantiate-parameter (get-slot-value)
						(type-of-parameter p)))
			(t p)))
		  (parameters-of-operator op))))

       (visit-term (term)
	 (instantiate-term (visit-operator (operator-of-term term))
			 (mapcar #'visit-bound-term (bound-terms-of-term term))))

       (visit-bound-term (bound-term)
	 (maybe-instantiate-bound-term bound-term
				       (mapcar #'(lambda (b)
						   (cond
						     ((dummy-display-meta-variable-id-p b)
						      (get-dummy-variable-id))
						     ((display-meta-variable-id-p b)
						      (get-slot-value))
						     (t b)))
					       (bindings-of-bound-term bound-term))
				       (if (itemplate-term-p (term-of-bound-term bound-term))
					   (make-free-placeholder)
					   (visit-term (term-of-bound-term bound-term))))))

    (with-slot-index
	(visit-term term))))


(defun dummy-display-variable-usage-p (model)
  (or (exists-p #'(lambda (bt)
		    (exists-p #'dummy-display-meta-variable-id-p
			      (bindings-of-bound-term bt)))
		(bound-terms-of-term model))
      (exists-p #'(lambda (parm)
		    (and (variable-parameter-p parm)
			 (dummy-display-meta-variable-id-p (value-of-parameter-m parm))))
		(parameters-of-term model))))



(defun dtpt-substitute-in-bindings (bindings subs)
  (if (forall-p #'(lambda (b) (variable-id-p b)) bindings)
      bindings
      (mapcar #'(lambda (b)
		  (let ((sub (cdr (assoc b subs))))
		    (cond
		      ((null sub) b)
		      ((variable-id-p sub) sub)
		      ((meta-variable-id-p sub) sub)
		      ((extended-parameter-value-p sub)
		       sub)
		      ((stringp sub) (get-variable-id sub))
		      (t ;;(setf a b c sub) (break)
		       (internal-edit-error "bad binding substitition")))))
	      bindings)))

(defun dtpt-substitute-template-term (term subs)
  (let ((term (instantiate-term
	       (substitute-in-operator (operator-of-term term) subs)
	       (mapcar #'(lambda (bound-term)
			   (dtpt-substitute-template-bound-term bound-term subs))
		       (bound-terms-of-term term)))))
    term))

(defun dtpt-substitute-template-subterm (term subs)
  (if (itemplate-term-p term)
      (or (let ((sub (cdr (assoc (get-display-meta-variable-id (id-of-itemplate-term term)) subs))))
	    (when sub
	      (if (parameter-p sub)
		  (instantiate-term (instantiate-operator (type-id-of-parameter sub)
							  (list sub)))
		  sub)))
		
	  term)
      (maybe-instantiate-term
       term (substitute-in-operator (operator-of-term term) subs)
       (mapcar #'(lambda (bound-term)
		   (dtpt-substitute-template-bound-term bound-term subs))
	       (bound-terms-of-term term)))))

(defun dtpt-substitute-template-bound-term (bound-term subs)
  (maybe-instantiate-bound-term
   bound-term
   (dtpt-substitute-in-bindings (bindings-of-bound-term bound-term)
			   subs)
   (dtpt-substitute-template-subterm (term-of-bound-term bound-term)
			     subs)))

(defun dform-to-placeholder-term (dform)
  ;;(break "dtpt")
  (with-slot-index
      (dtpt-substitute-template-term (model-term-of-dform dform)
				     (map 'list #'(lambda (mv)
						    (let ((v (id-of-dform-model-variable mv)))
						      (cons v
							    (if (dform-model-variable-flag-term-p mv)
								(iplaceholder-term)
								(if (and (dummy-display-meta-variable-id-p v)
									 (dummy-display-variable-usage-p
									  (model-term-of-dform dform)))
								    (get-dummy-variable-id)
								    (get-slot-value))))))
					  (model-variables-of-dform dform)))))

(defun edit-init ()
  (setf gstate nil)
  (let ((tl (nthcdr *edit-term-stack-cut-length* *edit-term-stack*)))
    (when tl (setf (cdr tl) nil))))


;; should be lazy 
;;  when point modified note modification
;;  when point looked up check if modified then rehash if so
(defun point-rehash (v &optional l)
  (let ((c (cursor-of-edit-state v))
	(d (dtree-at-label (or l `point) v)))

    ;;(setf -a d -b c -c v) (break "pr")
    (when (and d (edit-state-p v))
      (if (and (point-cursor-p c)
	       (eql d (point-of-point-cursor c)))
	  (when (dtree-leaf-p d)
	    (view-flag-set-cursor-layout-required v t))
	  (point-state v d)))))


(defun maybe-point-rehash (v l)
  (point-rehash v l)
  (point-of-edit-state v)
  )

(defunml (|view_set_point_cursor| (label v))
    (tag -> (view -> unit))

  (point-rehash v label))



(defunml (|view_associate_object_reset| (v))
    (view -> unit)

  (let ((vobj (object-of-view v)))

    (unless vobj
      (raise-error (error-message '(edit view associate refresh none))))

    (view-dtree-init v (term-of-vobject vobj) (implicit-of-vobject vobj))
    (setf (edit-state-cursor v) nil)
    (values)))



(defmacro maybe-reverse ((reverse-p destructive-p) &body body)
  (if destructive-p
      `(if ,reverse-p
	(nreverse (progn ,@body))
	(progn ,@body))
      `(if ,reverse-p
	(reverse (progn ,@body))
	(progn ,@body))))

(defun pieces-of-dtree (dtree &optional perp)
  (unless (iplaceholder-term-p (term-of-dtree dtree))
    (let ((acc nil))
      (map-dtree-children #'(lambda (dtree)
			      (with-ignore
				  (push (if (dtree-leaf-p dtree)
					    (dtree-leaf-to-parameter dtree t)
					    (dtree-to-term dtree))
					acc)))
			  perp
			  nil		; to avoid reverse after accumulation
			  dtree))))


(defun permuted-pieces-of-dtree (dtree)
  (pieces-of-dtree dtree t))

(defun slot-parameter-p (p)
  (slot-parameter-value-p (value-of-parameter-n p)))

(defun marks-of-parameter (p) (marks-of-parameter-value (value-of-parameter-n p)))

(defun edit-term-merge (term pieces &optional reverse-p)
  (let ((parameters (maybe-reverse (reverse-p t)
				   (mapcan #'(lambda (piece)
					       (unless (term-p piece)
						 (list piece)))
					   pieces)))
	(terms (maybe-reverse (reverse-p t)
			      (mapcan #'(lambda (piece)
					  (when (term-p piece)
					    (list piece)))
				      pieces))))

    ;;(setf a parameters b terms c term) (break "a")
    (labels ((find-parameter (type-id)
	       (when parameters
		 (with-ignore
		     (let ((p (pop parameters)))
		       (let ((pparts (edit-parameter-parts  p)))
			 (make-edit-parameter nil
					      (meta-type-of-parameter-parts pparts)
					      type-id
					      (string-of-parameter-parts pparts)
					      (marks-of-parameter-value (value-of-parameter-n p))))))))
					      
	     (find-binding ()
	       (when parameters
		 (with-ignore
		     (let ((p (pop parameters)))
		       (let ((pparts (edit-parameter-parts  p)))
			 
			 (let ((string (string-of-parameter-parts pparts)))
			   (sexpr-to-parameter-value (case (meta-type-of-parameter-parts pparts)
						       (display (cons 'd string))
						       (abstraction (cons 'a string))
						       ((nil) string)
						       (otherwise (raise-error
								   (error-message '(edit_term_merge meta-type unknown)
										  (meta-type-of-parameter-parts pparts)))))
						     *variable-type*)))))))
			   
	     (visit-term (term)
	       (if (iplaceholder-term-p term)
		   (if terms
		       (prog1 (car terms)
			 ;;(setf a terms)
			 ;;(break)
			 (setf terms (cdr terms)))
		       term)
		   (maybe-instantiate-term
		    term
		    (maybe-instantiate-operator
		     (operator-of-term term)
		     (id-of-operator (operator-of-term term))
		     (maybe-reverse (reverse-p t)
				    (mapcar #'(lambda (parameter)
						(or (when (slot-parameter-p parameter)
						      (find-parameter (type-id-of-parameter parameter)))
						    parameter))
					    (maybe-reverse (reverse-p nil)
							   (parameters-of-operator (operator-of-term term))))))
		    (maybe-reverse (reverse-p t)
				   (mapcar #'visit-bound-term
					   (maybe-reverse (reverse-p nil)
							  (bound-terms-of-term term)))))))

	     (visit-bound-term (bound-term)
	       (maybe-instantiate-bound-term
		bound-term
		(maybe-reverse (reverse-p t)
			       (mapcar #'(lambda (v)
					   (or (when (slot-parameter-value-p v)
						 (find-binding))
					       v))
				       (bindings-of-bound-term bound-term)))
		(visit-term (term-of-bound-term bound-term)))))

      (visit-term term))))


(defun edit-dtree-merge (dtree pieces reverse-p)
  (let ((parameters (maybe-reverse (reverse-p t)
					 (mapcan #'(lambda (piece) (unless (term-p piece) (list piece)))
						 pieces)))
	(terms (maybe-reverse (reverse-p t)
			      (mapcan #'(lambda (piece) (when (term-p piece) (list piece)))
				      pieces)))
	(r dtree))

    ;;(setf a terms b dtree) (break)
    
    (labels ((visit (dtree)
	       (if (dtree-leaf-p dtree)
		   (when (and parameters (dtree-flag-slot-p dtree))
		     (let ((ndtree (new-dtree-leaf (parameter-marks-union (pop parameters)
									  (mark-values dtree))
						   nil)))
		       (setf r (dtree-replace dtree ndtree))))
		       
		   (if (and terms (iplaceholder-term (term-of-dtree dtree)))
		       (setf r (dtree-replace dtree (new-dtree-lazy-term (pop terms)
									 (dfparms-of-dtree dtree)
									 nil)))
		       (when (or parameters terms)
			 (map-dtree-children #'visit t reverse-p dtree))))))

      (visit dtree)
      (dtree-to-term r))))

(defun edit-insert-replace-dtree (state term)
  (let ((point (point-of-edit-state state)))
    (unless (dtree-leaf-p point)
      (let* ((pieces (if (insert-edit-state-p state)
			 (unless (iplaceholder-term-p (term-of-dtree point))
			   (list (dtree-to-term point)))
			 (permuted-pieces-of-dtree point))))
	     
	(when (edit-replace state
			    point 
			    (edit-dtree-merge term
					      (if (insert-edit-state-p state)
						  (unless (iplaceholder-term-p (term-of-dtree point))
						    (list (dtree-to-term point)))
						  pieces)		      
					      (right-edit-state-p state)))
	  (point-rehash state 'point)))))
  state)



(defun edit-insert-replace-term (state term)
  (let ((point (point-of-edit-state state)))
    (unless (dtree-leaf-p point)
      ;;(setf -state state  -term term) ;; (break "irt")
      (when (edit-replace state
			  point
			  (cond
			    ((iplaceholder-term-p (term-of-dtree point))
			     (ilabel-term 'point term))
			    
			    ((insert-edit-state-p state)
			     (ilabel-term 'point (edit-term-merge term
								  (list (filter-term-tags (dtree-to-term point 'text)
											  *point-filter*))
								  (right-edit-state-p state))))

			    (t (ilabel-term 'point
					    (edit-term-merge term
							     (pieces-of-dtree point)
							     (right-edit-state-p state))))))

	;;(setf -d point) (break "irt2o")
	(point-rehash state 'point))))

    state)

(defun oed-leaf-replace (v point new)

  (when *dtree-flag-trace* (format t "oed-leaf-replace~%"))
  ;;(break "olr")
  
  ;; transfer labels? not here.
  (set-view-dtree v (dtree-replace point new)))


(defun oed-leaf-change-meta (v leaf m)
  ;;(setf -v v -leaf leaf -m m) (break "olcm")
  (let ((p (dtree-leaf-to-parameter leaf t t m)))
    (let ((ndtree (new-dtree-leaf p nil)))
      (dtree-leaf-set-meta-bit m ndtree)
      (oed-leaf-replace v leaf ndtree))))



;;;;	
;;;;	Sequence : 
;;;;	  - dtree-set-text-modifiable
;;;;	      * move !TEXT-EDIT label leaf
;;;;	      * oed-leaf-replace
;;;;		  - term-modified[STRUCTURE] path
;;;;	  - modify leaf
;;;;	      * instantiate-dtree leaf
;;;;	          - text-modified path
;;;;	  - layout
;;;;	      * instantiate-dtree
;;;;	        dtree-to-term choose-dform
;;;;		  - lifts text and looses text-modified 
;;;;	  - instantiate-dtree-leaf with !TEXT-EDIT & POINT
;;;;	      * text-modified path
;;;;	  - dtree-replace :
;;;;	      * lose !TEXT-EDIT.
;;;;	  - text mod with !TEXT-EDIT & POINT
;;;;	      * text-modified path
;;;;	
;;;;	
;;;;	
;;;;	

(defun dtree-set-text-modifiable (view leaf)

  (unless (dtree-leaf-p leaf)
    ;;(break "dstm") 
    (view-error-message view '(oed text modify dtree leaf not)))

  (when (dtree-flag-non-modifiable-p leaf)
    (raise-error (view-error-message view '(dtree text set modify non-modifiable))))

  (dtree-flag-trace
   (format-string "dtree-set-text-modifiable instantiated ? ~a~%."
		  (dtree-flag-instantiated-p leaf)
		  ))

  ;;(setf -leaf leaf) (break "stm")
  (if (dtree-flag-instantiated-p leaf)
      (when (and (not (dtree-flag-text-modified-p leaf))
		 (dtree-labeled-p '!TEXT-EDIT leaf)
		 (dtree-labeled-p 'POINT leaf))
	(dtree-path-text-modified leaf))
      (instantiate-dtree-leaf leaf))
		       
  (dtree-flag-trace
   (format-string "dtree-set-text-modifiable text-modified ? ~a, !TEXT-EDIT ? ~a~%."
		  (dtree-flag-text-modified-p leaf)
		  (dtree-labeled-p '!TEXT-EDIT leaf)))

  (if (dtree-flag-text-modified-p leaf)
      leaf
      (let ((ndtree (new-dtree-leaf (dtree-leaf-to-parameter leaf t) ; carrys over labels.
				    nil)))

	;;(format t "!~%")
	(when *dtree-flag-trace* (format t "dtree-set-text-modifiable~%"))

	(edit-remove-label view '!text-edit)
	(oed-leaf-replace view leaf ndtree)
	(tag-dtree ndtree  '!text-edit t)

	;; should be consequence of replace?
	;(view-flag-set-layout-required view t)
	
	ndtree)))  




(defun refresh-ancestors (dtree)
  (when dtree
    (refresh-dtree dtree t)
    (refresh-ancestors (parent-of-dtree dtree))))


(defun edit-modify-text-at-label-aux (label view f)

  ;; if not text-modified then replace leaf then modify
  (when
      (let ((dtree (dtree-set-text-modifiable view (dtree-at-label label view))))
	
	(when dtree

	  ;;(setf -edtree dtree)
	  (let ((istr (istring-of-dtree-leaf dtree)))
	    (let ((l (length istr))
		  (slotp (dtree-flag-slot-p dtree))
		  (indices (indices-of-dtree-leaf dtree)))
	      
	      (mlet* (((nistr nindices) (funcall f indices istr dtree)))
		     (let ((nl (length nistr)))
		       
		       (let ((string-modp (unless (and (= l nl)
						       (equal nistr istr))
					    (modify-dtree-leaf-istring dtree nistr)))
			     (index-modp (unless (eql indices nindices)
					   (set-dtree-leaf-indices dtree nindices)
					   t)))
			     
			     
			 (or index-modp string-modp
			     (not (eql slotp (dtree-flag-slot-p dtree))) ))))))))
    
    ;;(break "emtala")
    
    (view-flag-set-present-required view t)
    (view-flag-set-cursor-layout-required view t)
    t))


(defun adjust-indices-delete (indices b diff)
  (if (zerop diff)
      indices
      (mapcar #'(lambda (index-label)
		  (let ((index (cdr index-label)))
		    (cond
		      ((< index b) index-label)
		      ((>= index (+ b diff)) (cons (car index-label) (- index diff)))
		      (t (cons (car index-label) b)))))
	      indices)))

(defun adjust-indices-insert (indices b diff)
  ;;(setf -ii indices -b b -di diff) (break "aii")
  (if (zerop diff)
      indices
      (mapcar #'(lambda (index-label)
		  (let ((index (cdr index-label)))
		    (cond
		      ((< index b) index-label)
		      ((>= index b) (cons (car index-label) (+ diff index))))))
	      indices)))


;; dir : t -> forward, nil backward
(defun edit-delete-modify-istring (dir i istr)
  (let ((index (if dir i (1- i))))
    (values (nlist-delete istr index)
	    index)))

(defun edit-insert-modify-istring (dir index istr ich)
  (values (nlist-insert istr index ich)
	  ;; return index means any index equal or larger will be shifted.
	  (if dir
	      index
	      (1+ index))))

(defun edit-delete-text-at-label (dir label view)
  (edit-modify-text-at-label-aux
   label view
   #'(lambda (indices istr d)
       (declare (ignore d))
       (let ((i (or (cdr (assoc label indices)) 0)))
	 (mlet* (((nistr index) (edit-delete-modify-istring dir i istr)))
		(values nistr (adjust-indices-delete indices index 1)))))))


(defun edit-delete-text-segment-at-labels (alabel blabel view)
  (edit-modify-text-at-label-aux
   alabel view
   #'(lambda (indices istr d)
       (declare (ignore d))
       (let ((i (or (cdr (assoc alabel indices)) 0))
	     (j (or (cdr (assoc blabel indices)) 0)))

	 (let ((b (min i j)) (e (max i j)))

	   (cond
	     ((< b 0)
	      (message-emit (warn-message '(edit delete text segment begin) b))
	      (values istr indices))
	 
	     ((> e (length istr))
	      (message-emit (warn-message '(edit delete text segment end) e (length istr)))
	      (values istr indices))
	 
	     (t (values (nconc (subseq istr 0 b) (subseq istr e))
			(adjust-indices-delete indices b (- e b))
			))))))))


(defun edit-delete-text-segment-entire (label view)
  (edit-modify-text-at-label-aux
   label view
   #'(lambda (indices istr d)
       (declare (ignore istr d))
       (values nil (mapcar #'(lambda (index) (cons (car index) 0))
			   indices)))))

(defun edit-delete-text-segment-at (label view begin end)
  (edit-modify-text-at-label-aux
   label view
   #'(lambda (indices istr d)
       (declare (ignore d))
       (values (nconc (subseq istr 0 begin) (subseq istr end))
	       (adjust-indices-delete indices begin (- end begin))))))


(defun edit-fix-text (label view)
  (edit-modify-text-at-label-aux
   label view
   #'(lambda (indices istr d)
       (declare (ignore d))
       ;;(setf -istr istr) (break "eft")
       (values (edit-fix-istring istr)
	       (mapcar #'(lambda (index) (cons (car index) 0))
			   indices)))))

(defun oed-text-insert-null (label view)
  (edit-modify-text-at-label-aux
   label view
   #'(lambda (indices istr d)
       (declare (ignore istr))
       (dtree-flag-set-slot d nil)
       (values nil indices))))

(defun oed-modify-text-at-label (f label view)
  (edit-modify-text-at-label-aux
   label view
   #'(lambda (indices istr d)
       (declare (ignore d))
       (let* ((nistr (funcall f istr))
	      (l (length nistr)))
	 ;;(setf -nistr nistr -ist istr) (break "omtal")
	 (if (eql nistr istr)
	     (values istr indices)
	     (values nistr
		     (mapcar #'(lambda (index) (cons (car index) (min (cdr index) l)))
			     indices)))))))

(defun edit-text-insert (dir label ich view)
  ;;(break "eti")
  (edit-modify-text-at-label-aux
   label view
   #'(lambda (indices istr d)
       (declare (ignore d))
       (let ((i (or (cdr (assoc label indices)) 0)))
	 (mlet* (((nistr index) (edit-insert-modify-istring dir i istr ich)))
		;;(setf -ii indices -iii index -istr istr) (break "etii")
		(values nistr (adjust-indices-insert indices index 1)))))))



(defun edit-text-insert-istring (dir label iistr view)
  (edit-modify-text-at-label-aux
   label view
   #'(lambda (indices istr d)
       (declare (ignore d))
       (let ((i (or (cdr (assoc label indices)) 0)))
	 ;;(setf -ii indices) (break "etii")
  	 (values (append (subseq istr 0 i) iistr (subseq istr i))
		 (adjust-indices-insert indices
					(if dir i (1+ i))
					(length iistr)))))))


(defun edit-move-label-text-aux (label view f)
  (when
      (let ((dtree (dtree-at-label label view)))

	;;(setf -dtree dtree) (break "emlta")

	(when (dtree-leaf-p dtree)
	  (let ((istr (istring-of-dtree-leaf dtree)))
	    (when istr
	      (let ((index (index-of-dtree-leaf dtree label))
		    (l (length istr)))
		(let ((nindex (funcall f index istr dtree)))

		  (when (> nindex l) (setf nindex l))
		  (when (< nindex 0) (setf nindex 0))

		  (when (and (integerp nindex) (not (= index nindex)))
		    (set-dtree-leaf-index dtree label nindex)
		    t)))))))

    (view-flag-set-cursor-layout-required view t)
    t))


(defun oed-label-text (f label view)
  (let ((dtree (dtree-at-label label view)))

    (when (dtree-leaf-p dtree)
      (funcall f
	       (indices-of-dtree-leaf dtree)
	       (istring-of-dtree-leaf dtree)
	       dtree)))
  nil)


(defun ichar-of-dtree-leaf (label view)
  (let ((ich nil))
    (oed-label-text #'(lambda (indices istr d)
			(declare (ignore d))
			(let ((i (cdr (assoc label indices))))
			  (when i (setf ich (nth i istr)))))
		    label
		    view)
    ich))

(defun segment-of-dtree-leaf (alabel blabel view)
  (let ((result nil))
    (oed-label-text #'(lambda (indices istr d)
			(declare (ignore d))
			(let ((i (cdr (assoc alabel indices)))
			      (j (cdr (assoc blabel indices))))

			  (if (and i j)
			      (let ((b (min i j)) (e (max i j)))
			    
				(cond
				  ((< b 0)
				   (message-emit (warn-message '(edit text segment begin) b)))
	 
				  ((> e (length istr))
				   (message-emit (warn-message '(edit text segment end) e (length istr))))
	 
				  (t (setf result (subseq istr b e)))))
			      (message-emit (warn-message '(edit text segment label) i j)))))
		    alabel
		    view)
    result))

(defun entire-segment-of-dtree-leaf (label view)
  (let ((result nil)
	(labelpos nil))
    (oed-label-text #'(lambda (indices istr d)
			(declare (ignore d))
			(setf labelpos (or (cdr (assoc label indices))
					   0))
			(setf result istr))
		    label
		    view)
    (values result labelpos)))


;; assumes label is on dtree or you wouldn't be asking.
(defun oed-leaf-label-position (label dtree)
  (when (dtree-leaf-p dtree)
    (values
     (or (cdr (assoc label (indices-of-dtree-leaf dtree)))
	 0)
     (length (istring-of-dtree-leaf dtree)))))


(defun oed-leaf-label-first-p (label dtree)
  (eql 0 (oed-leaf-label-position label dtree)))

(defun oed-leaf-label-last-p (label dtree)
  ;;(setf -dtree dtree) (break "olllp")
  (mlet* (((pos l)  (oed-leaf-label-position label dtree)))

	 (and pos (eql l pos))))

;; left
(defun  edit-move-label-text (dir label view)
  (edit-move-label-text-aux label view
			    #'(lambda (index istring dtree)
				(declare (ignore istring dtree))
				(if (left-mode-p dir)
				    (1+ index)
				    (1- index)))))


(defun edit-move-label-text-to-end (dir label view)
  (edit-move-label-text-aux label view
			    #'(lambda (index istring dtree)
				(declare (ignore index dtree))
				(if (left-mode-p dir)
				    0
				    (length istring)))))

(defunml (|edit_move_label_text| (dir label view))
    (bool -> (tag -> (view -> bool)))

  (edit-move-label-text dir label view))
			   


;; todo : should be parameterizable.
(defvar *text-word-delimiters* (list ispace inewline itab idash iunder))

(defun set-word-delimiters (l)
  (setf *text-word-delimiters* (mapcar #'ichar l)))

(defun get-word-delimiters ()
  (mapcar #'ichar->char *text-word-delimiters*))

(defun add-word-delimiter (ch)
  (let ((ich (ichar ch)))
    (unless (member ich *text-word-delimiters*)
      (setf *text-word-delimiters*
	    (cons ich *text-word-delimiters*)))))

(defun delete-word-delimiter (ch)
  (let ((ich (ichar ch)))
    (setf *text-word-delimiters*
	  (delete ich *text-word-delimiters*))))


(defun istring-word-search (istring delims instart dir)
  (let ((seq (if dir
		 (reverse (subseq istring 0 instart))
		 istring))
	(start (if dir 0 instart))
	(p nil))
	
    ;;(setf -b seq -c start)
    (let ((dist (do ((i 0 (1+ i))
		     (l (nthcdr start seq) (cdr l)))
		    ((or (null l)
			 (if p
			     (member (car l) delims)
			     (when (not (member (car l) delims))
			       (setf p t)
			       nil)))
		     i))))
      ;;(setf -d dist)
      (if dir
	  (- instart dist)
	  (+ instart dist)))))


(defun edit-move-label-word (dir label view)
  (edit-move-label-text-aux label view
			    #'(lambda (index istring dtree)
				(declare (ignore dtree))
				(istring-word-search istring *text-word-delimiters* index dir))))



;; true -> forward
(defunml (|edit_delete_label_text| (dir label view))
    (bool -> (tag -> (view -> bool)))

  (edit-delete-text-at-label dir label view))
			   

(defunml (|edit_insert_label_text| (dir label s view))
    (bool -> (tag -> (string -> (view -> bool))))
    
  (edit-text-insert-istring dir label (istring s) view))



