
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************

#+cltl2(in-system-package)
#-cltl2(in-package *system-package-name*)

(defparameter *latex2e-short-preamble* 
  "\\documentclass{article}
\\usepackage{amssymb}
\\usepackage{nuprl}
\\usepackage{html}

\\begin{document}

")





(defun latex-line (line out)
  (let ((iline  (string-to-unicode-istring line)))
    ;;(setf -iline iline -line line) (break "ll")
    (labels ((visit (ich)
	       (let ((ch (code-char ich)))
		 (princ (if (alphanumericp ch)
			    ch
			    (or (cdr (assoc ch *nonstandard-graphic-code->latex-macro*
					    :test #'char=))
				(cdr (assoc ch *special-standard-char->latex-macro*
					    :test #'char=))
				ch))
			out))))
		   
      (dolist (ich iline)
	(visit ich)))))
     

(defun latex-preamble (out &optional old)
  (princ (if old
	     *latex-preamble*
	     *latex2e-short-preamble*)
	 out))

(defun latexize-file (input-file output-file
		      &optional
		      (nonstandard-chars-only? nil)
		      (no-ambles-p nil)
		      (old-latex-p nil)
		      )
  (let ((bdelim 138)
	(edelim 139)
	(paragraph-p)
	(end-pending nil)
	(i 0)
	)

    (handle-file-error
     (with-open-file (in
		      input-file
		      :direction :input)
       (with-open-file (out
			output-file
			:direction :output
			:if-exists :new-version
			:if-does-not-exist :create)

	 (labels ((start-paragraph ()
		    (terpri out)
		    (latex-paragraph-intro out)
		    (terpri out)
		    (princ "\\>" out)
		    (dotimes (j i) (princ " " out))
		    (setf paragraph-p t)
		    )
		  (end-paragraph ()
		    (terpri out)
		    (latex-paragraph-conclusion out)
		    (setf paragraph-p nil)
		    )
		  (ich (l)
		    (cond
		      ((null l) nil)
		      ((and (eql (car l) bdelim) (eql (cadr l) bdelim)
			    (eql (caddr l) edelim) (eql (cadddr l) edelim))

		       (ich (cddddr l)))

		      ((and (eql (car l) bdelim) (eql (cadr l) bdelim))
		       (if end-pending
			   (progn
			     (princ "\\\\" out) (terpri out) (princ "\\\>" out)
			     (setf end-pending nil))
			   (progn 
			     (start-paragraph)))
		       (ich (cddr l)))
		      ((and (eql (car l) edelim) (eql (cadr l) edelim))
		       (if (forall-p #'(lambda (ich) (eql ich ispace)) (cddr l))
			   (progn
			     (setf end-pending t)
			     nil)
			   (progn
			     (end-paragraph)
			     (ich (cddr l)))))
		      (t
		       (when end-pending
			 (setf end-pending nil)
			 (end-paragraph)
			 )

		       (cond
			 ((eql (car l) #xff24)
			  (write-char #\$ out)
			  (ich (cdr l)))
			 ((eql (car l) #xff5c)
			  (write-char #\\ out)
			  (ich (cdr l)))
			 ((eql (car l) #xff5e)
			  (write-char #\^ out)
			  (ich (cdr l)))
			 ((eql (car l) #xff5f)
			  (write-char #\_ out)
			  (ich (cdr l)))
			 ((eql (car l) #xff7b)
			  (write-char #\{ out)
			  (ich (cdr l)))
			 ((eql (car l) #xff7d)
			  (write-char #\} out)
			  (ich (cdr l)))
			 ((eql (car l) #xff7e)
			  (write-char #\~ out)
			  (ich (cdr l)))

			 (t (let ((ch (code-char (car l))))
			      (incf i)
			      ;;(when (eql (car l) 148) (setf -ch ch) (break "mem"))

			      (let ((macro (or (cdr (assoc ch *nonstandard-graphic-code->latex-macro*
							   :test #'char=))
					       (cdr (assoc ch *special-standard-char->latex-macro*
							   :test #'char=)))))
				;;(when (eql (car l) 148) (setf -macro macro -ch -ch) (break "mem"))
				(if macro
				    (princ macro out)
				    (write-char ch out))))
			    (ich (cdr l)))))))
		  )

	   (unless no-ambles-p (latex-preamble out old-latex-p))
	   (do ((line (read-line in nil nil) (read-line in nil nil)))
	       ((null line))

	     ;;(format t "LFx~a~%" line)
	     (do ()
		 ((not (when (> (length line) 5)
			  (string= "\\000c" (subseq line (- (length line) 5))))))
	       (setf line (concatenate 'string
				       (subseq line 0 (- (length line) 5))
				       (read-line in nil nil))))
	     ;;(format t "LF ~a~%" line)
	     (unless (string= "" line)
	       (let ((iline (string-to-unicode-istring line)))
		 #|(do ()
		       ((not (eql 12 (car (last iline)))))
		   (setf iline (append (butlast iline)
				       (string-to-unicode-istring (read-line in nil nil)))))|#
		 (when (and paragraph-p (not end-pending)) (princ "\\>" out))
		 (setf i 0)
		 (ich iline)
		 (when (and paragraph-p (not end-pending)) (princ "\\\\" out))
		 (unless end-pending
		   (terpri out))
		 )))

	   (when end-pending (end-paragraph))
	   (unless no-ambles-p (latex-postamble out))
			 
	   (values)))))))


;; may need to preprocess and concat lines ending in continuation  char
(defunml (|latexize_string| (line))
    (string -> string)
  (with-output-to-string (out)
    (labels ((ich (l)
	       (cond
		 ((null l) nil)

		 (t 

		  (let ((ch (code-char (car l))))
		    ;;(when (eql (car l) 148) (setf -ch ch) (break "mem"))

		    (cond
		      ((eql (car l) #x000A)
		       (write-char #\newline out)
		       (ich (cdr l)))
		      ((eql (car l) #xff24)
		       (write-char #\$ out)
		       (ich (cdr l)))
		      ((eql (car l) #xff5c)
		       (write-char #\\ out)
		       (ich (cdr l)))
		      ((eql (car l) #xff5e)
		       (write-char #\^ out)
		       (ich (cdr l)))
		      ((eql (car l) #xff5f)
		       (write-char #\_ out)
		       (ich (cdr l)))
		      ((eql (car l) #xff7b)
		       (write-char #\{ out)
		       (ich (cdr l)))
		      ((eql (car l) #xff7d)
		       (write-char #\} out)
		       (ich (cdr l)))
		      ((eql (car l) #xff7e)
		       (write-char #\~ out)
		       (ich (cdr l)))
		      (t 
		       (let ((macro (or (cdr (assoc ch *nonstandard-graphic-code->latex-macro*
						    :test #'char=))
					(cdr (assoc ch *special-standard-char->latex-macro*
						    :test #'char=)))))

			 (if macro
			     (princ macro out)
			     (write-char ch out))))))
		       (ich (cdr l))))))
    
      (unless (string= "" line)
	(let ((iline (string-to-unicode-istring line)))
	  (ich iline)
	  ))
      )))


