
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************

#+cltl2(in-system-package)
#-cltl2(in-package *system-package-name*)

(defun new-mathbus-link (primary-sockets outf inf)
  (make-link :channels 
	     (mapcar #'(lambda (primary-socket) 
			 (new-mathbus-channel primary-socket outf inf))

		     primary-sockets)
  ))


;;;;
;;;; mathbus channels
;;;;

(defstruct (mathbus-channel (:include stream-channel-aux
				      (dispatch-vector (channel-dispatch 'mathbus))))
  )

(defun new-mathbus-channel (sock out-f in-f)
  (make-mathbus-channel :primary-socket sock
			:kind 'mathbus
			:state 'primary
			:out-f out-f
			:in-f in-f))
(defun mathbus-channel-open (channel)
  (socket-channel-open #'(lambda (fd)
			   (let ((s #-cmu (make-io-stream fd fd 'character 'stream:bidirectional-terminal-stream)
				    #+cmu (make-io-stream fd fd 'character 'bidirectional-terminal-stream)))
			     (values s s)))
		       channel))
      
(defun mathbus-channel-close (channel)
  (let ((primary-socket (primary-socket-of-channel channel))
	(secondary-socket (secondary-socket-of-channel channel)))

    #+:lucid (when out-stream (finish-output out-stream))
    (when primary-socket (destroy-socket primary-socket t))
    (when secondary-socket (destroy-socket secondary-socket t))))
    
(defun mathbus-channel-send (channel data)
  ;;(format t "mb send ~%")
  (let ((stream (out-stream-of-stream-channel channel)))   
    (push-io-history data 'send)
    (funcall (out-f-of-stream-channel channel) data stream)
    (io-echo "/")
    (force-output stream)))

(defun mathbus-channel-recv (channel)
   ;;(format t "mb recv ~%")
   (let ((data nil))
    (setf data (funcall (in-f-of-stream-channel channel)
			(in-stream-of-stream-channel channel)))          
    (push-io-history data 'recv)
    (io-echo "\\")   
    data))

(defun mathbus-channel-listen (channel)
  (let* ((stream (in-stream-of-stream-channel channel))
	 (char #\=))

    (loop (if (and (listen stream)
		   (< (pascii2num char) 0))
	      (setf char (read-char stream))
	      (return)))
    (if (>= (pascii2num char) 0)
	(progn (unread-char char stream)
	       t)
	nil)))
   
(defun mathbus-channel-errors (&rest rest)
 (declare (ignore rest)) (values))

