
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************

#+cltl2(in-system-package)
#-cltl2(in-package *system-package-name*)

;;;;	link : send/recv terms
;;;;	bus : wraps terms in addresses/ does multi-tasking/queueing - configure?
;;;;	orb : interprets and routes req/notices.
;;;;	
;;;;	all three could be shared by multiple library instances.
;;;;	


;;;;	
;;;;	<tstate>	: [	
;;;;				<transaction-id>	;; local transaction id.
;;;;				<stamp{begin}>		;; server stamp.
;;;;				<stamp{local}>		;; local stamp.
;;;;				<thread-id>		;; global thread id.
;;;;				<tid-blink>		;; ??
;;;;				<tent{collect}> list	;; mostly relevant in client.
;;;;				<completion> list	;; only relevant in server.
;;;;				<bool{weak}>		;; if t attempt bcast -> fail.
;;;;				<closure{callback}>
;;;;				<*{result}>		
;;;;			  ]
;;;;	
;;;;	should callback/result be stacks. no may be reused recursively but overwrite ok.
;;;;
;;;;	<thread-id>	: (().!transaction_id{<n>:n, <pid>:t} . nil)
;;;;	
;;;;	new-tstate (<transaction-id> <local> <tid> <weak>)
;;;;	  * weak : implies local, causes error if broadcast attempted. remote reqs ok since
;;;;	   no lib state change possible???
;;;;	
;;;;	
;;;;	transaction-id is local to process. It is used in generating stamps during processing
;;;;	on behalf of the transaction. The server or thread-id is not suitable as it is not sensible
;;;;	to combine local time and sequences counts with remote transaction-ids. Client stamps
;;;;	should not be compared to server stamps unlessed paramterized by tstate, and then only
;;;;	for purpose of equality, ie not inequality.
;;;;	
;;;;	
;;;;	tstate-local-p (<tstate>) 	: BOOL
;;;;	  - t if begin and local have same transaction id.
;;;;	tstate-dummy-p (<tstate>)	: BOOL
;;;;	  - seq of local stamp = 0.
;;;;	
;;;;	tstate-set-begin (<tstate> <stamp>)	: NULL
;;;;	  - maybe be called more than once should check stamps same as sanity check.
;;;;	
;;;;	
;;;;	completions-p ()			: BOOL 
;;;;	completions-put (<completion> list)	: NULL
;;;;	completions-get ()			: <completion> list
;;;;
;;;;	completion-push (<completion>)		: NULL
;;;;
;;;;	completion-peek-first () 		: <completion>
;;;;	completion-peek-last ()  		: <completion>
;;;;	
;;;;	
;;;;	Transaction-less-than 
;;;;	  - need reliable comparison for ordering transaction stamps. So that
;;;;	    transaction view is consistent. 
;;;;	 
;;;;	Cannot use time stamps to compare stamp begun in diverses processes
;;;;	due to granularity of stamp (1s), synchronization of clocks, and
;;;;	io time of broadcasts.
;;;;
;;;;	EG: A starts local transaction, and looks up value v of oid o, then
;;;;	B updates value at o with v' via remote transaction. When A looks at o
;;;;	a second time it would be possible for it to believe that v' is older than
;;;;	v and use that when in fact it should use v.
;;;;
;;;;	Stamps from the same process are comparable since sequence count is serialized.
;;;;
;;;;	Tent needs to be able to compare start of one transaction with commit of
;;;;	another.  All tent mods are done in scope transaction (begin of tstate)
;;;;	originating in table server of table containing tent.  However, lookup
;;;;	may be done by any transaction. Lookup should use local begin stamp which
;;;;	will be compared to server commit stamp.
;;;;
;;;;	Thus need ordering of commits with local begins.
;;;;	
;;;;	active list contains tstates ordered(revers) by local begin. could intersperse commits
;;;;	or define new list
;;;;	
;;;;
;;;;	<tent-order>	: (<stamp> . (<token{tag}> . <bool{active}>)) list
;;;;	  * tag : BEGIN | COMMIT
;;;;	  * active only meaningful for BEGIN.
;;;;
;;;;	tent-order is part of environment.
;;;;
;;;;	to compare : search for begin. Once found search remainder for commit.
;;;;	 if commit found the begin older else commit older
;;;;	
;;;;	Any prefix consisting only of inactive begins and commits can be
;;;;	removed: If inactive then will not be used in lookup, if no active
;;;;	begins precede then can assume older than any active by default.
;;;;	
;;;;	When begin made inactive, remove largest prefix possible.
;;;;
;;;;	
;;;;	tent-order-push (<stamp> <tag>) 	: NULL
;;;;	tent-order-delete (<stamp>)		: NULL
;;;;	
;;;;	tent-order-less-than (<stamp{commit}> <stamp{begin}>)	: BOOL
;;;;	

;;;;	
;;;;	TODO : check out what happens if client does local but then makes remote req.
;;;;	  should result in error but I suspect it acts like dummy.
;;;;	
;;;;	<active>	: <tstate> list
;;;;	
;;;;	transaction-state-add (<tstate>)
;;;;	transaction-state-delete (<tstate>)
;;;;	
;;;;
;;;;	<tid>		: !transaction_id{<transaction-seq>:n, <process-id>:t}
;;;;	
;;;;	
;;;;	with-tid (tid &body)
;;;;	with-protect-tid ( &body)
;;;;	
;;;;	with-transaction-state
;;;;	
;;;;	tstate-by-tid (<thread-id>)		: <tstate>
;;;;	tstate-by-begin (<stamp{begin}>)	: <tstate>
;;;;	tstate-by-stamp  (<stamp{local}>)	: <tstate>
;;;;	
;;;;
;;;;	
;;;;	Join/Start transaction :
;;;;
;;;;	with-dummy-transaction (BODY)			: *	
;;;;	with-launch ((<bool{local}>) <closure>)		: NULL
;;;;	with-transaction ((<bool{local}>) BODY)		: *
;;;;	  * fails if called in scope of non-dummy transaction, ie nesting not allowed.
;;;;	  * if not local and current env not a server than reqs callback.
;;;;	  
;;;;	
;;;;	
;;;;	
;;;;	in-transaction-p (<stamp{begin}> <stamp>)	: BOOL
;;;;	  * t if transaction-ids equal
;;;;	      or transaction-id of stamp is equal to local stamp of tstate of begin stamp.
;;;;
;;;;	transaction-less-than (<stamp> <stamp>)
;;;;	  * compares begin stamps of tstates corresponding to stamps.
;;;;	    if not from same process the uses order of tstates.
;;;;	    if no corresponding tstate for one then the one is older.
;;;;	    if no corresponding tstate for both then error.
;;;;
;;;;	need to compare local stamp to commit stamp in table to judge if
;;;;	committed prior to begin of local transaction.
;;;;	so need ordered list of commit stamps (from various servers possibly) with begin
;;;;	stamps in order to test inequlaity of stamps from disparate processes.
;;;;	
;;;;	
;;;;	State Globals needing to be persistent between event dispatches.
;;;;	
;;;;	environment:
;;;;	(defvar *server-address*)
;;;;	orb-defs.lsp:(defvar *resources*)
;;;;	orb-defs.lsp:(defvar *environment-path* nil)
;;;;	orb-defs.lsp:(defvar *environment*)
;;;;	lib-defs.lsp:(defvar *locks* nil)
;;;;	
;;;;	transactions:
;;;;	orb-defs.lsp:(defvar *tid* nil)
;;;;	orb-defs.lsp:(defvar *tid-blink* nil)
;;;;	orb-defs.lsp:(defvar *oid-map*)  ;; may have been made a resource??
;;;;	orb-defs.lsp:(defvar *transaction-state*)
;;;;	bsc-io.lsp:(defvar *transaction-id* nil)
;;;;	
;;;; 	?? not sure about these investigate ??
;;;;	?? need implicit method of moving refs made in clients back to lib. ??
;;;;	com-defs.lsp:(defvar *dependency-event*)
;;;;	com-defs.lsp:(defvar *dependency-environment*)  
;;;;	com-defs.lsp:(defvar *dependencies*)
;;;;	com-defs.lsp:(defvar *current-dependency*)
;;;;	
;;;;	TODO : many defvars could/should be changed to defconstants or defparameters.
;;;;	
;;;;	
;;;;	transaction-begin, transaction-end : server calls to make bcast.
;;;;	transaction-begin-broadcast, transaction-end-broadcast
;;;;	  - called in rsp to receiving bcast
;;;;	
;;;;	transaction-local-begin, ...end : call to do local.
;;;;	
;;;;	transaction-callback
;;;;
;;;;
;;;;	thinks to worry about
;;;;	tid,env.
;;;;	active-list
;;;;	init/cleanup (touch-history) collect
;;;;	tent-order
;;;;	broadcasts
;;;;	
;;;;	client fielding request which has no tid.
;;;;	  - is it local ?
;;;;	  yes, if caller wanted non-local they would have sent a tid.
;;;;
;;;;	if there is a tid, but no matching transaction then need to
;;;;	do callback.
;;;;	  or do callback in any case (can't hurt).
;;;;	  or don't worry about cause it ain't happening at the moment.
;;;;
;;;;	should client simply start transaction.
;;;;	

;;;;	
;;;;	  - configure is done outside of transaction.
;;;;	  - 
;;;;	
;;;;	
;;;;	
;;;;	

;;;;	
;;;;	Orb should support an event model as well as a process model.
;;;;	event model would work well for single threaded implementations.
;;;;	
;;;;	Currently, bus will delay reception of rsps that are not at top of pend queue.
;;;;	Eg, Process A sends req a to process B. a is waiting.
;;;;	Simultaneously B has sent process req b to A. A calls B back with request
;;;;	b'. Simultaneously B replies with rsp to a. The response is queued
;;;;	until A completes b. Note this can arise even though A and B are both 
;;;;	single threaded.
;;;;	
;;;;	
;;;;	Event model: 
;;;;
;;;;	orb-eval-event(<tok{type}> <tok> list{environment-address}
;;;;			<term{req}>
;;;;			<closure{f}>)	: NULL
;;;;	   * f (<term{rsp}>) : NULL
;;;;	
;;;;	
;;;;	
;;;;	 suspend (<tstate> <closure{f}>)
;;;;	   * f (<term>) : NULL
;;;;	
;;;;	 todo: this isn't sufficient, need to link iob with suspend and f.
;;;;	
;;;;	Orb should be able to suspend transaction, ie remember completions,
;;;;	env, etc and re-establish dynamic bindings prior to calling closure.
;;;;	
;;;;	caller of orb_event_eval was called by dispatcher.
;;;;	orb_event_eval should queue the event and return. Caller then returns
;;;;	to dispatcher. Dispatcher chooses new event to dispatch.
;;;;	
;;;;	this is very similar to what mtt process scheduler does, maybe should model
;;;;	on that so in MTT it maps cleanly. MTT allows stack to be suspended not just
;;;;	tstate.
;;;;	  - what can't be done: 
;;;;	      * dynamic bind of variable : eval of closure looks up current value, ie
;;;;		closure does not capture instance of bind.
;;;;	      * cannot call and suspend call, call will complete and result returned
;;;;		via callback. implicit in event model.
;;;;	
;;;;	only io needs to be queued. but might want to queue intra-process inter environment
;;;;	requests. Definitely want to queue inter-env broadcasts, but definitely not intra-env
;;;;	broadcasts.
;;;;	
;;;;	Event model should work very well for calling refiner from editor.
;;;;	
;;;;	modify top-loop for and event eval. Should print req seq no so that you can match
;;;;	rsp with req.
;;;;	

;;;;	


;;;;	
;;;;	transaction end should contain bool to indicate possible failure:
;;;;	
;;;;	consider : client of one type of table is server for another. 
;;;;	EG, environment A is client of table T of server environment B,
;;;;	and A is also server of table S. If B starts transaction b and
;;;;	calls A and A does updates. Then A needs to know if b failed or
;;;;	succeded so as to judge whether to commit or undo its updates.
;;;;	
;;;;	Even more : what if b does partial commit or undo.  b must
;;;;	tell A to commit or undo. So part of b's completion list in
;;;;	B must be a broadcast to complete A. So any request to a remote
;;;;	process must make an entry on the completion list?
;;;;	
;;;;	FTTB, assume sever <-> server transactions not possible, and
;;;;	so no completion need be done after remote request.
;;;;	Could fail when completion queued if local and begin stamps
;;;;	not same.
;;;;	

;;;;	
;;;;	Definitions :
;;;;	  
;;;;	
;;;;	Lookup : access distributed data.
;;;;	
;;;;	Server Transaction : Transaction begun by environment with transaction
;;;;	purpose.  Servers of distributed data have transaction purpose.  Error
;;;;	if broadcast produced in scope of transaction which did not originate in
;;;;	producer of broadcast. Thus at the moment, a single transaction can not
;;;;	be used to cause broadcasts in more than one environment. Could have
;;;;	global transaction server t0o allow distinct producers to use same
;;;;	transaction. This would require extra processid field? one for
;;;;	transaction server and one for producer. Need to ensure that two
;;;;	processes do not produce identical stamp.  If both processes goto
;;;;	t-server for t-seq then not a problem and then do not require server
;;;;	process-id.
;;;;	
;;;;	Callback : A hard-coded request to client in scope of server transaction
;;;;	 initiated by client. Allows client to peform local and remote computations
;;;;	 within same transaction. Request to server for callback may prode server
;;;;	 to init a transaction or may join an active transaction depending on if
;;;;	 server recognizes tid.
;;;;	
;;;;	Local Transaction : transaction which does not produce broadcasts nor
;;;;	makes remote server requests.
;;;;	  - Note: any remote request must be serialized by server to ensure that
;;;;	    both parties are in consistent state wrt distributed data.
;;;;	  - FTTB, all client<->client comminucation should pass through server.
;;;;	    At some point, twould be nice to have fast independent transaction
;;;;	    server to perform serialization. Actually, not necessary to pass through
;;;;	    server as long as receiving client calls server to join transaction.
;;;;
;;;;	Could allow a very weak form of transaction which succeeds without
;;;;	serialization as long as no dependencies are recorded. Eg, a call to
;;;;	edit to pretty print a term.  Uses display table but does not depend
;;;;	upon it.
;;;;
;;;;	Eval : compute. Eval a request and return a reslt. Evals occur in scope
;;;;	 of transaction.
;;;;	
;;;;	Questions :
;;;;	  - lookup : what local used for lookup
;;;;	  - remote req : what tid used for remote call.
;;;;	  - eval : what begin used for eval
;;;;	
;;;;	Scenarios :
;;;;	  - Client receives begin/req*/end sequence.
;;;;	      * Initiated by client maybe in reaction to req recieved, req is callback.
;;;;	      * other.
;;;;	  - Client does local
;;;;	      * Initiated locally.
;;;;
;;;;	Dummy a good idea.
;;;;	Locals should do small things.
;;;;	Default should be init/join server transaction.
;;;;	
;;;;	tstate : connects tid, local stamp, and server (begin) stamp.
;;;;	  - Local eval
;;;;	  - !begin
;;;;	  - !req 
;;;;
;;;;	
;;;;	Receive !req with tid (maybe !transaction req) :
;;;;	  - tid matches active : inherit active.
;;;;	  - with-tid (with-transaction not local dont inherit, with result
;;;;		join/start transaction then do req.
;;;;	
;;;;	Eval (not in reaction to req) : with-transaction 
;;;;	  - (with-protect-tid (with-transaction BODY))
;;;;	    ie init tid local and add tstate. if server local = begin, then eval begin BODY end.
;;;;	
;;;;	Receive !begin(<stamp> <tid> :lib
;;;;	  - tid matches active : update tstate.
;;;;	  - otherwise add-tstate tid begin new local
;;;;
;;;;	
;;;;	Criteria : seeing the effects of a concurrent transaction is not good.
;;;;	  
;;;;
;;;;	Dummy transaction : not a real transaction.
;;;;	  - dummy new transaction-id but pre-determined sequence count, ie 0.
;;;;	  - local from dummy but not serialized, lookups using dummy
;;;;	    always find last commit.
;;;;	  - each remote request distinct server transaction.
;;;;
;;;;	Nesting is not good.
;;;;
;;;;	Local inheriting callers local transaction state is acceptable.
;;;;	
;;;;	Launching a transaction ok as closures not passed and no data 
;;;;	returned. May not be able to control globals.
;;;;	
;;;;	    Remote transactions can not be asynchronously launched without
;;;;	    serialization, ie a request with ack rsp.  the request may contain
;;;;	    data which is ahead of the state of the client. Server S broadcasts
;;;;	    commit b. Client A does commit of b and launches transaction in
;;;;	    Client C before C receives b.  C now has inconsistent view.
;;;;
;;;;	If client does call to server to serialize then req rsp to req 
;;;;



;;;;	  - Server receives transaction request
;;;;	  - Server receives request from callback.
;;;;	  - Server receives request 
;;;;	
;;;;	Implementation : bus-eval, environment-eval, lookup, 
;;;;	

;;;;	
;;;;	asynchronous callbacks : ie don't wait for refiner.
;;;;	
;;;;	mechanism : send req which launches new transaction in receiver.
;;;;	  new transacition includes a call to sender with result.
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	transaction is asynch or req is asynch?
;;;;	 req is problemmatical as caller may test failure.
;;;;	client does not wait for rsp or server rsp prior to eval?
;;;;	
;;;;
;;;;	  - lib : send posure to refiner to be applied to result of refine
;;;;	    to update lib.
;;;;	  - edd :
;;;;	      * lib posure contains call to edd to update edd.
;;;;	  	modify contents of some window and then optionally raise.
;;;;	      * any ***_eval not to term can be asynchronous wrt edd.
;;;;		failures: could be routed back to caller?
;;;;		cannot simply convert void requests to asynch as 
;;;;		caller may do test for failure. thus need special wrapper?.
;;;;	
;;;;	



;;;; -docs- (mod com)
;;;;
;;;;	Stamp :
;;;;
;;;;	stamp-to-term (<stamp>)		: <term>
;;;;	term-to-stamp (<term>) 		: <stamp>
;;;;	
;;;;	stamp-to-string (<stamp>)	: <string>
;;;;	string-to-stamp (<string>)	: <stamp>
;;;;
;;;;	The string representation of a stamp is the string representation
;;;;	of the term of the stamp.
;;;;	
;;;; -doce-


(defvar *component-kind* "???")	;; expect edd or lib, etc.


(defvar *dependencies*)

(defun noting-dependencies ()
  (and (boundp `*dependencies*)
       (not (eql 'not *dependencies*))))

(defmacro without-dependencies(&body body)
  `(let ((*dependencies* 'not))
    (prog1 (progn ,@body))))

(defmacro not-without-dependencies (&body body)
  `(let ((*dependencies* nil))
    (multiple-value-prog1 (progn ,@body)
      (when (and *dependencies* t)
	(dependency-note-dependencies *dependencies*)))))



(defun stamp-to-string (s)
  (term-to-standard-character-string (stamp-to-term s)))  

(defun string-to-stamp (s)
  (term-to-stamp (standard-character-string-to-term s)))  


;;(define-primitive |!expression| () (term))
;;(define-primitive |!command| () (term))
;;(define-primitive |!query| () (term))

(defparameter *iexpression* '|!expression|)
(defparameter *icommand*    '|!command|)
(defparameter *iquery*      '|!query|)



(defun expression-aux-term (id term &optional orb-p readonly-p implicit-eval-ok)
  (declare (ignore implicit-eval-ok))
  (instantiate-term (instantiate-operator id
					  (cons (bool-parameter (and orb-p t))
						(when readonly-p
						  (list (bool-parameter t)))))
		    (list (instantiate-bound-term term))))

(defun expression-aux-term-p (id term)
  (and (eql id (id-of-term term))
       (let ((parms (parameters-of-term term)))
	 (or (null parms)
	     (and (bool-parameter-p (car parms))
		  (or (null (cdr parms))
		      (and (null (cddr parms))
			   (bool-parameter-p (cadr parms)))))))
		      
       (let ((bts (bound-terms-of-term term)))
	 (and (null (cdr bts))
	      (null (bindings-of-bound-term (car bts)))))))
	 

(defun term-of-iexpression-aux-term (term)
  (term-of-bound-term (car (bound-terms-of-term term))))



(defun iexpression-term (term &optional orb-p readonly-p)
  (expression-aux-term *iexpression* term orb-p readonly-p))

(defun iquery-term (term &optional orb-p)
  (expression-aux-term *iquery* term orb-p))

(defun icommand-term (term &optional orb-p)
  (expression-aux-term *icommand* term orb-p))

(defun iexpression-term-p (term)
  (expression-aux-term-p *iexpression* term))

(defun icommand-term-p (term)
  (expression-aux-term-p *icommand* term))

(defun iquery-term-p (term)
  (expression-aux-term-p *iquery* term))

(defun inter-orb-transaction-expression-p (term)
  (let ((orb-p (car (parameters-of-term term))))
    (and orb-p
	 (eql t (value-of-parameter orb-p)))))

(defun readonly-transaction-expression-p (term)
  (let ((ro-p (cadr (parameters-of-term term))))
    (and ro-p
	 (eql t (value-of-parameter ro-p)))))

(defun transaction-expression-implicit-eval-ok (term)
  (let ((ro-p (caddr (parameters-of-term term))))
    (and ro-p
	 (eql t (value-of-parameter ro-p)))))


(define-primitive |!msg| ((natural . sequence)) (message))

(define-primitive |!ack|) 

;;(define-primitive |!fail| () (message))
;;(define-primitive |!value| () (term))
;;(define-primitive |!print| () (output))

(defparameter *ifail-op* (instantiate-operator '|!fail| nil))
(defparameter *ivalue-op* (instantiate-operator '|!value| nil))
(defparameter *iprint-op* (instantiate-operator '|!print| nil))

(defun ifail-term-p (term)
  (equal-operators-p *ifail-op* (operator-of-term term)))

(defun ifail-term (msg &rest msgs)
  (instantiate-term *ifail-op*
		    (cons (instantiate-bound-term msg)
			  (mapcan #'(lambda (msg)
				      (when msg
					(list (instantiate-bound-term msg))))
				  msgs))))

(defun ivalue-term-p (term)
  (and (equal-operators-p *ivalue-op* (operator-of-term term))
       (let ((bound-terms (bound-terms-of-term term)))
	 (forall-p #'(lambda (bt) (null (bindings-of-bound-term-n bt)))
		   bound-terms))))

(defun ivalue-term (msg &rest msgs)
  (instantiate-term *ivalue-op*
		    (cons (instantiate-bound-term msg)
			  (mapcan #'(lambda (msg)
				      (when msg
					(list (instantiate-bound-term msg))))
				  msgs))))

(defun iprint-term-p (term)
  (and (equal-operators-p *iprint-op* (operator-of-term term))
       (let ((bound-terms (bound-terms-of-term term)))
	 (forall-p #'(lambda (bt) (null (bindings-of-bound-term-n bt)))
		   bound-terms))))


(defun iprint-term (msg &rest msgs)
  (instantiate-term *iprint-op*
		    (cons (instantiate-bound-term msg)
			  (mapcan #'(lambda (msg)
				      (when msg
					(list (instantiate-bound-term msg))))
				  msgs))))

(defun msg-of-iprint-term (term)
  (term-of-bound-term (car (bound-terms-of-term term))))

(defun messages-of-iresult-term (term)
  (mapcar #'term-of-bound-term-f (cdr (bound-terms-of-term term))))

(defun result-of-iresult-term (term)
  (term-of-bound-term (car (bound-terms-of-term term))))


(defun ifail-term-fail (term)
  (let ((terms (messages-of-iresult-term term)))
    (when terms
      (message-emit (degenerate-term-message terms))))

  (raise-error (degenerate-term-message (result-of-iresult-term term))))


;;;
;;;	broadcasts
;;;

(define-primitive |!passport| ((token . table-type)) (stamp description broadcast))

;;(define-primitive |!broadcasts| ((token . type) (bool . auto-commit))
;;		(stamp auto-commit broadcast))
;;(define-primitive |!broadcasts| ((token . type)) (stamp broadcast))

(defvar *ibroadcasts* '|!broadcasts|)

(defun ibroadcasts-op (type)
  (instantiate-operator *ibroadcasts*
			(list (token-parameter type))))

(defun type-of-ibroadcasts-term (term)
  (value-of-parameter (car (parameters-of-term term))))

(defun auto-commit-of-ibroadcasts-term (term)
  (let ((restp (cdr (parameters-of-term term))))
    (when (and restp (value-of-parameter (car restp)))
      (term-of-bound-term (cadr (bound-terms-of-term term))))))


(defun stamp-of-ibroadcasts-term (term)
  (term-of-bound-term (car (bound-terms-of-term term))))


(defun broadcasts-of-ibroadcasts-term (term)
  (let ((restp (cdr (parameters-of-term term))))
    (if (and restp (value-of-parameter (car restp)))
	(cddr (bound-terms-of-term term))
	(cdr (bound-terms-of-term term)))))

(defun ibroadcasts-term-p (term)
  (eql *ibroadcasts* (id-of-term term)))

(defun ibroadcasts-auto-commit-term (type t-stamp ac-stamp bound-passports)
  (instantiate-term (instantiate-operator *ibroadcasts*
					  (list (token-parameter type)
						(bool-parameter t)))
		    (list* (instantiate-bound-term (stamp-to-term t-stamp))
			   (instantiate-bound-term (stamp-to-term ac-stamp))
			   bound-passports)))

  

;;;
;;;	ML
;;;

(define-primitive |!ML_woargs| ((bool . parse-p) (bool . result-p)) (text))

(defparameter *iml* '!ML)
(defparameter *iml-op* (instantiate-operator '!ML nil))

;;(defun iml-op () *iml-op*)

(defun iml-term-p (term)
  (and (eql *iml* (id-of-term term))
       (let ((bound-terms (bound-terms-of-term term)))
	 (and bound-terms
	      (forall-p #'(lambda (bt) (null (bindings-of-bound-term-n bt)))
			bound-terms)))))
	 
(defun text-of-iml-term (term)
  (term-of-bound-term (car (bound-terms-of-term term))))

(defun data-of-iml-term (term)
  (mapcar #'term-of-bound-term-f (cdr (bound-terms-of-term term))))


(defun iml-op (&optional parse-p result-p)
  (let ((bool (type-id-to-type 'bool)))
    (instantiate-operator *iml*
			  (list (instantiate-parameter (and parse-p t) bool)
				(instantiate-parameter (and result-p t) bool)))))

(defun result-p-of-iml-term (term)
  (let ((parameters (parameters-of-term term)))
    (and (cdr parameters) (value-of-parameter-r (cadr parameters)))))

(defun parse-p-of-iml-term (term)
  (let ((parameters (parameters-of-term term)))
    (and parameters (value-of-parameter-r (car parameters)))))

(defun iml-term (parse-p result-p term data)
  (let ((bool (type-id-to-type 'bool)))
    (instantiate-term (instantiate-operator *iml*
					    (list (instantiate-parameter (and parse-p t) bool)
						  (instantiate-parameter (and result-p t) bool)))
		      (cons (instantiate-bound-term term)
			    (mapcar #'instantiate-bound-term data)))))


(define-primitive |!stamp| ((n . sequence) (time . time) (n . transaction) (t . process-id)))
(define-primitive |!variable| ((variable . id)))
(define-primitive |!token| ((token . token)))    
(define-primitive |!void|)
(define-primitive |!placeholder|)
  

(defun stamp-to-term (stamp)
  (if (null stamp)
      (ivoid-term)
      (istamp-term (sequence-of-stamp stamp)
		   (time-of-stamp stamp)
		   (transaction-of-stamp stamp)
		   (process-id-of-stamp stamp))))

(defun term-to-stamp (term &optional void-ok-p)
  (cond
    ((and (ivoid-term-p term) void-ok-p)
     nil)
    ((istamp-term-p term)
      (cons (cons (transaction-of-istamp-term term) (process-id-of-istamp-term term))
	    (cons (sequence-of-istamp-term term) (time-of-istamp-term term))))
    (t (raise-error (error-message '(stamp term) term)))))




;;;
;;;	touch history
;;;

(defstruct touch-history
  (list nil))

(defun clear-touch-history (th)
 ;; (break "cth")
 (setf (touch-history-list th) nil))

(defun list-touch-history (th)
  (touch-history-list th))

;;(defun touch-history-push (record th)
;;  (when (and record th)
;;    (push record (touch-history-list th))))


;;;;	
;;;;	Orb : Object Request Broker. The orb described here does not 
;;;;	  conform to any standard. It does however server a similar role
;;;;	  as the standardized orbs.
;;;;
;;;;	
;;;;	Heavily loaded heavy-weight process : one lisp process containing
;;;;	 all environments per hardware box.
;;;;	  + share overhead
;;;;	  + share lisp overhead.
;;;;	  ++ share terms (allocate a compression level to encompass entire lisp process!).
;;;;	  +++ reduce io.
;;;;	  - overtax GC : if many users, but many users -> BIG hardware so maybe not an issue.
;;;;
;;;;	environment : persistent replicatable serializable data (may be distributed, may be shared).
;;;;	ML-state : programs and dynamic values (not distributed, may be shared).
;;;;	
;;;;	ML-state and environment comprise user model :
;;;;	 FTTB single ml-state per process, makes sharing of process problemmatical.
;;;;	 Eventually make ml-state parameterized by user/proccess-thread group.
;;;;	
;;;;	 Environments may be shared. Underlying data is shared invisibly.
;;;;	 Import/Export or lib-to-lib functionality to update central repository.
;;;;	  - users should be presented with a unique resource and then take concrete
;;;;	    action to update shared resource.
;;;;	
;;;;	Orb : connects environments and does data sharing.
;;;;
;;;;	
;;;;	User Model :
;;;;	  - refiner: for independence of proofs, ml-state required at refinement
;;;;	    should be parameterized through the library.
;;;;	    State may be dynamic as user codes tactics.
;;;;	  - library : should be static, but does not rely on that.
;;;;	  - edit : backend may be static or have unshared portions. Presentation
;;;;	    will be unique to user.
;;;;	
;;;;	General reasons to share : 
;;;;	  - remote debug by author. Ie user has tactic prob. Tac Author can share users refiner to
;;;;	    debug problem.
;;;;	  - more efficient utilization of resources.
;;;;
;;;;	Monolithic tables might not seem good idea. As you would like to share stable parts
;;;;	of lib. However, even with monolithic tables, table contents can be shared even if
;;;;	tables themselves are not. Simpler to have monolith especially if you do go back and
;;;;	modify within stable portion.
;;;;
;;;;	All lisp parameters hidden.
;;;;	desire multiple users to share process but have unique ml-state?
;;;;	- multiple ml-states sharing same tables?? Have own state but affect
;;;;	  shared library.
;;;;
;;;;
;;;;	component : list of environments
;;;;	  environments can share structures but not environment parameters.
;;;;	
;;;;	environment : should include all parameterizable features.
;;;;	 
;;;;	Orb hides remote/near distinction between environments defines replication
;;;;	 protocol for environment.
;;;;	

;;;;	compression : possible level allocation schemes:
;;;;
;;;;	IO :
;;;;	 level0 : encompasses connected components link.
;;;;	 level1 : encompasses duplex io session.
;;;;	 level2 : encompasses half-duplex io-transmission.
;;;;	 
;;;;	Process :
;;;;	 level0 : encompasses process.
;;;;	 level1 : encompasses environment.
;;;;	 level3 : encompasses accessible object.
;;;;
;;;;	Environment :
;;;;	 level0 : encompasses environment.
;;;;	 level1 : encompasses object history.
;;;;	 level2 : encompasses accessible object.
;;;;

;;;; 	cmd-eval (<tag> list <term>)
;;;;	 * tag list is destination.
;;;;	
;;;;	broadcast ( )			: (values)

;;;;	
;;;;	extent : local, ORB(component, remote)
;;;;	

;;;;	local-produce : types of tables environment generates broadcasts for.
;;;;	remote-produce	: types of tables we wish to listen for broadcasts of.
;;;;	environment-resources : resources we wish to listen for broadcasts of.
;;;;	  - possible to listen for bcast from more than one source (including local)
;;;;	    for same table types.
;;;;	  - at the moment, lookup can not handle multiple tables with same name, however
;;;;	    we may want to generalize at some point.

;; remote	: (type . (<addr> . <name> list) list) list
;; local 	: <name> list
;; environment 	: <name> list 


;;;;
;;;;	Environment :
;;;;	

;;;;
;;;;	Table : Replicatable data.  (table defined by broadcast table-type)
;;;;	  Characterized by the producer.
;;;;	  Various flavors : a subset of the data may be replicated rather than entire table.
;;;;
;;;;	Module : set of program functions. A module operates on a set of tables.
;;;;	 Modules may be co-resident, ie share the same process.
;;;;	 Tables may be shared among modules. 
;;;;	 
;;;;	Environment : tables and modules.
;;;;	  - modules may be loaded which are not used by the environment.
;;;;	  - environment functionality is parameterized by the tables in the environment.
;;;;
;;;;	Producer : environment which builds and broadcasts a table.
;;;;	Consumer : environment which receives and builds a remote
;;;;		   representation of the table.
;;;;	  - remote representation is(may be) a table.
;;;;	  - an environment may be both a consumer and a producer but not of the
;;;;	    same table.
;;;;	
;;;;	Producer broadcasts flavors of table.
;;;;	Consumer may require multiple representations of same flavor.
;;;;	Consumer may represent multiple flavors in same table.
;;;;
;;;;	It is expected but not required that a module will require a single
;;;;	flavor and a single representation of a table. Sharing then is mostly an
;;;;	artifact of co-resident modules.
;;;;	
;;;;	Some flavors of the same table can be shared by co-resident components.
;;;;	  - must be able to lookup shared co-resident tables by same name.
;;;;	      * map distinct flavor names to resident table.
;;;;	  - must allocate more robust flavor of shared co-resident tables.
;;;;	      * must order shareable flavors.
;;;;	  - must avoid applying weak broadcasts to strong shared co-resident tables.
;;;;	      * don't use mapping when applying broadcasts.
;;;;	Some may not be shared : the data received is same but organized
;;;;	incompatably by receiver. It may be that the same flavor may be need to
;;;;	be in two distinct tables.
;;;;	  - must have distinct name for each required unsharable table.
;;;;	  - must allocate distinct tables for each required unsharable table.
;;;;	  - must receive broadcasts for each required unsharable flavor.
;;;;
;;;;
;;;;	Life Phases of Tables : both local and remote representations.
;;;;
;;;;	Allocate :
;;;;	  Each table name corresponds to a table allocation function.
;;;;	  Only allocate most robust flavor and include table and robust name in
;;;;	  environment.
;;;;	
;;;;	Lookup:
;;;;	  When shared co-resident table of different flavors used, then a lookup
;;;;	  mapping must be defined. Mapping is part of environment.
;;;;
;;;;	Broadcast : table-type uniquely defines syntax of broadcast.
;;;;	  name -> table type mapping used to determine suitability of broadcast
;;;;	  for table.  Find all names using table type of broadcast, then find
;;;;	  tables with name in environment.  mapping is persistent.  Global
;;;;	  persistent mapping.
;;;;
;;;;	Configuration :
;;;;	  - defines list of names (without duplicates) of needed resources.
;;;;	    Must have only one name for a shared co-resident table.
;;;;	    environment-sig.
;;;;	  - defines mapping of names to environment resources for shared co-resident tables.
;;;;	    resource-map.
;;;;	  - defines mapping of broadcast table types to names of environment resources.
;;;;	    also: defines mapping of name of environment resource to broadcast table types.
;;;;	    broadcast-map.
;;;;	  - which environments to connect to, how to connect, and what table types to listen for.
;;;;	      * table types broadcast
;;;;	
;;;;	
;;;;	At a later date, we can define some configuration tools. FTTB, ok to hardcode most of this.
;;;;	
;;;;	
;;;;	<process>	: <component>
;;;;
;;;;	<component>	: (<environment>) list
;;;;
;;;;	<env-address>	: <token> list
;;;;	<environment>	: (<env-address> . <resource> list)
;;;;
;;;;	<resource>	: (<name> . <table>)
;;;;
;;;;	<env-sig>	: <resource-sig> list
;;;;	
;;;;	<resource-sig>	: <name>
;;;;
;;;;	
;;;;	** table contains stamp.
;;;;	** environment has stamp. Local produce tables use stamp.
;;;;	

;;;;
;;;;	Environment functions :
;;;;
;;;;	initialize-environment(<env-address> <env-sig> <tok> list{reduction tags})
;;;;	  : NULL
;;;;	  * env-sig is list of resources produced locally.
;;;;	  * reduction tags are used in source reduce by environment-eval???
;;;;
;;;;	with-environment-tag ((<tag>) &body)	: Macro
;;;;	  * narrows the choice of environments.
;;;;
;;;;	with-environment ([<tag> | <tag> list] &body) 	: Macro
;;;;	  * binds environment
;;;;
;;;;	current-environment ()			: ENVIRONMENT
;;;;
;;;;	environment-add-remote-resources (ENVIRONMENT, <remote-resources> list ) 
;;;;	  * <remote-resources> : (<stamp> . <resource-sig> list)
;;;;	  
;;;;	
;;;;	environment-resource (<name>) 		: <table>
;;;;
;;;;	environment-eval (term)			: <term>
;;;;	  * evals term in current environment.
;;;;


;;;;
;;;;	Table type to table name map:
;;;;	
;;;;	<table-name-map>	: (<name> . <table> list) list
;;;;	  * <table> is table type from broadcast terms.
;;;;	  * ie <broadcast> : <opid>{<sequence>:n, <table>:t, ...}(...)
;;;;
;;;;	broadcast-types-of-resource-name (<name>)	: <table> list
;;;;	broadcast-types-of-resource-names (<name> list)	: <table> list
;;;;	  * result contains no duplicates.
;;;;	




;;;;  -page-
;;;;	
;;;;	Component Expressions:
;;;;
;;;;	<transmission>	: <request>
;;;;			| <notice>
;;;;			? <interrupt>
;;;;			
;;;;	<request>	: !req{<sequence>:n, <type>:t, <env>:t}(<expression>)
;;;;			| !req{<sequence>:n, <type>:t, <env>:t}(<expression>; <tid>)
;;;;			| !rsp{sequence>:n}(<result>)
;;;;			| !msg{<sequence>:n}(<message-term>)
;;;;	
;;;;	<type>		: CALLBACK | <tooltalk-type>?
;;;;	
;;;;	<message-terms> : EPSILON
;;;;			| ; <message-term> <message-terms>
;;;;	
;;;;	Messages may be sent before rsp or with rsp.
;;;;
;;;;	Note the asymmetry between the req and the rsp. Only the request has
;;;;	routing information. The response is simply returned via the same
;;;;	channel the request was received.
;;;;
;;;;	Note that there may be any number of messages for a single request
;;;;	but there must be one (no more, no less) response.
;;;;
;;;;	Broadcast type will be either LIB or DMS.
;;;;
;;;;
;;;;	<bcasts>	: !broadcasts(<broadcasts>)
;;;;	
;;;;	<broadcasts>	: <broadcast> 
;;;;			| <broadcasts>; <broadcast>
;;;;
;;;;	<expression>	: !expression{<orb>:b}(<ml-expr>)
;;;;			| !expression{}(<ml-expr>)
;;;;			| <configure>
;;;;			| !command{<orb>:b}(<command>)
;;;;			| !query{<orb>:b}(<query>)
;;;;
;;;;			| !command(!transaction{<checkpoint>:bool}(<term{callback}>))
;;;;			| !command(!callback(<stamp>)
;;;;	  * server receives !req{...}(!transaction{...}(<term{callback}>); <tid>)
;;;;	    then sends !req{CALLBACK...}(!command(<term{callback}>); <tid)
;;;;	    if  checkpoint true
;;;;		checkpoint commits pending completions and disallows lib state-change (broadcasts) in
;;;;		tid until callback returns.
;;;;	  * orb bool : if new transaction start inter-orb transaction.
;;;;
;;;;	<result>	: !value(<term> <message-terms>)	{ expression }
;;;;			| !print(<term> <message-terms>)	{ expression }
;;;;			| !fail(<term> <message-terms>)		{ expression }
;;;;			| !ack()
;;;;			| !configure(!inform<info>)
;;;;
;;;;  -page-
;;;;
;;;;	ML expressions:
;;;;
;;;;	<ml-expr>		: !ML_woargs<ml-bits>(<term{text}>)
;;;;				| !ML<ml-bits>(<term{text}> <term-list>)
;;;;				| !LISP(<term{text}>)
;;;;
;;;;	<term-list>		: EPSILON
;;;;				| ; <term> <term-list>
;;;;
;;;;	<ml-bits>		: {<parse-p>:b, <result-p>:b}
;;;;				| {}
;;;;
;;;;	  ** If parse-p true, then expression should be parsed and type-checked
;;;;	     but not evaluated.
;;;;	  ** If result-p is true then expect !value or !print result. Otherwise expect !ack.
;;;;	  ** !value is returned if expression evaluated to a term. Othewise !print is returned.
;;;;
;;;;	
;;;;	
;;;;	
;;;;  -page-
;;;;
;;;;
;;;;	<configure>	: !configure(!inform(<info>))
;;;;			| !configure(!request(<info>))
;;;;			| !configure(!revoke(<info>))
;;;;	
;;;;	<info>		: <address{environment}>
;;;;			| <compression>
;;;;			| <table-types{produce}>
;;;;			| <start{broadcasts}>
;;;;			| <connect>
;;;;			| <disconnect>
;;;;			| <no-ack>
;;;;			
;;;;	
;;;;	<address>	: !environment_address{<tok>:t list}
;;;;	 * inform after request is first address matching tag list.
;;;;	   Any address containing all tags is considered a match.
;;;;	   Order of search is newest to oldest except that
;;;;	   null tags results in default orb address.
;;;;	 * revoke means revoke link address or remote site revoked local
;;;;	   depending on whether address is a local or remote address.
;;;;	
;;;;	<filename>	: !filename{<tok{root}>, <string<name>, <string{type}>, <tok{dir}> list}
;;;;			| !filename{<string{root}>, <string<name>, <string{type}>, <tok{dir}> list}
;;;;	  ** does not take effect until after response is sent.
;;;;	     MTT TODO : must queue something on queue to delay effect.
;;;;	  ** tok root indicates predefined path.
;;;;	  
;;;;	<table-types>	: !table_types{<types>}(<address{producer}>)
;;;;	  * in a request null types implies inform of all produced.
;;;;	  * otherwise informs of intersection of <types> and produce.
;;;;	
;;;;	<start>		: !start(<table-types{producer}>
;;;;				 <stamp>;
;;;;				 <address{consumer}>;
;;;;				 <description>)
;;;;			| !start(<table-types{producer}>
;;;;				 <stamp{producer}>;
;;;;				 <address{consumer}>
;;;;				 <bcasts>)
;;;;
;;;;	    in a request stamp is consumer (source).
;;;;	    in a revoke stamp is source.
;;;;	    if consumer wishes to remain anonymous then !void() may be used as stamp.
;;;;	  * broadcasts may be included in an inform.
;;;;
;;;;	<connect>       : !connect{port:n, host:s}
;;;;
;;;;	  * sent as inform to inform recipient of host and port on which to connect for bidirectionality
;;;;	  ** recipient connects, then responds with ack or fails (if connect fails)
;;;;
;;;;	<disconnect>	: !disconnect{<error-p>:b}
;;;;	  * sent as inform to inform recipient of desire to disconnect
;;;;	    recipient responds with ack, then disconnects
;;;;	  * if error-p true then send ack on primary stream
;;;;
;;;;	<no-ack>	: !noack{}       
;;;;
;;;;	  * sent as inform to inform recipient of a failure to read a term
;;;;	  ** rarely used, but necessary to prevent a sender of a req from
;;;;	     waiting indefinitely in the event that the receiver fails outside of
;;;;	     protected zone (ie receiver knows something is on the stream, but cannot
;;;;	     interpret or acknowledge the term)
;;;;	  *** recipient removes any pending requests of sender, responds with !ack{}, then fails
;;;;
;;;;
;;;;	The rsp to a request should be an inform.
;;;;	The rsp to an inform should be an ack.
;;;;	The rsp to a revoke should be an ack.
;;;;
;;;;	
;;;;	Configure : the exchange of state to connect two orbs.
;;;;	
;;;;	  Import : the reception of configuration information.
;;;;	  Export : the transmission of configuration information.
;;;;	
;;;;	  Inform  : a transmission of configuration data.
;;;;	    * builds shared state.
;;;;	  Revoke  : a tranmission informing the receiver that the sender
;;;;		    is removing previously received information.
;;;;	    * tears down shared state.
;;;;	  Request : a transmission requesting the receiver to inform.
;;;;
;;;;	 
;;;;	The sender treats informs/revokes as exports and the receiver treats
;;;;	them as imports.
;;;;
;;;;	<config-state>		: !inform(<info>) | !revoke(<info>)
;;;;	<config-request>	: !request(<info>)
;;;;
;;;;	<delay>			: CLOSURE
;;;;	  * a delay is held by the orb until the associated term is sent.
;;;;	    It is then evaluated. This allows modification of the orb
;;;;	    not to effect the orb until the rsp has been sent. 
;;;;
;;;;	configure-receive (<configure>) : (values <term{result}> <delay>)
;;;;	  * called when orb receives <configure>
;;;;	  * if request received, calls configure-request
;;;;	    if state received, calls configure-import.
;;;;
;;;;	configure-request (<config-request>) : (values (!inform(<info>)) <delay>)
;;;;	  * exports state prior to return.
;;;;	
;;;;	configure-import(<config-state>)	: values  (<iack> <delay>)
;;;;	configure-export(<config-state>)	: NULL
;;;;	
;;;;	
;;;;	Tranmission Syntax :
;;;;	
;;;;	>> 	: send in one direction.
;;;;	<<	: send in other direction.
;;;;	[x]*	: send 0 or more sequences of x.
;;;;	[x]+	: send 1 or more sequences of x.
;;;;	
;;;;	WITH	: indicates a specializtion of a sequence.
;;;;	WITHOUT : indicates all subsequent terms should be considered to be wrapped in indicated operators.
;;;;	\ 	: indicates that term should be literal and not considered to be wrapped by nearest without.
;;;;		  multiple levels could be escapped by duplication \.
;;;;
;;;;
;;;;	<transmission>		:>> <req>
;;;;				 << [<callback> | <notice>]*
;;;;				 << <rsp>
;;;;
;;;;	<callback>		:<< <req>
;;;;				 >> [<transmission> | <notice>]*
;;;;				 >> <rsp>
;;;;
;;;;	WITH <req> = !req{...}(!configure(<config>)
;;;;	WITHOUT !req & !rsp 
;;;;
;;;;	<ctransmission>		: <config-request>
;;;;				| <config-state>
;;;;	
;;;;	<config-state>		:>> !configure(!inform(<config-state>))
;;;;				  | !configure(!revoke(<config-state>))
;;;;				 << <ack>
;;;;				  | <fail>
;;;;	
;;;;	<config-request>	:>> !configure(!request(<config-request>))
;;;;				 << !configure(!inform(<info>))
;;;;				  | <fail>
;;;;
;;;;	<config-state>		: <address>
;;;;				| <table-types{produce}>
;;;;				| <start{broadcasts}>
;;;;				| <connect>
;;;;	
;;;;	<config-request>	: <address>
;;;;				| <start{broadcasts}>
;;;;	
;;;;
;;;;	<connect-transmission>	>> !inform(<connect>)
;;;;				<connect-reply>
;;;;
;;;;	<connect-reply>		:<< <ack>
;;;;				  | <connect-ack-fail>
;;;;				  | <connect-fail>
;;;;	
;;;;	<connect-ack-fail>	<< <ack>
;;;;				>> !inform(<disconnect>)
;;;;				<< <ack>
;;;;	
;;;;	<connect-fail>		<< <fail>
;;;;				>> !inform(<disconnect>)
;;;;				<< <ack>
;;;;	

;;;;	
;;;;	Directives produce broadcasts which effect tables. Some tables 
;;;;	contain library data, some are exported to other environents.
;;;;	
;;;;	The persistent store is maintained by capturing broadcasts.
;;;;	Restore is done by producing broadcasts.
;;;;	
;;;;	<notice>	| !broadcasts{<type>:t, true{auto-commit}:b}
;;;;					(<stamp{transaction}>; <stamp{auto-commit}>; <broadcasts>)
;;;;			| !broadcasts{<type>:t, false{auto-commit}:b}
;;;;					(<stamp{transaction}>; <broadcasts>)
;;;;			| !broadcasts{<type>:t}(<stamp{transaction}>; <broadcasts>)
;;;;	  * bool parameter indicates presence of auto-commit stamp.
;;;;	    absence of bool parameter indicates absence of auto-commit stamp.
;;;;
;;;;	<broadcasts>	: <passport> 
;;;;			| <broadcasts>; <passport>
;;;;
;;;;	<passport>	: !passport{<table-type>:t}(<stamp{table}>; <description>; <broadcast>)
;;;;	  * description is object descripiton for insert/delete and lib-description for activate allow
;;;;	    and insert/delete of bind info.
;;;;	
;;;;	<broadcast>	: 
;;;;
;;;;			| !definition_activate{<seq>:n, <oid>:o}()
;;;;			| !definition_deactivate{<seq>:n, <oid>:o}()
;;;;
;;;;			| !definition_allow{<seq>:n, <oid>:o}()
;;;;			| !definition_disallow{<seq>:n, <oid>:o}()
;;;;
;;;;			| !definition_insert{<seq>:n}(<definition>)
;;;;			| !definition_delete{<seq>:n, <oid>:o}()
;;;;		
;;;;			| !undo{<seq>:n, <oid>:o}()
;;;;			| !commit{<seq>:n, <oid>:o}(<stamp>)
;;;;
;;;;			| !begin(<stamp>, <tid>)
;;;;			| !end(<stamp>)
;;;;
;;;;			| !checkpoint(<stamp>)
;;;;
;;;;	 * commit stamp is stamp  at time of commit.
;;;;
;;;;	In some sense checkpoint is bigger than a transaction in that it sees all commits to that point
;;;;	even if some transaction are still active.
;;;;	
;;;;	Stamp in !broadcasts is used as commit stamp for auto-commit.





;;;;	Local link should know what info has been sent so as to revoke
;;;;	when env or link to be closed. remote site needs to be able to initiate revoke ?
;;;;	Certainly true for broadcasts.
;;;;	
;;;;	unrevoked informs of address, tables-types and broadcasts should be discernable.
;;;;	
;;;;	seems best place to keep is on links a'la broadcast sentries.
;;;;	exposed : address - table-types - broadcast
;;;;	 or automatically revoke address (and implicitly table-types) at close-env and receiver no-ops
;;;;        when unknown. 
;;;;	 + shutdown broadcasts for all sentries with producer stamp if producer or consumer stamp if consumer.
;;;; 
;;;;	??? Journal ???
;;;;	
;;;;	


;;;;	OLD STUFF : needs to be updated
;;;;
;;;;	broadcast sentries : checks if broadcast permitted to pass.
;;;;	  - Desire sentry at producer link to avoid unnecessary transmissions.
;;;;	  - Need sentry at consumer environment to avoid eval of inappropriate broadcasts.
;;;;	    Note that broadcasts may be produced by other environments of component
;;;;	    or enter component to be consumed by other environments.
;;;;	 
;;;;	Producers and consumers are identified by stamps. Producer must put identical stamp
;;;;	in all broadcasts. 
;;;;
;;;;	<sentry>	: <permit> list
;;;;
;;;;	<type-sentry>	: (<table-type> . <permit> list)
;;;;
;;;;	<permit>	: (<stamp{producer}> . [<stamp{consumer}> | t] list)
;;;;
;;;;	At producer link, broadcast is transmitted if there is any consumer with a permit.
;;;;	At consumer environment, broadcast is transmitted if producer has a permit.
;;;;	
;;;;	Sentries produce permit list by watching start/stop requests and responses.
;;;;	  - start : consumer sends to producer consumer stamp and desired table types.
;;;;	  - started : producer replies with producer stamp and initial tables.
;;;;	      * if consumer remote, producer updates link sentry to permit tranmission
;;;;		of broadcasts of requested types with producers stamp. Permit is stamped
;;;;		with consumers stamp to facilitate identification at stop.
;;;;	      * consumer updates environment sentry to permit evaluation of broadcasts
;;;;		of requested types with producers stamp.
;;;;	  - stop : consumer sends to producer consumer stamp and types.
;;;;	      * if consumer remote, producer removes consumers permits for requested 
;;;;		types from link sentry.
;;;;	  - stopped : producer replies producer stamp.
;;;;	      * consumer revokes permits for producer and type from environment sentry.
;;;;
;;;;	consumer may anonymously do start and stops, in which case t is used in place of the 
;;;;	consumer's stamp. This is unreliable as stops can then be spoofed.
;;;;
;;;;	??? multiple starts from same consumer for same type indicates confusion on consumers
;;;;	??? part, probably should issue warning and remove duplicate.
;;;;

;;;;	
;;;;	
;;;;	
;;;;	
;;;;	






;;;;	
;;;;	Non-orb Functions Orb calls (besides normal bsc, trm, io, etc)
;;;;
;;;;	broadcast-eval
;;;;	environment-eval
;;;;	broadcast-producer-state
;;;;	



;;;;
;;;;	BUS: 
;;;;

;;;;	bus calls orb-eval when req receieved
;;;;	bus calls orb-broadcast when bcast receieved

;;;; 	orb calls bus-eval when remote eval
;;;;	orb-connect calls add-bus-link
;;;;	orb-disconnect calls bus-link-close
;;;;	orb-broadcast calls bus-broadcast



;;;;	bus-eval (tags <term>)	: <term>
;;;;	bus-broadcast (<term>)	: (values)
;;;;	
;;;;	orb-eval : called by bus, does bcasts too???
;;;;	 * RLE TODO MTT when eval'ing a broadcast, no other things should be popped from bus
;;;;	 * RLE TODO MTT queue until broadcast completes as subsequent requests expect to see
;;;;	 * RLE TODO MTT effect of broadcast.
;;;;	
;;;;	send (<iob>)	: NULL
;;;;	  * send will attach result iob to req-iob. Result iob may be recursive req.
;;;;	  * result :
;;;;		<msg-iob> : process msg
;;;;		<req-iob> : process req
;;;;		<rsp-iob> : continue
;;;;
;;;;	receive ()	: <iob>
;;;;	  * <req> : process request.
;;;;
;;;;	Broadcasts : processed by read and never seen by send/receive.
;;;;	Start/Stop : similar except start calls producer synch hook.
;;;;
;;;;	Interrupt : ??? pend-local !!! stop request, reply interrupted. 
;;;;
;;;;	Serialization :
;;;;	 Transaction must not emit bcasts or messages after sending request until response received.
;;;;	 Broadcasts and requests received will be processed in order.
;;;;	
;;;;	Req/Rsp matching : primary sequence number of req is placed in response and messages.
;;;;	 Orb sending request sets primary sequence number. 
;;;;	
;;;;	
;;;;	


;;;;	Orb level:
;;;;	send : queue, post write, if not broadcast then wait ?msg handler loop?
;;;;	recv : wait, process, queue reply, post write
;;;;
;;;;	pend, send, wait, msgs, unpend.
;;;;
;;;;	Bus-level:
;;;;	read
;;;;	 msg, req, rsp : if waiting iob, update req-iob then post req task, otherwise reject.
;;;;	    Not MTT : after post return.
;;;;	    MTT : after read, read again
;;;;     bcast : process
;;;;
;;;;	write
;;;;	 pop, write
;;;;
;;;;	post write (iob) : Not MTT -> write, treat sequence of similar broadcasts lazily.
;;;;	post req (iob) :
;;;;	  - Not MTT -> return; req should be caller.
;;;;	wait (iob) : Not MTT -> read any.
;;;;	
;;;;	need a recv any iob for receive. With MTT causes task launch when posted. Sort of the intial task???
;;;;
;;;;	wait : task switching.
;;;;	  * tasks
;;;;	      - transaction task : each top-level request has a task.
;;;;		  * recursive requests : request to process which sent request. 
;;;;		    execute in same task.  ie launch task, start transaction,
;;;;		    send request to remote process.  Remote process calls back
;;;;		    with a reqest to originating process.
;;;;	      - write task : each bus link has a write task.
;;;;		Avoids transaction task wait for write. While this is not a win
;;;;		when writing requests and waiting for a response, it is a win
;;;;		when writing of broadcasts and responses.
;;;;		  * pops output-queue and writes.
;;;;	      - read task : each bus link has a read task.
;;;;		  * reads, then dispatches.
;;;;
;;;;	


;;;;	send-request (<iob{req}>)	: <term{result}>
;;;;	

;;;;	
;;;;	FTTB assume broadcasts only propogate one link. Ie, they can not pass
;;;;	through an intermediate.
;;;;	
;;;;	


;;;;	bus-read (<blink>)     : NULL
;;;;	 * updates pending iob
;;;;	
;;;;	bus-write ()
;;;;	 * pop from blink out queue
;;;;	
;;;;	wait (iob) :
;;;;	 * pushs on pend remote
;;;;	 

;;;;	connected-p (tags) : <bool>
;;;;	  * returns t if there is a link to environment specified by tags.
;;;;

;;;;	



;;;;	orb-bus queue : two queues for queue input and output between orb and bus.
;;;;	 functional abstraction. 
;;;;
;;;;	challenge is to hide multi-tasking issue as much as possible. Then small code
;;;;	diff between versions and limited feature loss.
;;;;	
;;;;	orb-to-bus : push iob from orb to bus. handles write-request from orb.
;;;;	send (iob) : (values)
;;;;	  * MTT : send
;;;;	    if req, queue iob on bus link, maybe post write, wait until posted. continue process iob.
;;;;	    if broadcast, queue iob on bus links, maybe post write, continue.
;;;;	    if rsp, queue, post write, kill task if not recursive req.
;;;;	  * Not MTT : send
;;;;	    if req, queue, then write, then read until rsp, then continue to process iob.
;;;;	    if broadcast, queue, maybe write, continue.
;;;;	    if rsp, queue, write, return.
;;;;
;;;;	bus-to-orb : push iob from bus to orb. handles process-request from bus.
;;;;	receive () : <iob>
;;;;	  * MTT : dispatch
;;;;	    if rsp, update req iob, post req task.
;;;;	    if recursive req, update root req-iob, post req task.
;;;;	    if other req, launch task.
;;;;	    if broadcast, process under read task.
;;;;	  * Not MTT : dispatch
;;;;	    if rsp, update req iob, continue.
;;;;	    if recursive req, update root req-iob, process new-req, send rsp, wait on read.
;;;;	    if other req, if no active request then prorcess req otherwise reject it.
;;;;	    if broadcast, process broadcast, wait on read.
;;;;	  * there is a de-facto input queue assoced with transaction by chaining iob on original req iob.
;;;;
;;;;	
;;;;
;;;;	Bus does not expose links.
;;;;	Bus does expose iob's.
;;;;	Sentries exist in bus.
;;;;	
;;;;	each link has output queue.
;;;;	bus queue is virtual
;;;;	  - orb-to-bus queues on link output queue.
;;;;	  - bus-to-orb dispatch iob directly.
;;;;
;;;;	orb-to-bus runs under transaction task.
;;;;    bus-to-orb runs under read task
;;;;	  - broadcast runs under read task also.
;;;;	
;;;;	
;;;;	read task dispatches iob read, if broadcast then read task does broadcast.
;;;;	Guarauntees serialization over link
;;;;	input from other links though does not need to wait for broadcasts
;;;;	Broadcasts should run fast so shouldn't hurt to wait.

;;;;	bus-wait ()
;;;;	bus-listen ()


;;;;	
;;;;	Each environment may have a journal. 
;;;;	  - journal can be used to record and then playback a session.
;;;;	  - intra-process eval should not be recorded.
;;;;	  - debug :
;;;;	      * start state : save/restore ???
;;;;		  - Tables/Library.
;;;;		  - lisp global values.
;;;;	  	  - RLE TODO
;;;;	      * bus : keyboard/toploop input must come through bus!
;;;;	          - in requests + responses
;;;;		    req forwards state and can verify same rsp.
;;;;	          - out requests + responses
;;;;		    verify same req and need rsp to forward playback.
;;;;		  - in broadcasts
;;;;		    forwards state
;;;;		  - out broadcasts
;;;;		    verify output.
;;;;	  - recovery : an expensive recovery method.
;;;;	    Crash recovery should be down by OO database.
;;;;	  - unrolling : unrolling not possible except by stopping playback.
;;;;	    Unrolling should be done by directives/transaction
;;;;	    Version control should be done by OO database.
;;;;
;;;;	Differs from io journal in that only single environment recorded.
;;;;	Bus journal records more state and does not record some low-level bus
;;;;	requests such as connect, start/stop, and ping.
;;;;


;;;;	defuns in this file whose names begin with orb- prefix
;;;;	
;;;;	orb-name
;;;;	orb-address
;;;;	orb-wait-request
;;;;	orb-request-loop
;;;;	orb-configure-request
;;;;	orb-configure-import
;;;;	orb-configure-export
;;;;	orb-accept-client
;;;;	orb-request-address
;;;;
;;;;	orb-cleanup
;;;;	orb-connect-stream
;;;;	orb-connect-tooltalk
;;;;	orb-disconnect
;;;;	
;;;;
;;;;	orb-broadcast
;;;;	orb-eval 

;;;;	for multi-plexing instances of librarys within an orb/bus:
;;;;
;;;;	bus-link-add-import-environment
;;;;	bus-link-delete-import-environment
;;;;	bus-environment-p
;;;;	bus-link-of-environment-address
;;;;	bus-link-close
;;;;	bus-link-of-port
;;;;	

;;;;	bus-broadcast
;;;;	bus-local-eval

;;;;
;;;;	bus-pend		;; queue to hold eval req's while waiting for rsp. 
;;;;	bus-unpend
;;;;	bus-write
;;;;	bus-post-write
;;;;	bus-send
;;;;	bus-link-read
;;;;	bus-read-any
;;;;	bus-wait


;;;;	for non-producer dedicated (to one env) bus the only interface functions are :
;;;;
;;;;	bus-eval	: to call remote.
;;;;	bus-wait	: to implement read loop.



;;;;	
;;;;	RLE TODO : orb-stats : 	
;;;;	RLE TODO :   - gather stats about broadcasts sent, cmds evaled, etc.
;;;;	


(define-primitive |!journal_entry| () (source))

(defun ijournal-result-entry-term (source result)
  (instantiate-term (ijournal-entry-op)
		    (list (instantiate-bound-term source)
			  (instantiate-bound-term result))))


;; RLE TODO needs to be parameterized with env.
(defvar *journal-stream* nil)
(defvar *journal-results-p* nil)

(defmacro environment-journal (source &body body)
  (let ((gres (gensym)))
    `(let ((,gres (progn ,@body)))
      (record-journal-entry ,source ,gres))))


(defun record-journal-entry (source result)
  ;; rle todo : nfg:  must serialize it write req before eval need to match req with result
  (when *journal-stream*
    (term-write *journal-stream*
		(if *journal-results-p*
		    (ijournal-result-entry-term source result)
		    (ijournal-entry-term source))))
  result)



;; (<name> . <broadcast-type> list) list 
(defvar *broadcast-type-resource-mapping*
  `((library . (library))
    ;;(restore-library . (library library-light))
    ;;(restore-library . (library library-light))
    ;;(edit-library . (library library-light))
    ;;(dms-library . (library library-light))

    (statements . (statements))
    (abstractions . (statements abstractions))

    ;; there is no transaction table, but need this for sentries to work.
    (transaction . (transaction))

    (dforms . (dforms))
    (precedences . (precedences))
    ;;(dms-dforms . (dms-dforms))
    ;;(dms-precedences . (dms-precedences))

    (proofs . (proofs))
    (rules . (rules))
    (comments . (comments))
    (code . (code))

    (terms . (terms))
    (ostates . (ostates))
    ;;(comments . (comments))
    ))


(defun broadcast-types-of-resource-name (name &optional table-type-resource-map)
  (or (cdr (assoc name (or table-type-resource-map *broadcast-type-resource-mapping*)))
      (list name)))

(defun broadcast-types-of-resource-names (names &optional table-type-resource-map)
  (delete-duplicates
   (mapcan #'(lambda (name)
	       (copy-list (broadcast-types-of-resource-name name table-type-resource-map)))
	   names)))

;;;;	
;;;;	RLE TODO : orb name should be ip-address + process-id of orb to ensure unique
;;;;	RLE TODO : addresses among running orbs.
;;;;	

(defvar *orb-name* (intern-system (princ-to-string (get-universal-time))))
(defvar *sys-version* (intern-system (format-string "~a~a.~a"
						    *system-kind*
						    *system-major-version*
						    *system-minor-version* )))
;; todo - update descriptions in objects libraries
;;   particularly library(includes? edit) objects
;;  or make match descriptions more general.
(defvar *system* 'nuprl) ;; (intern-system *system-kind*) 
(defvar *version* (list 5 0)) ;;(list *system-major-version* *system-minor-version*))

(defun orb-name ()
  (unless (boundp '*orb-name*)
    (raise-error (error-message '(orb name not))))
  *orb-name*)

(defun set-orb-name (name) (setf *orb-name* name))

(defun sys-version () *sys-version*)


;;;;	
;;;;	<resource>	: (<token{name}> . <table>)
;;;;
;;;;	<resources>	: <resource> list
;;;;	  * essentially, resources is an alist to lookup tables with a token.
;;;;		

(defvar *resources*)

(defun resource (name)
  (or (cdr (assoc name *resources*))
      (progn
	(break "resource not")
	(raise-error (error-message '(resource not) name)))))

(defun resource-p (name)
  (and (boundp '*resources*)
       (cdr (assoc name *resources*))
       t))


;;;
;;;	environment
;;;

(defvar *environment-path* nil)
(defvar *environment*)

(defun in-environment-p () (and (boundp '*environment*) *environment* t))
(defun current-environment ()  *environment*)
(defun current-environment-path () *environment-path*)


(defun require-environment (tags etags)
  (unless (in-environment-p)
    (break "re")(raise-error (error-message (append '(environment not) etags))))

  (let ((e (current-environment)))
    (when tags
      (unless (equal tags (address-of-environment e))
	(raise-error (error-message (append '(environment wrong) etags) tags))))
    e))


(defun current-environment-p (tags)
  (and (boundp '*environment*)
       *environment*
       (equal tags (address-of-environment *environment*))))


;;; represents args for broadcast.
;;; used to derive sentries.

(defstruct environment-base
  address
  address-parameters

  ;; term
  stamp

  ;; <table-type> list
  produce-table-types
  purposes

  ;; <broadcast-state> list 
  broadcast-states

  description

  ;; used for finer discrimination when multiple connections match description.
  (properties nil)
  (flow-control nil) ;; not used atm, but present so as to avoid recompile probs when use added.

  ;;(touch-history (make-touch-history))
  )


(defmacro with-local-touch-history ((ts e) &body body)
  (let ((old (gensym))
	(tstate (gensym))
	(env (gensym)))

    `(let* ((,tstate ,ts)
	    (,old (tstate-touch-history ,tstate))
	    (,env ,e))

      (unwind-protect
	   (progn
	     (setf (tstate-touch-history ,tstate) (make-touch-history))
	     ,@body)

	(let* ((new (tstate-touch-history ,tstate))
	       (newal (when new (list-touch-history new)))
	       (newl (cdr (when newal (assoc ,env newal :test #'eq)))))
	  (when newl
	    (let ((thl (touch-history-list ,old)))
	      (let ((oe (assoc ,env thl :test #'eq)))
		(if oe
		    (setf (cdr oe) (append newl (cdr oe)))
		    (push (cons ,env newl) (touch-history-list ,old))))))

	  (setf (tstate-touch-history ,tstate) ,old))))))


(defstruct (environment (:include environment-base))


  ;; (<name> . <table>) list
  resources

  ;; (<table-type> . <table> list) list
  types-resources
  
  broadcast-sentry
  connection-cache

  reduction-tags

  tent-order
  server-address

  ;; open journals on environment.
  journals

  global-env	;; extension of ml global env.
  
  ;; desire some ability to subclass environment for various uses of environment.
  ;; TODO defclass environment 
  sub-environment

  message-filter
  ;;short-name	;; concat last two toks of address.

  obid-encoding-table
  )

(defun tags-of-environment (e) (environment-base-address e))
(defun address-of-environment (e) (environment-base-address e))
(defun address-parameters-of-environment (e) (environment-base-address-parameters e))
(defun purposes-of-environment (e) (environment-base-purposes e))
(defun description-of-environment (e) (environment-base-description e))
;;(defun touch-history-of-environment (e) (environment-base-touch-history e))
(defun produce-table-types-of-environment (e) (environment-base-produce-table-types e))
(defun broadcast-states-of-environment (e) (environment-base-broadcast-states e))
(defun properties-of-environment (e) (environment-base-properties e))
(defun resources-of-environment (e) (environment-resources e))
(defun resource-of-environment (e name) (cdr (assoc name (environment-resources e))))
(defun resource-names-of-environment (e) (mapcar #'car (environment-resources e)))
(defun tent-order-of-environment (e) (environment-tent-order e))
(defun connection-cache-of-environment (e) (environment-connection-cache e))

(defun stamp-term-of-environment (e) (environment-stamp e))
;; stamp in env should not be term but stamps should have term cached.
(defun stamp-of-environment (e) (term-to-stamp (environment-stamp e)))
(defun broadcast-sentry-of-environment (e) (environment-broadcast-sentry e))
(defun reduction-tags-of-environment (e) (environment-reduction-tags e))

(defun types-resources-of-environment (e)  (environment-types-resources e))

(defun transaction-server-p (env) (member 'transaction (purposes-of-environment env)))
(defun orb-p (env) (equal '(orb) (purposes-of-environment env)))

(defun sub-of-environment (e) (environment-sub-environment e))
(defun global-env-of-environment (e) (environment-global-env e))

(defun server-address-of-environment (e) (environment-server-address e))
(defun environment-set-server-address (e a)
  (setf (environment-server-address e) a))


(defun journals-of-environment (e) (environment-journals e))
(defun environment-push-journal (e j) (push j (environment-journals e)))
(defun environment-pop-journal (e)
  (or (pop (environment-journals e))
      (raise-error (error-message '(environment journal pop not) (address-of-environment e)))))

(defun environment-delete-journal (e j)
  (setf (environment-journals e) (remove j (journals-of-environment e))))


(defun modify-environment-properties (f env)
    (setf (environment-base-properties env)
	  (acons 'stamp (stamp-to-term (new-transaction-stamp))
		 (remove 'stamp
			 (funcall f (environment-properties env))))))

(defun environment-property-acons (name prop env)
  (modify-environment-properties
   #'(lambda (props) (acons name prop (remove name props)))
   env))


(defun new-environment-connection (local remote blink)
  (list* local remote blink))

(defun local-of-environment-connection (ec) (car ec))
(defun remote-of-environment-connection (ec) (cadr ec))
(defun blink-of-environment-connection (ec) (cddr ec))


(defun rehash-environment-connection-caches ()
  ;; collect connections and imports.
  (let ((conns nil)
	(imports (mapcar #'(lambda (e) (cons nil e)) *component*)))

    (dolist (blink *bus-links*)
      (setf conns (append (environment-connections-of-bus-link blink) conns)
	    imports (nconc (mapcar #'(lambda (e) (cons blink e))
				   (imported-environments-of-bus-link blink))
			   imports)))

    (let ((connimports (mapcar #'remote-of-environment-connection conns)))
      (setf imports
	    (mapcar #'(lambda (blink-e)
			(let ((e (cdr blink-e)))
			  (let ((addr (address-of-environment e)))
			    (make-connection :description (or (description-of-environment e)
							      (ivoid-term))
					     :address addr
					     :environment e
					     :bus-link (car blink-e)))))

		    (filter #'(lambda (im)
				(not (member (address-of-environment (cdr im))
					     connimports
					     :test #'equal)))
			    imports))))
    

    (dolist (env *component*)
      (let ((eaddr (address-of-environment env)))
	(setf (environment-connection-cache env)
	      (append (mapcar #'(lambda (ec)
				 (let ((blink (blink-of-environment-connection ec))
				       (remote (remote-of-environment-connection ec)))
				   ;;(setf -blink blink -ec ec -conns conns)
				   (let ((ie (find remote
						   (imported-environments-of-bus-link blink)
						   :key #'address-of-environment
						   :test #'equal)))
				     (make-connection :description (or (description-of-environment ie)
								       (ivoid-term))
						      :address remote
						      :environment ie
						      :bus-link blink))))
			     (filter #'(lambda (ec)
					 (equal eaddr (local-of-environment-connection ec)))
				     conns))
		      imports))))))


  ;; RLE TODO : intra component links ???
  ;; none of the inform/revoke stuff is relevant as all are locally accessible.
  ;; a layer of abstraction which glosses the bus/local distincition sounds good.
  ;; ie all is just addressed. Of course this is layer to implement that.
  ;;
  ;;   - should be on bus so as to treat uniformly.
  ;;	  * simplifies MTT if all is through bus as avoids direct call of other environment.
  ;; 	    ie implement MTT in bus and only in bus.
  ;;   - special stream which hands terms off. like journal/toploop.
  ;;
  ;;	FTTB : do not support intra process starts except thru bus (journal).
  ;;    and move intra-process calls into bus when needed. Maybe LAL.


;;;;	Starts are exported by producer at request of consumer.
;;;;	revoking starts at environment close :
;;;;	  - environment is producer :
;;;;	      - revoke starts recorded in link export environments.
;;;;	  - environment is consumer :
;;;;	      - revoke starts recorded in environment (by import).
;;;;	* starts are not recorded in import environments of consumer
;;;;	  but instead are recorded in actual environment.
;;;;
;;;;	A start may not be exported by consumer. We may allow a producer
;;;;	to export a start without a request. Then consumer would 
;;;;	recognize start in inform import as usual and update consumer env.
;;;;	
;;;;	


(defstruct broadcast-state
  table-types
  producer-address
  producer-stamp
  consumer-address
  consumer-stamp
  description
  )


(defun table-types-of-broadcast-state (b) (broadcast-state-table-types b))
(defun producer-stamp-of-broadcast-state (b) (broadcast-state-producer-stamp b))
(defun producer-address-of-broadcast-state (b) (broadcast-state-producer-address b))
(defun consumer-stamp-of-broadcast-state (b) (broadcast-state-consumer-stamp b))
(defun consumer-address-of-broadcast-state (b) (broadcast-state-consumer-address b))
(defun description-of-broadcast-state (b) (broadcast-state-description b))

(defun new-broadcast-state (types paddr pstamp caddr cstamp desc)
  (make-broadcast-state :table-types types
			:producer-address paddr
			:producer-stamp pstamp
			:consumer-address caddr
			:consumer-stamp cstamp
			:description desc))


(defun find-broadcast-state (pstamp cstamp list)
  (find-first #'(lambda (state)
		  (when (and (equal-terms-p pstamp (producer-stamp-of-broadcast-state state))
			     (equal-terms-p cstamp (consumer-stamp-of-broadcast-state state)))
		    state))
	      list))


(defun make-environment-broadcast-sentry-cache (states)
  (let ((acc nil))

    (dolist (state states)
      (dolist (type (table-types-of-broadcast-state state))
	(let ((type-sentry (assoc type acc)))

	  (if type-sentry
	      (setf (cdr type-sentry)
		    (cons (list* (producer-stamp-of-broadcast-state state)
				 (consumer-stamp-of-broadcast-state state)
				 (description-of-broadcast-state state))
			  (cdr type-sentry)))

	      (push (cons type
			  (cons (list* (producer-stamp-of-broadcast-state state)
				       (consumer-stamp-of-broadcast-state state)
				       (description-of-broadcast-state state))
				(cdr type-sentry)))
		    acc)))))
    acc))


(defun add-broadcast-state (state env)
  (let ((cur-state (find-broadcast-state (producer-stamp-of-broadcast-state state)
					 (consumer-stamp-of-broadcast-state state)
					 (broadcast-states-of-environment env))))
    (if cur-state
	(setf (broadcast-state-table-types cur-state)
	      (append (table-types-of-broadcast-state state)
		      (table-types-of-broadcast-state cur-state)))
	(push state (environment-base-broadcast-states env)))))
  

(defun show-broadcasts (address)
  (let ((env (find-any-environment address)))
    (mapcar #'(lambda (bstate)
		(list* (table-types-of-broadcast-state bstate)
		      (producer-address-of-broadcast-state bstate)
		      (consumer-address-of-broadcast-state bstate)))
	    (broadcast-states-of-environment env))))


(defun add-broadcast-state-to-environment (state env)
  (add-broadcast-state state env)
  (setf (environment-broadcast-sentry env)
	(make-environment-broadcast-sentry-cache (broadcast-states-of-environment env))))

(defun remove-broadcast-state (types pstamp cstamp env)
  (let ((cur-state (find-broadcast-state pstamp cstamp
					 (broadcast-states-of-environment env))))
    ;;(setf a types b pstamp c cstamp d env e cur-state) (break "rbs")
    (if cur-state
	(let ((ttypes (table-types-of-broadcast-state cur-state)))
	  (let ((acc ttypes))

	    (dolist (type types)
	      (setf acc (remove type acc :count 1)))

	    (setf (broadcast-state-table-types cur-state) acc)

	    ;; filter out any broadcast states with no types.
	    (setf (environment-base-broadcast-states env)
		  (mapcan #'(lambda (bs)
			      (if (table-types-of-broadcast-state bs)
				  (list bs)
				  nil))
			  (environment-base-broadcast-states env)))	  
	    ))

	(message-emit (warn-message '(environment broadcast sentry remove not)
				    cstamp
				    pstamp)))))
  

(defun remove-broadcast-state-from-environment (types pstamp cstamp env)
  (prog1 (remove-broadcast-state types pstamp cstamp env)
    (setf (environment-broadcast-sentry env)
	  (make-environment-broadcast-sentry-cache (broadcast-states-of-environment env)))))


;;;
;;;	Description
;;;
;;;	
;;;	 - properties : 
;;;	   batch, slow, fast, big, small to be used for fine discrimination when multiple
;;;	   descriptions match.
;;;	   * maybe some more loose assoc than by including properties on description.
;;;	     ie some sort of declaration, allows changing by user while running.
;;;	     - requires extra args to orb eval, derive from principal oid or specify explicitly.

(defstruct description
  system
  version
  purposes
  )

(defun system-of-description (d) (description-system d))
(defun version-of-description (d) (description-version d))
(defun purposes-of-description (d) (description-purposes d))

(defun new-description (purposes)
  (make-description :system *system*
		    :version *version*
		    :purposes purposes
		    ))

(define-primitive |!description| ((token . system)) (version purposes))

(defun description-to-term (d)
  (idescription-term (system-of-description d)
		     (map-sexpr-to-isexpr (version-of-description d)
					  (inil-term)
					  #'inatural-term)
		     (map-sexpr-to-isexpr (purposes-of-description d)
					  (inil-term)
					  #'itoken-term)))
		     
(defun term-to-description (term)
  (make-description :system (system-of-idescription-term term)
		    :version (map-isexpr-to-list (version-of-idescription-term term)
						 (icons-op)
						 #'numeral-of-inatural-term)
		    :purposes (map-isexpr-to-list (purposes-of-idescription-term term)
						  (icons-op)
						  #'token-of-itext-term)
		    ))


    	

;;;;	
;;;;	environment : 
;;;;	  - imported : local manisfestation of a remote environemnt.
;;;;	      * at the momoent primarily identified via env-address and thus
;;;;		expect all imported environments to have unique addresses.
;;;;	  - exported :  a device for remembering what info has been exported.
;;;;	      * there must exist a corresponding component environment.
;;;;	  - component : actual local enironment.
;;;;	
;;;;	broadcast-state : info about broadcasts from one environment to another.
;;;;	  - updated via subscribe/unsubscribe.
;;;;	  - contained in imported env or component env.
;;;;	
;;;;	broadcast-sentry : summary of broadcast info for an environment.
;;;;	  - relevant to imported environments (via blink) and component environments (via *components*) .
;;;;	    accessed via blink or component-environment.
;;;;	  - distilled from broadcast states of environment.
;;;;	
;;;;	environment-connection : an imported / exported pair of a link.
;;;;	  - imported used to route remote requests.
;;;;	  - should be unique wrt the link and the pair of environment addresses.
;;;;	  ? could contain broadcast states/sentry.
;;;;	  ? could broadcast state be subclass of env-conn 
;;;;	
;;;;	connection-cache : summary of connected environments of a component.
;;;;	  - connected : (pair component imported)  environment list
;;;;	  - imported : imported list (those with no environment connection)
;;;;	      ? should an imported env connected to a different component env
;;;;		be available to the component as an imported env or should only
;;;;		unconnected imported environments be available.
;;;;		  - if connected implication is that it's not available for general use?
;;;;	  ! rehash at every environment-connection add/delete and environment import/unimport.
;;;;	
;;;;	
;;;;	  need broadcast sentry to compare descriptions,
;;;;	  thus broadcast needs to contain description and sentry needs descriptions
;;;;	  of remote environments.
;;;;	
;;;;	dest for evals are sometimes computed by examining connected environments.
;;;;	and comparing description of environments with description of request.
;;;;	
;;;;	Thus make sure that env desc are available and we can identify connected env.
;;;;	
;;;;	<environment-conn>	: <address{local}>, <address{remote}>, <blink>
;;;;	
;;;;	<blink>			: ...
;;;;				, <environment-conn> list
;;;;				, <environment{exported}> list
;;;;				, <environment{imported}> list
;;;;				, <broadcast-sentry>
;;;;				...
;;;;	
;;;;	<environment{imported}>	: ... <broadcast-state> list
;;;;	
;;;;	<environment{comp}>	: ...
;;;;				, <broadcast-sentry>
;;;;				, <connection-cache>
;;;;
;;;;	<connection-cache>	: (<description>, <address{imported}>, <blink>) list {connected}
;;;;				, (<description>, <address{imported}>, <blink>) list {imported}
;;;;	
;;;;	<broadcast-state>	: [ <tok> list	  {table types}
;;;;				    <tok> list	  { producer address }
;;;;				    <stamp> list  { producer }
;;;;				    <tok> list	  { consumer address }
;;;;				    <stamp> list  { consumer }
;;;;				    <description> { consumer }
;;;;				  ]
;;;;	
;;;;	<blink>			: ... <environment{imported}> list
;;;;	
;;;;	consumer description of broadcast state is used in testing suitability of broadcasts too
;;;;	consumer.
;;;;	


(defvar *bus-links* nil)

(defun show-bus-link (blink)
  (let* ((link (link-of-bus-link blink))
	(ch (car (channels-of-link link))))
    (terpri)
    (format t ";;;~T~a ~a~%" (kind-of-channel ch) (state-of-channel ch))

    (when (accept-channel-p ch)
      (let ((asock (socket-of-accept-channel ch)))
	(when asock
	  (format t ";;;~TSocket ~a ~a~%"
		  (port-of-socket asock) (fd-of-socket asock) (state-of-socket asock)))))
	
    
    (when (socket-channel-p ch)
      (let ((psock (primary-socket-of-channel ch))
	    (ssock (secondary-socket-of-channel ch)))
	(when psock
	  (format t ";;;~TPrimary Socket ~a ~a~%"
		  (port-of-socket psock) (fd-of-socket psock) (state-of-socket psock)))
	(when ssock
	  (format t ";;;~TSecondary Socket ~a ~a~%"
		  (port-of-socket ssock) (fd-of-socket ssock) (state-of-socket ssock)))))

    (dolist (e (imported-environments-of-bus-link blink))
      (format t ";;;~T~TImported ~a~%" (address-of-environment e))
      (dolist (p (properties-of-environment e))
	(format t ";;;~T~T Property ~a ~a~%"
		(car p)
		(if (ibool-term-p (cdr p))
		    (bool-of-ibool-term (cdr p))
		    "??"))))
    (dolist (e (exported-environments-of-bus-link blink))
      (format t ";;;~T~TExported ~a~%" (address-of-environment e)))

    (format t ";;;~T~T Idle ~a, Blocked ~a, HaveIt ~a, Out:~a, In:~a~%"
	    (cond
	      ((bus-link-idle-p blink) "IDLE")
	      ((bus-link-really-not-idle-p blink) "NOT!")
	      (t "NOT "))
	    (bus-link-block blink)
	    (bus-link-have-it blink)
	    (output-queue-length blink)
	    (length-of-queue (input-queue-of-bus-link blink)))

    (terpri)
    (values)
    ))

(defun show-bus-links ()
  (dolist (b *bus-links*)
    (show-bus-link b)))

(defun add-bus-link (l)
  (push l *bus-links*)
  (show-bus-links)
  )

(defun remove-bus-link (l)
  (setf *bus-links* (delete l *bus-links*)))

(defun cleanup-bus-links ()
  (dolist (l *bus-links*)
    (link-close (link-of-bus-link l))
    (setf *bus-links* nil)))

(defun cleanup-bus ()
  (cleanup-bus-links))



(defvar *library-description* (new-description '(library)))

(defun library-description () *library-description*)

(defstruct connection
  description
  address
  environment
  bus-link
  )

(defun address-of-connection (c) (connection-address c))
(defun description-of-connection (c) (connection-description c))
(defun environment-of-connection (c) (connection-environment c))
(defun bus-link-of-connection (c) (connection-bus-link c))


(defun connections-of-environment (env)
  (connection-cache-of-environment env)
  #|
  (let ((acc nil))
    
    (when nil
      ;; brain damage here:
      ;; - env is not right env in make-connection
      ;; - (library-description) is stacking the deck.
      (let ((local-is-producer-p (produce-table-types-of-environment env))) ;; kludge alert.
	(dolist (state (broadcast-states-of-environment env))
	  (let ((addr (if local-is-producer-p 
			  (consumer-address-of-broadcast-state state)
			  (producer-address-of-broadcast-state state))))
	    (setf -addr addr -local-is-producer-p local-is-producer-p -env env) (break "coe")
	    (unless (member addr acc :key #'address-of-connection :test #'equal)
	      (push (make-connection :description (if local-is-producer-p
						      (description-of-broadcast-state state)
						      (library-description))
				     :address addr
				     :environment env)
		    acc))))))

    ;; reflexive, ie include locals.
    (dolist (env *component*)
      (let ((addr (address-of-environment env)))
	(push (make-connection :description (or (description-of-environment env)
						(ivoid-term))
			       :address addr
			       :environment env
			       :bus-link nil)
	      acc)))

    (let ((laddr (address-of-environment env)))
      (dolist (blink *bus-links*)
	(dolist (ienv (imported-environments-of-bus-link blink))
	  (let ((raddr (address-of-environment ienv)))
	    ;;(break (format-string "~a" raddr))
	    (when (or t (some #'(lambda (bstate)
				  (or (equal laddr (consumer-address-of-broadcast-state bstate))
				      (equal laddr (producer-address-of-broadcast-state bstate))))
			      (broadcast-states-of-environment ienv)))
	      (push (make-connection :description (or (description-of-environment ienv)
						      (ivoid-term))
				     :address raddr
				     :environment ienv
				     :bus-link blink)
		    acc))))))
    acc)|#
  )


(defun find-connections-by-address (addr &optional env)
  (let ((e (or env (current-environment))))
    ;;(setf -e e) (break "fcba")
    (mapcan #'(lambda (c)
		(when (equal addr (address-of-connection c))
		  (list c)))
	    (connections-of-environment e))))

(defun find-connections-by-description (desc &optional env strictp)
  (let ((e (or env (current-environment))))

    (cond
      ((itokens-term-p desc)
       (find-connections-by-address (tokens-of-itokens-term desc) env))

      (t (mapcan #'(lambda (c)
		     (when (match-descriptions-p desc (description-of-connection c) strictp)
		       (list c)))
		 (connections-of-environment e))))))

#|(defun find-connected-addresses-by-description (desc &optional env strictp)
  (mapcar #'address-of-connection
	  (find-connections-by-description desc env strictp)))
|#

(defun environment-remove-types-resources (l resources)
  ;; (<type> . <table> list) list
  (mapcan #'(lambda (e)
	      (let ((r (mapcan #'(lambda (resource)
				   (unless (member resource resources)
				     (list resource)))
			       (cdr e))))
		(when r
		  (list (cons e r)))))
	  l))

;; used to distribute bcast to appropriate tables.
(defun cache-environment-resources-by-type (resources &optional table-type-resource-map)
  ;; (<type> . <table> list) list
  (mapcar #'(lambda (type)
	      (cons type
		    ;; <table> list
		    (mapcan #'(lambda (resource)
				(when (member type
					      (broadcast-types-of-resource-name (car resource)
										table-type-resource-map))
				  (list (cdr resource))))
			    resources)))
	  ;; <type> list
	  (broadcast-types-of-resource-names (mapcar #'car resources)
					     table-type-resource-map)))


(defun allocate-resources (esig stamp)
  (mapcar #'(lambda (rsig)
	      (cons rsig
		    (allocate-resource (name-of-resource-sig rsig)
				       stamp)))
	  esig))

;;produced : names of resources present in environment for which broadcasts are locally produced.

;; local and resources are similar. At env allocation concern
;; is with local produce. Start time configures for remote produce.

;; resources : (<name> . <resource>) list.

(defun new-environment (address purposes resource-names table-types reduction-tags &optional sube)
  ;;(break "ne")
  (let* ((stamp (progn (unless (boundp '*tstate*) (advance-transaction-sequence))
			(transaction-stamp)))
	 (stamp-term (stamp-to-term stamp))
	 (resources (mapcar #'(lambda (name)
				(cons name
				      (allocate-resource name nil)))
			    resource-names))
	 )
    
    (let ((env (make-environment :address address
				 :address-parameters (mapcar #'(lambda (tag)
								 (instantiate-parameter-r tag *token-type*))
							     address)
				 :produce-table-types table-types
				 :purposes purposes
				 :description (if (equal '(orb) purposes)
						  (term-to-description *orb-description*)
						  (new-description purposes))
				 :stamp stamp-term
				 :types-resources (cache-environment-resources-by-type resources)
				 :resources resources
				 :reduction-tags reduction-tags
				 :global-env (when (boundp '*global-env*)
						   *global-env*)
				 :sub-environment sube)))
      
      env)))


(defun environment-add-purpose (p e)
  (let ((ps (setf (environment-purposes e) (cons p (purposes-of-environment e))))
	(d (description-of-environment e)))

    (setf (environment-description e)
	  (make-description :system (system-of-description d)
			    :version (version-of-description d)
			    :purposes ps))
  ))

(defun make-orb-transaction-manager ()
  (let ((orb (find-environment (orb-address))))
    (unless (transaction-server-p orb)
      (environment-add-purpose 'transaction orb))))


(defun environment-add-resources (env resource-names saved-resources)

  (let ((resources (mapcar #'(lambda (name)
			       (or 
				(assoc name saved-resources)
				(cons name (allocate-resource name nil))))
			   resource-names)))

    (let ((cur-resource-names (resource-names-of-environment env)))
      (when (intersection cur-resource-names resource-names)
	(raise-error (error-message '(environment-add-resources duplicates)
				    (intersection cur-resource-names resource-names))))

      (setf (environment-types-resources env)
	    (append (types-resources-of-environment env)
		    (cache-environment-resources-by-type resources))

	    (environment-resources env)
	    (append resources (resources-of-environment env)))
      
      (when (boundp '*resources*)
	(setf *resources* (resources-of-environment env))) )))


(defun environment-remove-resources (env resource-names)

  (let (;;(names (resource-names-of-environment env))
	(resources (let ((resources (resources-of-environment env)))
		     (mapcar #'(lambda (n)
				 (cdr (assoc n resources)))
			     resource-names))))

    
    (setf (environment-types-resources env)
	  (environment-remove-types-resources (types-resources-of-environment env)
					      resources))

    (let ((resources-removed nil)
          (resources-kept nil))

      (dolist (r (resources-of-environment env))
	(if (member (car r) resource-names)
	    (push r resources-removed)
	    (push r resources-kept)))

      (setf (environment-resources env) (nreverse resources-kept))
      (nreverse resources-removed))))


;; should make sure all occurences of stamps
;; and stamp-terms in environment and tables are eq.


(defun reset-environment-broadcast-sentry (env)
  (setf (environment-broadcast-states env) nil))

(defun reset-environment-produce-table-types (env table-types)
  (setf (environment-base-produce-table-types env) table-types))

	  
;; used to distribute bcast to appropriate tables.
(defun environment-resources-of-type (env type)
  (cdr (assoc type (types-resources-of-environment env))))


(defvar *orb-address*)
(defvar *orb*)

(defun orb-address ()
  (if (and (boundp '*orb-address*) *orb-address*)
      *orb-address*
      (setf *orb-address* (list *sys-version* (orb-name) 'orb))))


;; rle mutex
(defvar *component* nil)

(defun delete-environment (tags)
  (when (component-environment-p tags)
    (setf *component* (remove-environment-from-list tags *component*)))
  (rehash-environment-connection-caches)
  (values))

(defun add-environment (e)
  ;;(unless (environment-base-p e)(setf a e) (break "ae"))
  (when (member (address-of-environment e) *component* :key #'address-of-environment :test #'equal)
    (raise-error (error-message '(enviroment add duplicate address) (address-of-environment e))))
  (push e *component*)
  (rehash-environment-connection-caches)
  (values))


(defun environment-in-list-p (address envs)
  (and (member address envs
	       :test #'equal
	       :key #'address-of-environment)
       t))

(defun find-environment-in-list (address envs)
  (car (member address envs
	       :test #'equal
	       :key #'address-of-environment)))

(defun remove-environment-from-list (address envs)
  (remove address envs :key #'address-of-environment :test #'equal :count 1))

(defun find-environment (tags)
  (or (find-environment-in-list tags *component*)
      (raise-error (error-message '(environment not) *environment-path* tags))))

(defun match-environment (tags)
  (match-environment-in-list tags *component*))

(defun component-environment-p (tags)
  (environment-in-list-p tags *component*))


(defun find-any-environment (addr)
  (if (component-environment-p addr)
      (find-environment addr)
      (if (bus-environment-p addr)
	  (find-bus-environment addr)
	  (raise-error (error-message '(environment not any) addr)))))

(defun name-of-resource (r) (caar r))
(defun type-of-resource (r) (cdar r))
(defun value-of-resource (r) (cdr r))

(defun name-of-resource-sig (r) (car r))
(defun type-of-resource-sig (r) (cdr r))


(defun allocate-resource (name stamp)
  (let ((func-name (intern-system (concatenate 'string "ALLOCATE-" (string name)))))
    (when (fboundp func-name)
      (funcall func-name stamp name))))


(defun environment-add-table-types (env table-types)
  (setf (environment-base-produce-table-types env)
	(append table-types
		(produce-table-types-of-environment env))))


(defun environment-remove-table-types (e table-types)

  (let ((acc (environment-base-produce-table-types e)))

    (dolist (type table-types)
      (setf acc (remove type acc :count 1)))

    (setf (environment-base-produce-table-types e) acc)))


(defvar *tid* nil)
(defvar *tid-blink* nil)

(defun tid () *tid*)
(defun tid-blink () *tid-blink*)

(defmacro with-tid ((tid &optional blink) &body body)
  `(let ((*tid* ,tid)
	 (*tid-blink* ,blink))
    ,@body))


(defmacro with-tid-protect (&body body)
  `(let ((*tid* nil)
	 (*tid-blink* nil))
    ,@body))


(defun equal-tids-p (tida tidb)
  (or (and tida tidb
	   (compare-terms-p tida
			    tidb))

      ;;(progn (format t "inequal-tids~%") nil)
      ;; ;; really not expecting unequal case to arise yet. so prob a bug.
      ;; (break "equal-tids-p")

    nil
    ))

(defvar *tstate*)

(defmacro with-tstate (tstate &body body)
  `(let ((*tstate* ,tstate))
    (with-tid ((tid-of-tstate *tstate*) (tidblink-of-tstate *tstate*))
      (with-transaction-id (transaction-id-of-tstate *tstate*)
	,@body))))



(defvar *oid-map*)

(defun oid-map ()
  (if (and (boundp '*oid-map*) *oid-map*)
      *oid-map*
      (raise-error (error-message '(oid map not)))))

(defmacro with-environment-tag ((tag) &body body)
  `(let ((*environment-path* (append *environment-path* (list ,tag))))
    ,@body))


(defmacro with-environment ((intags) &body body)
  (let ((pretags (gentemp))
	(tags (gentemp)))
    `(let* ((,pretags ,intags)
	    (,tags (if (symbolp ,pretags)
		       (list ,pretags)
		     ,pretags))
	    (*environment* (find-environment ,tags))
	    (*resources* (resources-of-environment *environment*))
	    (*environment-path* (append *environment-path* ,tags))
	    ;;(*global-env* (global-env-of-environment *environment*))
	    )
	    
      (unwind-protect (progn ,@body)
	;;(setf (environment-global-env *environment*) *global-env*)
	))))

(defmacro with-environment-actual (e &body body)
  (let ((ee (gensym)))
    `(let ((,ee ,e))
      (if (and (in-environment-p) (eql ,ee (current-environment)))
	  (progn ,@body)
	  (let* ((*environment* ,ee)
		 (*resources* (resources-of-environment *environment*))
		 ;;(*global-env* (global-env-of-environment *environment*))
		 )
	    (unwind-protect (progn ,@body)
	      ;;(setf (environment-global-env *environment*) *global-env*)
	      ))))))


(defun environment-resource (name)
   (or (cdr (assoc name *resources*))
      (raise-error (error-message '(environment resource name not) name)))) 

(defun environment-resource-p (name)
  (and (boundp '*resources*)
       (cdr (assoc name *resources*))
       t))





;; used if receiver of request fails, prompts sender to fail out of loop
;;(define-primitive |!noack|)

;; used to request client to disconnect from port
(define-primitive |!disconnect| ((bool . error-p)))


(defconstant *iconnect* '|!connect|)
(defun iconnect-term-p (term)
  (and (eql *iconnect* (id-of-term term))
       (null (bound-terms-of-term term))
       (let ((parameters (parameters-of-term term)))
	 (and (equal (length parameters) 2)
	      (natural-parameter-p (car parameters))
	      (string-parameter-p (cadr parameters))))))

(defun iconnect-term (port host)
  (instantiate-term
   (instantiate-operator *iconnect*
			 (list (instantiate-parameter-r port *natural-type*)
			       (instantiate-parameter-r host *string-type*)))
   nil))
 


(defun port-of-iconnect-term (term)
   (value-of-parameter (car (parameters-of-term term))))

(defun host-of-iconnect-term (term)
   (value-of-parameter (cadr (parameters-of-term term))))



;;;; RLE TODO : not sure how much of this is implemented and how much is vaporware.
;;;;
;;;;	<ifilename>	: !filename{<name>:s, <ext>:s}(<ipathname>)
;;;;	
;;;;	<ipathname>	: !pathroot{<root>:s}
;;;;			| !pathroot{<root>:t}
;;;;			| !pathname{<dir>:s}(<ipathname>)
;;;;			| !pathname{<dir>:t}(<ipathname>)
;;;;			| <oa>
;;;;	
;;;;	  ** !pathroot{<root>:t} is for some predefined root such as SYSTEM,
;;;;	     HOME or maybe USER
;;;;	     RELATIVE - root is implicit from context.
;;;;	  ** !pathname{<dir>:t}(<ipathname>) is for some predefined navigation
;;;;	     commands, ie UP.
;;;;	  ** could have !pathwild{<regexpr>:s}(<ipathname>) for filter/search.
;;;;	  ** considered !pathname{<dir>:s list}(<ipathname>) but that 
;;;;	     will be difficult to display iteratively.
;;;;	  ** considered !pathname{}(<ipathname>; <dir sexpr>) and it seems
;;;;	     a viable alternative.
;;;;!pathname{SRC:t}(<oa>) : use the source path of the object.


;;(define-primitive |!filename| ((token . tag) (string . name) (string . type)))
;;(define-primitive |!filename| ((string . root) (string . name) (string . type)))

(defconstant *ifilename* '|!filename|)

(defun ifilename-term-p (term)
  (and (eql *ifilename* (id-of-term term))
       (null (bound-terms-of-term term))
       (forall-p #'(lambda (p)
		     (or (string-parameter-p p)
			 (token-parameter-p p)))
		 (parameters-of-term term))))

(defun ifilename-term (path dirs name &optional type)
  (instantiate-term
   (instantiate-operator *ifilename*
			 (list*
			  (if (symbolp path)
			      (instantiate-parameter-r path *token-type*)
			      (instantiate-parameter-r path *string-type*))
			  (instantiate-parameter-r name *string-type*)
			  (instantiate-parameter-r (if type type "")  *string-type*)
			  (mapcar #'(lambda (dir)
				      (instantiate-parameter-r (if (symbolp dir)
								   (string dir)
								   dir)
							       *string-type*))
				  dirs)))))

;; root is token dirs name type are strings type may be nil "" is coerced to nil.
(defun ifilename-to-filename (root dirs name type)
  (cond
    ((symbolp root)
      (case root

	((|FDLdb| fdldb) (db-extend-pathname dirs name (unless (string= "" type) type)))

	(t (raise-error (error-message '(ifilename root token unknown) root)))))

    ((stringp root)
     (prl-make-filename root dirs name (unless (string= "" type) type)))

    (t (raise-error (error-message '(ifilename root datatype unknown))))))


(defun ifilename-term-to-filename (term)
  (let ((parameters (parameters-of-term term)))

    (ifilename-to-filename (value-of-parameter-r (car parameters))
			   (mapcar #'(lambda (p) (string (value-of-parameter-r p)))
				   (cdddr parameters))
			   (string (value-of-parameter-r (cadr parameters)))
			   (string (value-of-parameter-r (caddr parameters))))))



;;; <environment-address>
(defconstant *ienvironment-address* '|!environment_address|)

(defun ienvironment-address-term-p (term)
  (and (eql *ienvironment-address* (id-of-term term))
       (forall-p #'token-parameter-p (parameters-of-term term))
       (null (bound-terms-of-term term))))

(defun ienvironment-address-term (tags)
  (instantiate-term (instantiate-operator *ienvironment-address*
					  (mapcar #'(lambda (tag)
						      (instantiate-parameter-r tag *token-type*))
						  tags))))

(defun tags-of-ienvironment-address-term (term)
  (mapcar #'value-of-parameter-f
	  (parameters-of-term term)))

(defun toks-to-parameters (toks)
  (mapcar #'(lambda (tag)
	      (instantiate-parameter-r tag *token-type*))
	  toks))



;;;;	<inf-tables>	: !inform(!table_types{<type>:t list}(<address>))
;;;;	<req-tables>	: !request(!table_types{<type>:t list}(<stamp{consumer}>))
(defconstant *itable-types* '|!table_types|)

(defun itable-types-term-p (term)
  (and (eql (id-of-term term) *itable-types*)
       (forall-p #'token-parameter-p (parameters-of-term term))
       (forall-p #'(lambda (bt) (null (bindings-of-bound-term bt))) (bound-terms-of-term term))))

(defun itable-types-term (types address)
  (instantiate-term (instantiate-operator *itable-types* (toks-to-parameters types))
		    (list (instantiate-bound-term address))))

(defun types-of-itable-types-term (term)
  (mapcar #'value-of-parameter-r
	  (parameters-of-term term)))

(defun address-of-itable-types-term (term)
  (term-of-bound-term (car (bound-terms-of-term term))))



;;;;	RLE TODO : syngen will be sending three tags in a request fttb.
;;;;	RLE TODO : must make sure we name environments to match.


(define-primitive |!req| ((natural . sequence) (token . tag))
  (expression))



(defun ireq-aux-term-p (term)
  (and (eql *ireq* (id-of-term term))
       (let ((parameters (parameters-of-term term)))
	 (and (natural-parameter-p (car parameters))
	      (forall-p #'token-parameter-p (cdr parameters))))
       (let ((bts (bound-terms-of-term term)))
	 (and bts
	      (null (bindings-of-bound-term (car bts)))
	      (or (null (cdr bts))
		  (and (null (cddr bts))
		       (null (bindings-of-bound-term (cadr bts)))))))))

;; <tid> : (<bound-term> . nil) | nil  
(defun new-ireq-term (seq tid type tag-parameters e)
  (instantiate-term
   (instantiate-operator *ireq* (cons (instantiate-parameter-r seq *natural-type*)
				      (unless (and (null type)
						   (null tag-parameters))
					(cons (instantiate-parameter-r type *token-type*)
					      tag-parameters))))
   (cons (instantiate-bound-term e)
	 (when tid
	   (list (instantiate-bound-term tid))))))


(defun tags-of-ireq-term (term)
  (mapcar #'value-of-parameter-f (cdr (parameters-of-term term))))

(defun best-token-list-match (m l)
  (labels ((aux (best r)
	     (if (null r)
		 (cdr best)
		 (let ((l (length (intersection m (car r)))))
		   (if (> l (car best))
		       (aux (cons l (list (car r))) (cdr r))
		       (if (eql l (car best))
			   (aux (cons l (cons (car r) (cdr best))) (cdr r))
			   (aux best (cdr r))))))))


    ;; 1 to make sure null intersections not counted as best match.
    (let ((best (aux (cons 1 nil) l)))
      (when (null best)
	(raise-error (error-message '(environment match none) m)))
      (when (cdr best)
	(raise-error (error-message '(environment match multiple) m best)))
      
      (car best))))


(defun type-of-ireq-term (term)
  (let ((parms (parameters-of-term term)))
    (when (cdr parms)
      (value-of-parameter (cadr parms)))))

;; for application reqs finds match in exported environments of bus.
;; ie requires environment to be exported prior to being able to route requests.
;;
;; but if env exported then client ought to be supplying complete address.
;; thus if exports we should look for exact match but in otherwise look for best match.
(defun map-tags-of-ireq-term (term blink)
  (let ((tags (mapcar #'value-of-parameter-f (cdr (parameters-of-term term)))))
    ;;(setf -term term -blink blink) (break "mtoit")
    (if (and blink
	     (member (type-of-ireq-term term) '(|application| application)))

	(let ((eenvs (exported-environments-of-bus-link blink))
	      (lenvs *component*)
	      (addr (cdr tags)))

	  (cons 'application
		(cond

		  ;; no addr supplied use local orb.
		  ((null addr) (orb-address))

		  ((not (null eenvs)) addr)
		  
		  ;; otherwise attempt match of local envs with supplied addr.
		  (t (let ((addrs (mapcar #'address-of-environment lenvs)))
		       (let ((maddr (best-token-list-match
				     (if (null addr) '(orb) addr)
				     addrs)))
			    
			 ;;(when (null maddr)  (setf -tags tags) (break "mtoit") nil)
			 maddr))))))
	tags)))

(defun tid-of-ireq-term (term)
  (let ((btid  (cadr (bound-terms-of-term term))))
    (when btid
      (let ((tid (term-of-bound-term btid)))
	(unless (ivoid-term-p tid)
	  tid)))))
  
(define-primitive |!event_synchronization| () (description stamp))

(define-primitive |!rsp| ((natural . sequence)) (result))

(define-primitive |!configure| () (command))

(defun iconfigure-term-aux-p (term)
  (and (eql *iconfigure* (id-of-term term))
       (let ((bts (bound-terms-of-term term)))
	 (and bts
	      (null (cdr bts))
	      (null (bindings-of-bound-term (car bts)))))
       (let ((parms (parameters-of-term term)))
	 (or (null parms)
	     (and (null (cdr parms))
		  (bool-parameter-p (car parms)))))))
	 

(define-primitive |!inform| () (info))
(define-primitive |!revoke| () (info))

(define-primitive |!request| () (command))

(define-primitive |!start| () (types stamp address other))

(defun description-of-istart-term (term)
  (other-of-istart-term term))
  
(defun broadcasts-of-istart-term (term)
  (other-of-istart-term term))


(defun irsp-wmsg-term (seq result msgs)
  (instantiate-term (irsp-op seq)
		    (cons (instantiate-bound-term result)
			  (nreverse msgs))))

(defun bound-messages-of-irsp-term (term)
  (cdr (bound-terms-of-term term)))

(define-primitive |!ping| ((natural . sequence)) (term))

(define-primitive |!pong| ((natural . sequence)))

(define-primitive |!interrupt| ((natural . sequence)))
(define-primitive |!interrupted| ((natural . sequence)))


;;;;	RLE TODO FTTB : orb can connect to only one other orb.
;; (<tags> . <link>) list
(defvar *orb-address-map* nil)

;;;;	
;;;;	Broadcast Sentries
;;;;	

(defun producer-of-permit (p) (car p))
(defun consumers-of-permit (p) (cdr p))


(defun add-to-broadcast-sentry (sentry types producer &optional (consumer t))
  (dolist (type types)
    (let ((type-sentry (assoc type sentry)))
      (unless type-sentry
	(setf sentry
	      (cons (setf type-sentry
			  (cons type nil))
		    sentry)))
      
      (setf (cdr type-sentry)
	    (cons (cons producer consumer) (cdr type-sentry)))))
  sentry)





;;;;
;;;;	BUS
;;;;

;;;
;;;	IOB's
;;;	


(defstruct iob
  (term nil))

(defun term-of-iob (iob) (iob-term iob))


(defstruct (broadcast-iob (:include iob))
  stamp
  type
  blink)

(defun type-of-broadcast-iob (iob) (broadcast-iob-type iob))
(defun stamp-of-broadcast-iob (iob) (broadcast-iob-stamp iob))
(defun blink-of-broadcast-iob (iob) (broadcast-iob-blink iob))

(defun new-broadcast-iob (bcast type stamp &optional blink)
  (make-broadcast-iob :term bcast :type type :stamp stamp :blink blink
		      ))


;; used to derive iobs for incoming data.
(defstruct (seq-iob (:include iob))
  (sequence nil))

;; reply: used to derive iob for outgoing data generated by a request.
(defstruct (rep-iob (:include iob))
  (req nil))

(defun sequence-of-iob (iob) (seq-iob-sequence iob))
(defun request-of-out-iob (iob) (rep-iob-req iob))


;; primary sequence numbers used to match replies(msg|rsp) with requests
;; secondary sequence numbers used to match recursive req with req.
;; EG.
;; process A, B
;; A sends req 1 to B.		: req 1 added to A's pend-remote
;; B recvs req 1 		: sets secondary to 1
;; B sends req 3,1 to A		: secondary is 1, req 3,1 add to B's pend-remote
;; A recvs req 3,1 		: sets secondary to 3 and points 1 -> 3,1, req 3,1 inherits 1's task.
;; A sends req 2,3 to B		: req 2,3 added to A's pend-remote
;; B recvs req 2,3		: sets secondary to 2, and points 3,1 -> 2,3, req 2,3 inherits 3,1's task.
;; B sends req 4,2 to C		: req 4,2 added to B's pend-remote
;; C recvs req 4,2		: sets secondary to 4, no 2,x pending -> launch task 
;; C sends req 8,4 to A
;; A recvs req 8,4		: A will not find 4,x and thus will launch task
;; fails as transaction registry. Need unique transaction number for all particpating parties
;; ie secondary sequence is not robust, instead need real transaction stamp
;; only send transaction stamp if sender wants to allow recursive call back.
;; ATheMoment, only the library would do so. but receivers must recognize and pass along if
;; they want to call back or allow connected env to call back.

;;;;	INVARIANT : MTT : A task can only process a single transaction at a time.

;;;;	
;;;;	Callback : implicit callback can be done without knowledge of callers
;;;;	  environment address.
;;;;	
;;;;	Scenario: Process A with environment e calls Process b with environment f.
;;;;	  f calls e back.
;;;;	
;;;;	A,e sends !req{a1; f}(t1; tid) to B. 
;;;;	B,f sends !req{b1;}(t2; tid) to A
;;;;	 
;;;;	  B needs to be able to associate tid with link.  (B has in-req-iob
;;;;	  A needs to be able to associate tid with e (A has out-req-iob)
;;;;	
;;;;	
;;;;	tid is thread id. It may correspond to a transaction id in the process originating
;;;;	the thread. The tid might be used to find the appropriate task to run a pending
;;;;	transaction. When a transaction is initiated it will inherit the tid of the environment
;;;;	if there is one otherwise it will init the tid.
;;;;	
;;;;	
;;;;	v4.2/v5 transactions : 
;;;;	  - only want v5 lib initiating inter-process transactions.
;;;;	  - v4.2 can be called back from v5 with transaction-id.
;;;;	  - v4.2 may do intra-process transaction.
;;;;	
;;;;	if a request is made to v5 in scope of intra-process transaction then 
;;;;	failure is generated as tstate will not be located or will simply
;;;;	create a v5 transaction for the request.
;;;;	
;;;;	
;;;;	v5 : 
;;;;	 req comes in : tid and blink or req are bound to *tid* and *tid-blink*
;;;;	  this is the only place tid is set !
;;;;     req gets to environment eval
;;;;	    if tid names known state then uses that state.
;;;;		actually at the momemt expects *transaction-state* to match tid if known.
;;;;		this should be fixed with event model changes.
;;;;	    else makes new transaction and transaction state
;;;;	
;;;;	
;;;;	v4 : 
;;;;	  - should support v5 callback ie when called back sets *tid* *transaction-state*
;;;;	    as indicated by callback.
;;;;	  - then can do same environment eval ?
;;;;	
;;;;	v4 input evaled. Eval creates local transaction and binds *transaction-state*
;;;;	sends req with embedded callback to v5. ?? 
;;;;	v5 does not recoginize tid so initiates new transaction but assoc's with tid from v4
;;;;	  assoc done in transaction-state.
;;;;	v5 evals callback which sends callback req to v4.
;;;;	v4 does recognize tid, but creates new transaction state as indicated by callback?
;;;;	v4 must send futher reqs to v5 with tid derived from new transaction.
;;;;	
;;;;	Do not want all ml-evals to occur in transaction mode so need with_transaction
;;;;	wrapper in order to wrap ml eval requiring intra transaction. Inter transaction
;;;;	will be bound implicitly.
;;;;	 this does create prob with toploop when coding \(). for \unit  ilist sees
;;;;	 the escaped paren and gets confused. but this is a toploop prob.
;;;;	
;;;;	
;;;;	
;;;;	inter-process transactions : 
;;;;	 
;;;;	Ordering stamps from diverse processes is problematical. Order is important
;;;;	for distributed table access. 
;;;;	
;;;;	Thus table server should be origin of all stamps in distributed table.
;;;;	
;;;;	Client still requires comparison of local transaction stamp with table stables
;;;;	so as to allow local lookup. 
;;;;	
;;;;	A single threaded client can assume that the local stamp is later than any 
;;;;	table stamps unless the stamp was recieved during the local transaction.
;;;;	However, in a single threaded client the client should not be reading broadcasts
;;;;	during a local transaction so this shouldn't be a concern.
;;;;	
;;;;	If a client wishes to make several requests during a single transaction then it must
;;;;	be done in scope of a callback. If the server allowed the client to decide begin and
;;;;	end of transaction then the server has no guaruntee of transaction termination.
;;;;
;;;;	If a client executes more than one server transaction during a local transaction
;;;;	then it is impossible to maintain the constistency contraint of transactions.
;;;;	  - if concurrent transactions are interleaved with the transaction executed
;;;;	    on behalf of the client transaction then the commits must be performed
;;;;	    sequentially. Thus some of the concurrent data will be visible to the client
;;;;	    transaction if the server transaction data is.
;;;;	
;;;;	Conclusion : we are left with the somewhat unsatisfying feature that 
;;;;	  a client transaction must know apriori if it will send requests to
;;;;	  the server. (if it wants to see updates by server, ie client could
;;;;	  launch server transactions, but not nest them).
;;;;
;;;;	  Or conservatively execute all transactions in
;;;;	  scope of server callback. The second solution is appropriate if 
;;;;	  you have coarse granularity transactions. Ie you do a lot with
;;;;	  each one, so the overhead of the remote call is noise.
;;;;	
;;;;	  Or Client could operate in a transaction less mode where any
;;;;	  local access to distributed data finds the latest committed
;;;;	  data and any server transaction serves a single request.
;;;;	  This could be implemented by using a special constant
;;;;	  transaction for data access. 
;;;;	
;;;;	The comibination of the two may be a reasonable solution. Operate in
;;;;	transaction less mode except for easily recognized specific calls.
;;;;	Those calls could be nested in the transaction-less transaction.
;;;;	



;;;;	Not applicable: ???
;;;;	To facilitate stamp ordering, clients should listen for begin and end transaction
;;;;	broadcasts, and keep a list of transaction stamps received during the local transaction.
;;;;	
;;;;	If a client initiates a transaction from within a local transaction then the 
;;;;	transaction begin broadcast should contain the clients stamp so that the local
;;;;	transaction can access data updated by the server transaction.
;;;;

(defstruct (req-iob (:include seq-iob))
  (type nil)
  (tags nil)
  (tid nil))

(defun tags-of-req-iob (iob) (req-iob-tags iob))
(defun type-of-req-iob (iob) (req-iob-type iob))

;; singleton bound-term list containing transaction-id.
(defun tid-of-req-iob (iob) (req-iob-tid iob))

(defun transaction-id-of-req-iob (iob)
  (let ((tid (req-iob-tid iob)))
    (when tid
      (term-of-bound-term (car tid)))))		

;; no rsp
(defstruct (asynch-req-iob (:include req-iob)))

(defstruct (out-req-iob (:include req-iob))
  (read nil))

(defstruct (callback-iob (:include out-req-iob))
  (blink nil))

(defun new-callback-iob (tid blink term)
  (make-callback-iob :blink blink
		     :tid tid
		     :term term
		     :sequence (current-sequence)
		     :type 'callback))

(defun blink-of-callback-iob (iob) (callback-iob-blink iob))

(defun update-req-iob-read (req-iob iob)
  ;; MTT MUTEX
  (setf (out-req-iob-read req-iob) (nconc (out-req-iob-read req-iob) (list iob))))
  
(defun pop-req-iob-read (req-iob)
  ;; MTT MUTEX
  (pop (out-req-iob-read req-iob)))
  
(defun peek-req-iob-read (req-iob)
  (car (out-req-iob-read req-iob)))

(defun new-tid (&optional tid)
  (let ((t-id (or tid (transaction-id))))
    (when t-id (new-transaction-id-term t-id))))

;; rle todo if not lib (transaction-id) always the same for all reqs sent. which prob is not good.
(defun new-out-req-iob (type tags term)
  (advance-sequence)
  (make-out-req-iob :type type :tags tags :term term :sequence (current-sequence)
		    :tid (tid)
		    ))

;; dummy request to catch top-level requests.
(defun new-receive-req-iob ()
  (make-out-req-iob :tid nil))



(defstruct (in-req-iob (:include req-iob))
  (blink nil)
  (messages nil)	;; accumulate messages. !msg terms.
  			;;  Some types of links do not have ability to send msgs asynch. In which
 			;;  case they are queued here until rsp and sent back with rsp.
  )

(defun blink-of-in-req-iob (iob) (in-req-iob-blink iob))
(defun messages-of-in-req-iob (iob) (in-req-iob-messages iob))
  
(defun new-in-req-iob (blink seq tid type tags term)
  (make-in-req-iob :blink blink
		   :sequence seq
		   :tags tags
		   :type type
		   :tid tid
		   :term term))

(defun in-req-iob-add-message (iob msg)
  (push (instantiate-bound-term msg) (in-req-iob-messages iob)))


(defstruct (in-msg-iob (:include seq-iob)))

(defstruct (out-msg-iob (:include rep-iob)))

(defun new-in-msg-iob (sequence msg)
  (make-in-msg-iob :sequence sequence :term msg))

(defun new-out-msg-iob (req msg)
  (make-out-msg-iob :req req :term msg))


(defun new-asynch-req-iob (type tags term)
  (advance-sequence)
  (make-in-req-iob :sequence (current-sequence)
		   :tags tags
		   :type type
		   :term term))

;; used to send response
(defstruct (in-rsp-iob (:include seq-iob)))

(defun result-of-in-rsp-iob (iob) (term-of-iob iob))
	   
(defun new-in-rsp-iob (seq result)
  (make-in-rsp-iob :sequence seq :term result))


(defstruct (out-rsp-iob (:include rep-iob))
  ;;(delay) ; no need with config changes 11/2002
  )


(defun new-out-rsp-iob (req result)
  (make-out-rsp-iob :req req :term result))


;;;
;;;	bus 
;;; 

;;;;	RLE TODO : broadcasts on bus:
;;;;	RLE TODO : use double linked out queues and hold output until non-broadcast msg or
;;;;	RLE TODO : some transaction end notification. Then compress queue by matching commits with acts.
;;;;	RLE TODO : and removing undo and undone acts. Then send messages in blocks.
;;;;	RLE TODO : want double link queue do facilitate matching completions. May be better 
;;;;	RLE TODO : to extract act sequence then process completion sequence by either removing
;;;;	RLE TODO : undone from end of act sequence or match commit to front of act sequence.
;;;;	RLE TODO : then only need to doubly link act sequence. but usual case will be sequece
;;;;	RLE TODO : of acts followed by sequence of commits so should optimize for this then
;;;;	RLE TODO : fallback to more costly scheme if undo encountered. optimize can just be scan
;;;;	RLE TODO : queue to commit sequence and then pair off.

;;;
;;;;	want some type of mirror image of environments to reflect configuration knowledge.
;;;;	
;;;;	link broadcast sentries then derivable from link environments.
;;;;	

;;;;	
;;;;	it : a bus-link may deadlock to both ends attempt to simultaneously 
;;;;	  write a large term. The socket buffers a limited amount of bytes and then
;;;;	  blocks until the other end reads some. Since both ends are writing neither 
;;;;	  reads and they both become blocked. 
;;;;	
;;;;	  - a multi-tasking solution would be for each bus-link end to have a 
;;;;	    task which continuously reads from the socket and queues the terms read. MTT
;;;;	  - the non-multi-tasking solution is for the ends of the sockets to cooperate so
;;;;	    that only one may write to the socket at a time. 
;;;;	      * write requires that bus-link have "it":
;;;;		get it : 
;;;;	         - read rsp
;;;;		 - read req
;;;;	        lose it :
;;;;	         - send rsp
;;;;		 - send req
;;;;	      * if a bus-links has a write to perform but does not have it
;;;;	        then it can send a short request and will gain it with the response.
;;;;	
;;;;	

(defstruct flow-control
  (idle nil)
  (it nil)
  )



(defstruct (link-environment (:include environment-base)) 
  )

;; init link environment to indicate connected env is idle.
(defun new-link-environment (address &optional table-types)
  (make-link-environment :address address
			 :address-parameters (toks-to-parameters address)
			 :produce-table-types table-types
			 :properties (list (cons 'idle (ibool-term t)))))
  
;; shared by read and write
(defstruct bus-link
  exported-environments				; remote
  imported-environments
  link

  ;; out
  broadcast-sentry
  flow-control
  (primary nil)			;; if accept true if connect false.
  (block nil)			;; do not write if true. make false on any recv. true on request !it.
  (output-queue (new-queue))	;; shared by write task(pop) and transaction tasks (push). could q msg while waiting for it.
  (input-queue  (new-queue))    ;; bus-link recv pops, config-wait pushes.
  (properties nil)
  (connections nil)

  input-sentries
  )

(defun environment-connections-of-bus-link (blink)
  (bus-link-connections blink))

(defun find-environment-connection (blink local remote)
  (find-if #'(lambda (econn)
	       (and (equal local (local-of-environment-connection econn))
		    (equal remote (remote-of-environment-connection econn))))
	   (environment-connections-of-bus-link blink)))

(defun add-environment-connection (blink econn)
  (push econn (bus-link-connections blink))
  (rehash-environment-connection-caches))

(defun delete-environment-connection (blink econn)
  (setf (bus-link-connections blink)
	(delete-if #'(lambda (bconn)
		       (and (equal (local-of-environment-connection econn)
				   (local-of-environment-connection bconn))
			    (equal (remote-of-environment-connection econn)
				   (remote-of-environment-connection bconn))))
		   (environment-connections-of-bus-link blink)))
  (rehash-environment-connection-caches))


(defun properties-of-bus-link (blink)
  (bus-link-properties blink))

(defun blink-it-able-p (blink)
  (cdr (assoc 'it (properties-of-bus-link blink))))

(defun interpret-blink-property (prop)
  (let ((name (tok-upcase (car prop)))
	(term (cdr prop)))
    (cons name
	  (case name
	    (it (bool-of-ibool-term term))
	    (otherwise term)))))

(defun blink-property-to-term (name v)
  (cons name
	(case name
	  (it (ibool-term v))
	  (otherwise v))))

(defun blink-modify-properties (blink properties)
  (setf (bus-link-properties blink)
	(mapcar #'interpret-blink-property properties)))

(defun bus-link-it-able-p (blink)
  (cdr (assoc 'it (properties-of-bus-link blink))))
	    


(defun flow-control-of-bus-link (blink)
  (let ((fc (bus-link-flow-control blink)))
    (or fc
	(setf (bus-link-flow-control blink) (make-flow-control)))))

;; this only works for lib client environments.
;; nil --> idle.
(defun bus-link-not-idle (blink &optional forcep)
  (when (and blink (or forcep (not (flow-control-idle (flow-control-of-bus-link blink)))))
    (setf (flow-control-idle (flow-control-of-bus-link blink)) t)
    (show-link-change blink "not idle"))
  )

(defun bus-link-really-not-idle (blink)
  (setf (flow-control-idle (flow-control-of-bus-link blink)) 'really-not)
  (show-link-change blink "really not idle"))

(defun show-link-change (blink mods)
  (let ((rie (some #'(lambda (ie)
		       ;;(format t "~%~a~%" (address-of-environment ie))
		       (when (member '|ref|  (address-of-environment ie))
			 (address-of-environment ie)))
		   (imported-environments-of-bus-link blink))))
    (when rie
      (format t "~%set ~a ~a~%" mods rie))))

(defun bus-link-idle (blink)
  (setf (flow-control-idle (flow-control-of-bus-link blink)) nil)
  (show-link-change blink "idle")
  ;; depends on certain object code being loaded!.
  (handle-process-err #'(lambda (err)
			  (declare (ignore err))
			  ;;(setf -err err) (break "bni")
			  (format t "call_notify_idle_hooks failed~%"))
		      (ml-text "call_notify_idle_hooks ()")))

(defun bus-link-idle-p (blink)
  (and blink
       (null (flow-control-idle (flow-control-of-bus-link blink)))))

(defun bus-link-really-not-idle-p (blink)
  (and blink
       (eql 'really-not (flow-control-idle (flow-control-of-bus-link blink)))))


(defun bus-link-got-it (blink)
  (show-telemetry "got-it") ;(setf -blink blink)(break "git")
  (setf (flow-control-it (flow-control-of-bus-link blink)) t))

(defun bus-link-lost-it (blink)
  (show-telemetry "lost-it") ; (break "lit")
  (setf (flow-control-it (flow-control-of-bus-link blink)) nil))

;; it would seem that if there is a cycle of links then
;; this is insufficient to prevent deadlock.
;; at the moment, (7/00) we do not have link cycles .
(defun bus-link-have-it (blink)
  (or (soft-link-p (link-of-bus-link blink))
      (flow-control-it (flow-control-of-bus-link blink))))

;; some links may be exempt from having the it , such as metaprl
;; since we know that we only receive from them after a request and we wait.
(defun bus-link-exempt-p (blink)
  
  ;;(break)
  (mathbus-channel-p (car (channels-of-link (link-of-bus-link blink))))
)


(defun new-bus-link (l &optional primary) (make-bus-link :link l :primary primary))

(defun imported-environments-of-bus-link (l) (bus-link-imported-environments l))
(defun exported-environments-of-bus-link (l) (bus-link-exported-environments l))
(defun broadcast-sentry-of-bus-link (l) (bus-link-broadcast-sentry l))
(defun output-queue-of-bus-link (l) (bus-link-output-queue l))
(defun input-queue-of-bus-link (l) (bus-link-input-queue l))
(defun link-of-bus-link (l) (bus-link-link l))
(defun bus-link-alive-p (l) (and (bus-link-link l) t))
(defun set-blink-link (blink link)  (setf (bus-link-link blink) link))

(defun primary-bus-link-p (blink) (bus-link-primary blink))

(defun bus-link-add-import-environment (addr l)
  (push (make-link-environment :address addr
			       :address-parameters (toks-to-parameters addr))
	(bus-link-imported-environments l))
  (rehash-environment-connection-caches))

(defun bus-link-delete-import-environment (addr l)
  (setf (bus-link-imported-environments l)
	(remove addr (imported-environments-of-bus-link l)
		:test #'equal
		:key #'address-of-environment))
  (rehash-environment-connection-caches))

    
(defun add-broadcast-state-to-link-environment (state env blink)
  ;;(setf a state b env c blink) (break "abstle")
  (add-broadcast-state state env)
  (setf (bus-link-broadcast-sentry blink)
	(make-environment-broadcast-sentry-cache
	 (mapcan #'(lambda (env) (copy-list (broadcast-states-of-environment env)))
		 (imported-environments-of-bus-link blink)))))

(defun remove-broadcast-state-from-link-environment (types pstamp cstamp env blink)
  ;;(setf a types b env c blink d (bus-link-broadcast-sentry blink)) (break "rbsfle")
  (remove-broadcast-state types pstamp cstamp env)
  (setf (bus-link-broadcast-sentry blink)
	(make-environment-broadcast-sentry-cache
	 (mapcan #'(lambda (env) (copy-list (broadcast-states-of-environment env)))
		 (imported-environments-of-bus-link blink)))))


(defun find-address-parameters-of-bus-link (blink tags &optional nil-ok-p)
  (or (find-first #'(lambda (env)
		      (when (equal tags (address-of-environment env))
			(address-parameters-of-environment env)))
		  (imported-environments-of-bus-link blink))
      (unless nil-ok-p
	(raise-error (error-message '(bus link tags parameters not)
				    tags)))))


(defun add-blink-input-sentry (name f blink)
  (setf (bus-link-input-sentries blink)
	(cons (cons name f)
	      (delete name (bus-link-input-sentries blink) :key #'car))))


(defun check-blink-input-sentries (blink term)
  (labels
      ((crush-kill-destroy (why)
	 (kill-bus-link blink (itext-term why))
	 (return-from check-blink-input-sentries nil)))

    (dolist (s (bus-link-input-sentries blink))
      (let ((why (funcall (cdr s) term)))
	(when why
	  (crush-kill-destroy why))))
    
    term))

#|
;; returns list of environment addresses (both local and remote).
(defun find-matching-environments (table-type stamp desc)
  (labels ((matchp (bs)
	     (and (member table-type (table-types-of-broadcast-state bs))
		  (compare-terms-p (producer-stamp-of-broadcast-state bs) stamp)
		  (match-descriptions-p desc (description-of-broadcast-state bs)))))
    (let ((acc nil))
      (dolist (l *bus-links*)
	(dolist (e (imported-environments-of-bus-link l))
	  (when (exists-p #'matchp
			  (broadcast-states-of-environment e))
	    (push (address-of-environment e) acc))))
      (dolist (e *component*)
	(when (exists-p #'matchp
			(broadcast-states-of-environment e))
	  (push (address-of-environment e) acc)))
      acc)))


;; returns list of environment addresses (both local and remote).
(defun find-matching-environments-by-description (desc)
  (labels ((matchp (bs)
	     (match-descriptions-p desc (description-of-broadcast-state bs))))
    (let ((acc nil))
      (dolist (l *bus-links*)
	(dolist (e (imported-environments-of-bus-link l))
	  (when (exists-p #'matchp
			  (broadcast-states-of-environment e))
	    (push (address-of-environment e) acc))))
      (dolist (e *component*)
	(when (exists-p #'matchp
			(broadcast-states-of-environment e))
	  (push (address-of-environment e) acc)))
       acc)))
|#

;; why pend local?? should be part of MTT data structures.
;; indicates who/what to interrupt if interrupt comes in.
;;(defun pend-local (blink iob) (push iob (bus-link-pend-local blink)))


;;;
;;;	resources
;;;
;;;
;;;	transaction and tids.
;;;

(define-primitive |!begin| () (stamp tid))
(define-primitive |!end| () (stamp))
(define-primitive |!checkpoint| () (stamp))

(define-primitive |!transaction_id| ((n . transaction) (t . process-id)))


(defun new-transaction-id-term (tid)
  (itransaction-id-term (car tid) (cdr tid)))


(defmacro transaction-passport-term-p (term)
  `(and (ipassport-term-p ,term)
       (eql 'transaction (table-type-of-ipassport-term ,term))))

(defun transaction-passport-begin-term-p (term)
  (and (transaction-passport-term-p term)
       (ibegin-term-p (broadcast-of-ipassport-term term))))

(defun transaction-passport-end-term-p (term)
  (and (transaction-passport-term-p term)
       (iend-term-p (broadcast-of-ipassport-term term))))

(defun only-transactions-delimiters-p (blink)
  (let ((l (output-queue-list blink)))
    (and (not (transaction-passport-end-term-p (term-of-iob (car l))))
	 (every #'(lambda (iob) (transaction-passport-term-p (term-of-iob iob)))
		l))))


;;; blink : anonymous transaction req needs to carry blink for callback.
;;;	

(defstruct tstate
  blink
  transaction-id
  begin-stamp
  local-stamp
  tid
  (collect-queue nil)
  (completions nil)
  (weak nil)
  (callback nil)
  (result nil)
  (properties nil)
  (stuff nil)
  (touch-history (make-touch-history))
  )

(defun touch-history-touch (r &optional ts env)
  (let ((e (or env (current-environment)))
	(tstate (or ts (tstate-by-tid (tid)))))
    (let ((th (touch-history-of-tstate tstate)))
      (let ((eh (assoc e (touch-history-list th) :test #'eq)))
	(if eh
	    (push r (cdr eh))
	    (push (cons e (list r)) (touch-history-list th)))))))

(defun touch-history-of-environment (&optional ts env)
  (let ((e (or env (current-environment)))
	(tstate (or ts (tstate-by-tid (tid)))))
    (let ((th (touch-history-of-tstate tstate)))
      (cdr (assoc e (touch-history-list th) :test #'eq)))))
    

(defun transaction-id-of-tstate (tstate)  (tstate-transaction-id tstate))
(defun completions-of-tstate (tstate)  (tstate-completions tstate))
(defun collect-queue-of-tstate (tstate)  (tstate-collect-queue tstate))
(defun begin-stamp-of-tstate (tstate)  (tstate-begin-stamp tstate))
(defun tid-of-tstate (tstate)  (tstate-tid tstate))
(defun tidblink-of-tstate (tstate)  (tstate-blink tstate))
(defun callback-closure-of-tstate (tstate)  (cdr (tstate-callback tstate)))
(defun callback-environment-of-tstate (tstate)  (car (tstate-callback tstate)))
(defun result-of-tstate (tstate)  (tstate-result tstate))
(defun local-stamp-of-tstate (tstate)  (tstate-local-stamp tstate))
(defun touch-history-of-tstate (tstate)  (tstate-touch-history tstate))

(defun properties-of-tstate (tstate) (tstate-properties tstate))
(defun property-of-tstate (key tstate)			   
  (cdr (assoc key (tstate-properties tstate))))
(defun tstate-property-acons (name prop tstate)
  (setf (tstate-properties tstate)
	(acons name prop (remove name (tstate-properties tstate) :key #'car))))

(defun tstate-weaken (tstate)
  (setf (tstate-weak tstate) t))

(defun weak-tstate-p (tstate stamp)
  (or (tstate-weak tstate)
      ;; ie transaction started elsewhere.
      (not (in-transaction-p (begin-stamp-of-tstate tstate) stamp))))

(defun new-tstate (&optional weakp instamp)
  (let ((stamp (or instamp (transaction-stamp))))
    ;;(setf s instamp u stamp) (break "nt")
    (let ((t-id (transaction-id))
	  (tid (tid)))
      (make-tstate :transaction-id t-id
		   :local-stamp stamp
		   :tid (or tid (new-tid t-id))
		   :blink (when tid (tid-blink))
		   :weak weakp))))

(defun tstate-dummy-p (tstate)
  (let ((bstamp (begin-stamp-of-tstate tstate)))
    (and bstamp
	 (dummy-transaction-stamp-p bstamp))))


(defun tstate-set-result (tstate result)
  (setf (tstate-result tstate) result))

(defun tstate-set-callback (tstate closure)
  ;;(break "tsc")
  (setf (tstate-callback tstate) (cons (current-environment) closure)))

(defun tstate-set-begin (tstate begin)

  ;;(break "tsbegin")
  ;; do sanity check.
  (let ((cur (begin-stamp-of-tstate tstate)))
    (when (and cur (not (equal-stamps-p begin cur)))
      ;;(break "tsb")
      (message-emit (warn-message '(tstate begin insane)))
      ;;(raise-error (error-message '(tstate begin insane) (stamp-to-term cur) (stamp-to-term begin)))
      ))
      
  (setf (tstate-begin-stamp tstate) begin))



(defun tent-order-push (stamp tag)
  (let ((env (require-environment nil '(tent-order))))
    ;;(when (or t (not (member '|lib| (address-of-environment env)))) (break "top"))
		    
    (setf (environment-tent-order env)
	  (nconc (tent-order-of-environment env)
		 (list (cons stamp (cons tag (eql tag 'begin))))))
    ))
		 
(defun tent-order-delete (stamp)
  (let ((env (current-environment))
	(foundp nil))

    ;;(setf g (tent-order-of-environment env)) (break "tod")

    (do ((o (tent-order-of-environment env) (cdr o)))
	((or (null o)
	     (let ((e (car o)))
	       (and (eql (cadr e) 'begin)
		    (cddr e)
		    (not (when (equal-stamps-p (car e) stamp)
			   (setf foundp t))))))
	 (setf (environment-tent-order env) o)))

    ;;(setf a stamp b env c (tent-order-of-environment env) f foundp) (break "tod")
    (let ((toe (tent-order-of-environment env)))
      (when toe
	(unless foundp
	  (let ((e (assoc stamp toe :test #'equal)))
	    (if e
		(setf (cddr e) nil)
		(progn (when *process-break* (break "tod"))
		       (message-emit (warn-message '(tent order delete) (stamp-to-string stamp)))))))))))

;; used to order commits/begin in rsp to broadcast, begin comes from server.
;; used to find view for lookup. begin then is local.
;; caller already determined that process-ids differ, thus begin should be local.
;; find tstate by t-id of begin
(defun tent-order-less-than (commit stamp)
  (let ((local (local-stamp-of-tstate (tstate-by-stamp stamp)))
	(result t)
	(localp nil))
    (do ((o (tent-order-of-environment (current-environment)) (cdr o)))
	((or (null o)
	     (let ((e (car o)))
	       (if (eql (cadr e) 'begin)
		   ;; found local ?
		   (when (equal-stamps-p (car e) local)
		     (setf localp t)
		     nil)
		   ;; found local then commit ?
		   (when (and localp (equal-stamps-p commit (caar o)))
		     (setf result nil)
		     t))))))
	result))


;;;
;;;	completions
;;;

(defun completions-p (&optional tstate)
  (and (completions-of-tstate (or tstate (transaction-state))) t))

(defun completions-get (&optional tstate)
  (completions-of-tstate (or tstate (transaction-state))))

(defun completions-put (clist)
  (setf (tstate-completions (transaction-state)) clist))

(defun completion-push (c)
  (let ((tstate (transaction-state)))
    (setf (tstate-completions tstate)
	  (cons c (completions-of-tstate tstate)))))

(defun completion-peek-last (&optional tstate)
  (car (last (completions-get tstate))))

(defun completion-peek-first (&optional tstate)
  (car (completions-get tstate)))





;;;
;;;	io-queues
;;;

(defun output-queue-push (blink iob)
  (if (it-iob-p iob)
      (queue-push-front (output-queue-of-bus-link blink) iob)
      (queue-push (output-queue-of-bus-link blink) iob)))


(defun output-queue-peek (blink)  (queue-peek (output-queue-of-bus-link blink)))
(defun output-queue-peek-ahead (blink)  (queue-peek-ahead (output-queue-of-bus-link blink)))
(defun output-queue-pop (blink)  (queue-pop (output-queue-of-bus-link blink)))
(defun output-queue-length (blink)  (length-of-queue (output-queue-of-bus-link blink)))
(defun output-queue-list (blink)  (queue-list (output-queue-of-bus-link blink)))

(defun input-queue-push (blink term) (queue-push (input-queue-of-bus-link blink) term))
(defun input-queue-pop (blink)  (queue-pop (input-queue-of-bus-link blink)))

;; RLE TODO if bus-link closed pending reqs should be purged.

(defvar *bus-pend* nil)

(defun bus-pend-abort (tid)
  (dolist (iob *bus-pend*)
    (when (and (out-req-iob-p iob)
	       (equal-tids-p tid (tid-of-req-iob iob)))
      (push (new-in-rsp-iob (sequence-of-iob iob)
			    (ifail-term (ivoid-term)))
	    (out-req-iob-read iob)))))

(defun bus-abort ()
  (let ((iob (car *bus-pend*)))
    (let ((tid (tid-of-req-iob iob)))
      (when tid
	(bus-pend-abort tid)
	(format t "BusAbort ~a remaining~%" (length *bus-pend*))))))


(defun show-bus-pend ()
  (format t "~%~%")
  (mapcar #'(lambda (iob)
	      (cond
		((req-iob-p iob)
		 (format t "ReqIOB Type: ~a ~%" (type-of-req-iob iob))
		 (format t "  Address     : ~a ~%" (tags-of-req-iob iob))
		 (let ((tid (tid-of-req-iob iob)))
		   (when tid 
		     (format t "  Transaction : ~a ~%"
			     (transaction-of-itransaction-id-term tid))))
		 (if (out-req-iob-p iob)
		     (format t "  Out -read   : ~a ~%" (length (out-req-iob-read iob)))
		     (format t "  Out -not     ~%"))
		 )
		(t (format t "Unexpected IOB ~%"))
	      )
	      (terpri))
	      
	  *bus-pend*)
  (format t "~%~%"))


;; queueing of two req with distinct thread-ids is an error as it is likely
;; to cause failure until we have event model or mtt.
(defun bus-pend (iob) 

 (when (and nil
	    (out-req-iob-p iob)
	    (tid-of-req-iob iob)
	    (exists-p #'(lambda (piob)
			  (and (out-req-iob-p piob)
			       (tid-of-req-iob piob)
			       (not (equal-tids-p (tid-of-req-iob iob)  (tid-of-req-iob piob)))))
		      *bus-pend*))
   (break "bp")
   ;; failure needs to be dealt with ??
   (raise-error (error-message '(bus pend request synch))))
					     
 (push iob *bus-pend*)
 )

(defun pending-out-reqs-of-blink (blink)
  (mapcar #'(lambda (iob)
	      (when (and (out-req-iob-p iob)
			 (eq (or (bus-link-of-environment-address (tags-of-req-iob iob))
				 (and (callback-iob-p iob)
				      (blink-of-callback-iob iob)))
			     blink))
		    iob))
	  *bus-pend*))
	   
(defun pending-in-reqs-of-blink (blink)
  (mapcar #'(lambda (iob)
	      (when  (and (in-req-iob-p iob)
			  (eq (blink-of-in-req-iob iob) blink))
		     
		     iob))
	  *bus-pend*))

;; a recursive request will have usual request sequence number, plus a second sequence
;; number which can be used to find originating task.
(defun find-pending-remote (seq &optional transaction-id)
  ;;(break "fpr")
  (find-first #'(lambda (iob)
		  (if transaction-id
		      (let ((tid (tid-of-req-iob iob)))
			(if (null tid);; receive-request. Pending requests should preceed null tid on queue.
			    iob
			    (when (equal-tids-p tid transaction-id)
			      iob)))
		      (when (eql seq (sequence-of-iob iob))
			iob)))
	      *bus-pend*))

(defun any-pending-remote-p ()
  (and (find-first #'(lambda (iob)
		       (when (sequence-of-iob iob)
			 iob))
	      *bus-pend*)
       t))

(defun bus-unpend (iob)
  (setf *bus-pend* (delete iob *bus-pend*))
  (values))

(defun peek-pending () (car *bus-pend*))


(defun find-bus-environment (address)
  (or (find-first #'(lambda (blink)
		      (find-environment-in-list address (imported-environments-of-bus-link blink)))
		  *bus-links*)
      (raise-error (error-message '(bus environment not) address))))

(defun match-bus-environment (tags)
  (when nil
    (or (find-first #'(lambda (blink)
			(match-environment-in-list tags (imported-environments-of-bus-link blink)))
		    *bus-links*)
	(raise-error (error-message '(match bus environment not) tags))))

  ;; kludge to get around dummy link? proper question is why is dummy there.
  (let ((envs (mapcan #'(lambda (blink)
			  (let ((e (match-environment-in-list tags (imported-environments-of-bus-link blink))))
			    (when e (list e))))
		      *bus-links*)))
    (unless envs
      (raise-error (error-message '(match bus environment not) tags)))

    ;;(setf -a envs) (break "tyo")
    (if (and (cdr envs) (member 'dummy (address-of-environment (car envs))))
	(cadr envs)
	(car envs))))

(defun match-bus-environments (tags)

  ;; kludge to get around dummy link? proper question is why is dummy there.
  (let ((envs (mapcan #'(lambda (blink)
			  (let ((e (match-environment-in-list tags (imported-environments-of-bus-link blink))))
			    (when e (list e))))
		      *bus-links*)))

    ;;(setf -a envs) (break "tyo")
    (if (and (cdr envs) (member 'dummy (address-of-environment (car envs))))
	(cdr envs)
	envs)))

(defun match-bus-environment-links (stampt)

  ;; kludge to get around dummy link? proper question is why is dummy there.
  (let ((blinks (mapcan #'(lambda (blink)
			    (when (exists-p #'(lambda (e) (compare-terms-p stampt (stamp-term-of-environment e)))
					    (imported-environments-of-bus-link blink))
			      (list blink)))
		      *bus-links*)))

    (delete-duplicates blinks :test #'eq)))


(defun match-bus-environment-p (tags)
  (let ((envs (mapcan #'(lambda (blink)
			  (let ((e (match-environment-in-list tags (imported-environments-of-bus-link blink))))
			    (when e (list e))))
		      *bus-links*)))

    ;;(setf -a envs) (break "tyo")
    (when envs
      (if (member 'dummy (address-of-environment (car envs)))
	  (and (cdr envs) t)
	  t))))


(defun bus-environment-p (address)
  (find-first #'(lambda (blink)
		  (environment-in-list-p address (imported-environments-of-bus-link blink)))
	      *bus-links*))



(defun bus-link-of-environment-address (tags)
  (find-first #'(lambda (bl)
		  '(lambda (blink)
			  (let ((e (match-environment-in-list tags (imported-environments-of-bus-link blink))))
			    (when e (list e))))
		  (when (find-environment-in-list tags (imported-environments-of-bus-link bl))
		    bl))
	      *bus-links*))  


;;;
;;; 	send
;;;	
;;;	want it to address problem of multiple sends backing up and clogging a link
;;;	 and stalling a process waiting for write to complete.
;;;	
;;;	Maybe:
;;;	include it with broadcasts and notices.
;;;	send it after recving broadcast and notice.
;;;	
;;;	Another it issue:
;;;	
;;;	A sends it
;;;	B recvs it
;;;	simultaneously A requests it & B sends it.
;;;	simultaneously A receives it and B sends it again (to answer request).
;;;	  - maybe b shouldn't do this.
;;;	    but then risk losing it, ie neither have it so neither can give it up.
;;;	
;;;		currently !it{F:b} means ask and !it{T:b} means give.
;;;		  - ask, give, don't have it. 
;;;		  - if recv a don't have it then assume it. (no diff from giving it when don't have).
;;;		  OR recv dont have it: then send synchrounous request and assume 
;;;		  - primary (accept) and secondary(connect) link ends
;;;		    if primary gets a don=t have it then assume it
;;;		    if secondary does then assume not.
;;;		 - don't send(not even it request) until we receive something bit.
;;;		   prevents repeated requests for it.
;;;	
;;;	
;;;	     then of course could add an i don't have it and assume you do command to clear that up.
;;;	      -recv req but don't have it send an I don't have it rsp.
;;;	simultaneously A sends it and A receives it.
;;;	A receives it & b receives it
;;;	Both A & B have it.


;;;	currently lose it on send req,rsp. assume it on recv req,rsp
;;;	add assume it after receiving broadcast or msg but then send it unilaterally.
;;;	
;;;	

;;;;	A is primary
;;;;	
;;;;	A has it, B req's it, A sends it.
;;;;	B has it, A req's it, B sends it.
;;;;	A does not have it, B requests it, A sends not-it, B sends not-it, A assumes it.
;;;;	A req it, B sends not-it, A assumes it.

;;;;	A|B X (it{T|F} send|recv) X (not-it send|recv) X  own/not 
;;;;	
;;;;	A owns it
;;;;	  - recvs it{T}, noop?
;;;;	  - recvs it{F}, own <- F, sends it{T}
;;;;	  - sends it{T}, own <- F,
;;;;	  x sends it{F}
;;;;	  - recvs not-it, noop?
;;;;	  x sends not-it
;;;;	
;;;;	A does not own it
;;;;	  - recvs it{T}, own <- T
;;;;	  - recvs it{F}, sends not-it
;;;;	  x sends it{T}
;;;;	  - sends it{F}
;;;;	  - recvs not-it, own <- T
;;;;	  x sends not-it (only if recvs it{F}
;;;;	
;;;;	B owns it
;;;;	  - recvs it{T}, noop?
;;;;	  - recvs it{F}, own <- F, sends it{T}
;;;;	  - sends it{T}, own <- F,
;;;;	  x sends it{F}
;;;;	  - recvs not-it, noop?
;;;;	  x sends not-it
;;;;	
;;;;	B does not own it
;;;;	  - recvs it{T}, own <- T
;;;;	  - recvs it{F}, sends not-it
;;;;	  x sends it{T}
;;;;	  - sends it{F}
;;;;	  - recvs not-it, noop
;;;;	  x sends not-it (only if recvs it{F}
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	B has it, B recvs not-it, noop
;;;;	A has it, A recvs not-it, noop
;;;;	A recvs not-it, A assumes it.
;;;;	A has it, A recvs it{F}, A sends it{T}.
;;;;	B has it, A recvs it{F}, A sends it{T}.
;;;;	^(x has it), x recvs it{F}, A sends not-it().
;;;;	^(B has it), A recvs it{F}, A sends not-it().
;;;;	

(define-primitive |!it| ((bool . bool)))
(define-primitive |!not_it| ())

(defun get-blink-it (blink)
  ;;(setf -blink blink) (break "gi")
  (unless (bus-link-block blink)
    (show-telemetry "blocked")
    (setf (bus-link-block blink) t)
    (bus-send-asynch-command-iob
     (new-callback-iob (tid) blink (iasynch-command-term (iit-term nil))))
    (show-telemetry "get-it")
    ;;(setf -blink blink) (break "gi")
    ))

(defun it-iob-p (iob)
  (and (iasynch-command-iob-p iob)
       (let ((c (command-of-iasynch-command-term (term-of-iob iob))))
	 (or (iit-term-p c)
	     (inot-it-term-p c)))))

(defun remove-superfluous-transactions (blink)
  (let ((modp nil))
    (labels ((auxl (l)
	     (if (null l) nil
		 (let ((a (car l))
		       (b (cadr l)))

		   (if (and a b
			    (let ((aterm (term-of-iob a))
				  (bterm (term-of-iob b)))
	
			      ;;(setf -blink blink -iob iob -oterm oterm -bts bts) (break "bso")
			      (and (transaction-passport-end-term-p bterm)
				   (transaction-passport-begin-term-p aterm)
				   (compare-terms-p  (stamp-of-iend-term bterm) (stamp-of-ibegin-term aterm)))))
		       (progn (setf modp t)
			      (auxl (cddr l)))
		       (cons a (auxl (cdr l)))))))

	   (aux ()
	     (let ((a (output-queue-peek blink))
		   (b (output-queue-peek-ahead blink)))

	       (when (and a b)
		 (let ((aterm (term-of-iob a))
		       (bterm (term-of-iob b)))
	
		   ;;(setf -blink blink -iob iob -oterm oterm -bts bts) (break "bso")
		   (when (and (transaction-passport-end-term-p bterm)
			      (transaction-passport-begin-term-p aterm)
			      (compare-terms-p  (stamp-of-iend-term bterm) (stamp-of-ibegin-term aterm)))
		     (output-queue-pop blink)	  
		     (output-queue-pop blink)
		     ;;(format t "~%removed 2, ~a remain " (length (output-queue-list blink)))
		     (aux)))))))

      (let ((nl (auxl (output-queue-list blink))))
	(when modp
	  (set-queue (output-queue-of-bus-link blink) nl)))))
  (values)
  )

(defun bus-write ()
  ;; at this point stream is available for writing.
  ;;(break "bw")
  (dolist (blink *bus-links*)

    ;; it
    (remove-superfluous-transactions blink)
    (let ((iob (output-queue-peek blink)))
      ;;(setf -iob iob) (break "bw")
      (when (and iob
		 (not (only-transactions-delimiters-p blink)))

	;;(setf -iob iob -blink blink -term (term-of-iob iob)) (break "bw")
	;; need to prevent sending it again if it is in transit.
	;; ie block writes until we receive it one we request it.
	(unless (it-iob-p iob)
	  (unless (or (bus-link-have-it blink)
		      (not (bus-link-it-able-p blink)))
	    (get-blink-it blink)))


	(when (or (bus-link-have-it blink)
		  (not (bus-link-it-able-p blink))
		  (it-iob-p iob))

	  (let ((iob (output-queue-pop blink)))
	    (setf -iob iob -blink blink)

	    ;; 6/2002 twould seem the it should travel with the !req
	    (when (and t ;;(not (iasynch-command-iob-p iob))
		       (not (it-iob-p iob)) ;; shouldn't have it anyways.
		       (or t ;; 3/2004
			   (out-req-iob-p iob)
			   (out-rsp-iob-p iob)))
	      ;; ie, not losing it on broadcast or msg
	      (bus-link-lost-it blink))

	    (cond
	      ((broadcast-iob-p iob)

	       ;; PERF IO broadcasts.
	       ;; could check for action/undo and cancel.
	       ;; could combine action/commit to action w/auto-commit.
	       ;; cancel transaction begin/end if no intervening bcasts.

	       (let ((type (type-of-broadcast-iob iob))
		     (stamp (stamp-of-broadcast-iob iob))
		     (bts nil))

		 (push (instantiate-bound-term (term-of-iob iob)) bts)

		 ;;(setf -blink blink -iob iob) (break "bs")
		 (do ((next (output-queue-peek blink) (output-queue-peek blink)))
		     ((or (null next)
			  (not (broadcast-iob-p next))
			  (not (in-transaction-p stamp (stamp-of-broadcast-iob next)))
			  (not (eql type (type-of-broadcast-iob next)))
			  (only-transactions-delimiters-p blink)
			  ))
	   
		   (let* ((oterm (term-of-iob (output-queue-pop blink))))
		     ;;(setf -blink blink -iob iob -oterm oterm -bts bts) (break "bso")
		     (push (instantiate-bound-term oterm) bts)))

		   
		 (when bts
		   (link-send (link-of-bus-link blink)
			      (instantiate-term (ibroadcasts-op type)
						(cons (instantiate-bound-term (stamp-to-term stamp))
						      (nreverse bts))) ))))
	      ((out-req-iob-p iob)
	       (link-send (link-of-bus-link blink)
			  (new-ireq-term (sequence-of-iob iob)
					 (tid-of-req-iob iob)
					 (type-of-req-iob iob)
					 (find-address-parameters-of-bus-link blink (tags-of-req-iob iob) t)
					 (term-of-iob iob)))
	       ;;(format t "out-req:~s" (new-ireq-term (sequence-of-iob iob)
	       ;;(tid-of-req-iob iob)
	       ;;(type-of-req-iob iob)
	       ;;(find-address-parameters-of-bus-link blink (tags-of-req-iob iob))
	       ;;(term-of-iob iob)))
	       )

	      ((out-msg-iob-p iob)
	       ;; messages maybe suppressed at queue time.
	       ;;(break "omi")
	 
	       (let ((req-iob (request-of-out-iob iob))
		     (link (link-of-bus-link blink)))
		 (if (link-asynch-ok-p link)
		     (link-send link
				(imsg-term (sequence-of-iob req-iob)
					   (term-of-iob iob)))
		     (in-req-iob-add-message req-iob
					     (imsg-term (sequence-of-iob req-iob)
							(term-of-iob iob))))))

	      ((out-rsp-iob-p iob)
	       (let ((req-iob (request-of-out-iob iob)))
		 (link-send (link-of-bus-link blink)
			    (irsp-wmsg-term (sequence-of-iob req-iob)
					    (term-of-iob iob)
					    (messages-of-in-req-iob req-iob)))
		 ))
	
	      (t (setf -iob iob -blink blink) (break "bw")))
	    t))))))


(defun bus-post-write ()
  (bus-write))
  
	 

(defun permit-broadcast-p (term sentry &optional blink)
  ;;(setf -pbterm term -pbsentry sentry);; (break "pbp")
  (let ((tt (table-type-of-ipassport-term term)))
    (and (ipassport-term-p term)
	 (if (null sentry)
	     (and (eql tt 'orb)
		  blink
		  (some #'(lambda (le)
			    (member 'orb (address-of-environment le)))
			(imported-environments-of-bus-link blink))
		  )
	     
	     (let ((type-sentry (cdr (assoc tt sentry))))
	       ;;(setf a term b type-sentry) (break "pbp")
	       (and type-sentry
		    (let ((stamp (stamp-of-ipassport-term term)))
		      (exists-p #'(lambda (permit)
				    (and (or;;(ivoid-term-p stamp)
					  (compare-terms-p (car permit) stamp))
					 (or (member tt  *object-attr-table-types*) ; kludge alert.
					     (progn;;(setf a term b (cddr permit)) (break "pbp2")
					       (match-descriptions-p (description-of-ipassport-term term)
								     (cddr permit))))) )
				type-sentry))))))))

(defun bus-send (iob &optional (post-not nil))
  ;;(break "bs")
  ;; queue
  (prog1
      (cond
	((broadcast-iob-p iob)
	 ;; do links.
	 (dolist (blink *bus-links*)
	   ;;(setf a iob b (term-of-iob iob) c blink) (break "bsb")
	   (when (permit-broadcast-p (term-of-iob iob) (broadcast-sentry-of-bus-link blink) blink)
	     (output-queue-push blink iob))))

	((out-req-iob-p iob)
	 (let ((blink (if (callback-iob-p iob)
			  ;; what if blink has been killed?
			  (blink-of-callback-iob iob)
			  (bus-link-of-environment-address (tags-of-req-iob iob)))))

	   (unless blink
	     ;; remove pend now otherwise remains forever.
	     (bus-unpend iob)
	     (raise-error (error-message '(bus output environment unknown)
					 (tags-of-req-iob iob))))

	   ;;(format t "out-req ~a ~%" (it-iob-p iob))
	   (unless (it-iob-p iob)
	     (bus-link-not-idle blink))

	   (if (bus-link-alive-p blink)
	       (output-queue-push blink iob)
	       (progn (message-emit (warn-message '(bus-send alive not)))
		      (bus-unpend iob)))

	   blink))

	((or (out-rsp-iob-p iob)
	     (out-msg-iob-p iob))
	 (let ((req-iob (request-of-out-iob iob)))
	   (let ((blink (blink-of-in-req-iob req-iob)))
	     ;;(break "bus-send")
	     (if (bus-link-alive-p blink)
		 (output-queue-push blink iob)
		 (message-emit (warn-message '(bus-send alive not)))))))

	(t (break "???")))

    (unless post-not (bus-post-write))
    ))


(defun send-it (blink)
  (show-telemetry "send it")
  (bus-link-lost-it blink)
  (bus-send-asynch-command-iob
   (new-callback-iob (tid) blink (iasynch-command-term (iit-term t)))))

(defun read-term-to-iobs (term blink)
  ;;(setf -term term -blink blink)  (break "rtti")
  (cond
   ((null term) nil)
      
   ;;new
   ((ibroadcasts-term-p term)
    (when (bus-link-it-able-p blink)
      (send-it blink))    ;; 3/2004
    (mapcar #'(lambda (bt)
		(new-broadcast-iob (term-of-bound-term bt)
				   (type-of-ibroadcasts-term term)
				   (let ((s (stamp-of-ibroadcasts-term term)))
				     (unless (ivoid-term-p s)
				       (term-to-stamp s)))
				  blink
				  ))
	    (broadcasts-of-ibroadcasts-term term)))
    
   ((imsg-term-p term)
    (when (bus-link-it-able-p blink)
      (send-it blink))    ;; 3/2004
    (list (new-in-msg-iob (sequence-of-imsg-term term)
			  (message-of-imsg-term term))))

   ((irsp-term-p term)
    (bus-link-got-it blink)
    (nconc (mapcar #'(lambda (bt)
		       (let ((term (term-of-bound-term bt)))
			 (new-in-msg-iob  (sequence-of-imsg-term term)
					  (message-of-imsg-term term))))
		   (bound-messages-of-irsp-term term))
	   (list (new-in-rsp-iob (sequence-of-irsp-term term)
				 (result-of-irsp-term term)))))

   ;; if no type or address then take address of exported
   ;; if multiple exports then fail?
   ;; otherwise match type/address against exports

   ((ireq-aux-term-p term)
    (let ((e (expression-of-ireq-term term)))
      ;; asynch commands do not change it!.
      ;; 6/2002 twould seem the it should travel with the !req
      ;; 3/2004 not.
      (unless (and (iasynch-command-term-p e)
		   (let ((c (command-of-iasynch-command-term e)))
		     (or (iit-term-p c)
			 (inot-it-term-p c))))
	(bus-link-got-it blink))
      
      (mlet* (((tags message) (with-handle-error-and-message (nil #'(lambda (msg) 
								      (values nil
									      (message-to-term msg))))
				(map-tags-of-ireq-term term blink))))
	     (let ((iob (new-in-req-iob blink
			      (sequence-of-ireq-term term)
			      (tid-of-ireq-term term)
			      (car tags)
			      (cdr tags)
			      e)))
	       (when message
		 (in-req-iob-add-message iob message))
		     
	       ;;(setf a blink b term c (tid-of-ireq-term term)) (break "rti")
	       (list iob)))))


   ;; interrupt(ed)
   (t (raise-error (error-message '(read term to iob unexpected) term)))))


(defun bus-link-read (blink blockp)
  (when (and (peek-pending) (peek-req-iob-read (peek-pending)))
    ;;(break "blr")
    )
  
  (link-errors (link-of-bus-link blink))

  ;;(setf *process-break* t)
  (let ((term (with-handle-error
		  (('(bus link read))
		   (format t "A connected process terminated, closing link. ~%")
		   (kill-bus-link blink (itext-term "link error"))
		   nil)

		(or (input-queue-pop blink)
		    (link-recv (link-of-bus-link blink) blockp)))))

    ;; check for restrictions on allowable traffic on blink and kill link
    ;; if unacceptable input
    ;;  - could let environment-eval try to limit but more possibility
    ;;    of error, ie cut it short quick.
    
    (when (and term (bus-link-it-able-p blink))
      (show-telemetry "unblocked")
      ;;(setf -term term -blink blink) (break "bub")
      (setf (bus-link-block blink) nil))
    (setf term (check-blink-input-sentries blink term))
      
    ;;(when term (setf -term term ) (break "blr"))
    (if (and term (iconfig-req-term-p term))
	(progn
	  (config-blink-received-request blink term)
	  (when blockp
	    (bus-link-read blink blockp)))
	term)))



(defun config-unexport-environment (blink addr)
  (let ((envs (exported-environments-of-bus-link blink)))
    (if (environment-in-list-p addr envs)
	(setf (bus-link-exported-environments blink)
	      (remove-environment-from-list addr envs))
	(message-emit (warn-message '(orb configure unexport address not) addr)))))

(defun config-unimport-environment (blink addr)
  (let ((envs (imported-environments-of-bus-link blink)))
    (if (environment-in-list-p addr envs)
	(bus-link-delete-import-environment addr blink)
	(raise-error (error-message '(orb configure unimport address not) addr)))))


(defun config-export-environment (blink addr)
  (let ((envs (exported-environments-of-bus-link blink)))
    (if (environment-in-list-p addr envs)
	(message-emit (warn-message '(orb configure export address duplicate) addr))
	(push (new-link-environment addr)
	      (bus-link-exported-environments blink)))))

(defun config-import-environment (blink addr)
  (let ((envs (imported-environments-of-bus-link blink)))
    (if (find-environment-in-list addr envs)
	(message-emit (warn-message '(orb configure import address duplicate) addr))
	(bus-link-add-import-environment addr blink)))

  ;;(setf -blink blink -addr addr) (break "cie")
  )
	 

(define-primitive |!link_encoding| ((token . kind)))
(define-primitive |!link_describe_environment| () (address description))
(define-primitive |!link_environment_properties| () (address properties))
(define-primitive |!link_properties| () (properties))
(define-primitive |!connect_environments| () (source destination))

(defun config-request (blink cmd)
  (declare (ignore blink))

  (cond
    ((iinform-term-p cmd)
     (let ((info (info-of-iinform-term cmd)))
       (cond
	 ((ienvironment-address-term-p info)
	  (let* ((tags (tags-of-ienvironment-address-term info)))
	    (let ((eaddr (if tags
			     (let ((env (match-environment-in-list tags *component*)))
			       (when env (address-of-environment env)))
			     (orb-address))))
	      (if eaddr
		  (iinform-term (ienvironment-address-term eaddr))
		  (raise-error (error-message '(orb configure request inform environment-address not)
					      info))))))

	 ((ilink-describe-environment-term-p info)
	  (let ((eaddr (tokens-of-itokens-term (address-of-ilink-describe-environment-term info))))
	    (let ((env (find-environment eaddr)))
	      (if env
		  (iinform-term (ilink-describe-environment-term (address-of-ilink-describe-environment-term info)
								 (description-to-term (description-of-environment env))))
		  (raise-error (error-message '(orb configure request inform description not)
					      info))))))

	 (t (raise-error (error-message '(orb configure request inform unknown) info))))))

    ;; revoke
    ((irevoke-term-p cmd)
     (let ((info (info-of-irevoke-term cmd)))
       (cond
	 ((ienvironment-address-term-p info)
	  (let* ((tags (tags-of-ienvironment-address-term info)))
	    (let ((eaddr (if tags
			     (let ((env (match-environment-in-list tags *component*)))
			       (when env (address-of-environment env)))
			     (orb-address))))
	      (if eaddr
		  (irevoke-term (ienvironment-address-term eaddr))
		  (raise-error (error-message '(orb configure request revoke environment-address not)
					      info))))))

	 ((ilink-describe-environment-term-p info)
	  (let ((eaddr (tokens-of-itokens-term (address-of-ilink-describe-environment-term info))))
	    (let ((env (find-environment eaddr)))
	      (if env
		  (irevoke-term (ilink-describe-environment-term (address-of-ilink-describe-environment-term info)
								 (description-to-term (description-of-environment env))))
		  (raise-error (error-message '(orb configure request revoke description not)
					      info))))))
	  
	 (t (raise-error (error-message '(orb configure request revoke unknown) info))))))

    (t (raise-error (error-message '(orb configure request unknown) cmd)))))


(defun config-inform-environment-connection (local remote blink source info)
  (let ((econn (new-environment-connection local remote blink)))

    ;; verify local exists
    (unless (component-environment-p local)
      (raise-error
       (error-message '(config inform connect-environments local not) source info)))

    ;; verify remote imported
    (unless (find-environment-in-list remote (imported-environments-of-bus-link blink))
      (raise-error
       (error-message '(config inform connect-environments remote not) source info)))

    ;; verify unique connection.
    (when (exists-p #'(lambda (blink)
			(find-environment-connection blink local remote))
		    *bus-links*)
      (raise-error
       (error-message '(config inform connect-environments unique not) source info)))
		    
    #'(lambda () (add-environment-connection blink econn))))

(defun config-revoke-environment-connection (local remote blink source info)
  (let ((econn (find-environment-connection blink local remote)))

    (when (null econn)
      (raise-error
       (error-message '(config revoke connect-environments not) source info)))
		    
    #'(lambda () (delete-environment-connection blink econn))))

;; : (tok{ack{t}|info|fail{nil}} # (effector{unit->unit) | failure{term list})
(defun config-inform (inform blink source)
  (let ((info (info-of-iinform-term inform)))

    (cond
      ((ilink-encoding-term-p info)
       (let ((nlink (convert-link-encoding (link-of-bus-link blink)
					   (kind-of-ilink-encoding-term info))))
	 #'(lambda () (set-blink-link blink nlink))))

      ((idisconnect-term-p info)
       (let ((w (why-of-idisconnect-term info)))
	 (unless (ivoid-term-p w)
	   (message-emit (warn-message '(disconnect) w)))
	 #'(lambda () (kill-bus-link blink w))))

      ;; need to know of info local or remote to decide between import/export,
      ((ienvironment-address-term-p info)
       (let ((tags (tags-of-ienvironment-address-term info)))
	 ;;(setf -tags tags -info info -source source -blink blink) (break "ci")
	 (if (eql source 'local)

	     (if (environment-in-list-p tags (exported-environments-of-bus-link blink))
		 ;; error if already exported
		 (raise-error (error-message '(orb configure export address already) tags))
		 ;; error if not local env
		 ;; someday maybe ok if imported on some other link. Ie we're just routing.
		 (if (not (component-environment-p tags))
		     (raise-error (error-message '(orb configure export address not) tags))
		     #'(lambda ()
			 (config-export-environment blink tags))))

	     (if (environment-in-list-p tags (imported-environments-of-bus-link blink))
		 ;; error if already imported
		 (raise-error (error-message '(orb configure imxport address already) tags))
		 #'(lambda () (config-import-environment blink tags))))))

      ((ilink-describe-environment-term-p info)
       (cond
	 ((eql source 'local) #'(lambda () nil)) ;; no-op
	 ((eql source 'remote)
	  (let ((benv (find-environment-in-list (tokens-of-itokens-term
						 (address-of-ilink-describe-environment-term info))
						(imported-environments-of-bus-link blink))))
	    (unless benv
	      (raise-error (error-message '(orb configure describe environment not) info)))
	    (when (description-of-environment benv)
	      (raise-error (error-message '(orb configure describe already) info)))
	    (let ((desc (term-to-description (description-of-ilink-describe-environment-term info))))
	      ;;(setf -env benv -desc desc) (break "fu")
	      #'(lambda () ;;(break "bar") (setf -desc desc) (break "bar1") (setf -env benv) (break "bar2")
		  (setf (environment-description benv) desc)))))
	 (t (raise-error (error-message '(config inform describe source) source info)))))


      ((ilink-environment-properties-term-p info)
       (cond
	 ;; expecting to be used for partner to manipulate link environment properties
	 ((eql source 'local) #'(lambda () nil)) ;; no-op
	 ((eql source 'remote)
	  (let ((benv (find-environment-in-list (tokens-of-itokens-term
						 (address-of-ilink-environment-properties-term info))
						(imported-environments-of-bus-link blink))))
	    (let ((props (term-to-properties
			  (properties-of-ilink-environment-properties-term info))))
	      #'(lambda ()
		  (modify-environment-properties
		   #'(lambda (eprops)
		       (append
			;; !void() == delete
			(filter #'(lambda (p)
				    (not (ivoid-term-p (cdr p))))
				props)
			(filter #'(lambda (p)
				    (not (member (car p) props :key #'car)))
				eprops)))
		   benv)))))
	 (t (raise-error (error-message '(config inform env-properties source) source info)))))

      ((ilink-properties-term-p info)
       (cond
	 ;; expecting to be used for partner to manipulate link environment properties
	 ((eql source 'local)
	  ;; implicitly expect partner to be it-able as
	  ;; must be native process. How will this apply to
	  ;; other properties.
	  (let ((props (term-to-properties
			(properties-of-ilink-properties-term info))))
	    #'(lambda () (blink-modify-properties blink props))))
	 ((eql source 'remote)
	  (let ((props (term-to-properties
			(properties-of-ilink-properties-term info))))
	    #'(lambda ()
		(blink-modify-properties blink props))))
	 (t (raise-error (error-message '(config inform properties source) source info)))))

      
      ((iconnect-environments-term-p info)
       (cond
	 ((eql source 'local)
	  (let ((local (tags-of-ienvironment-address-term
			(source-of-iconnect-environments-term info)))
		(remote (tags-of-ienvironment-address-term
			 (destination-of-iconnect-environments-term info))))
	    (config-inform-environment-connection local remote blink source info)))
	 
	 ((eql source 'remote)
	  (let ((local (tags-of-ienvironment-address-term
			(destination-of-iconnect-environments-term info)))
		(remote (tags-of-ienvironment-address-term
			 (source-of-iconnect-environments-term info))))
	    (config-inform-environment-connection local remote blink source info)))
		
	 (t (raise-error (error-message '(config inform connect-environments source) source info))))
       )

      (t (raise-error (error-message '(config inform unknown) info))))))


(defun config-revoke (revoke blink source)
  (let ((info (info-of-irevoke-term revoke)))

    (cond
      ((ienvironment-address-term-p info)
       (let ((tags (tags-of-ienvironment-address-term info)))
	 (if (eql source 'local)

	     (if (not (environment-in-list-p tags (exported-environments-of-bus-link blink)))
		 ;; error if not exported?
		 (raise-error (error-message '(orb configure unexport address not) tags))
		 #'(lambda () (config-unexport-environment blink tags)))
		
	     (if (not (environment-in-list-p tags (imported-environments-of-bus-link blink)))
		 ;; error if not imported.
		 (raise-error (error-message '(orb configure unimport address not) tags))
		 #'(lambda ()
		     (config-unimport-environment blink tags))))))

      ((ilink-describe-environment-term-p info)
       (cond
	 ((eql source 'local) #'(lambda () nil))
	 ((eql source 'remote)
	  (let ((lenv (find-environment-in-list (tokens-of-itokens-term (address-of-ilink-describe-environment-term info))
						(imported-environments-of-bus-link blink))))
	    (unless (and lenv
			 (compare-terms-p (description-to-term (description-of-environment lenv))
					  (description-of-ilink-describe-environment-term info)))
	      (raise-error (error-message '(orb configure describe not) info)))
	    #'(lambda () (setf (environment-description lenv) nil))))
	 (t (raise-error (error-message '(config inform describe source) source info)))))

      ((iconnect-environments-term-p info)
       (cond
	 ((eql source 'local)
	  (let ((local (tags-of-ienvironment-address-term
			(source-of-iconnect-environments-term info)))
		(remote (tags-of-ienvironment-address-term
			 (destination-of-iconnect-environments-term info))))
	    (config-revoke-environment-connection local remote blink source info)))
	 
	 ((eql source 'remote)
	  (let ((local (tags-of-ienvironment-address-term
			(destination-of-iconnect-environments-term info)))
		(remote (tags-of-ienvironment-address-term
			 (source-of-iconnect-environments-term info))))
	    (config-revoke-environment-connection local remote blink source info)))
		
	 (t (raise-error (error-message '(config revoke connect-environments source) source info))))
       )

      (t (raise-error (error-message '(config revoke unknown) info))))))


(defun blink-send-config-response (blink seq h-rsp)
  (advance-sequence)
  (link-send (link-of-bus-link blink)
	     (irsp-term seq (cdr h-rsp)))
  (when (car h-rsp)
    (funcall (car h-rsp))))

;;
;; unexpected link error
;;  - kill and let partner clean up from dead link
;;      + possible that partner has already closed link and that is source of local problem.
;;	+ must be some system error which failing is unlikely to help.
;;  | send link-error message but leave link up.
;;      + may be able to continue.
;;
;; fttb : kill - later if we identify specifics
;;  where cleanup may have workded better than do that ad-hoc.

;; unexpected link loss.
;; makes no attempt to communicate to link partner.
(defun kill-bus-link (blink why)

  ;;(setf -blink blink -why why) (break "kbl")
  (let ((preqs (mapcan #'(lambda (x) (when x (list x)))
		       (pending-out-reqs-of-blink blink))))
			

    ;; should be a send-request that we return to that will find this.
    (dolist (iob preqs)
      (let ((rsp-iob (new-in-rsp-iob (sequence-of-iob iob)
				     (ifail-term (message-to-term
						  (error-message '(link killed) why))))))
	(update-req-iob-read iob rsp-iob)))

    (bus-link-close blink)
    ))

(defun why-of-idisconnect-term (dcterm)
  (let ((bt (car (bound-terms-of-term dcterm))))
    (if bt
	(term-of-bound-term bt)
	(ivoid-term))))

(defun blink-send-config-request (blink config)
  (advance-sequence)
  (let ((seq (current-sequence)))
    (link-send (link-of-bus-link blink)
	       (new-ireq-term seq nil 'config nil config))

    (do ((r (link-recv (link-of-bus-link blink) t)
	    (link-recv (link-of-bus-link blink) t)))

	((and (irsp-term-p r)
	      (eql seq (sequence-of-irsp-term r)))
	 (result-of-irsp-term r))

      (if (iconfig-req-term-p r)

	  ;; possible that each simultaneously sent config req. (not if !it is used?)
	  ;;  unlikely in any event.
	  ;; but can't fail disconnect!
	  (blink-send-config-response
	   blink
	   (sequence-of-ireq-term r)
	   (cons nil
		 (ifail-term
		  (message-to-term (error-message '(config recursive) (command-of-iconfigure-term
								       (expression-of-ireq-term r)))))))

	  ;; if not rsp then push on blink in queue.
	  (if (idisconnect-term-p (expression-of-ireq-term r))
	      (progn
		;; kill link
		;; raise-error with why-of-idisconnect-term
		(kill-bus-link blink (why-of-idisconnect-term (expression-of-ireq-term r)))
		(break "disconnect"))

	      (input-queue-push blink r))))))
      
(defun config-blink-received-request (blink req)
  (labels ((doit (cmd source)
	     (cond
	       ((iinform-term-p cmd)
		(config-inform cmd blink source))

	       ((irevoke-term-p cmd)
		(config-revoke cmd blink source))

	       ((irequest-term-p cmd)
		(when (irequest-term-p cmd)
		  (raise-error (error-message '(config request recursion) req cmd))))

	       (t (raise-error (error-message '(config request unknown) cmd))))))

    (let ((cmd (command-of-iconfigure-term (expression-of-ireq-term req))))
      (blink-send-config-response
       blink
       (sequence-of-ireq-term req)
       (with-handle-error-and-message
	   (()
	    #'(lambda (msg)
		(cons nil 
		      (apply #'ifail-term 
			     (cons (message-to-term
				    (tag-message '(config request) msg))
				   (mapcar #'message-to-term (messages-flush)))))))

	 (if (irequest-term-p cmd)
	     (let ((ncmd (config-request blink (command-of-irequest-term cmd))))
	       (cons (doit ncmd 'local) (iconfigure-term ncmd)))
	     (cons (doit cmd 'remote) (iack-term)))
	 )))))

(defun iconfig-req-term-p (term)
  (and (ireq-aux-term-p term)
       (eql 'config (car (tags-of-ireq-term term)))
       (iconfigure-term-p (expression-of-ireq-term term))))


;; send !inform|!revoke
;; f is config-inform or config-revoke
(defun config-blink-cmd-aux (f blink cmd tag)
  (let* ((hook (funcall f cmd blink 'local)))

    (let ((rr (blink-send-config-request blink (iconfigure-term cmd))))
      (cond
	((iack-term-p rr)
	 (funcall hook))

	((ifail-term-p rr)
	 (raise-error (error-message (list 'config tag 'remote) (cons cmd rr))))

	;; unexpected result, can not predict state of partner thus kill link.
	(t (let ((m (error-message (list 'config tag 'remote 'result) (cons cmd rr))))
	     (kill-bus-link blink (message-to-term m))
	     (raise-error m)))))))

(defun config-blink-inform-aux (blink info tag)
  (config-blink-cmd-aux #'config-inform blink (iinform-term info) tag))

(defun config-blink-revoke-aux (blink info tag)
  (config-blink-cmd-aux #'config-revoke	blink (irevoke-term info) tag))



(defun config-mathbus-blink (blink)
  (config-blink-inform-aux blink (ilink-encoding-term 'mathbus) 'mathbus))

(defun config-compressed-blink (blink)
  (config-blink-inform-aux blink (ilink-encoding-term 'ascii-compressed) 'compressed))

(defun config-uncompressed-blink (blink)
  (config-blink-inform-aux blink (ilink-encoding-term 'ascii-uncompressed) 'uncompressed))

(defun config-export-address (blink eaddr)
  (config-blink-inform-aux blink (ienvironment-address-term eaddr) 'export-address))

(defun config-unexport-address (blink eaddr)
  (config-blink-revoke-aux blink (ienvironment-address-term eaddr) 'export-address))


(defun config-export-description (blink eaddr)
  (let ((env (find-environment eaddr)))
    (config-blink-inform-aux blink
			     (ilink-describe-environment-term
			      (itokens-term (address-of-environment env))
			      (description-to-term (description-of-environment env)))
			     'export-description)))

(defun config-unexport-description (blink eaddr)
  (let ((env (find-environment eaddr)))
    (config-blink-inform-aux blink
			     (ilink-describe-environment-term
			      (itokens-term (address-of-environment env))
			      (description-to-term (description-of-environment env)))
			     'export-description)))

(defun config-connect-environments (blink laddr raddr)
  (config-blink-inform-aux blink
			   (iconnect-environments-term
			    (itokens-term laddr)
			    (itokens-term raddr))
			   'CONNECT-ENVIRONMENTS))

(defun config-unconnect-environments (blink laddr raddr)
  (config-blink-revoke-aux blink
			   (iconnect-environments-term
			    (itokens-term laddr)
			    (itokens-term raddr))
			   'UNCONNECT-ENVIRONMENTS))


;; send !configure(!request(<info>))
;;  ... think now should be !configure(!request([!inform|!revoke](<info>)))
(defun config-blink-req-aux (blink info tag)
  (when (null blink)
    (raise-error (error-message '(config req link not) info tag)))
  (let ((r (blink-send-config-request blink
				      (iconfigure-term
				       (irequest-term info)))))

      ;; if unexpected failure should we take out link? yes send !disconnect(<why>)
      ;; seems the proper thing to do,  otherwise will just have messed up link.
    
      ;; two phase config : 
      ;;  ie req replies with !req !configure !inform instead of !rsp !configure !inform
      ;;  then if no fail on second req then first req can not fail (but can take out link).

    
      ;; kill instead of error since we can't know state of partner.
      (let* ((rr (cond
		 ((iack-term-p r)
		  ;; a little severe, but someone obviously is messed up.
		  (cons nil
			(error-message '(config request rsp ack) info)))
       
		 ;; fail ok here as we know partner failed too.
		 ((ifail-term-p r)
		  (raise-error (error-message (list 'config tag 'request 'rsp) info r)))

		 ((iconfigure-term-p r)
		  (with-handle-error-and-message
		      (()
		       #'(lambda (msg)
			   (cons nil msg)))


		    (let ((cmd (command-of-iconfigure-term r)))
		      (cond
			((iinform-term-p cmd)
			 (let ((h (config-inform cmd blink 'remote)))
			   (funcall h)
			   (cons t (info-of-iinform-term cmd))))
			((irevoke-term-p cmd)
			 (let ((h (config-revoke cmd blink 'remote)))
			   (funcall h)
			   (cons t (info-of-irevoke-term cmd))))
			(t (cons nil
				 (error-message (list 'config tag 'request 'rsp 'command) info cmd)))))))

		 (t
		  ;; a little severe, but someone obviously is messed up.
		  (cons nil (error-message '(config request rsp unknown) info)))))
	     (bit (car rr)))

	
	(if bit
	    (cdr rr)
	    (let ((msg (cdr rr)))
	      (kill-bus-link blink (message-to-term msg))
	      (raise-error msg))))))



(defun config-request-address (blink eaddr)
  (let ((info (config-blink-req-aux blink
				    (iinform-term (ienvironment-address-term eaddr))
				    'request-address)))
    (tags-of-ienvironment-address-term info)))

(defun config-request-address-revoke (blink eaddr)
  (let ((info (config-blink-req-aux blink
				    (irevoke-term (ienvironment-address-term eaddr))
				    'request-address)))
    (tags-of-ienvironment-address-term info)))



(defun config-request-environment-description (blink eaddr)
  (let ((info (config-blink-req-aux blink
				    (iinform-term
				     (ilink-describe-environment-term (itokens-term eaddr)
								      (ivoid-term)))
				    'request-description)))
    (description-of-ilink-describe-environment-term info)))

(defun config-unrequest-environment-description (blink eaddr)
  (let ((info (config-blink-req-aux blink
				    (irevoke-term
				      (ilink-describe-environment-term (itokens-term eaddr)
								       (ivoid-term)))
				    'request-address)))
    (description-of-ilink-describe-environment-term info)))


(defvar *bus-poll-max-sleep-quantum* 1.0)
(defvar *bus-poll-min-sleep-quantum* (/ *bus-poll-max-sleep-quantum* 256)) ; ~ 4 MS
(defvar *bus-poll-sleep-quantum* *bus-poll-max-sleep-quantum*)
(defvar *bus-poll-inactive-count* 0)

(defun never (&rest r)
  (declare (ignore r))
  nil)

(defvar *sleeper* nil)

(defun set-orb-sleeper (s) (setf *sleeper* s))

(defun sleep-aux (q)
  #+ALLEGRO(mp:process-wait-with-timeout "system-sleep" q #'never)
  #-ALLEGRO(sleep q)
  )

(defun system-sleep (quantum)
  ;;(format t "ZZ~aZZ" quantum)
  (if *sleeper*
      (funcall *sleeper* quantum)
    (sleep-aux quantum)
  ))

(defvar *idle-p* nil)

(defvar *nightly-hooks*
  (list (cons 'activity-log #'update-process-activity-log)))

;; update with null hook to remove.
(defun update-nightly-hooks (name hook)
  (setf *nightly-hooks*
	(cons (cons name hook)
	      (remove name *nightly-hooks* :key #'car))))

(defun nightly-call-hooks (note ctime)
  (dolist (h *nightly-hooks*)
    (let ((hh (cdr h)))
      (when hh (funcall hh note ctime)))))
    

;;; broadcast  !passport(???<orbunconditional>; !flow-control(<orb-addr>; !idle{t:b}))
(define-primitive |!idle| ())

(defun bus-sleep ()

  (when (and (not *idle-p*)
	     (onep (length *bus-pend*))
	     (null *transactions-active*)

	     ;; no pending asynchs.
	     (let ((a (find-asynch-link t)))
	       (or (null a)
		   (forall-p #'(lambda (ch)
				(null (asynch-channel-pend-queue ch)))
			    (channels-of-link (link-of-bus-link a)))))
	     )
    (setf *idle-p* t)
    ;;(break "bs")
    (unless (eql `|lib| *component-kind*)
      (bus-broadcast 'flow-control
		     (orb-passport-term (stamp-term-of-environment (find-environment (orb-address))) (iidle-term))
		     nil))
    (show-telemetry "idle"))

  ;;(format t "~a ~a~%" *bus-poll-sleep-quantum* *bus-poll-inactive-count*)

  (incf *bus-poll-inactive-count*)

  (when (> *bus-poll-inactive-count* 2048)

    (when nil (format t "~%Increasing sleep quantum, new: ~a, period of inactivity: ~a.~%"
		      (* 2 *bus-poll-sleep-quantum*)
		      (* *bus-poll-inactive-count* *bus-poll-sleep-quantum*)))
    ;;(format t "~%eh! ~a ~%" *bus-poll-inactive-count*)

    (setf  *bus-poll-inactive-count* 0)

    ;;(unless (=  *bus-poll-max-sleep-quantum* *bus-poll-sleep-quantum*)
    ;;(format t "~%incrementing sleep quantum ~a " *bus-poll-sleep-quantum*))
    (setf *bus-poll-sleep-quantum*
	  (min *bus-poll-max-sleep-quantum* (* *bus-poll-sleep-quantum* 2)))
    (nightly-gc nil #'nightly-call-hooks)
    )
      
  ;;(when (= *bus-poll-sleep-quantum* *bus-poll-max-sleep-quantum*) (format t "z"))
  ;;(sleep 1)
  
  ;;(break "bss")
  (system-sleep *bus-poll-sleep-quantum*)
  )

(defun bus-active ()
  ;;(break "ba")
  (when nil
    (format t "~%Inactive for ~a sleep quantums, quantum: ~a, elapsed time: ~a. ~%"
	    *bus-poll-inactive-count*
	    *bus-poll-sleep-quantum*
	    (* *bus-poll-inactive-count* *bus-poll-sleep-quantum*)))

  ;;(let ((cur-quantum *bus-poll-sleep-quantum*))

  (if (= *bus-poll-inactive-count* 0)
      (setf *bus-poll-sleep-quantum*
	    (max *bus-poll-min-sleep-quantum* (/ *bus-poll-sleep-quantum* 32)))
      (setf *bus-poll-sleep-quantum*
	    (max *bus-poll-min-sleep-quantum* (/ *bus-poll-sleep-quantum* 16))))

  ;;(when (not (= cur-quantum *bus-poll-sleep-quantum*)) (format t "~%eh! ~a ~%" *bus-poll-sleep-quantum*))
  ;;(format t "bpic ~a ~a ~%" *bus-poll-sleep-quantum* *bus-poll-min-sleep-quantum*)

  (setf  *bus-poll-inactive-count* 0)
  
  ;;(< *bus-poll-inactive-count* 16)
  ;;)
  )
  
(defvar *inqueue* nil)





;; handles broadcast locally.
;; when sending remote request only check blink of  request to preclude
;; some other link being posted and being read out of order.

(defun accept-blink-p (blink)
  (accept-channel-p (car (channels-of-link (link-of-bus-link blink)))))

(defun bus-read-any (blink &optional (blockp t))

  ;;(format t "bra ~a ~a~%" (when blink t) blockp)
  ;;(break "bra")

  ;;  3/2004 first write- maybe caller should be doing this ?
  (do ((b (bus-write) (bus-write)))
      ((not b)))
  
  (do ()
      (nil)

    (if *inqueue*
	(let ((iob (pop *inqueue*)))
	  ;; transaction end broadcast can perform a request which
	  ;; indirectly reads and queues on approprate req-iob a rsp.
	  ;; thus return after broadcast if rsp for top of pending
	  ;; is present.
	  (if (broadcast-iob-p iob)
	      (progn
		;;(setf -biob iob)
		(orb-broadcast (type-of-broadcast-iob iob) ;; LAL protect this?
			       (term-of-iob iob)
			       (stamp-of-broadcast-iob iob)
			       t
			       (blink-of-broadcast-iob iob))
		(when (let ((piob (peek-pending))) (and piob (peek-req-iob-read piob)))
		  ;;(break "bra ?")
		  (return-from bus-read-any nil)))
		
	      (return-from bus-read-any iob)))
	
	(cond
	  (blink
	   (with-unwind-error
	       ( ;;(break "bra e")
		;;(configure-send-state-blink blink (iinform-term (inoack-term)))
		(kill-bus-link blink (message-to-term (error-message '(read error 1))))
		)
	     ;;(setf b blink) (break)
				   
	     (setf *inqueue*

		   (read-term-to-iobs
		    (bus-link-read blink
				   (not (accept-channel-p
					 (let ((l (link-of-bus-link blink)))
					   (let ((chs (when l (channels-of-link l))))
					     (when (null chs)
					       (raise-error (error-message '(bus-read-any link channels none))))
					     (car chs))))))
		    blink))))	     

	  ((or (> (length *bus-links*) 1)
	       (and *bus-links* (accept-blink-p (car *bus-links*)))
	       (and *bus-links* (asynch-blink-p (car *bus-links*))))
	  
	   (setf *inqueue*
		 (mapcan #'(lambda (blink)
			     (with-handle-error (('(bus read any))
						 ;;(break "bra e")
						 ;; ;; if errors on read, don't want other side stuck waiting for response
						 ;; (configure-send-state-blink blink (iinform-term (inoack-term)))
						 ;; if errors on read, bail
						 (kill-bus-link blink (message-to-term (error-message '(read error non-conforming term ))))
						 nil
						 )
			       (let ((term (bus-link-read blink nil)))
				 (when (and term) ;; (not (inoack-term-p term))
				   (read-term-to-iobs term blink)))))
			 *bus-links*))

	   (cond
	     ((and (null blockp) (null *inqueue*))
	      (return-from bus-read-any nil))
	     ((null *inqueue*)
	      ;;flush-writes
	      (bus-post-write)
	      (bus-sleep))
	     (t (bus-active))))

	  ;; single link
	  (*bus-links*
	   (let ((blink (car *bus-links*)))
	     ;; todo : toploop needs to handle noack.
	     (with-unwind-error ( ;;(configure-send-state-blink blink (iinform-term (inoack-term)))
				 (kill-bus-link blink (message-to-term (error-message '(read error 3))))
				 )
	       ;;(setf b blink) (break)
	       (setf *inqueue*
		     (read-term-to-iobs
		      (bus-link-read blink
				     (not (accept-channel-p
					   (car (channels-of-link
						 (link-of-bus-link blink))))))
		      blink)))))

	  (t (raise-error (error-message '(bus read any links none))))))))
       

;; Not MTT : should only be single req pending (except if top is req-it.
;;  Error if more than one or if iob comes in for other.
;;  If iob comes in for iob not on top of pend stack then update iob, but wait again.
;;  If bus-wait called but iob already updated then return immediately.
;; ie bus-wait waits until first iob on bus stack is updated.
(defun bus-wait (&optional blink (blockp t))
  (let ((piob (peek-pending)))

    ;;(setf a piob b (peek-req-iob-read piob)) ;(break "bw2")

    (prog ()

     wait

     (mapc #'print-message (messages-flush))

     (if (peek-req-iob-read piob)
	 (progn
	   (when (and (req-iob-p piob)
		      (not (callback-iob-p piob))
		      (not (bus-environment-p (tags-of-req-iob piob))))
	     (setf -piob piob) (break "bw rr")
	     (format t "Removing request for ~a ~%   from bus queue as there is no corresponding link"
		     (tags-of-req-iob piob))
	     (setf *bus-pend*
		   (remove piob *bus-pend*)))
	   (return-from bus-wait))
	 (let ((iob (bus-read-any blink blockp)))

	   ;;(setf -iob iob) (break "hello")

	   ;; expect msg,rsp, or req
	   (cond
	     ((or (in-msg-iob-p iob)
		  (in-rsp-iob-p iob))

	      (let ((req-iob (find-pending-remote (sequence-of-iob iob))))
		(unless req-iob
		  (bus-unpend iob)
		  (raise-error (error-message '(bus wait pending none))))
	       
		(update-req-iob-read req-iob iob)))

	     ((in-req-iob-p iob)
	      (let ((req-iob (find-pending-remote nil
						  (tid-of-req-iob iob))))

		;;(setf -iob iob) (break "hello2")
		(if (or (null req-iob) (null (tid-of-req-iob req-iob)))
		    (cond
		      ((and *other-broadcasts-stamp* (not (it-iob-p iob)))
		       ;;fail if not asynch (it) ?? 
		       ;;(setf -req-iob req-iob -iob -iob);; (break "fail")
		       (bus-send
			(new-out-rsp-iob iob
					 (irsp-term (sequence-of-iob iob)
						    (ifail-term (message-to-term
								 (error-message '(startup precludes requests)))))  )))

		      ((and (null (tags-of-req-iob iob)) ;; ie orb command
			    (not (iasynch-command-iob-p iob))
			    (not (it-iob-p iob))
			    ;;(not (idisconnect-term-p (term-of-iob iob)))
			    )
		       (setf -iob iob
			     -b (and (null (tags-of-req-iob iob))
				     (not (iasynch-command-iob-p iob))
				     (not (it-iob-p iob))))
		       ;;(break "hello")
		       (bus-send
			(new-out-rsp-iob iob
					 (irsp-term (sequence-of-iob iob)
						    (ifail-term (message-to-term
								 (error-message '(environment address not)))))
					 )))
			
		      (t (bus-local-eval iob)))

		    (update-req-iob-read req-iob iob))))

	     ((null iob))

	     (t					
	      ;;(configure-send-state-blink (blink-of-in-req-iob iob) (iinform-term (inoack-term)))
	      (kill-bus-link blink
			     (message-to-term (error-message '(bus wait iob unexpected))))
	      ))

	   (when (and blockp (let ((piob (peek-pending))) (and piob (null (peek-req-iob-read piob)))))
	     ;;(setf a piob) (break "bw")
	     (go wait)
	     ;;(bus-wait)
	     )
	   )))))





;;;;
;;;;	orb-bus
;;;;

;;; new-iob, send(iob), msg-loop: wait(iob)

(defun interpret-result (rsp &optional value-msg-p)
  ;;(setf a rsp) (break "ir")
  (cond
    ((ifail-term-p rsp)
     (ifail-term-fail rsp))
    ((iprint-term-p rsp)
     (let ((msgs (messages-of-iresult-term rsp)))
       (when msgs
	 (message-emit (degenerate-term-message msgs))))
       (message-emit (degenerate-term-message (msg-of-iprint-term rsp)))
       nil)
    ((ivalue-term-p rsp)
       (let ((msgs (messages-of-iresult-term rsp)))
	 (when (or msgs value-msg-p)
	   (message-emit
	    (degenerate-term-message (if value-msg-p
					 (cons (result-of-iresult-term rsp) msgs)
					 msgs)))))
       (result-of-iresult-term rsp))
    ((iack-term-p rsp)
     nil)
    (t (system-error (error-message '(eval interpret result) rsp)))))


;;;	broadcasts and requests only are sent. rsp/msg etc take another path.
;;;	??? start stop.


(defun send-request (iob)
  (bus-pend iob)
  (let ((blink (bus-send iob)))
    (do ((rsp nil))
	(rsp  (progn ;; (format t " response:~s ~%" rsp)
		rsp))
      (if (eql `|lib| *component-kind*)
	  (bus-wait nil t) ; let lib server other requests while waiting for rsp.
	  (bus-wait blink))
      (let ((riob (pop-req-iob-read iob)))
	(unless riob
	  (bus-unpend iob)
	  (setf -riob riob -iob iob) (break "srrn")
	  (system-error (error-message '(send request result not))))
	(cond
	  ((in-req-iob-p riob)
	   ;; if callback may not have env tags. if not then should eval in current env.
	   ;; how to tell if meant for env. FTTB just assume as we do for rsp.
	   ;; proper would be to suspend evals at out and then lookup suspended.
	   ;; this we do in rsp case by matching sequences. Here we could do by
	   ;; matching tids or iobs? we've already done that we are here because of a tid match.
	   ;; just need to relate to env.
	   ;; It is possible for code at random times to
	   ;; make a request which could queue the requeset and then suspend itself with a closure
	   ;; for rsp and or callbacks. maybe rsp closure but reuse transaction-state for req, but
	   ;; then state needs env-addr for anonymous callback.
	   (bus-local-eval riob))
	  ((in-msg-iob-p riob)
	   (message-emit (degenerate-term-message (term-of-iob riob))))
	  ((in-rsp-iob-p riob)
	   (bus-unpend iob)
	   (setf rsp riob)) 
	  (t
	   (bus-unpend iob)
	   (system-error (error-message '(request send result unexpected)))))))))

(defun bus-eval-callback-aux (tid blink term)
  (let ((iob (new-callback-iob tid blink term)))

    (with-unwind-error ((bus-unpend iob))
      (let ((rsp (send-request iob)))
	(when rsp (result-of-in-rsp-iob rsp))))))

(defun bus-eval-callback (term)
  (bus-eval-callback-aux  (tid) (tid-blink) term))


(defun bus-eval (type tags term)
  ;;(setf -term term -tags tags) (break "bus-eval")
  (let ((rsp (send-request (new-out-req-iob type tags term))))
    ;;(setf -rsp rsp)
    (when rsp (result-of-in-rsp-iob rsp))))


(defun receive-request (&optional (blockp t))

  ;; push pending which matches null secondary sequence.

  ;; Not MTT queue requests until active request completes.
  ;; but why? should process request.

  ;; assume receive-req iob is pending.
  ;; tid nil seq nil so matches any req
  (let ((req-iob (find-pending-remote nil nil)))
    (unless req-iob
      (setf req-iob (new-receive-req-iob))
      (bus-pend req-iob))
    
    (or (pop-req-iob-read req-iob)
	(progn
	  (bus-wait nil blockp)
	  (pop-req-iob-read req-iob)))))


;; vestigial
(defun orb-wait-request ()
  (let ((req-iob (find-pending-remote nil nil)))
    (unless req-iob
      (setf req-iob (new-receive-req-iob))
      (bus-pend req-iob))
    (bus-wait)))
    
   
(define-primitive |!noop|)


;;;;	link should have a message sentry.
;;;;	
;;;;	FTTB, have single message filter for all links.
;;;;	
;;;;	

(defvar *bus-message-filter* nil)

(defun push-bus-message-filter (f)
  (setf *bus-message-filter*
	(message-filter-or f *bus-message-filter*)))

(defun iasynch-command-iob-p (iob)
  (iasynch-command-term-p (term-of-iob iob)))

(defun bus-send-asynch-command-iob (iob)
  (bus-send iob nil)
  )

(defun bus-asynch-command-eval (iob)
  (let ((term (term-of-iob iob)))
    (let ((c (command-of-iasynch-command-term term)))
      (if (or (iit-term-p c)
	      (inot-it-term-p c))
	  (let ((blink (blink-of-in-req-iob iob)))

	    ;;(setf -blink blink -c c -iob iob) (break "bace")
	    (cond

	      ;; not it
	      ((inot-it-term-p c)
	       (show-telemetry "recvd not-it")
	       (when (and (primary-bus-link-p blink)
			  (not (bus-link-have-it blink)))
		   (bus-link-got-it blink)))

	      ;; given
	      ((bool-of-iit-term c)
	       (show-telemetry "recvd it")
	       (unless (bus-link-have-it blink)
		 (bus-link-got-it blink)))

	      ;; asked and have it
	      ((bus-link-have-it blink)
	       (show-telemetry "sent it")
	       (bus-link-lost-it blink)
	       (bus-send-asynch-command-iob
		(new-callback-iob (tid-of-req-iob iob)
				  blink
				  (iasynch-command-term (iit-term t)))))

	      ;; asked and don't have it.
	      (t 
	       (show-telemetry "sent not-it")
	       (bus-send-asynch-command-iob
		(new-callback-iob (tid-of-req-iob iob)
				  blink
				  (iasynch-command-term (inot-it-term)))))))

	  ;; problem is asynch channel expects a rsp?
	  ;; kluged that too (see asynch-channel-recv)
	  (unless (null (with-tid ((tid-of-req-iob iob) (blink-of-in-req-iob iob))
			  ;; id call backs
			  (setf -iob iob -term term)
			  (orb-eval (type-of-req-iob iob)
				    (tags-of-req-iob iob)
				    term)))
	    (break "bace expected nil")
	    ))))
  nil)

(defun metaprl-start-req-p (iob)
  (let ((term (term-of-iob iob)))
    (when (iconfigure-term-p term)
      (let ((command (command-of-iconfigure-term term)))
	(when (irequest-term-p command)
	  (let ((info (info-of-irequest-term command)))
	    (when (istart-term-p info)
	      (bus-link-exempt-p (blink-of-in-req-iob iob)))))))))

(defun bus-local-eval (iob)
  (with-asynch-message-redirect
      #'(lambda (message)
	  ;;(setf -message message -iob iob) (break "ble")
	  (when (or (null *bus-message-filter*)
		    (not (funcall *bus-message-filter* message)))
	    (bus-send (new-out-msg-iob iob (message-to-term message))))
	  nil)
				
    ;;(setf -iob iob) (break "ble")
    (if (iasynch-command-iob-p iob)
	(bus-asynch-command-eval iob)
	(let ((term (term-of-iob iob)))
	  (let ((result
		   (cond
		     ((inoop-term-p term)
		      (iack-term))

		     ((eql '|!it| (id-of-term term))
		      (iack-term)
		      (break "it??"))
		 
		     (t
		      (with-tid ((tid-of-req-iob iob) (blink-of-in-req-iob iob))
			;; id call backs
			;;(setf -iob iob -term term) (break "ble")
			(orb-eval (type-of-req-iob iob)
				  (tags-of-req-iob iob)
				  term))))))	      
	     
		 (when (null result)
		   (setf -iob iob -result result)
		   (break "nr"))
		 ;;(setf -iob iob -result result) (break "nr")
		 (bus-send
		  (new-out-rsp-iob iob result)))))))


(defun quit-accept ()
  (let ((blink (find-first #'(lambda (blink)
			       (when (accept-channel-p (car (channels-of-link
							     (link-of-bus-link blink))))
				 blink))
			   *bus-links*)))
    (when blink
      (bus-link-close blink))))


(defvar *request-loop-quit-p* t)

(defun quit-request-loop ()
   (quit-accept)	 ;; stop accepting new clients
   (setf *request-loop-quit-p* t))

(defun orb-request-loop ()
  (let ((*request-loop-quit-p* nil))
    (do ()
	(*request-loop-quit-p*)

      (mapc #'print-message (messages-flush))
      (let ((iob (receive-request)))
	(when iob
	  (cond
	    ((asynch-req-iob-p iob) (asynch-eval iob))
	    (t (bus-local-eval iob))))))))


(defun orb-request-one ()
  (let ((iob (receive-request nil)))
    (when iob
      (if (asynch-req-iob-p iob)
	  (asynch-eval iob)
	  (bus-local-eval iob))
      (orb-request-one))))


;;;;	
;;;;	Desire orb hook which when called reads outstanding requests
;;;;	but returns immediately if none.
;;;;	
;;;;	
;;;;	

;;;;
;;;;  orb
;;;;


(defun broadcast-eval (env bcasts)
  ;;(setf a env b bcasts) (break "be")
  
  (with-environment-actual env
    ;; how to get begin through, with-tstate fails as no state yet.
    (let ((tstamp (term-to-stamp (stamp-of-ibroadcasts-term bcasts)))
	  (auto-commit (auto-commit-of-ibroadcasts-term bcasts)))

      (when auto-commit (setf auto-commit (term-to-stamp auto-commit)))

      (dolist (bbt (broadcasts-of-ibroadcasts-term bcasts))
	(let ((term (term-of-bound-term bbt)))

	  ;; handle error is here in case client broadcast processing fails.
	  ;; server broadcasts should not go through here?
	  ;; RLE TODO failure during activation phase of restore gets caught here.
	  ;;  restore shouldn't fail but it would be nice for debug for failure to pass thru.
	  (with-handle-error-and-message (nil #'(lambda (msg)
						  ;;(setf -msg msg -term term) (break "be")
						  (message-emit
						   (warn-message '(broadcast fail)
								 (cons msg (messages-flush)))
						   'asynch)))

	    (if (ipassport-term-p term)
		(apply-passport env term tstamp auto-commit)
		(progn
		  (setf a term) (break "np")
		  (message-emit (warn-message '(eval-broadcast passport not) term))))))))))


(defun orb-broadcast-eval (env ipass tstamp)
  
  ;; handle error is here in case client broadcast processing fails.
  ;; server broadcasts should not go through here?
  ;; RLE TODO failure during activation phase of restore gets caught here.
  ;;  restore shouldn't fail but it would be nice for debug for failure to pass thru.
  (with-handle-error-and-message (nil #'(lambda (msg)
					  ;;(setf -msg msg -term ipass) (break "obe")
					  (message-emit
					   (warn-message '(broadcast fail)
							 (cons msg (messages-flush)))
					   'asynch)))

    (if (ipassport-term-p ipass)
	(apply-passport env ipass tstamp nil)
	(progn
	  (break "ebpn")
	  (message-emit (warn-message '(eval-broadcast passport not) ipass))))))



;;;;	consumer sends request(!start
;;;;	producer 
;;;;	
;;;;	producer exports inform(!start
;;;;	producer replies inform(!start(...; <bcasts>)
;;;;	consumer imports inform(!start(...; <bcasts>)	   
;;;;	

;;;;	
;;;;	Some startup problems : 
;;;;	  startup basically involves processing a bunch of broadcasts.
;;;;	  code defs may cause calls to the lib, these give an opening for calls
;;;;	    to the process starting up. As the init is not done such calls 
;;;;	    may not proceed well. Also broadcasts may come in and be done
;;;;	    out of order.
;;;;	
;;;;	Fix : delay broadcasts which arrive while broadcasts being processed
;;;;	 - this is important outside of startup as well.
;;;;	 - lib needs to treat component as unavailable to process requests until startup completed.
;;;;	     * Except for requests generated by/related to startup?
;;;;	       maybe fan of one/any/all ignored but a directly addressed request makes it thru?
;;;;	
;;;;	  - delay compiles
;;;;	  - eval delayed compile 
;;;;	     * call lib
;;;;	     * lib sends broadcasts.
;;;;	   * how are these ordered wrt other concurrent broadcasts.    
;;;;	     requests evaled from compiles should not be allowed to change state.
;;;;	     or call lib. Could allow queueing of asych requests.
;;;;	       
;;;;	
;;;;	 receive bcasts a b, for diff transactions.
;;;;	 bcast a calls lib which generates bcasts c d
;;;;	   - should bcasts c d precede b
;;;;	   - ie might b depend on effects of a's broadcasts
;;;;		c d should happen in same transaction as a
;;;;		if so then b can not depend on them, it can't seem til transaction_of(a) completes.
;;;;		if so then a,c,d have been broadcast prior to d.
;;;;	     at startup things are odd, solution is do startup-broadcasts sequentially, allowing generated broadcasts
;;;;	      to be read prior to next startup broadcast, but new broadcast from other events must be queued.
;;;;	      other requests should be just fail.

;;;;	 startup starts transaction and then just evals code as though list of requests. then new bor
;;;;	   - start transaction to process startup broadcasts
;;;;	       * startup could fail due to lock conflicts with other transactions!
;;;;	           that is a good and bad consequence of our transaction model, good that the conflict is
;;;;		   noticed but bad that the startup might fail.
;;;;	       * if startup causes a new broadcast then ok since part of a transaction
;;;;	       * other transactions complete and alter state but startup transaction cannot see them
;;;;		tis possible to write badly behaving ml-code which depends on lib-state.
;;;;		such code can break when state changes, and would break on next startup if not this
;;;;		so let it break.
;;;;	   - queues other broadcasts
;;;;	   - fails other requests.
;;;;	  when complete then processes queued broadcasts.

;;;;	      after startup-broadcasts.
;;;;	     should lib wait for a commit rsp prior to ending transaction (Multi-phase commit problem here!!)
;;;;	     to be so effects would have to have been committed. committing
;;;;	     doesn't cause the side effects. So a would have to have completed
;;;;
;;;;	punt : do broadcast groups in promotable transaction.
;;;;     generally expect broadcasts to be evaled in a transaction
;;;;
;;;;	   processing of a should be in new transaction.
;;;;	

(defun environment-broadcast-update (env types stamp state &optional forcep)

  (dolist (type types)
    (dolist (table (environment-resources-of-type env type))
      (when table
	(definition-table-set-stamp table stamp forcep))))
	      
  (add-broadcast-state-to-environment state env))


;;;;	
;;;;	Two problems with startup 
;;;;	  - broadacsts that come in while start broadcasts being read
;;;;	     are processed prior to the remaining start broadcasts.
;;;;	  - call backs to the library by code compiles happen in this
;;;;	    virtual transaction which is easily confusing to the lib/ref if lib
;;;;	    does anything non-trivial.
;;;;	  - why does lib do static determination ?
(defmacro with-virtual-transaction ((s env) &body body)
  `(prog2
    (transaction-begin-broadcast ,s nil)
      (progn ,@body)
    ;; refiner uses (current-environment) in end hook, an unfortunate dependency
    ;; but this is cheapest fix fttb.
    (with-environment-actual ,env
      (transaction-end-broadcast ,s))))



(defun do-broadcasts (env bcasts)
 ;; (with-virtual-transaction ((term-to-stamp (stamp-of-ibroadcasts-term bcasts)) env)
    (broadcast-eval env bcasts))
;;    )



(defvar *delay-broadcast-compiles* nil)
(defvar *broadcast-compiles-delayed* nil)
(defvar *broadcast-compiles-orders* nil)

(defvar *other-broadcasts-delayed* nil)
(defvar *other-broadcasts-stamp* nil)


;;;;	
;;;;	map resource-tag from to table
;;;;	
;;;;	need to be able to filter out non-applicable broadcasts
;;;;	prior to reading from Psuedo-ORB. Thus we should not have to worry
;;;;	about receiving both library variants as only one should have been read.


;; todo ob1-temp add stamp, use apply-passport.
(defun process-orb-broadcast (b blink)

  ;;(setf -b b -blink blink) (break "pob")
  (when blink (bus-link-idle blink))
  
  (let ((stamp (stamp-of-ipassport-term b)))

    (let ((blinks (match-bus-environment-links stamp)))

      (dolist (blink blinks)
	(bus-link-idle blink)))
	
      ;;(setf -b b -blinks blinks -stamp stamp) (break "pob")
    ))

(defmacro orb-passport-term-p (term)
  `(and (ipassport-term-p ,term)
       (eql 'orb (table-type-of-ipassport-term ,term))))

(defun orb-broadcast (type b stamp &optional from-bus-p blink)
  ;;(break "ob")
  (if (orb-passport-term-p b)
      ;; find all connected environments and update flow-control.
      (process-orb-broadcast b blink)
      
      (progn
	;;(setf a b) (break)
	;; rle todo push down to bus level a'la toploop or lib-journal.
	;; do component environments
	(dolist (env *component*)
	  ;; assume producer took care of broadcast to self.
	  ;; todo need more robust test here.
	  ;;(setf a b c (broadcast-sentry-of-environment env) e env) (break "ob")
	  (unless (and (not from-bus-p) (eq env (current-environment)))
	    ;;(setf a b c (broadcast-sentry-of-environment env) e env) (break "ob")
	    (with-environment-actual env
	      ;;(setf -b b -t type -e env) (break "obl")
	      (when (permit-broadcast-p b (broadcast-sentry-of-environment env))
		(orb-broadcast-eval env b stamp)))))

	;; seems could easily get into loop by sending back to sender here.
	(bus-send (new-broadcast-iob b type stamp) t))))

(defun bus-broadcast (type b stamp)
  (bus-send (new-broadcast-iob b type stamp) nil))




;;; --------------------------------------------------

(defun asynch-eval (iob)
  (let ((term (term-of-iob iob)))
    (with-handle-error-and-message (nil #'(lambda (msg)
					    (message-emit
					     (warn-message '(asynch request fail)
							   term
							   (cons msg (messages-flush)))
					     'asynch)))
      (let ((result (orb-eval (type-of-req-iob iob)
			      (tags-of-req-iob iob)
			      term)))
	(message-emit (inform-message '(asynch request complete) term result) 'asynch)
	nil))))


#|(defun orb-queue-asynch-request (type tags term)
  
  (let ((req-iob (find-pending-remote nil nil)))

    (unless req-iob
      (raise-error (error-message '(asynch request pending none))))

    (update-req-iob-read req-iob (new-asynch-req-iob type tags term))))
|#

(defun asynch-command (tags term)
  (with-environment-actual (match-environment-in-list '(orb) *component*)
    (let ((cmd (command-of-iasynch-command-term term)))
      ;;(setf -cmd cmd) (break "ac")
      (cond
	((iasynch-queue-term-p-aux cmd)
	 (recv-orb-asynch-queue tags cmd))
	((iasynch-notify-term-p cmd)
	 ;;(format t "asynch command ~%")
	 (bus-link-not-idle (tid-blink) t)
	 (recv-orb-asynch-notify cmd))
	(t ;;(break "acu")
	 (raise-error (error-message '(asynch-command unknown) term)))))))

(defun orb-eval (type tags term &optional local-ok)
  ;;(setf -type type -tags tags -term term)(break "oe")
  ;;(with-io-echo-stats (nil "Orb Eval"))
  (setf *idle-p* nil)

  (cond
    ;; TODO only works with directly connected envs.
    ;; TODO if remote then would need to leave a notify to forward notification
    ;; must come before callback clause as looks like callback.
    ((iasynch-command-term-p term)
     ;;(break "ict")
     (asynch-command tags term))

    ((eql type 'callback)
     (with-handle-error-and-message (nil #'(lambda (msg)
					     (apply #'ifail-term 
						    (cons (message-to-term
							   (tag-message  '(transaction callback fail) msg))
							  (mapcar #'message-to-term (messages-flush))))))
       (let ((tstate (tstate-by-tid (tid))))
	 (with-environment-actual (callback-environment-of-tstate tstate)
	   (environment-eval term)))))
      
    ((current-environment-p tags)
     (environment-eval term))

    ((component-environment-p tags)
     (with-environment (tags)
       (environment-journal term
			    (environment-eval term))))
	
    (t
	
     ;;(when (dummy-transaction-p)
     ;;(break "oe dummy"))
     ;;(setf -type type -tags tags -term term)(break "oe")
     
     ;; if local trans attempts to call remotely than fail.
     ;; but if 
     (if (and (not local-ok)
              (local-transaction-p)
              (not (and (iexpression-term-p term)
                        (readonly-transaction-expression-p term))))

	 (progn (format t "~%~%~% OETL ~a ~a ~%~%~%" (id-of-term term) (length (parameters-of-term term)))
                ;;(setf -term term) (break "oetl")
		
		(raise-error (error-message '(orb-eval transaction local) type tags term))
		)

	 (bus-eval type tags term)))))
;;()


;;;;	
;;;;	orb-eval-by-description (<description> <term{expression}> &optional (<tok{fan}>))
;;;;	  - fan : ALL | ANY | ONE.
;;;;	    if one but description applies to none or more than one then error.

;;	self? does eval in current environment or other locals? other locals should be on bus.
;;	fttb, do not do self.


;;;;	
;;;;	journal description satisfy  match for lib. nfg.
;;;;	
;;;;	


;;;	
;;;	not idle
;;;	greatest number of matching bool-properties
;;;
;;;	priority
;;;
;;;	: (env list{pri sort}) list{match sort}
;;;	
;;;	
;;;	
;;;	load balancing : 
;;;	  - number of outstanding requests on link.
;;;	  - number of remote asynch running.
;;;	      * how do we know since if asynch then we are not necessarily waiting for a response.
;;;	
;;;	  - could poll
;;;	  - could have processes broadcast when idle.
;;;	  
;;;	
;;;	

;; sort by queue length ??? bus-link-of-environment-address
(defun properties-of-connection (conn)
  (properties-of-environment (environment-of-connection conn)))


;; two connotations of idle :
;;   - not accepting requests - that is what is checked here.
;;   - not doing anything.
(defun filter-idle-connections (conns)
  (mapcan #'(lambda (conn)
	      (unless (let ((idle (cdr (assoc 'idle (properties-of-connection conn)))))
			(and idle
			     (ibool-term-p idle)
			     (bool-of-ibool-term idle)))
		(list conn)))
	  conns))


(defun filter-connections-by-properties (property-names conns)
  (when conns
    (let ((s (sort (mapcar #'(lambda (conn)
			       (cons (length (mapcan #'(lambda (prop)
							 (when (and (member (car prop) property-names)
								    (ibool-term-p (cdr prop))
								    (bool-of-ibool-term (cdr prop)))
							   (list prop)))
						     (properties-of-connection conn)))
				     conn))
			   conns)
		   #'> :key #'car)))
      (let ((m (caar s)))
	(let ((f (filter #'(lambda (e) (eql m (car e))) s)))
	  ;;(setf -f f -property-names property-names -conns conns) (break "f")
	  (mapcar #'cdr f))))))

(defun sort-by-flow-control (conns)
  (let ((haves nil)
	(havenots nil))
    (dolist (conn conns)
      (if (and (bus-link-of-connection conn)
	       (bus-link-have-it (bus-link-of-connection conn)))
	  (push conn haves)
	  (push conn havenots)))
    (nconc (nreverse haves) (nreverse havenots))))


(defun sort-connections-by-properties (property-names conns)

  ;;(setf -property-names property-names -conns conns) (break "scbp")
  (let ((maxl 0))
    (let ((cconns (mapcar #'(lambda (conn)
			     (cons (let ((l (length (mapcan #'(lambda (prop)
								(when (and (member (car prop) property-names)
									   (ibool-term-p (cdr prop))
									   (bool-of-ibool-term (cdr prop)))
								  (list prop)))
							    (properties-of-connection conn)))))
				     (setf maxl (max l maxl))
				     l)
				   conn))

			  conns)))
      

      ;; sort by # matching true bool properties.
      (let ((a (make-array (1+ maxl) :initial-element nil)))
	(dolist (e cconns)
	  (setf (aref a (car e))
		(cons (let ((pri (cdr (assoc 'priority (properties-of-connection (cdr e))))))
			(cons (or (when (and pri (inatural-term-p pri))
				    (let ((n (numeral-of-inatural-term pri)))
				      (when (integerp n) n)))
				  0)
			      (cdr e)))
		      (aref a (car e)))))

	;; sort by priority
	(let ((acc nil))
	  (dotimes (i (1+ maxl))
	    (let ((l (aref a i)))
	      (when l
		(push (mapcar #'cdr (sort l #'> :key #'car)) acc))))

	  (mapcar #'(lambda (sconns)
		      (let ((idle nil)
			    (notidle nil)
			    (reallynotidle nil))
			(dolist (conn sconns)
			  (let ((blink (bus-link-of-connection conn)))
			    (cond
			      ((null blink)
			       (push conn idle))
			      ((bus-link-idle-p blink)
			       (push conn idle))
			      ((bus-link-really-not-idle-p blink)
			       (push conn reallynotidle))
			      (t (push conn notidle)))))
			(show-telemetry "~%IDLE : ~a --- ~a --- ~a~%" (length idle) (length notidle) (length reallynotidle))
			;;(when (and (onep (length notidle)) (onep (length reallynotidle))) (setf -notidle notidle) (break "nti"))
			
			(nconc (sort-by-flow-control (nreverse idle))
			       (sort-by-flow-control (nreverse notidle))
			       (sort-by-flow-control (nreverse reallynotidle)))))
		  acc))))))


(defvar *connections-properties* '(main))

(defmacro with-connection-properties (props &body body)
  `(let ((*connections-properties* ,props))
    ,@body))

(defun show-ref-blinks (properties)
  (let ((description (description-to-term (new-description 'refine))))
    (let ((connections
	   (mapcan #'(lambda (conn)
		       (unless (member 'journal (address-of-connection conn)) (list conn)))
		   (find-connections-by-description description nil nil))))

      (let ((sconns (car (sort-connections-by-properties properties connections))))

	(format t "~%~a ~%" properties)
	(mapc #'(lambda (conn)
		  (let ((blink (bus-link-of-connection conn)))
		    (format t "~a ~a~%"
			    (address-of-connection conn)
			    (cond
			      ((bus-link-idle-p blink)
			       'idle
			       )
			      ((bus-link-really-not-idle-p blink)
			       `really-not
			       )
			      (t 'not)))))
	      sconns)
	(length connections)))))
			     
;;;;	
;;;;	there should be some env<->env link.
;;;;	especially when subscriptions exist so that envs 
;;;;	
;;;;	consider two libs in one process connected to distinct refiners.
;;;;	if descriptions are similar how are reqs routed so that they go 
;;;;	to proper refiner.
;;;;	
;;;;	link-environment structures
;;;;	  - exported - represents local env
;;;;	     - should contain list of addresses exported to.
;;;;	  - imported - represents remote env
;;;;	     - should contain list of addresses imported to.
;;;;	
		  
(defun orb-connections (description)
  (filter-idle-connections 
   (or (mapcan #'(lambda (conn)
		   (unless (member 'journal (address-of-connection conn)) (list conn)))
	       (find-connections-by-description description nil t))
       (mapcan #'(lambda (conn)
		   (unless (member 'journal (address-of-connection conn)) (list conn)))
	       (find-connections-by-description description nil nil)))))

(defun orb-choose-connected-environment (description properties &optional peek-idle-p)
  (let ((connections (orb-connections description)))

    (let ((sconns (car (sort-connections-by-properties properties connections))))
      (when (and nil (not (onep (length sconns))))
	;;(setf -sconns sconns -description description -connections connections)
	(break "cce oqar")
	(raise-error (error-message '(orb eval asynch description one not) description (length sconns)
				    (mapcar #'address-of-connection sconns))))

      ;;(setf -sconns sconns) (break "occe")

      (when (null sconns)
	(raise-error (error-message '(orb eval asynch description none) description)))
      
      (let ((sconn (car sconns)))
	(if peek-idle-p
	    (bus-link-idle-p (bus-link-of-connection sconn))
	    (progn
	      (when (and (cdr sconns)
			 (not (bus-link-idle-p (bus-link-of-connection sconn))))
	  
		(bus-link-really-not-idle (bus-link-of-connection sconn)))

	      (when (> (length sconns) 2)
		(show-ref-blinks properties)
		(format t "using ~a ~%" (address-of-connection sconn)))

	      (address-of-connection sconn)))))))

(defun orb-eval-by-description (desc-term term &optional (fan 'all) (properties '(main)))

  ;;(format t "~%orbevalbydesc ~a~%" properties)
  ;; hardcoded filtering of journal based on journal token in environment address.
  ;; this is a kludge. 
  ;; 
  ;; Possible solutions: 
  ;;   - promote 'journal to a purpose and require code objects to have (not 'journal) purpose.
  ;;   - add 'eval to lib description and require code objects to have 'compiler purpose.
  ;;   - add 'eval to lib description and hard code filtering for 'eval.
  ;;   - add '(not eval) to journal description and hard code filtering for '(not eval).
  ;; Last seems best.
  ;;
  (if (and (eql fan 'one)
	   (match-descriptions-p desc-term (description-of-environment (current-environment))))
      (environment-eval term)
      ;;(orb-eval fan (address-of-environment (current-environment)) term)

      (let ((connections (orb-connections desc-term)))
	;;(setf -connections connections -desc-term desc-term -term term -fan fan) (break "oebd")

	(if (eql fan 'all)
	    (mapcar #'(lambda (conn)
			(orb-eval fan (address-of-connection conn) term))
		    connections)
	    (let ((sconns (car (sort-connections-by-properties properties
							       (if (eql fan 'one)
								   (filter-connections-by-properties properties connections)
								   connections)))))

	      ;; do sort here so that idle are not present.
	      ;; however want idles to be included in all.

	      ;;(setf -sconns sconns -desc desc-term) (break "oebau")
	      
	      (when (and (eql fan 'one) (not (onep (length sconns))))
		;;(setf -sconns sconns -desc desc-term) (break "oeba")
		(raise-error (error-message '(orb eval description one not)
					    desc-term (length connections)
					    (mapcar #'address-of-connection sconns))))

	      (when (zerop (length sconns))
		(raise-error (error-message '(orb eval description any none) desc-term)))

	      ;; load-balancing on sconns list.
	      
	      (orb-eval fan
			(address-of-connection
			 (if (null (cdr sconns))
			     (car sconns)
			     (or (find-first #'(lambda (conn)
						 (when (bus-link-idle-p (bus-link-of-connection conn))
						   ;;(setf -sconns sconns) -conn conn) (break "eip")
						   conn))
					     sconns)
				 (car sconns))))
			term))))))

			       

;;;;	orb-broadcast-start(<server-type> <tags{producer-address}> <types{table}>)
;;;;	  : <started>
;;;;	
;;;;	  - send start, received started.
;;;;	  - updated current environment sentry.
;;;;	  - add tables to current environment
;;;;	  - init tables from started.
;;;;	



;;;; adds link to bus whose function is to check for new client(s) and if waiting,
;;;;opens stream channel(s) and adds new link(s) to bus
 ;; don't use yet, put elsewhere
(defun orb-accept-client (sock &optional mathbus-p)
  (let ((l (new-soft-link (new-accept-channel sock mathbus-p )
			  :listen #'accept-channel-listen)))
    (link-open l)
    (add-bus-link (new-bus-link l))))



;; receiver must not send back compressed !started term.
;; 'nuprl (list "store" "level0") "level0" "trm"


;; open link


(defun bus-link-close (blink)
  ;;(setf w blink)(break "blb")
  (with-handle-error (('(bus link close)) (remove-bus-link blink))
    (let ((l (link-of-bus-link blink)))
      (when l
	(link-close l))))

  (set-blink-link blink nil)
  (remove-bus-link blink)

  ;; ensure clean up of blink.
  (rehash-environment-connection-caches) )


;; tt should nil port return tt link??? maybe it does ???
(defun bus-link-of-port (port)
  (find-first #'(lambda (blink)
		  (when (link-port-p (link-of-bus-link blink) port)
		    blink))
	      *bus-links*))

(defun port-of-bus-link (blink)
  (let* ((link (link-of-bus-link blink))
	 (ch (car (channels-of-link link))))
    (port-of-socket (primary-socket-of-channel ch))))

  
(defun orb-connect-uncompressed-stream (remote-port remote-host)
  (let ((primary-sock (new-socket-connect remote-port remote-host)))
    (let ((link (new-prl-stream-link (list primary-sock))))
    
      (with-unwind-error ((destroy-socket primary-sock))
	(link-open link))
      (add-bus-link (new-bus-link link)))))

(defun orb-connect-stream (remote-port remote-host local-port &optional (repeat 3))
  (declare (ignore local-port repeat))
  (let ((primary-sock (new-socket-connect remote-port remote-host)))
    (let ((link (new-cprl-stream-link (list primary-sock) (get-levels))))
    
      (with-unwind-error ((destroy-socket primary-sock))
	(link-open link))

      (let ((blink (new-bus-link link)))
	(add-bus-link blink)

	;; ??? TODO secondary ???
	;;(with-unwind-error
	;;((configure-send-state-blink blink (iinform-term (idisconnect-term t))))
	;;(configure-send-state-blink blink
	;;(iinform-term (iconnect-term local-port
	;;(local-hostname)
	;; ;;"localhost";; LAL on laptop need to say "localhost" not fun call (local-hostname)
	;;))))
	;;(accept-callback link)
	;;(link-open link)

	))))


#|  (let* ((socket
	  (or (make-socket-pair remote-host remote-port local-port)
	      (and repeat
		   (integerp repeat)
		   (> repeat 0)
		   (let ((npn (+ local-port (random 10))))
		     (format t "~% changing local socket port ~a. " npn)
		     (ml-text (format-string "set_local_port ~a" (princ-to-string npn)))
		     (return-from orb-connect-stream
		       (orb-connect-stream remote-port remote-host npn (1- repeat)))))
	      (raise-error (error-message '(make socket pair) local-port))))

	 (link (new-cprl-stream-link (list socket) (get-levels))))

    (link-open link)
    (let ((blink (new-bus-link link)))
      (add-bus-link blink)

      (with-unwind-error
	  ((configure-send-state-blink blink (iinform-term (idisconnect-term t))))
	(configure-send-state-blink blink
				    (iinform-term (iconnect-term local-port
								 (local-hostname)
								 ;;"localhost";; LAL on laptop need to say "localhost" not fun call (local-hostname)
								 ))))
      (accept-callback link)
      (link-open link)))|#

#|(defun orb-connect-tooltalk (types &optional session)
  (let ((l (new-term-tt-link types t session)))
    (link-open l)
    (add-bus-link (new-bus-link l))))
|#


;; no port -> tooltalk
(defun orb-disconnect (&optional port (send-disconnect-p t))
  (let ((blink (bus-link-of-port port)))
    (when blink
      (let ((idis (idisconnect-term nil)))
	(if send-disconnect-p ;; LAL check in
	    (with-handle-error (('(orb disconnect)) (bus-link-close blink))
	      (config-blink-inform-aux blink idis 'disconnect))
	    (kill-bus-link blink idis))))))


;;;
;;;	active transactions.
;;;

(defvar *transactions-active* nil)

(defun transactions-active () *transactions-active*)


(defun tstate-by-stamp (stamp)
  (let ((t-id (transaction-id-of-stamp stamp)))
    (or (find-first #'(lambda (tstate)
			(when (or (equal t-id (transaction-id-of-tstate tstate))
				  (equal t-id (transaction-id-of-stamp (begin-stamp-of-tstate tstate))))
			  tstate))
		    *transactions-active*)

	(and (boundp '*tstate*)
	     *tstate*
	     (when (or (equal t-id (transaction-id-of-tstate *tstate*))
		       (equal t-id (transaction-id-of-stamp (begin-stamp-of-tstate *tstate*))))
	       *tstate*))
	
	(raise-error (error-message '(tstate by stamp))))))


(defun tstate-by-tid (tid &optional nil-ok-p)
  (or (find-first #'(lambda (tstate)
		      (when (equal-tids-p tid (tid-of-tstate tstate))
			tstate))
		    *transactions-active*)
      (unless nil-ok-p (raise-error (error-message '(tstate by tid))))))

(defun tstate-by-begin (begin)
  (or (find-first #'(lambda (tstate)
		      (when (in-transaction-p (begin-stamp-of-tstate tstate) begin)
			tstate))
		    *transactions-active*)
      ;;(progn (break "tbb") nil)
      (raise-error (error-message '(tstate by begin)))))

			   

(defun transaction-state (&optional nil-ok-p)
  (if (boundp '*tstate*)
      (or *tstate*
	  (unless nil-ok-p
	    (raise-error (error-message '(transaction state null)))))
      (unless nil-ok-p
	;;(break "tsnb")
	(raise-error (error-message '(transaction state not bound))))))

(defun tstate-add (tstate)
  ;;(setf -tstate tstate) (break "ta")
  (unless (member tstate *transactions-active*)
    (tent-order-push (local-stamp-of-tstate tstate) 'begin)
    (setf *transactions-active* (cons tstate *transactions-active*))))

(defun tstate-delete (tstate)
  ;;(setf -tstate tstate) (break "td")
  (when (member tstate *transactions-active*)
    (tent-order-delete (local-stamp-of-tstate tstate))
    (setf *transactions-active* (delete tstate *transactions-active*))))

(defun tstate-set (tstate)
  (setf *tstate* tstate))

(defun dummy-transaction-p ()
  (let ((tstate (transaction-state t)))
    (and tstate
	 (in-environment-p)
	 (not (transaction-server-p (current-environment)))
	 (tstate-dummy-p tstate))))

;; place to hang arbitrary caches/hints for transaction.
(defun tstate-stuff-get (tag)
  (when *tstate*
    (cdr (assoc tag (tstate-stuff *tstate*)))))

(defun tstate-stuff-put (tag d)
  (when *tstate*
    (let ((stuff (assoc tag (tstate-stuff *tstate*))))
      (if stuff
	  (setf (cdr stuff) d)
	  (setf (tstate-stuff *tstate*)
		(cons (cons tag d) (tstate-stuff *tstate*)))))))


(defun tstate-stuff-ap (tag f)
  (when *tstate*
    (let ((stuff (assoc tag (tstate-stuff *tstate*))))
      (if stuff
	  (setf (cdr stuff) (funcall f (cdr stuff)))
	  (setf (tstate-stuff *tstate*)
		(cons (cons tag (funcall f nil)) (tstate-stuff *tstate*)))))
    t))

(defun local-transaction-p ()
  (let ((tstate (transaction-state t)))
    
    (and tstate
	 (in-environment-p)
	 (not (transaction-server-p (current-environment)))
	 (not (tstate-dummy-p tstate))
	 (in-transaction-p (begin-stamp-of-tstate tstate)
			   (local-stamp-of-tstate tstate)))))
       

;;;
;;;	transaction end hooks.
;;; 

(defvar *transaction-end-hooks* nil)

(defun remove-transaction-end-hook (name)
  (setf *transaction-end-hooks* (remove name *transaction-end-hooks* :key #'car)))

(defun add-transaction-end-hook (name hook)
  (setf *transaction-end-hooks* (acons name hook (remove-transaction-end-hook name))))



;;;;	
;;;;	< rsp 566 start 243/6d1e
;;;;	
;;;;	> req 570 revoke 525/3473
;;;;	< begin/end 248/6d1e 248/6d1e 
;;;;	> req 573 !transaction 527/3473  ;; caused by 248 end on assuming touch history of start.
;;;;
;;;;	< begin 249/6d1e 249/6d1e
;;;;	< ostates
;;;;	< end 249
;;;;	
;;;;	
;;;;	> req 576 !transaction 529/3473  ; this comes out of end of 249
;;;;	< begin/end 250/6d1e 250 6die
;;;;	< rsp 570 ack
;;;;	< begin 251/6d1e  527/3473
;;;;	< callback 251/6die 527/3473
;;;;	
;;;;	edd waits for 529 call back and lib waits for rsp to 527 callback.
;;;;	
;;;;	
;;;;	more abstractly:
;;;;	
;;;;	EDD sends E1 req to LIB.
;;;;	EDD reads A1 req from ?
;;;;	LIB sends E1 callback to EDD.
;;;;	EDD sends E2 req to LIB.
;;;;	EDD recvs E1 callback but shelves it since E2 is on top.
;;;;	LIB recvs E2 req and shelves req ???
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	this is precipitated by end hook transaction in scope of request.
;;;;	can be averted by avoiding end-hooks when in scope of transaction
;;;;    assuming end hook of cur transaction will take care of touch history.
;;;;	
;;;;	
;;;;	TODO : seems like touch history should be part of tstate during transaction
;;;;	  and then be dumped into environment at transaction end or just be dealt
;;;;	  with by transaction hooks. Need some special hook for start.
;;;;	11/2002 touch history moved to tstate.

;; see  transaction-end in orb-eval for hung transaction-cleanup.
(defun tstate-end (tstate)
  ;; MTT what if transactions begin end during collect.
  (dolist (tent (collect-queue-of-tstate tstate))
    (tent-collect tent (transactions-active)))

  ;; call hooks.
  ;; if end hook starts a transaction while a req is pending,
  ;; which may happen if an asynch transaction occured (ie initiated elsewhere)
  ;; then server and client get out of step with transaction request/responses.

  ;; don't let hook failure hose us.
  (with-handle-error (('(transaction end))  nil)
    (unless (and nil (any-pending-remote-p))

      (let ((th (touch-history-of-tstate tstate)))
	(let ((l (list-touch-history th)))
	  ;; tis very important that history be cleared prior to calling end hook.
	  ;; since if end hook does a transaction then it loops.
	  ;; 11/2002 N/A since move of touch history to tstate since new tstate in end hooks?
	  (when *io-echo-p* (format t "[THL-~a]" (length l)))
	  (clear-touch-history th)
	  (dolist (e l)
	    (with-environment-actual (car e)
	      (call-transaction-end-hooks (cdr e))))))))
  )

(defun transaction-end-broadcast (stamp)
  
  (let ((tstate (tstate-by-begin stamp)))

    (tstate-delete tstate)
    (with-tid-protect
	(tstate-end tstate))))


;; broadcast could be asynch or from !transaction request.
;; if latter then tstate should exist.
;; tstate is possible in env irrespective, but if not transaction request
;; then is unrelated to begin.

(defun transaction-begin-broadcast (stamp tid)
  ;;(setf a stamp) (break "tbb")
  (let ((tid-tstate (tstate-by-tid tid t)))
    
    ;;(setf -stamp stamp -tid tid -tid-tstate tid-tstate) (break "tbb")
    ;; nil tid-tstate when dummy transaction.

    ;; broadcast eval should init null state for bcast eval when transaction unkown
    ;; which it should be prior to the begin.

    (with-tid (tid)
      ;;(setf a stamp b tid c (tid) d tid-tstate) (break "tbb")
      (let ((tstate (or tid-tstate
			(with-transaction-id (new-transaction-id)
			  ;;(break "tbb tstate")
			  (new-tstate t)))))

	(tstate-set-begin tstate stamp)
	(unless tid-tstate (tstate-add tstate))
	))))

(defun apply-transaction-broadcast (term)
  ;;(setf a term) (break "atb")
  (cond
    ((ibegin-term-p term)
     (transaction-begin-broadcast (term-to-stamp (stamp-of-ibegin-term term))
				  (tid-of-ibegin-term term)))
    ((iend-term-p term)
     (transaction-end-broadcast
      (term-to-stamp (stamp-of-iend-term term))))
    (t (raise-error (error-message '(transaction broadcast unknown) term)))))




(defun current-transaction-stamp ()
  (begin-stamp-of-tstate (transaction-state)))

(defun local-transaction-stamp ()
  (local-stamp-of-tstate (transaction-state)))


(defun transaction-queue-collect (stamp tent)
  (let ((tstate (tstate-by-begin stamp)))
    (setf (tstate-collect-queue tstate)
	  (cons tent
		(collect-queue-of-tstate tstate)))))

(defun transaction-active-p ()
  (and (transaction-state) t))


;; stub; will be redefined by lib module.
(defun unwind-transaction (ok &optional tstate) 
 (declare (ignore ok tstate))
  )


(defun orb-cleanup (&optional (delete-component-p nil))
  ;;(dolist (env *component*)
  ;;(orb-remove-environment env))
  (when delete-component-p
    (setf *component* nil))
  (setf *bus-pend* nil)
  (setf *inqueue* nil)
  (setf *transactions-active* nil)
  (dolist (blink *bus-links*)
    (unless (and (bus-link-imported-environments blink)
		 (member 'journal (address-of-environment (car (bus-link-imported-environments blink)))))
      (bus-link-close blink))))



(defun orb-bus-environments ()
  (mapcan #'(lambda (blink)
	      (mapcar #'address-of-environment
		      (imported-environments-of-bus-link blink)))
	  *bus-links*))



;;;;	todo : twould seem like with-tstate should bind transaction-id.
;;;;	
;;;;	but if nested transaction then bumps local binding which is bad.
;;;;	so need two vars, one to bind and one global.



(define-primitive |!transaction| ((bool . checkpoint)) ())
(define-primitive |!callback| ((string . cookie)) (stamp))
    
(defun transaction-callback (term)
  ;;(break "tb")
  (let ((stamp (term-to-stamp (stamp-of-icallback-term term)))
	(tstate (transaction-state)))
    
    ;; set begin stamp in case not receiving transaction broadcasts.
    (tstate-set-begin tstate stamp)

    ;;(setf -tstate tstate -callback (callback-closure-of-tstate tstate)) (break "tc")

    (tstate-set-result tstate (funcall (callback-closure-of-tstate tstate)))

    ;;(setf -tstate tstate) (break "tc2")
    
    (iack-term)))


;; with-transaction if not server
(defmacro with-transaction-callback (tstate &body body)
  (let ((ltstate (gensym)))
    `(let ((,ltstate ,tstate))
      (with-tstate ,ltstate
	(tstate-set-callback ,ltstate #'(lambda () ,@body))

	(unwind-protect (progn
			  (tstate-add ,ltstate)

			  ;; throw failure 
			  (interpret-result (progn
					      ;;(break "with-transaction-client")
					      (orb-eval 'transaction
							(or (server-address-of-environment *orb*)
							    (server-address-of-environment  (current-environment)))
							(icommand-term (itransaction-term nil)))))
	  )
	(tstate-delete ,ltstate))
      (result-of-tstate ,ltstate)
      ))))


(defmacro with-transaction-client ((joinp) &body body)
  (let ((tid (gensym))
	(tstate (gensym)))

    `(let* ((,tid (tid))
	    (,tstate (when ,tid (tstate-by-tid ,tid t))))

      (if (and ,joinp ,tstate (not (tstate-dummy-p ,tstate)))
	  (with-tstate ,tstate ,@body)
	  (progn
	    (when (and ,tstate (not (tstate-dummy-p ,tstate)))
	      (raise-error (error-message '(transaction nest))))
	    
	    (with-transaction-callback (with-transaction-id (new-transaction-id)
					 ;;(break "wct tstate")
					 (new-tstate t))

	      ,@body)))))  )

(defmacro with-transaction-atom (&body body)
  `(with-tstate (with-transaction-id (new-transaction-id)
		  (new-tstate nil))

    (tstate-set-begin (transaction-state) (new-transaction-stamp))  
    ;; mutex MTT
    ,@body))


(defmacro with-transaction-readonly (&body body)
  `(with-tstate (with-transaction-id (new-transaction-id)
		  (new-tstate t))
    (tstate-set-begin (transaction-state) (new-transaction-stamp))  
    ;; mutex MTT
    ,@body))


;; FTTB : in server, serving a transaction.
(defmacro with-transaction-new (tstate &body body)
  (let ((ok (gensym))
	(ltstate (gensym)))
    `(let ((,ltstate ,tstate))
      (with-tstate ,ltstate
      (let ((,ok nil))
	(unwind-protect (multiple-value-prog1 (progn
						(transaction-begin ,ltstate)
						;; mutex MTT
						,@body)
			  (setf ,ok t))
	  (transaction-end ,ltstate ,ok)))))))

(defmacro with-transaction-server ((joinp readonlyp) &body body)

  (let ((tid (gensym))
	(tstate (gensym)))

    `(let* ((,tid (tid))
	    (,tstate (when ,tid (tstate-by-tid ,tid t))))

      ;; tstate may be left with hanging transaction when connected component fails ungracefully.
      ;;  then joins inherit this orphaned transaction incorrectly.
      (if (and ,joinp ,tstate (not (tstate-dummy-p ,tstate)))
	  (with-tstate ,tstate ,@body)
	  (if ,readonlyp
	      (with-transaction-readonly ,@body)
	      (progn
	    
		(when (and ,tstate (not (tstate-dummy-p ,tstate)))
		  (raise-error (error-message '(transaction nest))))
	    
		;;(with-io-echo-stats (nil "Transaction, server"))
		(with-transaction-new (with-transaction-id (new-transaction-id)
					;;(break "wts tstate")				    
					(new-tstate nil))
		  ,@body)
		))))))

(defmacro with-transaction ((joinp &optional readonlyp) &body body)
  (let ((env (gensym)))
  `(let ((,env (current-environment)))
    (if (transaction-server-p ,env)
	(with-transaction-server (,joinp ,readonlyp) ,@body)
	(with-transaction-client (,joinp) ,@body)))))

(defmacro with-local-transaction (&body body)
 
 (let ((tid (gensym))
	(tid-tstate (gensym)))

    `(let* ((,tid (tid))
	    (,tid-tstate (when ,tid (tstate-by-tid ,tid t))))

      (when (and ,tid-tstate (not (tstate-dummy-p ,tid-tstate)))
	(raise-error (error-message '(transaction nest))))

      (with-io-echo-stats (nil "Transaction, local")
	(with-tstate (with-transaction-id (new-transaction-id)
		       ;;(break "wlt tstate")
		       (new-tstate t))
	
	  (tstate-set-begin (transaction-state) (new-transaction-stamp))
	  (unwind-protect (progn
			    (tstate-add (transaction-state))
			    ,@body)
	    (tstate-delete (transaction-state))))))))


(defun call-transaction-end-hooks (thl)
  ;;(break)
  (with-local-transaction
    (dolist (h *transaction-end-hooks*) (funcall (cdr h) thl)))
  )

(defmacro with-dummy-transaction (&body body)
  (let ((tid (gensym))
	(tid-tstate (gensym)))

    `(let* ((,tid (tid))
	    (,tid-tstate (when ,tid (tstate-by-tid ,tid t))))

      (when ,tid-tstate
	(raise-error (error-message '(transaction nest dummy))))

      ;;(setf a ,tid-tstate) (break "wdt2")
      (with-tstate (with-transaction-id (new-transaction-id)
		     (new-tstate t (dummy-transaction-stamp)))
	(tstate-set-begin (transaction-state) (local-stamp-of-tstate (transaction-state)))
	,@body
	))))

(defun do-delayed-broadcasts (delayed)
  (let ((env-alist nil))
    (dolist (d delayed)
	(unless (eql 'transaction (table-type-of-ipassport-term (cadr d)))
	  (let ((a (assoc (car d) env-alist)))
	    ;;(setf -env-alist env-alist -a a -d d)
	    (if a
		(setf (cdr a) (cons (cdr d) (cdr a)))
	      (setf env-alist (list (cons (car d) (list (cdr d)))))))))

    ;;(setf -env-alist env-alist) (break "ddb")
    (dolist (a env-alist)
    (with-environment-actual (car a)
     ;; problem here in that can't do broadcasts for multiple envs with one transaction??
     ;; could queue asynch but then other broadcasts might sneak in unless delayed
     ;; so asynch loop leaving broadcasts delayed until no broadcasts
     ;; OTOH, this will work FTTB since generally single environment.
     ;;(with-transaction (t nil)
      (let ((stamp (current-transaction-stamp)))		       
       (dolist (b (cdr a))
	(apply-passport (car a) (car b) stamp (cdr b))))))))


(defun do-delayed-compiles (stamp c-env delayed-orders)
  (when (resource-p 'code)
    (let ((delayed (car delayed-orders))
	  (orders (cdr delayed-orders))
	  (dbs nil))

      (with-environment-actual c-env
	;;(with-transaction (t nil)
	(let ((ctable (resource 'code))
	      ;; use stamp passed (should be same?)
	      (stamp (current-transaction-stamp)) )

	  (let ((*other-broadcasts-stamp* stamp)
		(*other-broadcasts-delayed* nil))
	
	    ;;(setf -delayed delayed -orders orders) (break "dddc")

	    (if orders
		(dolist (order orders)
		  (dolist (o order)
		    (compile-ml-code-woxref-woerr o (definition-lookup-by-oid ctable o t stamp t) ctable)))
		
		(dolist (o (reverse delayed))
		  (compile-ml-code-woxref-woerr o (definition-lookup-by-oid ctable o t stamp t) ctable)))

	    (setf dbs *other-broadcasts-delayed*)
	    ;;(break "ddc")
	    )))
      ;;)

      (do-delayed-broadcasts dbs))))



    





;;;
;;; Commands
;;;


(defvar *command-map-hook* nil)

;; map should be pre,post pair of functions.
;; nil ok for post.
(defun add-command-map (type map)
  (remove-command-map type)
  (setf *command-map-hook* (cons (cons type map) *command-map-hook*)))

(defun remove-command-map (type)
  (setf *command-map-hook* (delete type *command-map-hook* :key #'car)))

(defun map-command (f cmd)

  (dolist (type-map *command-map-hook*)
    (let ((pre (cadr type-map))
	  (post (cddr type-map)))

      ;;(setf -pre pre -post post -cmd cmd) ;;(break "mc")
      
      (let ((mapped (funcall pre cmd)))
	(when mapped
	  (return-from map-command 
	    (let ((r (funcall f mapped)))
	      ;;(setf -r r) (break "mc2")
	      (if post
		  (funcall post r)
		  r)))))))

  (raise-error (error-message '(command term unknown)
			      cmd
			      (mapcar #'car *command-map-hook*))))

(defvar *query-map-hook* nil)

(defun add-query-map (type map)
  (remove-query-map type)
  (setf *query-map-hook* (cons (cons type map) *query-map-hook*)))

(defun remove-query-map (type)
  (setf *query-map-hook* (delete type *query-map-hook* :key #'car)))

(defun map-query (quy)

  (dolist (type-map *query-map-hook*)
    (let ((mapped (funcall (cdr type-map) quy)))
      (when mapped (return-from map-query mapped))))

  nil)
  
(defmacro member-oid (oid l)
  `(member ,oid ,l :test #'equal-oids-p))

;; www0
(defun make-www-command-map (name oids)
  (add-command-map name
		   (cons #'(lambda (cmd-in)
			     (let ((abs (abstraction-of-term cmd-in)))
			       ;;(setf -cmd-in cmd-in -abs abs -oids oids) (break "mwcm")
			       (if (and abs (member-oid (oid-of-definition abs) oids))
				   ;; do source reduce first so that abstraction defined
				   ;; wrt outside view to allow abs matching to be used to filter
				   ;; requests.
				   (www-term-in (source-reduce cmd-in (list name) t))
				   nil)))
			 #'(lambda (out) (www-term-out out)))))
   

;;;;	embed obids into strings.
;;;;	

(defstruct obid-encoding-table
  (rep-table (make-hash-table :test #'equal :size 1000))
  (unrep-table (make-hash-table :test #'equal :size 1000))
  (rep-index 0))


(defun reps-of-obid-encoding-table (oet) (obid-encoding-table-rep-table oet))
(defun unreps-of-obid-encoding-table (oet) (obid-encoding-table-unrep-table oet))
(defun incf-obid-encoding-table-index (oet) (incf (obid-encoding-table-rep-index oet)))

(define-primitive |!oet_member| ((string . rep) (oid . obid))) 
(define-primitive |!oet_table| ((natural . index)) (list)) 

(defun obid-encoding-table-to-term (env &optional prefix)
  (let ((oet (obid-encoding-table-of-environment env))
	(acc nil))

    (maphash #'(lambda (s oid)
		 (when t ;; prefix matches s
		   (push (ioet-member-term s oid) acc)))
	     (unreps-of-obid-encoding-table oet))

    (ioet-table-term (obid-encoding-table-rep-index oet)
		     (map-list-to-ilist acc (icut-nil-term)))))

(defun term-to-obid-encoding-table (oett env)
  (let ((oet (make-obid-encoding-table)))

    (let ((reps (reps-of-obid-encoding-table oet))
	  (unreps (unreps-of-obid-encoding-table oet)))
      (map-ilist-to-list
       (list-of-ioet-table-term oett) (icut-cons-op)
       #'(lambda (oetm)
	   (let ((rep-s (rep-of-ioet-member-term oetm))
		 (oid (obid-of-ioet-member-term oetm)))
	     (let ((s (string-of-oid oid)))
	       (setf (gethash s reps) rep-s
		     (gethash rep-s unreps) oid)))))
      (setf (obid-encoding-table-rep-index oet)
	    (index-of-ioet-table-term oett)))

    (setf (environment-obid-encoding-table env) oet)))

(defun obid-encoding-table-of-environment (&optional e)
  (let ((env (or e (current-environment))))
    (or (environment-obid-encoding-table env)
	(setf (environment-obid-encoding-table env)
	      (make-obid-encoding-table)))))

(define-typeid (|ObjectId| (objectid) objectid-typeid)
    #'stringp
  #'string=
  #'(lambda (s) s)
  #'(lambda (s) s)
  #'sxhash)


(defvar *obid-encoding-prefix* "%NO")
(defvar *objectid-rep-p* t)

(defun objectid-rep-p () *objectid-rep-p*)

(defun rep-oid-aux (reps unreps oet oid)
  ;;(setf -reps reps -unreps unreps -oet oet -oid oid) (break "roa")
  (if (oid-p oid)
      (let ((s (string-of-oid oid)))
	(or (gethash s reps)
	    (let ((rep-s (format-string "~ar~a"
				       *obid-encoding-prefix*
					(incf-obid-encoding-table-index oet))))
	      (setf (gethash s reps) rep-s
		    (gethash rep-s unreps) oid)
	      rep-s)))

      ;; may be slot or meta value
      (let ((sexpr (parameter-value-to-sexpr oid *oid-type*)))
	(with-byte-accumulator ('standard-string)
	  (accumulate-standard-string "*obid-encoding-prefix*")
	  (parameter-sexpr-ascii-aux sexpr #'accumulate-char)))))


(defun rep-oid (e oid)
  (let ((oet (obid-encoding-table-of-environment e)))
    (rep-oid-aux (reps-of-obid-encoding-table oet)
		 (unreps-of-obid-encoding-table oet)
		 oet
		 oid)))

(defun unrep-oid-parameter-value (s)
  (let ((sexpr (scan-parameter-demand-value-sexpr s)))
    (if (not (char= #\O (car sexpr)))
	(raise-error (error-message '(unrep oid type) s))
	(if (not (consp (cdr sexpr)))
	    (raise-error (error-message '(unrep oid value) s))
	    (sexpr-to-parameter-value (cdr sexpr) *oid-type*)))))
    

;; assume we've check that s starts with "%NO"    
(defun unrep-oid-aux (unreps s)
  (if (char= #\r (char s 3))
      (or (gethash s unreps)
	  (raise-error (error-message '(unrep oid) s)))

      ;; might be meta/slot value.
      (unrep-oid-parameter-value s)))

(defun unrep-oid (e s)
  (unrep-oid-aux (unreps-of-obid-encoding-table
		  (obid-encoding-table-of-environment e))
		 s))


(defun bound-id-term (bs term)
  (instantiate-term
   (instantiate-operator '|bound_id|
			 (mapcar #'variable-parameter bs))
   (list (instantiate-bound-term term))))

(defun bound-id-term-p (term)
  (and (eql '|bound_id| (id-of-term term))
       (let ((parms (parameters-of-term term)))
	 (and parms
	      (forall-p-optimized (p parms) (variable-parameter-p p))))
       (let ((bts (bound-terms-of-term term)))
	 (and bts
	      (null (cdr bts))
	      (null (bindings-of-bound-term (car bts)))))))

(defun bindings-of-bound-id-term (term)
  (mapcar #'value-of-parameter-n (parameters-of-term term)))

(defun term-of-bound-id-term (term)
  (term-of-bound-term (car (bound-terms-of-term term))))

		
;; convert bound-id to bindings,
;; unquote bound-id terms,
;; and un-embed obids into strings.
(defun www-term-in (term)
  (let ((oet (obid-encoding-table-of-environment (current-environment))))
    (let ((reps (reps-of-obid-encoding-table oet))
	  (unreps (unreps-of-obid-encoding-table oet)))

      (labels
	  ((visit-bterm (bterm)
	     (let ((bindings (bindings-of-bound-term bterm))
		   (term (term-of-bound-term bterm)))
	       (if (and (null bindings)
			(bound-id-term-p term))
		   (instantiate-bound-term (visit (term-of-bound-id-term term))
					   (bindings-of-bound-id-term term))
		   (maybe-instantiate-bound-term bterm bindings (visit term)))))

	   (maybe-unrep-oid-parm (p)
	     (if (and (or (objectid-parameter-p p)
			  (string-parameter-p p))
		      (real-parameter-p p))
		 (let ((s (value-of-parameter-n p)))
		   (if (repd-oid-string-p s)
		       (oid-parameter (unrep-oid-aux unreps s))
		       p))
		 p))
       
	   (visit (term)
	     (maybe-instantiate-term
	      term
	      (let ((op (operator-of-term term)))
		(maybe-instantiate-operator op
					    (id-of-operator op)
					    (let ((parms (parameters-of-operator op)))
					      (when parms
						(if (and (quote-parameter-p (car parms))
							 (eql (value-of-parameter-m (car parms))
							      '|bound_id|))
						    (cdr parms)
						    (mapcar #'maybe-unrep-oid-parm parms))))))
	      (mapcar #'visit-bterm (bound-terms-of-term term)))) )

	(if (opquoted-term-p term '|bound_id|)
	    (raise-error (error-message '(www-term-in quoted bound_id) term))
	    (visit term))))))


;; convert bindings to bound-id,
;; quote bound-id terms,
;; and embed obids into strings.
(defun www-term-out (term &optional (encode-bindings-p t))
  (let ((oet (obid-encoding-table-of-environment (current-environment))))
    (let ((reps (reps-of-obid-encoding-table oet))
	  (unreps (unreps-of-obid-encoding-table oet)))

      (labels
	  ((maybe-rep-oid-parm (p)
	     (if (oid-parameter-p p)
		 (if (objectid-rep-p)
		     (objectid-parameter
		      (rep-oid-aux reps unreps oet (value-of-parameter-n p)))
		     (string-parameter
		       (rep-oid-aux reps unreps oet (value-of-parameter-n p))))
		 p))

	   (visit (term)
	     ;;(setf -term term) (break "wto")
	     (if (bound-id-term-p term)
		 (instantiate-term (instantiate-operator
				    (id-of-term term)
				    (if encode-bindings-p
					(cons (quote-parameter '|bound_id|)
					      (parameters-of-term term))
					(parameters-of-term term)))
				   (list (instantiate-bound-term
					  (visit (term-of-bound-term
						  (car (bound-terms-of-term term)))))))
		 (let ((op (operator-of-term term))
		       (bts (bound-terms-of-term term)))
		   (maybe-instantiate-term
		    term
		    (maybe-instantiate-operator op
						(id-of-operator op)
						(mapcar #'maybe-rep-oid-parm
							(parameters-of-operator op))
						)
		    (mapcar #'(lambda (bt)
				(let ((bs (bindings-of-bound-term bt))
				      (nterm (visit (term-of-bound-term bt))))
				  (if (null bs)
				      (maybe-instantiate-bound-term bt nil nterm)
				      (if encode-bindings-p
					  (instantiate-bound-term (bound-id-term bs nterm))
					  (instantiate-bound-term nterm bs)))))
			    bts) ))))
	   )

	(visit term) ))))



;;; old:

;;;;
;;;;	Local transactions must have access to commit stamps from remote transactions
;;;;	since launch of local. Cannot rely on begin stamp of remote transaction as
;;;;	local may begin in middle. Could require begin end transaction broadcasts and
;;;;	say commited updates not visible until transaction end even if older.
;;;;	This may be right thing to do. Counter arg would be long running transactions
;;;;	doing partial commits. May long running transaction should be split into 
;;;;	a series of shorter ones.
;;;;	
;;;;	
;;;;	Fttb, can assume any remote commit is older than local.
;;;;	This is wrong when local causes remote by calling without callback.
;;;;	It is insidious as one might wrongly expect effects from a remote
;;;;	call to be visible if called from within the local. This is the
;;;;	distinction betweent the local and the callback transaction.
;;;;	
;;;;	Proper temporary solution would be to treat as recent any transaction
;;;;	stamp for which a similar stamp has been received since local began.
;;;;	maybe fix with event model
;;;;	
;;;;	What if local transaction starts in middle of remote. 
;;;;	
;;;;	Updates committed prior to start of local should be visible, but if transaction put on no-no list
;;;;	then how to id?
;;;;	Transaction-less-than 
;;;;	  - need reliable comparison for ordering transaction stamps. So that
;;;;	    transaction view is consistent. 
;;;;	 
;;;;	Lets say process A and B have clocks which differ.
;;;;
;;;;	A starts local transaction, and looks up value v of oid o, then
;;;;	B updates value at o with v' via remote transaction. When A looks at o
;;;;	a second time it is possible for it to believe that v' is older than
;;;;	v and use that when in fact it should use v.
;;;;
;;;;	Stamps from the same process are comparable.
;;;;	Local transactions must have access to commit stamps from remote transactions
;;;;	since launch of local. Cannot rely on begin stamp of remote transaction as
;;;;	local may begin in middle. Could require begin end transaction broadcasts and
;;;;	say commited updates not visible until transaction end even if older.
;;;;	This may be right thing to do. Counter arg would be long running transactions
;;;;	doing partial commits. May long running transaction should be split into 
;;;;	a series of shorter ones.
;;;;	
;;;;	
;;;;	Fttb, can assume any remote commit is older than local.
;;;;	This is wrong when local causes remote by calling without callback.
;;;;	It is insidious as one might wrongly expect effects from a remote
;;;;	call to be visible if called from within the local. This is the
;;;;	distinction betweent the local and the callback transaction.
;;;;	
;;;;	Proper temporary solution would be to treat as recent any transaction
;;;;	stamp for which a similar stamp has been received since local began.
;;;;	maybe fix with event model
;;;;	
;;;;	What if local transaction starts in middle of remote. 
;;;;	
;;;;	Updates committed prior to start of local should be visible, but if transaction put on no-no list
;;;;	then how to id?


;;;; -doct- (mod itd)
;;;;
;;;;	component-eval(<ml-expr> <tag{env}> <tag{type}> <tag{name}>)
;;;;	 : <ml-result>
;;;;	 * establishes component context and does ml-eval.
;;;;	 * may require <ml-expr> be evaled remotely in order to establish proper
;;;;	   context.
;;;;
;;;;	ml-eval (<ml-expr>)					: <ml-result>
;;;;	 * <asynch-msg>'s may be asynchrounously emitted during evaluation.
;;;;
;;;;	<request>	: !req{<sequence>:n, <env-address>}(<expression>)
;;;;			| !rsp{<sequence>:n}(<result>)
;;;;
;;;;	<notice>	: !broadcast{<tooltalk-type>:t}(<bcasts>)
;;;;
;;;;	<start-bcasts>	: <start-bcast> 


;;;;			| <start-bcasts>; <start-bcast>
;;;;
;;;;	TID : 
;;;;	  - !req may binds tid.
;;;;	      * may have tid already.
;;;;	      * may be new tid.
;;;;	  - Local eval inits new tid.
;;;;	  - !begin : may init tid or find tid.
;;;;
;;;;	Begin Stamp : 
;;;;	  - !begin assoc's server stamp and local stamp.
;;;;	    if not tstate at !begin then allocate state and local stamp.
;;;;	
;;;;	Local : allocated with tstate, tid derived from local 
;;;;	  unless tstate allocate in reaction to bus input.
;;;;	
;;;;	Assume begin/end transactions:
;;;;	
;;;;	Client A does transaction via callback.
;;;;	  - tid from A
;;;;	  - begin from server
;;;;	  - local matchs tid, but serialized via begin.
;;;;	  - local : must be inside of callback, ie no lookups outside of callback:
;;;;	      * A does lookup.
;;;;		Concurrent transaction c commits.
;;;;		A initiates callback transaction b.
;;;;		Callback transaction b updates.
;;;;		A does lookup.
;;;;		Contradiction : sever expects c to be older, ie b may ref c
;;;;		  but c commit would not be visible to local
;;;;	  - with-tid (!req !transaction)
;;;;	    !transaction_begin 
;;;;	      * allocate tstate, serialize begin
;;;;	    !req(!callback) : with-local BODY
;;;;	    !transaction_end
;;;;	      * remove tstate, begin
;;;;	
;;;;	Client A does local transaction.
;;;;	  - remote begins and locals serialized, all begins after local are
;;;;	    not visible to local.
;;;;	  - fail if remote req made.
;;;;	  - with-tid (with-local (serialize local BODY))
;;;;	
;;;;	Server local is Client begin
;;;;
;;;;	Cold call :
;;;;	  - tid from caller
;;;;	  - begin matches tid.
;;;;	  - local inside call, serialized via begin.
;;;;	  - with-tid (tid of !req) (with-local BODY) 
;;;;	      * if caller server then req would be wrapped by !transaction_begin !transaction_end.
;;;;		tid should allow client to assoc local with tstate alloc'd by begin.
;;;;	      * if caller client then local is sent back to caller as begin.
;;;;	    !transaction_begin 
;;;;	      * allocate tstate, serialize begin
;;;;	    !req(!callback) : with-local BODY
;;;;	    !transaction_end
;;;;	      * remove tstate, begin
;;;;	
;;;;	  
;;;;	Client does dummy transaction :
;;;;	  - tid from dummy.
;;;;	  - local from dummy but not serialized, lookups using dummy
;;;;	    always find last commit.
;;;;	  - each remote request distinct server transaction.
;;;;	  - each server transaction gets local bound by server.
;;;;	dummy inherently does not satisfy transaction visibilility constraints,
;;;;	ie not serialized. analogous to distinct local transaction for each local lookup.
;;;;	  - local within dummy, hides dummy.
;;;;	  - callback within dummy, hides dummy.
;;;;	  - recursive dummies ok. dummy within local or callback is no-op.
;;;;	    ie can't nest transactions by wrapping in dummies as dummies are see through.
;;;;	


(defun orb-start-appl-server-accept-aux (port &optional (type '|fdl|) (compressp t) api-kind)
  ;;(break "osasa")
  (let* ((socket (or (new-socket-listen port)
		     (raise-error (error-message '(orb start accept) port))))
	 (c (new-accept-channel socket
				(eql type `|mathbus|)
				(when (eql type '|fdl|) *orb-compression-levels*)
				(when (eql type '|fdl|) compressp)
				api-kind))
	 (l (new-soft-link c
			   :close #'accept-channel-close
			   :listen #'accept-channel-listen)))
    (link-open l)
    l))

