%
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************
%

% basic term fns for mp/nuprl communication %

let imp_msequent_op = (`!mp_msequent`, nil);;
let imp_msequent_term a g = make_term imp_msequent_op [([], a); ([], g)];;
let imcons_op = (`!mcons`, nil);;
let imp_nil_term = make_term imcons_op [];;

let symbolic_address_term saddr =
    map_to_ilist itoken_term icons_op saddr
;;
    
% basic terms for proof editor %

let ipui_addr_cons_op = (`!pui_addr_cons`, []) ;;
let ipui_addr_term num = make_term (`!pui_addr`, [( mk_natural_parm num)]) nil;;
let address_term_to_list term =
  rev (map_isexpr_to_list ipui_addr_cons_op
                     (\term. dest_natural_parm (parameter_of_term term 1)) term)
;;
  
let nat_list_to_address = map_to_ilist ipui_addr_term ipui_addr_cons_op;;
;;

let butlast l =
  let index = length l in
  letrec iter src i =
    if i = 0 then nil else (hd src) . (iter (tl src) (i-1)) in
  iter l (max 0 (index - 1))
;;
  
%stub%
let ref_add_visible_statements re prevs soids = ();;
