%
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2000                                *
;;;                                                                       *
;;;                                                                       *
;;;                Nuprl Proof Development System                         *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the Nuprl group, Department of Computer Science,       *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify Nuprl provided this notice  *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;************************************************************************
%

let compute_term = compute;;

let new_refiner_environment tag = 
   let ea = [sys_version(); orb_name(); `ref`; tag] in
    make_refiner_environment ea
		    ``REFINE``
		    % important that statements precede abstractions so that statement defs are 
                      instantiated prior to abstractions to facilitate sharing statement def as termof abs%
		    nil %let broadcast subscribe add : ``STATEMENTS ABSTRACTIONS CODE RULES``%
		    nil
		    ``REF REFINE``;
    ea
;;

let finish_start_ref = finish_start_aux (\a b. ()) `ref`;;
let start_ref_aux = start_aux (begin_ap "finish_start_ref ");;

let start_ref name =
 start_ref_aux (inl ())
               name
               (new_refiner_environment name)
;;

let restart_ref () =
  start_ref_aux (inr restart_event_synchronization_stamp)
                restart_name
                (orb_match_local_environment [restart_kind; restart_name])
;;	       

let restart = restart_ref;;

let stop_refine_broadcasts producer consumer = 
  unsubscribe producer (apply_alist client_broadcasts `ref`)
;;

let finish_ref_disksave hotp name = finish_client_disksave (dodisk_ref hotp) name;;

let ref_disksave hotp name =
  stop_aux (inr (bool_ap (begin_ap "finish_ref_disksave ") hotp)) true name
;;


let open_lib = start_ref;;
let close_lib =  stop_aux_nosync false;;

let go_open () = open_aux start_ref;;
let stop_close () = close_aux (stop_aux_nosync true);;


let edd_eval p = lib_eval (posure_ap (begin_ap "edd_eval ") p);;
let edd_evald prop p =
  orb_queue_asynch_wo_completion `ONE` false nuprl5_library_description_term nil
    (posure_ap (token_ap (begin_ap "edd_evald") prop) p)
;;

let edd_eval_to_string p = 
  lib_eval_to_string_unmarshall (posure_ap (begin_ap "edd_eval_to_string_marshalled ") p);;

%let term_to_print_string w t = edd_eval_to_string (nat_ap (term_ap (begin_ap "term_to_print_string ") t) w);;%

letref rrtbug = ivoid_term;;
let refine_tree_fail re goal tac e =
 make_term (`refine_tree_fail`, [make_object_id_parameter re]) [[], goal; [],tac; [],e]
;;
let refine_tree_failt re goal tac e =
 make_term (`refine_tree_fail`, []) [[], goal; [],tac; [], re; [],e]
;;

let ref_refine_profile igoal tac envoid =
 with_object_id
  (\(). tty_print "rrp hello"; ref_refine_profile_aux igoal tac envoid)
  (new_dummy_object_id ())
;;

let match_tok_with_prefix prefix =
 (string_match_f true (concatenate_strings ["^"; prefix])) o tok_to_string
;;

				     
