%
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2000                                *
;;;                                                                       *
;;;                                                                       *
;;;                Nuprl Proof Development System                         *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the Nuprl group, Department of Computer Science,       *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify Nuprl provided this notice  *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;************************************************************************
%

%;;;
;;;;	Proofs/termofs ?.
;;;%


let exists_object_delimiters_p_ap = begin_ap "exists_object_delimiters_p";;
let exists_object_delimiters_p name = lib_eval_to_bool (token_ap exists_object_delimiters_p_ap name);;

let exists_object_p_ap = begin_ap "exists_object_p";;
let exists_object_p name = lib_eval_to_bool (token_ap exists_object_p_ap name);;

% leave undefined to mill callers.
let is_lib_member = exists_object_p;;
%

let create_lib_objects_ap = itext_term "lib_create_ref_objects";;
let create_lib_objects place odata =
  lib_eval_to_object_ids (token_ap (terms_ap create_lib_objects_ap odata) place)
;;

let create_lib_objects_at_ap = itext_term "lib_create_ref_objects_at";;
let create_lib_objects_at dir place odata =
  lib_eval_to_object_ids (token_ap (oid_ap (terms_ap create_lib_objects_at_ap odata) dir) place)
;;
let create_lib_objects_at_wrechain dir place odata =
  lib_eval_to_object_ids
    (token_ap (oid_ap (terms_ap (itext_term "lib_create_ref_objects_at_wrechain")
				odata) dir) place)
;;

%
;;;;	accumulator : closure to incrementally create group of objects in lib 
;;;;	
;;;;	reaccumulator : allows redefinition of objects created by an accumulator.
;;;;	
;;;;	
;;;;	
;;;;	object_accumulator :
;;;;	  unit + ((tok{kind} # tok{name} # term{content}) list -> unit)
;;;;	  - (isl loc) then can be used by content to test if objects are being
;;;;	    created or only ref variable update.
;;;;	
;;;;	make_object_accumulator 
;;;;	  : bool{dirp} -> (unit + bool{delimp} # token))
;;;;		-> object_id{dir} -> tok{place} -> object_accumulator
;;;;	
;;;;	  * dirp : if true makes subdirectoy to contain objects.
;;;;	  * if isr then allows for delim and or undo.
;;;;	      - if first bool true then will add delimiters 
;;;;	      - if second bool true then will add .undo
;;;;	      - token mnemonic : used as dir name?
;;;;	    if no delimiters and no subdir then places objects before place.
;;;;	  * isl : bool indicates  delims or not ;
;;;;	
;;;;	 undo : deletes all objects in undo list and .undo
;;;;	  - if dir emtpy besides then rm's dir.
;;;;	 redo : if .undo exists then fails.
;;;;	        if dir exists then reuses
;;;;	ob_acc adds objects such that the linear order matches the temporal order 
;;;;	
;;;;	So want content providers to take obacc as arg and then
;;;;	have wrappers which take oid and to make obacc.
;;;;	
;;;;	
%
let obacc_start_ap = (begin_ap "obacc_start ");;
let obacc_start dirp delimp mnemonic extras dir place =
  lib_eval_to_object_id
   (token_ap (oid_ap (term_ap (token_ap (bool_ap (bool_ap obacc_start_ap dirp) delimp)
					mnemonic)
			      (map_to_ilist (\x.x) icons_op extras))
		      dir)
	      place)
;;

let obacc_add_ap = itext_term "obacc_add";;
let obacc_add odata roid =
  lib_eval (oid_ap (terms_ap obacc_add_ap odata) roid)
;;

let obacc_add_wrechain re odata roid =
  lib_eval_to_object_ids (oid_ap  (oid_ap (terms_ap (itext_term "obacc_add_wrechain") odata) re) roid)
;;


let make_obacc_wrechain_rroid dirp delimp mnemonic extras (dir, place) =
   let oid = obacc_start dirp delimp mnemonic extras dir place in
     (\re odata. without_ref_environment (obacc_add_wrechain re (map odt odata)) oid)
     , oid
;;


%
let make_obacc dirp delimp mnemonic loc =
 snd (make_obacc_aux dirp delimp mnemonic loc)
;;
%

let call_oacc obacc d =
 let re, oacc = obacc in
 let (nre . noids) = (oacc re d)
   in (nre, oacc)
;;

let call_oacc_to_obids obacc d =
 let re, oacc = obacc in
 let (nre . noids) = (oacc re d)
   in noids, (nre, oacc)
;;

let find_ephemeral_refenv_location (dir,place) =
 let t = lib_eval_to_term 
          (oid_ap (token_ap (begin_ap "ephemeral_refenv_location_term") place) dir) in
  first_oid_of_term (ihead t), itail t
;;

let obacc_finish_wrechain re a =
 lib_eval (term_ap (oid_ap (begin_ap "finish_ephemeral_refenv_chain") re) a)
;;


%
let at_location f dirp delimp mnemonic =
 \loc. (f (if (isr loc)
              then inr (make_obacc dirp delimp mnemonic (outr loc))
	      else inl ()))
;;
%

let at_location_wrechain_aux_aux partialp contentf f dirp delimp mnemonic =
 \extras loc.
       if (isr loc)
          then (let lloc = (outr loc) in 
                let reinit, a = find_ephemeral_refenv_location lloc in
        	(let obacc,roid = make_obacc_wrechain_rroid dirp delimp mnemonic extras lloc in
		 % f (rreinit, (\re d. obacc re (contentf d)))%
		 if partialp then
    	            ((let relast = fst (f (reinit, (\re d. obacc re (contentf d)))) in
 		     % need to link next to relast. %
                     obacc_finish_wrechain relast a;
		     ())
		     ? ())
		    else
		    (let relast = fst (f (reinit, (\re d. obacc re (contentf d)))) in
 		     % need to link next to relast. %
                     obacc_finish_wrechain relast a;
		     ())))
	   else ()
;;

let directory_child d place =
  lib_eval_to_object_id (token_ap (oid_ap (begin_ap "child") d) place);;

let at_location_source_aux oid =
  mk_simple_term `at_location_source`
    [ioid_term oid]
;;
   
let at_location_source (d, place) =
 at_location_source_aux (directory_child d place)
;;
    
let at_location_wrechain_aux partialp contentf f dirp delimp mnemonic =
 \loc. at_location_wrechain_aux_aux partialp contentf f dirp delimp mnemonic
         [if isr loc
	     then ((at_location_source (outr loc)) ? inil_term)
	  else inil_term]
	  loc
;;	 

	   
let at_location_wrechain partialp = at_location_wrechain_aux partialp (\x.x);;

% 7/2002 wouldn't compile with cmu18d solaris and didn't seem to be called.
let at_location_wsrc src =
 (\f dirp delimp mnemonic src loc.
      at_location_wrechain_aux_aux (\x.x)
      f dirp delimp mnemonic
      [at_location_source_aux src])
;;
%
%
let at_location_with_ref_env f dirp delimp mnemonic =
 \re loc. with_ref_environment  f
          (if (isr loc)
              then inr (make_obacc dirp delimp mnemonic (outr loc))
	      else inl ())
          re
;;
%

let object_accumulator_add_ap = itext_term "object_accumulator_add";;
let object_accumulator_add odata dir =
  lib_eval (oid_ap (terms_ap object_accumulator_add_ap odata) dir)
;;

let object_accumulator_start_ap = (begin_ap "object_accumulator_start ");;
let object_accumulator_start name place = 
  lib_eval_to_object_id (token_ap (token_ap object_accumulator_start_ap name) place)
;;

let object_accumulator_finish_ap = (begin_ap "object_accumulator_finish ");;
let object_accumulator_finish name oid = 
  lib_eval (oid_ap (token_ap object_accumulator_finish_ap name) oid)
;;

let create_object_accumulator name place f =
  let oid = object_accumulator_start name place in
      ( (f (\odata. object_accumulator_add (map odt odata) oid))
      ; (object_accumulator_finish name oid)
      ; ())
;;


let object_accumulator_wo_delim_ap = (begin_ap "object_accumulator_wo_delim ");;
let object_accumulator_wo_delim name place = 
  lib_eval_to_object_id (token_ap (token_ap object_accumulator_wo_delim_ap name) place)
;;

let create_object_accumulator_wo_delim name place f =
   let oid = object_accumulator_wo_delim name place in
      ( (f (\odata. object_accumulator_add (map odt odata) oid))
      ; ())
;;

let object_accumulator_wo_delim_at_ap = (begin_ap "object_accumulator_wo_delim_at ");;
let object_accumulator_wo_delim_at name dir place = 
  lib_eval_to_object_id (token_ap (oid_ap (token_ap object_accumulator_wo_delim_at_ap name) dir) place)
;;


let create_object_accumulator_wo_delim_at name dir place f =
   let oid = object_accumulator_wo_delim_at name dir place in
      ( (f (\odata. object_accumulator_add (map odt odata) oid))
      ; ())
;;

let add_comb_for_thm_ap = begin_ap "(add_comb_for_thm true)";;
let add_comb_for_thm wfoid data = 
  lib_eval_to_object_id (oid_ap (term_ap (add_comb_for_thm_ap) (odt data)) wfoid)
;;



let get_static_oids_ap = (begin_ap "get_static_oids ");;
let get_static_oids kind oids = lib_eval_to_object_ids (oids_ap (token_ap get_static_oids_ap kind) oids);;

let get_static_abstraction_oids = get_static_oids `ABS` ;;
let get_static_statement_oids = get_static_oids `STM`;;
let get_static_code_oids = get_static_oids `CODE`;;

% Jprover now connects directly to refiner so this is out of date 5/2003%%	
let jprover_asynch_ap = null_ap (itext_term "jprover_asynch ");;
let jprover_asynch term hyps comp = lib_eval_queue_asynch (term_ap (term_ap jprover_asynch_ap term) hyps) comp;;
%
