%
*************************************************************************
*                                                                       *
*    Copyrighted Cornell University 2000                                *
*                                                                       *
*                                                                       *
*                Nuprl Proof Development System                         *
*                ------------------------------                         *
*                                                                       *
*   Developed by the Nuprl group, Department of Computer Science,       *
*   Cornell University, Ithaca NY.  See the release notes for a list    *
*   of the members of the group.                                        *
*                                                                       *
*   Permission is granted to use and modify Nuprl provided this notice  *
*   is retained in derived works.                                       *
*                                                                       *
*                                                                       *
*************************************************************************
%

%[
****************************************************************************
****************************************************************************
INCLUSION.ML
****************************************************************************
****************************************************************************
Tactics in this file are intended for proving goals of form:

x:S >> x = x in S'
 
or goals where we have equands similar to those in a hyp:

ta = tb in S >> tc = td in S'

where subset [tc*;td*] [ta*;tb*].

  and t* is t with all soft abstractions unfolded.

The main tactic, Inclusion also recognises equalities hidden in member 
abstractions.
]%



%[
**********************************************************************
Universe Inclusion
**********************************************************************
]%

let is_var_inclusion i p =
  ( let x = first_equand (concl p) and y = var_of_hyp i p in
    dv x = y
  ) ? false
;;



let subtype_of_inclusion i p =
  if is_var_inclusion i p then type_of_hyp i p
    else eq_type (type_of_hyp i p)
;;


%
|- t = t in Ui

  BY Cumulativity j

  |- t = t in Uj

%

let Cumulativity j p =
 %mlbreak `cumul`;%
  let c = concl p in
  let i = dest_U (eq_type c) in
  if level_exp_less_equal j i then 
    Refine `cumulativity` [mk_level_exp_arg j] p
  else failwith `Cumulativity`
;;

let UniverseInclusion i =
  (\p. Cumulativity (snd (dest_lp_term (subtype_of_inclusion i p))) p)
  THEN (NthHyp i ORELSE NthDecl i ORELSE Eq)

;;


let CumulativityByTypeInf p =
 %mlbreak `cbt`;%
  let T,t,() = dest_equal (concl p)
  in let i = snd (dest_lp_term T)
  in let goodi = snd (dest_lp_term (get_type p t))
  in 
  if level_exp_equal i goodi then
    failwith `CumulativityByTypeInf: no restriction necessary`
  else
  ( Repeat (UnfoldAtAddr [1] 0)
    THEN Cumulativity goodi
  ) p
;;

  
  
  
%[
****************************************************************************
New version of Inclusion
****************************************************************************
Most of these tactics are designed to work on goals of form:

1. ... >> Subtype(A;B)
2. ... >> Suptype(A;B)
3. ...x:A ... >> x = x in B

Unfortunately this leads to extra unnecessary wf goals.
]%



%
ApFunToHypEquands
~~~~~~~~~~~~~~~~~


   ...#i: a = b in T ... >> C

    BY ApFunToHypEquands x s[x] S[x] i 

   `fun wf`: ...#i: a = b in T ... x:T  >> s[x] = s[x] in S[x] 
       `wf`: ...#i: a = b in T ...  >> T = T in Uk 
     `main`: ...#i: a = b in T ... s[a] = s[b] in S[a] >> C

Idea is to apply \x.s[x] of type x:T -> S[x] to equands.

x should be a var distinct from all in hyp list.
Also used in EqHD function.
%

let ApFunToHypEquands x s S i p =

  let T,a,b = dest_equal (h i p) in
  let f = mk_lambda_term x s in
  let S_of_a = fo_subst [x,a] S in

  %...#i: a = b in T ... >> C  %

 (Assert (mk_equal_term S_of_a (mk_apply_term f a) (mk_apply_term f b))
  THEN IfLabL
  [`assertion`,
   %...#i: a = b in T ... >> (\x.s[x]) a = (\x.s[x]) b in S[a]  %

   Refine `applyEquality` [mk_term_arg (mk_function_term x T S)]

   THENL
   [%...#i: a = b in T ... >> (\x.s[x]) = (\x.s[x]) in (x:T -> S[x])  %
    Refine `lambdaEquality` [infer_level_exp_arg p T;mk_var_arg x]
    THENL
    [ AddHiddenLabel `fun wf`
    ; AddHiddenLabel `wf`
    ]
      %...#i: a = b in T ... x:T >> s[x] = s[x] in S[x]  %
      %...#i: a = b in T ... >> T = T in U{*}  %
   ;
    %...#i: a = b in T ... >> a = b in T %
    NthHyp i
   ]
  ;`main`,
  %...#i: a = b in T ... (\x.s[x]) a = (\x.s[x]) b in S[a] >> C  %
   ReduceEquands (-1) 
  %...#i: a = b in T ... s[a] = s[b] in S[a] >> C  %
  ]
 ) p
;;

% 
Convert equality inclusion problem to var inclusion problem:

... #i: a = b in S ... >> a = b in T

BY EqIncToVarInc i

`main`  ... x:S >> x = x in T
`wf`    ...     >> S = S in U*
%

let EqIncToVarInc i p =
  let x = get_distinct_var (mkv `zzz`) p in

  ( ApFunToHypEquands x (mk_var_term x) (eq_type (concl p)) i
    THEN
    IfLabL
    [`main`,NthHyp (-1) ORELSE Eq
    ;`fun wf`,AddHiddenLabel `main`]
  ) p
;;


%
...  #i:x:S ... >> x = x in T

BY VarIncToSubtypeRel i

... #i:x:S ... >> Subtype(S,T)
%

let VarIncToSubtypeRel i =
  FoldTop `member` 0
  THEN CopyToConcl i 
  THEN FoldTop `subtype` 0
;;



let kind_of_inclusion i p =
  (let a,b = equands (concl p) in
   let x = var_of_hyp i p in
   if (x = dest_var a & x = dest_var b ? false) then 
     `var`
   else
   let c,d = equands (h i p) in
   if (subset_p [a;b] [c;d] alpha_equal_terms) then
     `eq`
   if (subset_p 
        (map unfold_all_soft_abs [a;b]) 
        (map unfold_all_soft_abs [c;d])
	alpha_equal_terms)
   then
     `soft eq`
   else
     fail
  )
  ? `not`
;;

% 
...  #i:x:S ... >> x = x in T

BY SetupInclusion i

`main` ... #i:x:S ... >> x = x in T


OR


... #i: a = b in S ... >> c = d in T   ({c,d} subset of {a,b})

BY SetupInclusion i

`main` ... #i: a = b in S ... x:S >> x = x in T
`wf` ... #i: a = b in S ... >> S = S in U*

If S = T then no subgoals are generated in either case.
SetupInclusion initially unfolds any member abstractions in hyp i or the conclusion.

%

let SetupInclusion i =
  let EqTac =
    NthHyp i
    ORELSE Eq
    ORELSE EqIncToVarInc i
  in

  Try (UnfoldTop `member` i)
  THEN Try (UnfoldTop `member` 0)
  THEN 
  \p.
  let kind = kind_of_inclusion i p in
  if kind = `var` then
  ( NthDecl i 
    ORELSE AddHiddenLabel `main`
  ) p
  if kind = `eq` then
    EqTac p
  if kind = `soft eq` then
  ( Try (HardenEquands i) 
    THEN Try (HardenEquands 0)
    THEN EqTac
  ) p
  else
    failwith `SetupInclusion: not an inclusion goal`
;;


%
Now we have tactics for solving 

>> Subtype(A;B)
as well as solving >> RevSubtype(A;B)

Kinds of tests done:

0. If Suptype(A;B), solve subtype(B;A)

1. Trivial.
   a. A = B 
   b. A' = B' by unfolding topmost soft abstractions.
   c. A = B by unfolding all soft abstractions.

2. Subtype:
   At least one of A and B is a subtype. and A , B have the same supertype.

3. Structural decomposition.
   First Strip off any outermost soft abstractions:
   And check opids the same.

   a. If universes, do universe inclusion.
   b. If possible, backchain through an appropriate lemma and repeat.
   c. If hard abstractions.
        invoke abstraction level inclusion.



%

%
 ... >> Subtype(S;T) ...

  BY SubtypeCD =

   `wf`   ... >> S = S in U*  
   `main` x:S >> x = x in T 
 
OR

  ... x:S ... >> x = x in T

  BY SubtypeCD =

 `main` ... x:S ... >> x = x in T 

tactics shouldn't assume after SubtypeCD that inclusion var is last in hyplist.
%

let SubtypeCD p =
  %  ... >> Subtype(S;T) ...%
  ((UnfoldTop `subtype` 0
    %  ... >> All x:S x in T ...%
    THEN D 0
    % `wf`   ... >> S = S in U*  %
    % `main` x:S >> x in T ...%
    THENM 
    ( UnfoldTopAb 0
      % `main` x:S >> x = x in T %
    ) 
   ) ORELSE AddHiddenLabel `main`
  ) p

;;

% also returns hyp num of declaration... %
% defined in monitor.ml %

%
let get_subtype_args p =
%

% Handles prop abstraction... %


let UniverseSubtype p =
  %  ... >> Subtype(Ui;Uj) ...%
  let i,A,B = get_subtype_args p in
  if not subset (map opid_of_term [A;B]) ``universe prop`` then
    failwith `UniverseSubtype: not a universe inclusion`
  else
  ( SubtypeCD
    THENM UniverseInclusion i
    % `main` x:Ui >> x = x in Uj ...%
  ) p
;;

%[
**********************************************************************
Trivial Inclusion
**********************************************************************
For tackling goals:
]%

%
Takes care of identity and soft equality
%

let TrivialSubtype p =
  %  ... >> Subtype(S;T) ...%
  let i,A,B = get_subtype_args p in
  let A_eq_B = soft_equal A B in
  if A_eq_B = `false` then
    failwith `TrivialSubtype`
  else
  let tagger =
    (if A_eq_B = `true` then
       id
     if A_eq_B = `top-soft` then
       tag_soft_ab
     if A_eq_B = `soft` then
       tag_all_soft_abs
     else
       failwith `TrivialSubtype: bad case`
    )
  in
  ( SubtypeCD
    THENM 
    (Repeat (ComputeUsing tagger i)
     THEN Repeat (ComputeAtAddrUsing tagger [1] 0)
     THEN NthDecl i
    )
  ) p
;;

let EqSubtype = SubtypeCD THENM Eq
;;

let HardenSubtypeTypes p =
 let i,(),() = get_subtype_args p in
 if i = (-1) then
   (Repeat (UnfoldSoftAbAtAddr [1] 0)
    THEN Repeat (UnfoldSoftAbAtAddr [2] 0)
   ) p
 else
   (Repeat (UnfoldSoftAb i)
    THEN Repeat (UnfoldSoftAbAtAddr [1] 0)
   ) p
   
;;




letref Subtype_additions = [] : (tok # tactic) list
;;

let add_Subtype_tactic name tac = 
  Subtype_additions := update_alist Subtype_additions name tac ; ()
;;

let IncToSubtype p = 
  let i,(),() = get_subtype_args p 
  in
  (if i = (-1) then Id else VarIncToSubtypeRel i) p
;;

let ProveSubtypingAdditions p =
  First (map snd Subtype_additions) p
;;


% defined later on in inc-aux-tactics %

letref LemmaSubtype p = Fail p
;;

% 
1. converts |- suptype(A;B) to |- subtype(B;A)
%

let RegularizeSubtyping p = 
  let opid = opid_of_term (concl p) 
  in 
  if opid = `suptype` then
  ( UnfoldTopAb 0 THEN AddHiddenLabel `subterm`) p
  else
    AddHiddenLabel `subterm` p
    
;;

%
There are two ways this can make progress, but fail...
1. Predicates from AbSetSubtype are unprovable.
2. DecomposeSubtypeThen fails if no appropriate function is in cache.

The HardenSubtypeTypes is probably very rarely used, and could be
removed.
%

%
let ProveSubtyping1 p =
  Progress
  ( RepWith (is_proof_with_label `subterm`) "I"
     ["Reg",Progress RegularizeSubtyping
     ;"Tri",TrivialSubtype
     ;"Lem",LemmaSubtype
     ;"Har",Progress (HardenSubtypeTypes THEN AddHiddenLabel `subterm`)
     ;"Uni",UniverseSubtype 
     ;"EqS",EqSubtype
     ;"PSA",ProveSubtypingAdditions 
     ;"End",IfLabL [`subterm`, AddHiddenLabel `unproved Inclusion subgoal`]
     ]
g  )
  p
;;
%

letrec DefaultProveSubtyping1 p =
 (RegularizeSubtyping THENM
   (TrivialSubtype
    ORELSE LemmaSubtype
    ORELSE
    ( HardenSubtypeTypes THEN
        (UniverseSubtype 
         ORELSE EqSubtype
         ORELSE (ProveSubtypingAdditions 
                 THEN IfLabL
                 [`subterm`,
                  DefaultProveSubtyping1 
                  ORELSE AddHiddenLabel 
                    `unproved subgoal from Inclusion`
                 ]
                )
        )
    )
   ) 
 ) p
;;

% label matches ver.4 in this one %
letrec DefaultProveSubtyping2 p =
 (RegularizeSubtyping THENM
   (TrivialSubtype
    ORELSE LemmaSubtype
    ORELSE
    ( HardenSubtypeTypes THEN
        (UniverseSubtype 
         ORELSE EqSubtype
         ORELSE (ProveSubtypingAdditions 
                 THEN IfLabL
                 [`subterm`,
                  DefaultProveSubtyping1 
                  ORELSE AddHiddenLabel 
                    `unproved Inclusion subgoal` 
                 ]
                )
        )
    )
   ) 
 ) p
;;

let DefaultProveSubtyping3 p =
  Progress
  ( RepWith (is_proof_with_label `subterm`) "I"
     ["Reg",Progress RegularizeSubtyping
     ;"Tri",TrivialSubtype
     ;"Lem",LemmaSubtype
     ;"Har",Progress (HardenSubtypeTypes THEN AddHiddenLabel `subterm`)
     ;"Uni",UniverseSubtype 
     ;"EqS",EqSubtype
     ;"PSA",ProveSubtypingAdditions 
     ;"End",IfLabL [`subterm`, AddHiddenLabel `unproved Inclusion subgoal`]
     ]
  )
  p
;;


% This is refvar so that it can be changed easily for e.g. one
  that incorporates caching.
%

letref ProveSubtyping1 = DefaultProveSubtyping3 ;;

% Old version of ProveSubtyping. Doesn't allow easily for caching. %
%
letrec ProveSubtyping1 p =
 (RegularizeSubtyping THENM
   (TrivialSubtype
    ORELSE LemmaSubtype
    ORELSE
    ( HardenSubtypeTypes THEN
        (UniverseSubtype 
         ORELSE EqSubtype
         ORELSE (ProveSubtypingAdditions 
                 THEN IfLabL
                 [`subterm`,
                  ProveSubtyping1 
                  ORELSE AddHiddenLabel 
                    `unproved subgoal from Inclusion`
                 ]
                )
        )
    )
   ) 
 ) p
;;
%

%
Inclusion1 leaves many well formedness and predicate subgoals floating around.
%

let Inclusion1 i p =
 (SetupInclusion i THENM ProveSubtyping1) p;;


%
Two behaviours tried here:

1. Inclusion never fails. If it doesn't complete an inclusion proof, it
   doesn't do anything and leaves an `inclusion?` label on inclusion goal.
   We can then try running

     Inclusion1 i 

   to see how far inclusion got and why it failed.

2. Inclusion fails outright. This seems to be a more desirable behaviour, 
   since it gives other tactics a chance of tackling the goal in hand.

   However, I remember the `inclusion?` labels being useful sometimes,
   but can't recall specific instances.
%

letref inc_debug = false ;;

let Inclusion i =
  (Inclusion1 i THEN 
   IfLabL
   [`unproved subgoal from Inclusion`,Fail
   ;`unproved set predicate from Inclusion`,Fail
   ]
  ) 
  ORELSE Eq
  ORELSE If (\p.inc_debug) (AddHiddenLabel `inclusion?`) (FailWith `Inclusion`)
;;

update_stop_labels `inclusion?` ;;

% Used to restrict behaviour of inclusion tactics in prove subtyping 
additions %

let WithSimpleInc = WithArgs [`simple_inclusion`,tok_to_arg `yes`] ;;

let SimpleInclusion i =
  WithSimpleInc (Inclusion i) ;;

let is_simple_inclusion_goal p = 
  get_tok_arg `simple_inclusion` p = `yes` ? false
;;

let ProveSubtyping p = 
  if is_terms ``suptype subtype`` (concl p) then
  ( ProveSubtyping1 THEN IfLabL
     [`unproved subgoal from Inclusion`,FailWith `ProveSubtyping`
     ;`unproved set predicate from Inclusion`,FailWith `ProveSubtyping`
     ]
  ) p
  else
    failwith `ProveSubtyping`
;;


%
Uses of Inclusion tactic:

1. PrimEqCD on >> apply(a;b) in T  : see basic-eq-tactics
2. EqCDByLemma in reflexive and non-reflexive case when flexible match tried.
3. BackThruGenFormula  : see univ-fmla-tactics
4. On variables by EqCD.

NB: Inclusion above doesn't deal with cases when we don't have member
or equal terms but still need to prove inclusion...
e.g. if  we have T >> T' 
where T and T' are the same except for some level expression parameter
buried deep inside!

%

