%
*************************************************************************
*                                                                       *
*    Copyrighted Cornell University 2000                                *
*                                                                       *
*                                                                       *
*                Nuprl Proof Development System                         *
*                ------------------------------                         *
*                                                                       *
*   Developed by the Nuprl group, Department of Computer Science,       *
*   Cornell University, Ithaca NY.  See the release notes for a list    *
*   of the members of the group.                                        *
*                                                                       *
*   Permission is granted to use and modify Nuprl provided this notice  *
*   is retained in derived works.                                       *
*                                                                       *
*                                                                       *
*************************************************************************
%

%[
****************************************************************************
****************************************************************************
MODULE-TACTICS-2.ml
****************************************************************************
****************************************************************************
Functions for creating new modules.

Usage:

Assume we want to create a new module with opid <opid>.

1. Create ml library object with name create_<opid>

2. Insert in object an application of the create_module ML function.

  create_module
    opid     (: tok)
    short_id (: tok)
    [x1,A1;...;xm,Am]     (: (var # term) list)
    [lab1,B1;...;labn,Bn] (: (var # term) list)
    U  (: term)
  ;;

  The short_id is used to prefix the module slot accessor functions.
  xi are parameters to the module and Ai are their types.
  lab1...labn are the slot names, and B1 are the slot types/propositions.
  U should be the universe which the dependent product inhabits. (NB: it
  will depend on level vars in the Bs and the As.)

3. Check the ML object. (Usually happens automatically on object exit)


On checking the ML object, the various module objects will be automatically
added to the library at a position just before the create_<opid> object,
assuming that they don't already exist. If they do exist, the create_module
function records some information on the module structure. For this
reason, the create_<opid> ML object should not be deleted.
]%

% Creates term which selects mth item from n-tuple tup. %

let mk_tuple_select_term tup n m =
  if n = 1 then tup
  else
  letrec f addr t = 
     if null addr then t
     else 
     let k.addr' = addr 
     in 
     if k = 1 then
       mk_simple_term `pi1` [f addr' t]
     else
       mk_simple_term `pi2` [f addr' t]
  in
  let addr = (m = n => [] | [1]) @ replicate 2 (m-1) 
  in f addr tup
;;

let create_module_aux
  opid
  pi_opids
  x_A_prs   % parameters %
  v_T_prs
  U_tm
  = 
 
  let n = length v_T_prs 
  in let vs,Ts = unzip v_T_prs
  in let xs,As = unzip x_A_prs
  in let v_T_prs',[(),lastT] = split (n-1) v_T_prs
  in let modtype = mk_iterated_product v_T_prs' lastT
  in let le_vars = level_vars modtype
  in let ab_tm = 
    mk_term
      (opid,(map (mk_level_exp_parm o mk_var_level_exp) le_vars))
      (map (\x.[],mk_var_term x) xs)
  
  in let modv = maybe_new_var (mkv (hd (explode opid))) (xs @ vs)
  in let modv_tm = mk_var_term modv

  in let pi_ab_tms = 
    map (\opid.mk_simple_term opid [modv_tm]) pi_opids
  in let pi_tms = 
    map (\i. mk_tuple_select_term modv_tm n i) (upto 1 n)
  in let pi_sub = zip vs pi_ab_tms
  in let pi_types = map (subst pi_sub) Ts
  in let pi_wf_thms = 
   map2
     (\t T.
        mk_iterated_all
          x_A_prs
          (mk_all_term modv ab_tm
             (mk_member_term T t)
          )
     )
     pi_ab_tms
     pi_types

  in let ab_wf_thm = mk_iterated_all x_A_prs (mk_member_term U_tm ab_tm)
  in
    ab_tm
    ,modtype
    ,ab_wf_thm
    ,zip pi_opids (zip vs (zip pi_ab_tms (zip pi_tms pi_wf_thms)))
;;

let ModulePiTac (n:int) pi_ids p = 
  Try
  ( UnivCD
    THENM RepeatFor (n-1) (D (-1))
    THENM 
    (Unfolds pi_ids 0 THEN AbReduce 0) 
    THEN Auto
  )
  p
;;

%
Reduction management:

Want to have AbRedexC handle instances of the projection functions
applied to tuples, or abstractions wrapped around tuples. 
%

let ModulePiC pi_opid = 
  IfC 
    (\e t. is_term pi_opid t)
    ( SubC 
        (RepeatC UnfoldTopAbC
         ANDTHENC IfC (\e t. is_term `pair` t) IdC
        )
     ANDTHENC UnfoldTopAbC
     ANDTHENC SweepUpC (pi1_evalC_bo ORELSEC pi2_evalC_bo)
    )
;;

let ForceModulePiC pi_opid F = 
    IfC 
      (\e t. is_term pi_opid t)
      ( SubC 
          (IfC (\e t. red_str_geq F (get_reduction_strength (opid_of_term t)))
            (RepeatC UnfoldTopAbC
             ANDTHENC IfC (\e t. is_term `pair` t) IdC
            )
          )
       ANDTHENC UnfoldTopAbC
       ANDTHENC SweepUpC (pi1_evalC_bo ORELSEC pi2_evalC_bo)
      )
;;

let ForceModulePiC_o pi_oid F = 
    IfC 
      (\e t. is_term_o pi_oid t)
      ( SubC 
          (IfC (\e t. red_str_geq F (get_reduction_strength (opid_of_term t)))
            (RepeatC UnfoldTopAbC
             ANDTHENC IfC (\e t. is_term `pair` t) IdC
            )
          )
       ANDTHENC UnfoldTopAbC
       ANDTHENC SweepUpC (pi1_evalC_bo ORELSEC pi2_evalC_bo)
      )
;;

%
let create_and_check_thm_obj p obname position = 
  create_object_nr obname "thm" position
  ; insert_proof_in_thm_object p (string_to_tok obname)
  ; check_object_nr obname
;;
%


let mk_force_reduce_adds opid toks args =
 mk_term (`force_reduce_adds`, [mk_token_parm opid])
  [ [], indicate_insert_object_id (mk_term (`!oid`, []) [])
  ; [], (mk_tok_func_alist_term toks args)
  ]
;;

let mk_ForceModulePiC_let pi_opid =
 let pi_opids = undash_string (tok_to_string pi_opid) in
 let pioid = abstraction_lookup_by_name pi_opid in 
 let funcs = ("ForceModulePiC" J pi_opids) in
  funcs,
     mk_func_def_term funcs
       [ itext_term "ForceModulePiC_o (ioid "
       ; (ioid_term pioid)
       ; itext_term ")"]
;;


let build_ForceModulePiC_updates opid pi_opids =
 let upds, letts = unzip (map mk_ForceModulePiC_let pi_opids) in
  let lets_term =
   mk_text_seq `!text_cons`
     (flatten (map (\lets. [lets;  newline_term]) letts)) in

 let upds_term = mk_force_reduce_adds opid pi_opids upds in

  mk_defs_updates_content ((tok_to_string opid) J "_ForceModulePiC_conv")
   lets_term upds_term
;;
 
let create_module_content oacc opid short_id
	  x_A_prs   % parameters %
	  v_T_prs
	  U_tm
  = 
  let field_names = map (var_to_tok o fst) v_T_prs
  in let short_id' = short_id ^ `_`
  in let pi_opids = map (\fn.short_id' ^ fn) field_names
  in

  let ab_tm, modtype, ab_wf_thm, id_v_lhs_rhs_wfthm_quints = 
    create_module_aux opid pi_opids
      x_A_prs   % parameters %
      v_T_prs
      U_tm in
  
   let mk_pi_df_lhs v lhs_tm = 
    mk_df_format_list
      [mk_df_slot_format
         (tok_to_string (var_to_tok (dest_var (subterm_of_term lhs_tm 1))))
         (tok_to_string short_id) 
         "E"
      ;
       mk_text_term ("." J tok_to_string (var_to_tok v))
      ]

  in let short_id' = short_id ^ `_`
  in let pi_ids_str = 
    mk_string_list 
      "[]" 
      "``" 
      " " 
      "``" 
      (map (tok_to_string o fst) id_v_lhs_rhs_wfthm_quints)

  in
   letrec create_pi_objs oacc quints =
    if null quints then oacc else
    let (opid',v,lhs_tm,rhs_tm,wfgoal) = hd quints in
    let disp_obj_term = 
      mk_df_def_list 
        [mk_dform_def_term
           (tok_to_string opid')
           (mk_pi_df_lhs v lhs_tm)
           (mk_df_rhs_for_term lhs_tm)
        ]

    in
    create_pi_objs
     (call_oacc oacc
      [ create_disp_obj_data disp_obj_term (tok_to_string opid' J "_df")
      ; create_ab_content_for_new_def lhs_tm rhs_tm (tok_to_string opid')
      ; create_thm_obj_data wfgoal
         (itext_term
	    (concatenate_strings
	           ["ModulePiTac "
	           ;int_to_string (length v_T_prs)
	           ;" "
	           ;pi_ids_str
	           ]))
           (tok_to_string opid' J "_wf")
       ])
    (tl quints)

  in
  call_oacc 
   (create_pi_objs 
    (call_oacc oacc
          [ create_disp_content_for_new_def  ab_tm  (tok_to_string opid J "_df") (tok_to_string opid)
	    ; create_ab_content_for_new_def ab_tm modtype (tok_to_string opid) 
	    ; create_thm_obj_data ab_wf_thm
	       (itext_term
	        (concatenate_strings
	          ["Unfold `"
	          ;tok_to_string opid
	          ;"` 0 THEN Auto"
	          ]))
	       (tok_to_string opid J "_wf")
	     ])
     id_v_lhs_rhs_wfthm_quints)
   (build_ForceModulePiC_updates
    short_id pi_opids)
;;      
