%
*************************************************************************
*                                                                       *
*    Copyrighted Cornell University 2000                                *
*                                                                       *
*                                                                       *
*                Nuprl Proof Development System                         *
*                ------------------------------                         *
*                                                                       *
*   Developed by the Nuprl group, Department of Computer Science,       *
*   Cornell University, Ithaca NY.  See the release notes for a list    *
*   of the members of the group.                                        *
*                                                                       *
*   Permission is granted to use and modify Nuprl provided this notice  *
*   is retained in derived works.                                       *
*                                                                       *
*                                                                       *
*************************************************************************
%

%
| This rewrite performs a substitution on the current term.
| Use is as follows:
|     term 'a'
|     RW (SqSubstWithTacC 'A ~ B' tac)
|        1. .... >> a ~ b
|                   (By tac)
|               ....
|
|        2. b
|
|     In the substitution, the A must be a pattern matching a.  The pattern
|     is unified to produce b.
%
let (SqSubstWithTacC: term -> tactic -> convn) A_sim_B tac e a =
    let A, B = dest_sqequal A_sim_B ?
	failwith `SqSubstWithTacC: substitution must use an equality of the form A ~ B`
    in
    let sub = match (free_vars A) A a ?
	failwith `SqSubstWithTacC: substitution pattern does not match`
    in
    let b = subst sub B in
    let b' = mk_tag_term 1 b in
        b,
	sqequal_reln,
	form_comp_seq_just ((NOP, a, []). (SQEQUAL, b', [tac]). [NOP, b, []]);;

let SqSubstC A_sim_B = SqSubstWithTacC A_sim_B Id;;

%
| No matching.
%
let SqReplaceWithTacC b tac e a =
    let b' = mk_tag_term 1 b in
	b,
	sqequal_reln,
	form_comp_seq_just ((NOP, a, []). (SQEQUAL, b', [tac]). [NOP, b, []]);;

let SqReplaceC b = SqReplaceWithTacC b Id;;
