
%
*************************************************************
Sqequal Justifications
*************************************************************

A sqequal justification is a representation of a tactic that
proves that two terms are squequal.
The three forms that such a proof can take are:
1. The two terms are identical, so the proof is trivial (SqEqRefexive)
2. A tactic proves that they are squequal
3. The two terms have the same op, parameters, and arity, so by the sqequal
   rule, it's enough to prove that the subterms are sqequal.
   So a list of sqequal justifications represents this case.

The reason that we need sqequal justifications is that
although the compute sequence justifications allows SQEQUAL steps,
the tactics in the justification that prove the sqequal relation have to
work without any of the original hypotheses.
For example, with a sequent like
1. a ~ b
|- f(a)

We would like the tactic RW (AssertThenC (NthHyp 1) (a~b)) 0
to rewrite the conclusion to f(b).
If we use a compute sequence justification for the AssertThenC, then
this fails because the original hypothesis 1 is not available to the
tactic in the compute sequence.

If we use a tactic justification for the AssertThenC, then the above example
works as intended. But using the tactic justification has another problem
that we hope to solve by using the sqequal justification.
If we have
1. x : T
2. a ~ b
3. c ~ d
|- all x:T foo(a,c,x)

Then if we try RW (SubC 1 ((SubC 1 (AssertThenC (NthHyp 2) (a~b)) ANDTHENC
                          (SubC 2 (AssertThenC (NthHyp 3) (c~d))) 0
we want to rewrite the conclusion to
|- all x:T foo(b,d,x)
and generate no other well formedness subgoals.

But in fact, the justification that is built will fail.
It will try to prove (all x:T foo(a,c,x)) ~ (all x:T foo(b,d,x)).
The first step (corresponding to the first SubC 1) will use EqCD to
take off the (all x), and since there is already an x declared, the new
x will be renamed, so the subgoals are T~T and foo(a,c,x2)~foo(b,d,x2).
Then second of these subgoals, is justified by a transitivity step that
comes from the ANDTHENC, and it inserts the intermediate term foo(b,c,x),
which leave subgoals foo(a,c,x2)~foo(b,c,x) and foo(b,c,x)~boo(b,d,x).
Then the justifications from the interior SubC's decompose these goals
into a~b, c~c, x2~x,  and  b~b, c~d, x~x. All of these are proved as
computed in the justification except for x2~x. This goal results from
the renaming of the bound variable and the fact that the conversions
can't anticipate this renaming when building the ANDTHENC transitivity step.
two rewrite steps by Asserting foo(a,c,x) ~ foo(b,c,x)


Now, using the sqequal justifications, this same example will work as follows.
Let idj be the sqequal justification for identical terms, and sq(T) be
the tactic sqequal justification, and [sq1; ...; sqn] be the list form.

Then the justification for foo(a,c,x) ~ foo(b,c,x) will be
[sq(NthHyp 2);idj;idj] 
and the justification for foo(b,c,x) ~ foo(b,d,x) will be
[idj;sq(NthHyp 3);idj]

When ANDTHENC performs the transitivity step, it will check for the case
when both justifications being chaine together are list forms, and it
will recursively chain the corresponding subterm justifications.
Also, as will happen in the example, chaining idj with another 
sqequal justification, s, results in s.

So, the justification for foo(a,c,x) ~ foo(b,d,x) will be
[sq(NthHyp 2);sq(NthHyp 3);idj]

and the justification for (all x:T. foo(a,c,x)) ~ (all x:T. foo(b,d,x))
will be
[idj; [sq(NthHyp 2);sq(NthHyp 3);idj] ]

To execute such a justification, we merely interpret idj as SqEq_Reflexive
and sq(T) as T, and [sq1;...;sqn] as SqEqCD THENL [interp sq1;...; interp sqn].

So the proof of our example becomes:
SqEqCD THENL [SqEq_Reflexive; SqEqCD THENL [NthHyp 2; NthHyp 3; SqEq_Reflexive]]

and this can easily be seen to work.
*************************************************************
%

absrectype sqjust = 
  unit + (tactic + sqjust list)
with mk_id_sqjust = abs_sqjust (inl ())
and  is_id_sqjust sq = isl (rep_sqjust sq)
and  mk_tactic_sqjust t = abs_sqjust (inr (inl t))
and  is_tactic_sqjust sq = isr (rep_sqjust sq) & isl (outr (rep_sqjust sq))
and  tactic_of_sqjust sq = outl (outr (rep_sqjust sq))
and  mk_list_sqjust sqs = abs_sqjust (inr (inr sqs))
and  is_list_sqjust sq = isr (rep_sqjust sq) & isr (outr (rep_sqjust sq))
and  list_of_sqjust sq = outr (outr (rep_sqjust sq))
;;

letrec ExecuteSqJust sq = 
  if is_id_sqjust sq then
    SqEq_Reflexive
 else if is_tactic_sqjust sq then
    tactic_of_sqjust sq
 else
    SqEqCD THENL (map ExecuteSqJust (list_of_sqjust sq))
;;

let SqEqInterpolation t p =
  let v = new_proof_var `z' p in
  let goal = concl p in
  let a, b = dest_sqequal goal in
  (Refine `sqequalSubstitution`
                 [mk_term_arg (mk_sqequal_term a t) ;
                  mk_var_arg v;
                  mk_term_arg (mk_sqequal_term (mk_var_term v) b)]
  ) p
;; 

letrec chain_sqjusts sq1 sq2 interp = 
  if is_id_sqjust sq1 then sq2
  else if is_id_sqjust sq2 then sq1
  else if is_list_sqjust sq1 & is_list_sqjust sq2 then
    mk_list_sqjust (map3 chain_sqjusts 
                   (list_of_sqjust sq1)
                   (list_of_sqjust sq2)
                   (subterms interp)
                   )
 else
    mk_tactic_sqjust ( SqEqInterpolation interp THENL
                       [ExecuteSqJust sq1; ExecuteSqJust sq2])
;;
