/*
 * Decompiled with CFR 0.152.
 */
package Lambda;

import Lambda.Function;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.regex.Pattern;

public class Library {
    private LinkedList lib = new LinkedList();

    public Library() {
        this.lib.clear();
    }

    public void loadFromFile(String filename) {
        Pattern p = Pattern.compile("[|]");
        String newName = new String();
        try {
            File inputFile = new File(filename);
            FileReader fr = new FileReader(inputFile);
            BufferedReader br = new BufferedReader(fr);
            String line = br.readLine();
            while (line != null) {
                String[] newFunction = p.split(line);
                this.addFunction(new Function(newFunction[0], Integer.parseInt(newFunction[1]), newFunction[2], newFunction[3]));
                line = br.readLine();
            }
            br.close();
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            System.out.println("Aufruf mit");
            System.out.println(" java j2h name");
            System.out.println("erzeugt aus einer Datei name.java");
            System.out.println("eine Datei name.html");
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("Habe gefangen: " + fnfe);
        }
        catch (IOException ioe) {
            System.out.println("Habe gefangen: " + ioe);
        }
    }

    public void saveToFile(String filename) {
        String newline = System.getProperty("line.separator");
        try {
            File outputFile = new File(filename);
            FileWriter fw = new FileWriter(outputFile);
            BufferedWriter bw = new BufferedWriter(fw);
            int i = 0;
            while (i < this.countFunction()) {
                bw.write(String.valueOf(this.getFunction(i).getName()) + "|" + this.getFunction(i).countArgs() + "|" + this.getFunction(i).getLambdaExp() + "|" + this.getFunction(i).getDescription() + "|" + newline);
                ++i;
            }
            bw.close();
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            System.out.println("Array Error!");
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("Catch Error: " + fnfe);
        }
        catch (IOException ioe) {
            System.out.println("Catch Error: " + ioe);
        }
    }

    public void addFunction(Function newFunction) {
        this.lib.add(newFunction);
    }

    public void removeFunction(int i) {
        this.lib.remove(i);
    }

    public Function getFunction(int i) {
        return (Function)this.lib.get(i);
    }

    public int countFunction() {
        return this.lib.size();
    }
}

