/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.XPCOMObject;
import org.eclipse.swt.internal.mozilla.nsIBaseWindow;
import org.eclipse.swt.internal.mozilla.nsID;
import org.eclipse.swt.internal.mozilla.nsISupports;
import org.eclipse.swt.internal.mozilla.nsIWebBrowser;
import org.eclipse.swt.internal.mozilla.nsIWebBrowserChrome;
import org.eclipse.swt.internal.mozilla.nsIWindowCreator;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

class WindowCreator {
    XPCOMObject supports;
    XPCOMObject windowCreator;
    int refCount = 0;

    public WindowCreator() {
        this.createCOMInterfaces();
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        int[] nArray = new int[3];
        nArray[0] = 2;
        this.supports = new XPCOMObject(nArray){

            public int method0(int[] args) {
                return WindowCreator.this.queryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return WindowCreator.this.AddRef();
            }

            public int method2(int[] args) {
                return WindowCreator.this.Release();
            }
        };
        int[] nArray2 = new int[4];
        nArray2[0] = 2;
        nArray2[3] = 3;
        this.windowCreator = new XPCOMObject(nArray2){

            public int method0(int[] args) {
                return WindowCreator.this.queryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return WindowCreator.this.AddRef();
            }

            public int method2(int[] args) {
                return WindowCreator.this.Release();
            }

            public int method3(int[] args) {
                return WindowCreator.this.CreateChromeWindow(args[0], args[1], args[2]);
            }
        };
    }

    void disposeCOMInterfaces() {
        if (this.supports != null) {
            this.supports.dispose();
            this.supports = null;
        }
        if (this.windowCreator != null) {
            this.windowCreator.dispose();
            this.windowCreator = null;
        }
    }

    int getAddress() {
        return this.windowCreator.getAddress();
    }

    int queryInterface(int riid, int ppvObject) {
        if (riid == 0 || ppvObject == 0) {
            return -2147467262;
        }
        nsID guid = new nsID();
        XPCOM.memmove((nsID)guid, (int)riid, (int)16);
        if (guid.Equals(nsISupports.NS_ISUPPORTS_IID)) {
            XPCOM.memmove((int)ppvObject, (int[])new int[]{this.supports.getAddress()}, (int)4);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(nsIWindowCreator.NS_IWINDOWCREATOR_IID)) {
            XPCOM.memmove((int)ppvObject, (int[])new int[]{this.windowCreator.getAddress()}, (int)4);
            this.AddRef();
            return 0;
        }
        XPCOM.memmove((int)ppvObject, (int[])new int[1], (int)4);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    int CreateChromeWindow(int parent, int chromeFlags, int _retval) {
        Browser browser;
        int[] result;
        nsIWebBrowser webBrowser;
        if (parent == 0) {
            return -2147467263;
        }
        nsIWebBrowserChrome browserChromeParent = new nsIWebBrowserChrome(parent);
        int[] aWebBrowser = new int[1];
        int rc = browserChromeParent.GetWebBrowser(aWebBrowser);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (aWebBrowser[0] == 0) {
            Browser.error(-2147467262);
        }
        if ((rc = (webBrowser = new nsIWebBrowser(aWebBrowser[0])).QueryInterface(nsIBaseWindow.NS_IBASEWINDOW_IID, result = new int[1])) != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0) {
            Browser.error(-2147467262);
        }
        webBrowser.Release();
        nsIBaseWindow baseWindow = new nsIBaseWindow(result[0]);
        result[0] = 0;
        int[] aParentNativeWindow = new int[1];
        rc = baseWindow.GetParentNativeWindow(aParentNativeWindow);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (aParentNativeWindow[0] == 0) {
            Browser.error(-2147467262);
        }
        baseWindow.Release();
        Display display = Display.getCurrent();
        Browser src = Browser.findBrowser(aParentNativeWindow[0]);
        boolean doit = false;
        if ((chromeFlags & 0x20000000) != 0) {
            final Shell shell = new Shell(src.getShell(), 67680);
            shell.setLayout(new FillLayout());
            browser = new Browser(shell, 0);
            browser.addVisibilityWindowListener(new VisibilityWindowListener(){

                public void hide(WindowEvent event) {
                }

                public void show(WindowEvent event) {
                    if (event.location != null) {
                        shell.setLocation(event.location);
                    }
                    if (event.size != null) {
                        Point size = event.size;
                        shell.setSize(shell.computeSize(size.x, size.y));
                    }
                    shell.open();
                }
            });
            browser.addCloseWindowListener(new CloseWindowListener(){

                public void close(WindowEvent event) {
                    shell.close();
                }
            });
            doit = true;
        } else {
            WindowEvent event = new WindowEvent(src);
            event.display = display;
            event.widget = src;
            int i = 0;
            while (i < src.openWindowListeners.length) {
                src.openWindowListeners[i].open(event);
                ++i;
            }
            browser = event.browser;
            boolean bl = doit = browser != null && !browser.isDisposed();
        }
        if (doit) {
            int address = browser.webBrowserChrome.getAddress();
            nsIWebBrowserChrome webBrowserChrome = new nsIWebBrowserChrome(address);
            webBrowserChrome.AddRef();
            XPCOM.memmove((int)_retval, (int[])new int[]{address}, (int)4);
        }
        return doit ? 0 : -2147467263;
    }
}

