/*
 * Decompiled with CFR 0.152.
 */
package Lambda;

import Lambda.Conversion;
import Lambda.Expression;
import Source.MainForm;
import java.util.LinkedList;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

public class Term
implements Expression {
    private LinkedList variables = new LinkedList();
    private LinkedList lambdaTerms = new LinkedList();
    private LinkedList lambdaArgs = new LinkedList();
    private String atom = new String();
    private Term parent;
    private final String lambdaSign = "\u03bb";

    public Term(Term newparent) {
        this.variables.clear();
        this.lambdaTerms.clear();
        this.lambdaArgs.clear();
        this.parent = newparent;
    }

    public Term getParent() {
        return this.parent;
    }

    public String toString() {
        String varString = "";
        String termString = "";
        String argString = "";
        int i = 0;
        while (i < this.countVar()) {
            varString = String.valueOf(varString) + "\u03bb" + this.getVar(i) + ".";
            ++i;
        }
        i = 0;
        while (i < this.countTerm()) {
            String space = i == 0 ? "" : " ";
            termString = String.valueOf(termString) + space + this.getTerm(i).toString();
            ++i;
        }
        i = 0;
        while (i < this.countArg()) {
            argString = String.valueOf(argString) + " " + this.getArg(i).toString();
            ++i;
        }
        String result = this.countArg() == 0 && this.getParent() == null ? String.valueOf(varString) + termString : "(" + varString + termString + ")" + argString;
        return result;
    }

    public void toComposite(Composite composite) {
        String varString = "";
        String termString = "";
        String argString = "";
        Label leftBorder = null;
        Label rightBorder = null;
        if (this.countArg() != 0 || this.getParent() != null) {
            leftBorder = new Label(composite, 0);
            leftBorder.setText("(");
            leftBorder.setData(this);
            leftBorder.addMouseTrackListener(new MouseTrackAdapter(){

                public void mouseEnter(MouseEvent e) {
                    Term myTerm = (Term)((Label)e.widget).getData();
                    Label Border = (Label)e.widget;
                    if (Border != null) {
                        Border.setToolTipText(myTerm.getToolTip());
                    }
                }
            });
        }
        int i = 0;
        while (i < this.variables.size()) {
            varString = String.valueOf(varString) + "\u03bb" + this.variables.get(i) + ".";
            ++i;
        }
        Label lblVar = new Label(composite, 0);
        lblVar.setText(varString);
        if (this.countArg() != 0 || this.getParent() != null) {
            lblVar.setData(this);
            lblVar.setData("leftBorder", leftBorder);
            lblVar.addMouseListener(new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    MainForm.saveLastInteractiveTerm();
                    Term myTerm = (Term)((Label)e.widget).getData();
                    Conversion.beta(myTerm);
                    MainForm.buildInteractiveTerm();
                }
            });
            lblVar.addMouseTrackListener(new MouseTrackAdapter(){

                public void mouseExit(MouseEvent e) {
                    Label varLabel = (Label)e.widget;
                    Label leftBorder = (Label)varLabel.getData("leftBorder");
                    Label rightBorder = (Label)varLabel.getData("rightBorder");
                    if (leftBorder != null && varLabel != null && rightBorder != null) {
                        varLabel.setForeground(new Color(Display.getDefault(), 0, 0, 0));
                        leftBorder.setForeground(new Color(Display.getDefault(), 0, 0, 0));
                        rightBorder.setForeground(new Color(Display.getDefault(), 0, 0, 0));
                        leftBorder.setFont(new Font(Display.getDefault(), "Lucida Grande", 8, 0));
                        rightBorder.setFont(new Font(Display.getDefault(), "Lucida Grande", 8, 0));
                    }
                }

                public void mouseEnter(MouseEvent e) {
                    Term myTerm = (Term)((Label)e.widget).getData();
                    Label varLabel = (Label)e.widget;
                    Label leftBorder = (Label)varLabel.getData("leftBorder");
                    Label rightBorder = (Label)varLabel.getData("rightBorder");
                    if (leftBorder != null && varLabel != null && rightBorder != null) {
                        varLabel.setToolTipText(myTerm.getToolTip());
                        varLabel.setForeground(new Color(Display.getDefault(), 255, 0, 0));
                        leftBorder.setForeground(new Color(Display.getDefault(), 255, 0, 0));
                        rightBorder.setForeground(new Color(Display.getDefault(), 255, 0, 0));
                        leftBorder.setFont(new Font(Display.getDefault(), "Lucida Grande", 10, 1));
                        rightBorder.setFont(new Font(Display.getDefault(), "Lucida Grande", 10, 1));
                    }
                }
            });
        }
        i = 0;
        while (i < this.lambdaTerms.size()) {
            ((Expression)this.lambdaTerms.get(i)).toComposite(composite);
            ++i;
        }
        if (this.countArg() != 0 || this.getParent() != null) {
            rightBorder = new Label(composite, 0);
            rightBorder.setText(")");
            rightBorder.setData(this);
            rightBorder.addMouseTrackListener(new MouseTrackAdapter(){

                public void mouseEnter(MouseEvent e) {
                    Term myTerm = (Term)((Label)e.widget).getData();
                    Label Border = (Label)e.widget;
                    if (Border != null) {
                        Border.setToolTipText(myTerm.getToolTip());
                    }
                }
            });
        }
        lblVar.setData("rightBorder", rightBorder);
        i = 0;
        while (i < this.lambdaArgs.size()) {
            ((Expression)this.lambdaArgs.get(i)).toComposite(composite);
            ++i;
        }
        composite.pack();
    }

    public Expression replaceExp(String oldAtom, Expression newExp) {
        boolean localVar = false;
        boolean term2arg = false;
        boolean change = false;
        int i = 0;
        while (i < this.countVar()) {
            if (this.getVar(i).compareTo(oldAtom) == 0) {
                localVar = true;
            }
            ++i;
        }
        if (!localVar) {
            i = 0;
            while (i < this.countTerm()) {
                this.lambdaTerms.set(i, this.getTerm(i).replaceExp(oldAtom, newExp));
                ++i;
            }
        }
        return this;
    }

    public void addVar(String variable) {
        this.variables.add(variable);
    }

    public void addTerm(Expression exp) {
        exp.setParent(this);
        this.lambdaTerms.add(exp);
    }

    public void addArg(Expression exp) {
        exp.setParent(this);
        this.lambdaArgs.add(exp);
    }

    public int countVar() {
        return this.variables.size();
    }

    public int countTerm() {
        return this.lambdaTerms.size();
    }

    public int countArg() {
        return this.lambdaArgs.size();
    }

    public String removeVar(int i) {
        return (String)this.variables.remove(i);
    }

    public Expression removeTerm(int i) {
        return (Expression)this.lambdaTerms.remove(i);
    }

    public Expression removeArg(int i) {
        return (Expression)this.lambdaArgs.remove(i);
    }

    public String getVar(int i) {
        return (String)this.variables.get(i);
    }

    public Expression getTerm(int i) {
        return (Expression)this.lambdaTerms.get(i);
    }

    public Expression getArg(int i) {
        return (Expression)this.lambdaArgs.get(i);
    }

    public void setParent(Term newParent) {
        this.parent = newParent;
    }

    public Expression getCopy(Term newParent) {
        Term myCopy = new Term(newParent);
        int i = 0;
        while (i < this.countVar()) {
            myCopy.addVar(this.getVar(i));
            ++i;
        }
        i = 0;
        while (i < this.countTerm()) {
            myCopy.addTerm(this.getTerm(i).getCopy(myCopy));
            ++i;
        }
        i = 0;
        while (i < this.countArg()) {
            myCopy.addArg(this.getArg(i).getCopy(myCopy));
            ++i;
        }
        return myCopy;
    }

    public int getPosition() {
        int i = 0;
        while (i < this.parent.countTerm() && this.parent.getTerm(i) != this) {
            ++i;
        }
        if (i == this.parent.countTerm()) {
            return -1;
        }
        return i;
    }

    public String getToolTip() {
        String myString = "Term: " + this.toString() + "\nCount Variables: " + this.countVar() + "\nCount Terms: " + this.countTerm() + "\nCount Arguments: " + this.countArg();
        if (this.getParent() != null) {
            myString = String.valueOf(myString) + "\nParent-Term: " + this.getParent().toString() + "\nPosition: " + (this.getPosition() + 1);
        }
        return myString;
    }
}

