/*
 * Decompiled with CFR 0.152.
 */
package Source;

import Lambda.Conversion;
import Lambda.Expression;
import Lambda.Function;
import Lambda.Library;
import Lambda.Parser;
import Lambda.Term;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class MainForm {
    private static Display display = null;
    private Shell sShell = null;
    private Shell functionShell = null;
    private Shell aboutBoxShell = null;
    private Label labelInputLambda = null;
    private Label labelCurrentLambda = null;
    private Text textInputLambda = null;
    private ToolBar toolBar = null;
    private MenuItem menuItemDescription = null;
    private static Composite currentLambda = null;
    private static List termList = null;
    private List libList = null;
    public static Term fullWorkTerm = null;
    public static Term lastFullWorkTerm = null;
    private Library myLib = null;
    private final String standardLibrary = "standard.lib";
    private final int maxAutoSteps = 10000;
    private final String version = "0.83";

    public static void main(String[] args) {
        System.setProperty("java.library.path", System.getProperty("user.dir"));
        Display display = Display.getDefault();
        MainForm thisClass = new MainForm();
        thisClass.createSShell();
        thisClass.sShell.open();
        while (!thisClass.sShell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private boolean parseInput() {
        termList.removeAll();
        Parser p = new Parser();
        fullWorkTerm = p.strToTerm(this.textInputLambda.getText(), this.myLib);
        if (fullWorkTerm != null) {
            return true;
        }
        switch (Parser.getLastError()) {
            case 0: {
                this.showErrorBox(this.sShell, "Unknown Error");
                break;
            }
            case -1: {
                this.showErrorBox(this.sShell, "PreparseError: Unknown Expressions in use (Library entry not found)");
                break;
            }
            case -2: {
                this.showErrorBox(this.sShell, "PreparseError: Unknown Error");
                break;
            }
            case 1: {
                this.showErrorBox(this.sShell, "ParseError: Expression have to start with '('");
                break;
            }
            case 2: {
                this.showErrorBox(this.sShell, "ParseError: Wrong Parenthesis");
                break;
            }
            case 3: {
                this.showErrorBox(this.sShell, "ParseError: Wrong Parenthesis");
                break;
            }
            case 4: {
                this.showErrorBox(this.sShell, "ParseError: Expression ending expected");
                break;
            }
            case 5: {
                this.showErrorBox(this.sShell, "ParseError: Add Term or Variables");
                break;
            }
            case 6: {
                this.showErrorBox(this.sShell, "ParseError: Dot or Space between and behind variables expected");
                break;
            }
            case 7: {
                this.showErrorBox(this.sShell, "ParseError: Space expected");
                break;
            }
            case 8: {
                this.showErrorBox(this.sShell, "ParseError: Replace '#' with real Arguments");
                break;
            }
            case 9: {
                this.showErrorBox(this.sShell, "ParseError: Wrong parenthesis in Argument-List");
                break;
            }
            case 10: {
                this.showErrorBox(this.sShell, "ParseError: Unexpected Token");
                break;
            }
            case 11: {
                this.showErrorBox(this.sShell, "Please enter a Term");
            }
        }
        return false;
    }

    private void showErrorBox(Shell myShell, String errorMsg) {
        MessageBox mb = new MessageBox(myShell, 1);
        mb.setMessage(errorMsg);
        mb.setText("LambdaRed Error");
        mb.open();
    }

    public static void placeDialogInCenter(Shell parent, Shell shell) {
        Rectangle parentSize = parent.getBounds();
        Rectangle mySize = shell.getBounds();
        int locationX = (parentSize.width - mySize.width) / 2 + parentSize.x;
        int locationY = (parentSize.height - mySize.height) / 2 + parentSize.y;
        shell.setLocation(new Point(locationX, locationY));
    }

    private boolean editFunction(final Function myFunction) {
        this.functionShell = new Shell(67680);
        this.functionShell.setSize(new Point(640, 480));
        GridLayout gridLayoutFunction = new GridLayout();
        gridLayoutFunction.numColumns = 2;
        gridLayoutFunction.makeColumnsEqualWidth = false;
        this.functionShell.setLayout(gridLayoutFunction);
        Label labelFunctionName = new Label(this.functionShell, 0);
        labelFunctionName.setText("Name:");
        final Text textFunctionName = new Text(this.functionShell, 2048);
        GridData gridDataFunctionName = new GridData(768);
        gridDataFunctionName.widthHint = 300;
        textFunctionName.setLayoutData(gridDataFunctionName);
        Label labelFunctionArgs = new Label(this.functionShell, 0);
        labelFunctionArgs.setText("Number of Arguments:");
        final Text textFunctionArgs = new Text(this.functionShell, 2048);
        textFunctionArgs.setLayoutData(new GridData(768));
        Label labelFunctionLambda = new Label(this.functionShell, 0);
        labelFunctionLambda.setText("Lambda-Term:");
        final Text textFunctionLambda = new Text(this.functionShell, 2048);
        textFunctionLambda.setLayoutData(new GridData(768));
        Label labelFunctionDescription = new Label(this.functionShell, 0);
        labelFunctionDescription.setText("Description:");
        final Text textFunctionDescription = new Text(this.functionShell, 2048);
        textFunctionDescription.setLayoutData(new GridData(768));
        if (myFunction != null) {
            this.functionShell.setText("Edit Function");
            textFunctionName.setText(myFunction.getName());
            textFunctionArgs.setText(String.valueOf(myFunction.countArgs()));
            textFunctionLambda.setText(myFunction.getLambdaExp());
            textFunctionDescription.setText(myFunction.getDescription());
        } else {
            this.functionShell.setText("New Function");
        }
        final Button ok = new Button(this.functionShell, 8);
        ok.setLayoutData(new GridData(768));
        ok.setText("Ok");
        Button cancel = new Button(this.functionShell, 8);
        cancel.setLayoutData(new GridData(768));
        cancel.setText("Cancel");
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == ok) {
                    try {
                        int i = Integer.parseInt(textFunctionArgs.getText());
                        if (myFunction == null) {
                            MainForm.this.myLib.addFunction(new Function(textFunctionName.getText(), i, textFunctionLambda.getText(), textFunctionDescription.getText()));
                        } else {
                            myFunction.setName(textFunctionName.getText());
                            myFunction.setCountArgs(i);
                            myFunction.setLambdaExp(textFunctionLambda.getText());
                            myFunction.setDescription(textFunctionDescription.getText());
                        }
                        MainForm.this.writeLibList();
                        MainForm.this.functionShell.close();
                    }
                    catch (NumberFormatException error) {
                        MainForm.this.showErrorBox(MainForm.this.functionShell, "Number of Arguments has to be an Integer!");
                    }
                } else {
                    MainForm.this.functionShell.close();
                }
            }
        };
        ok.addListener(13, listener);
        cancel.addListener(13, listener);
        this.functionShell.pack();
        this.functionShell.open();
        MainForm.placeDialogInCenter(this.sShell, this.functionShell);
        return true;
    }

    private void aboutBox() {
        this.aboutBoxShell = new Shell(67680);
        this.aboutBoxShell.setText("About LambdaRed");
        GridLayout gridLayoutFunction = new GridLayout();
        gridLayoutFunction.numColumns = 1;
        gridLayoutFunction.makeColumnsEqualWidth = false;
        this.aboutBoxShell.setLayout(gridLayoutFunction);
        Label labelLine1 = new Label(this.aboutBoxShell, 0);
        labelLine1.setText("LambdaRed");
        labelLine1.setForeground(new Color(Display.getDefault(), 255, 0, 0));
        labelLine1.setFont(new Font(Display.getDefault(), "Lucida Grande", 12, 1));
        Label labelLine2 = new Label(this.aboutBoxShell, 0);
        labelLine2.setText("TI Project 2005 by");
        Label labelLine3 = new Label(this.aboutBoxShell, 0);
        labelLine3.setText("David Sonnabend (david.sonnabend@student.hpi.uni-potsdam.de)");
        Label labelLine4 = new Label(this.aboutBoxShell, 0);
        labelLine4.setText("Lars Schneider (lars.schneider@student.hpi.uni-potsdam.de)");
        Button ok = new Button(this.aboutBoxShell, 8);
        ok.setLayoutData(new GridData(768));
        ok.setText("Ok");
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                MainForm.this.aboutBoxShell.close();
            }
        };
        ok.addListener(13, listener);
        this.aboutBoxShell.pack();
        this.aboutBoxShell.open();
        MainForm.placeDialogInCenter(this.sShell, this.aboutBoxShell);
    }

    private void startLambdaConversion() {
        if (this.parseInput()) {
            lastFullWorkTerm = null;
            MainForm.buildInteractiveTerm();
        }
    }

    private void loadLibrary(String filename) {
        this.myLib = new Library();
        this.myLib.loadFromFile(filename);
        this.writeLibList();
    }

    private void writeLibList() {
        this.libList.removeAll();
        int i = 0;
        while (i < this.myLib.countFunction()) {
            this.libList.add(this.myLib.getFunction(i).getNameArgs());
            ++i;
        }
    }

    public static void saveLastInteractiveTerm() {
        lastFullWorkTerm = (Term)fullWorkTerm.getCopy(null);
    }

    public static void buildInteractiveTerm() {
        termList.add(fullWorkTerm.toString());
        while (currentLambda.getChildren().length > 0) {
            currentLambda.getChildren()[0].dispose();
        }
        fullWorkTerm.toComposite(currentLambda);
        currentLambda.pack();
    }

    private static String replaceAll(String source, String search, String replace) {
        int nPos;
        if (search.equals(replace)) {
            return source;
        }
        StringBuffer result = new StringBuffer();
        int len = search.length();
        if (len == 0) {
            return source;
        }
        int pos = 0;
        do {
            if ((nPos = source.indexOf(search, pos)) != -1) {
                result.append(source.substring(pos, nPos));
                result.append(replace);
                pos = nPos + len;
                continue;
            }
            result.append(source.substring(pos));
        } while (nPos != -1);
        return result.toString();
    }

    public void saveConversionToFile(String filename) {
        String newline = System.getProperty("line.separator");
        try {
            File outputFile = new File(filename);
            FileWriter fw = new FileWriter(outputFile);
            BufferedWriter bw = new BufferedWriter(fw);
            int i = 0;
            while (i < termList.getItemCount()) {
                String s = MainForm.replaceAll(termList.getItem(i), "\u03bb", "\\");
                bw.write(String.valueOf(s) + newline);
                ++i;
            }
            bw.close();
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            System.out.println("Array Error!");
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("Catch Error: " + fnfe);
        }
        catch (IOException ioe) {
            System.out.println("Catch Error: " + ioe);
        }
    }

    private SelectionListener startMenuFileOpenLibrary() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileOpener = new FileDialog(MainForm.this.sShell, 4098);
                fileOpener.setText("Open Library Files...");
                fileOpener.setFilterExtensions(new String[]{"*.lib; *.txt;"});
                fileOpener.setFilterNames(new String[]{"Library Files (*.lib; *.txt)", "all (*.*)"});
                String filename = fileOpener.open();
                if (filename != null) {
                    MainForm.this.loadLibrary(String.valueOf(fileOpener.getFilterPath()) + "\\" + fileOpener.getFileName());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    private SelectionListener startMenuFileSaveLibrary() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileSaver = new FileDialog(MainForm.this.sShell, 8194);
                fileSaver.setText("Save Library Files...");
                fileSaver.setFilterExtensions(new String[]{"*.lib; *.txt;"});
                fileSaver.setFilterNames(new String[]{"Library Files (*.lib; *.txt)", "all (*.*)"});
                String filename = fileSaver.open();
                if (filename != null) {
                    MainForm.this.myLib.saveToFile(String.valueOf(fileSaver.getFilterPath()) + "\\" + fileSaver.getFileName());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    private SelectionListener startMenuFileExit() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                System.exit(0);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    private SelectionListener startMenuLibraryAddFunction() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MainForm.this.editFunction(null);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    private SelectionListener startMenuLibraryEditFunction() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int i = MainForm.this.libList.getSelectionIndex();
                if (i >= 0) {
                    MainForm.this.editFunction(MainForm.this.myLib.getFunction(i));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    private SelectionListener startMenuLibraryRemoveFunction() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int i = MainForm.this.libList.getSelectionIndex();
                if (i >= 0) {
                    MainForm.this.myLib.removeFunction(i);
                    MainForm.this.writeLibList();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    private SelectionListener startMenuLibrarySetAsDefault() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MainForm.this.myLib.saveToFile("standard.lib");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    private SelectionListener startMenuLibraryLoadDefault() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MainForm.this.loadLibrary("standard.lib");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    private SelectionListener startMenuLibraryImport() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileOpener = new FileDialog(MainForm.this.sShell, 4098);
                fileOpener.setText("Import Library Files...");
                fileOpener.setFilterExtensions(new String[]{"*.lib; *.txt;"});
                fileOpener.setFilterNames(new String[]{"Library Files (*.lib; *.txt)", "all (*.*)"});
                String filename = fileOpener.open();
                if (filename != null) {
                    Library myImportLib = new Library();
                    myImportLib.loadFromFile(filename);
                    int i = 0;
                    while (i < myImportLib.countFunction()) {
                        MainForm.this.myLib.addFunction(myImportLib.getFunction(i));
                        ++i;
                    }
                    MainForm.this.writeLibList();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    private SelectionListener startMenuLambdaConversion() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MainForm.this.startLambdaConversion();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    private SelectionListener startMenuUndoConversion() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (lastFullWorkTerm != null) {
                    fullWorkTerm = lastFullWorkTerm;
                    lastFullWorkTerm = null;
                    MainForm.buildInteractiveTerm();
                } else {
                    MainForm.this.showErrorBox(MainForm.this.sShell, "No Undo-Term available.");
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    private Expression searchForConvertableTerm(Expression checkTerm) {
        Expression result = null;
        if (checkTerm.countVar() > 0 && (checkTerm.countArg() != 0 || checkTerm.getParent() != null)) {
            result = checkTerm;
        } else if (checkTerm.countTerm() > 0) {
            int i = 0;
            while (i < checkTerm.countTerm() && result == null) {
                result = this.searchForConvertableTerm(checkTerm.getTerm(i));
                ++i;
            }
        }
        return result;
    }

    private SelectionListener startMenuLambdaConversionAuto() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (MainForm.this.parseInput()) {
                    lastFullWorkTerm = null;
                    termList.add(fullWorkTerm.toString());
                    int i = 0;
                    while (Conversion.beta(fullWorkTerm) && i < 10000) {
                        termList.add(fullWorkTerm.toString());
                        ++i;
                    }
                    Expression exp = fullWorkTerm;
                    while (exp != null && i < 10000) {
                        Conversion.beta(exp);
                        termList.add(fullWorkTerm.toString());
                        exp = MainForm.this.searchForConvertableTerm(fullWorkTerm);
                        ++i;
                    }
                    if (i == 10000) {
                        MainForm.this.showErrorBox(MainForm.this.sShell, "Maximum step count has been reached. The formula may contain mistakes.");
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    private SelectionListener startMenuLambdaConvertChurchNumeral() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int i = Conversion.churchNumeral(fullWorkTerm);
                if (i != -1) {
                    termList.add("Number: " + i);
                } else {
                    termList.add("No Church Numeral identified!");
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    private SelectionListener startMenuLambdaSaveToFile() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileSaver = new FileDialog(MainForm.this.sShell, 8194);
                fileSaver.setText("Save Conversion History...");
                fileSaver.setFilterExtensions(new String[]{"*.txt"});
                fileSaver.setFilterNames(new String[]{"Conversion History Files (*.txt)", "all (*.*)"});
                String filename = fileSaver.open();
                if (filename != null) {
                    MainForm.this.saveConversionToFile(String.valueOf(fileSaver.getFilterPath()) + "\\" + fileSaver.getFileName());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    private SelectionListener startMenuLambdaClear() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                while (currentLambda.getChildren().length > 0) {
                    currentLambda.getChildren()[0].dispose();
                }
                MainForm.this.textInputLambda.setText("");
                termList.removeAll();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    private SelectionListener startMenuAboutBox() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MainForm.this.aboutBox();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    private void createMenu() {
        Menu menu = new Menu(this.sShell, 2);
        this.sShell.setMenuBar(menu);
        MenuItem menuFileItem = new MenuItem(menu, 64);
        menuFileItem.setText("File");
        Menu menuFile = new Menu(this.sShell, 4);
        menuFileItem.setMenu(menuFile);
        MenuItem menuFileOpenLibraryBtn = new MenuItem(menuFile, 8);
        menuFileOpenLibraryBtn.setText("Open Library");
        menuFileOpenLibraryBtn.addSelectionListener(this.startMenuFileOpenLibrary());
        MenuItem menuFileSaveLibraryBtn = new MenuItem(menuFile, 8);
        menuFileSaveLibraryBtn.setText("Save Library");
        menuFileSaveLibraryBtn.addSelectionListener(this.startMenuFileSaveLibrary());
        new MenuItem(menuFile, 2);
        MenuItem menuFileExitBtn = new MenuItem(menuFile, 8);
        menuFileExitBtn.setText("Exit");
        menuFileExitBtn.addSelectionListener(this.startMenuFileExit());
        MenuItem menuLibraryItem = new MenuItem(menu, 64);
        menuLibraryItem.setText("Library");
        Menu menuLibrary = new Menu(this.sShell, 4);
        menuLibraryItem.setMenu(menuLibrary);
        MenuItem menuLibraryAddFunctionBtn = new MenuItem(menuLibrary, 8);
        menuLibraryAddFunctionBtn.setText("Add Function");
        menuLibraryAddFunctionBtn.addSelectionListener(this.startMenuLibraryAddFunction());
        MenuItem menuLibraryEditFunctionBtn = new MenuItem(menuLibrary, 8);
        menuLibraryEditFunctionBtn.setText("Edit Function");
        menuLibraryEditFunctionBtn.addSelectionListener(this.startMenuLibraryEditFunction());
        MenuItem menuLibraryRemoveFunctionBtn = new MenuItem(menuLibrary, 8);
        menuLibraryRemoveFunctionBtn.setText("Remove Function");
        menuLibraryRemoveFunctionBtn.addSelectionListener(this.startMenuLibraryRemoveFunction());
        new MenuItem(menuLibrary, 2);
        MenuItem menuLibrarySetDefaultBtn = new MenuItem(menuLibrary, 8);
        menuLibrarySetDefaultBtn.setText("Set Library as Standard");
        menuLibrarySetDefaultBtn.addSelectionListener(this.startMenuLibrarySetAsDefault());
        MenuItem menuLibraryLoadDefaultBtn = new MenuItem(menuLibrary, 8);
        menuLibraryLoadDefaultBtn.setText("Load Standard Library");
        menuLibraryLoadDefaultBtn.addSelectionListener(this.startMenuLibraryLoadDefault());
        new MenuItem(menuLibrary, 2);
        MenuItem menuLibraryImportBtn = new MenuItem(menuLibrary, 8);
        menuLibraryImportBtn.setText("Import Library");
        menuLibraryImportBtn.addSelectionListener(this.startMenuLibraryImport());
        MenuItem menuLambdaItem = new MenuItem(menu, 64);
        menuLambdaItem.setText("Lambda");
        Menu menuLambda = new Menu(this.sShell, 4);
        menuLambdaItem.setMenu(menuLambda);
        MenuItem menuLambdaStartBtn = new MenuItem(menuLambda, 8);
        menuLambdaStartBtn.setText("Start Lambda Conversion");
        menuLambdaStartBtn.addSelectionListener(this.startMenuLambdaConversion());
        MenuItem menuLambdaStartAutoBtn = new MenuItem(menuLambda, 8);
        menuLambdaStartAutoBtn.setText("Start Automatic Lambda Conversion");
        menuLambdaStartAutoBtn.addSelectionListener(this.startMenuLambdaConversion());
        new MenuItem(menuLambda, 2);
        MenuItem menuLambdaConvertChurchBtn = new MenuItem(menuLambda, 8);
        menuLambdaConvertChurchBtn.setText("Convert Church Numeral");
        menuLambdaConvertChurchBtn.addSelectionListener(this.startMenuLambdaConvertChurchNumeral());
        new MenuItem(menuLambda, 2);
        MenuItem menuLambdaSaveToFileBtn = new MenuItem(menuLambda, 8);
        menuLambdaSaveToFileBtn.setText("Save Conversion to File");
        menuLambdaSaveToFileBtn.addSelectionListener(this.startMenuLambdaSaveToFile());
        MenuItem menuLambdaClearBtn = new MenuItem(menuLambda, 8);
        menuLambdaClearBtn.setText("Clear Lambda");
        menuLambdaClearBtn.addSelectionListener(this.startMenuLambdaClear());
        MenuItem menuHelpItem = new MenuItem(menu, 64);
        menuHelpItem.setText("Help");
        Menu menuHelp = new Menu(this.sShell, 4);
        menuHelpItem.setMenu(menuHelp);
        MenuItem menuHelpAboutBtn = new MenuItem(menuHelp, 8);
        menuHelpAboutBtn.setText("About");
        menuHelpAboutBtn.addSelectionListener(this.startMenuAboutBox());
    }

    private void createToolBar() {
        this.toolBar = new ToolBar(this.sShell, 0x800100);
        ToolItem BtnOpen = new ToolItem(this.toolBar, 8);
        BtnOpen.setText(" Open ");
        BtnOpen.setToolTipText("Open Library");
        BtnOpen.addSelectionListener(this.startMenuFileOpenLibrary());
        BtnOpen.setWidth(50);
        ToolItem BtnSave = new ToolItem(this.toolBar, 8);
        BtnSave.setText(" Save ");
        BtnSave.setToolTipText("Save Library");
        BtnSave.addSelectionListener(this.startMenuFileSaveLibrary());
        ToolItem BtnGo = new ToolItem(this.toolBar, 8);
        BtnGo.setText("  Go  ");
        BtnGo.setToolTipText("Start Lambda conversion");
        BtnGo.addSelectionListener(this.startMenuLambdaConversion());
        ToolItem BtnUndo = new ToolItem(this.toolBar, 8);
        BtnUndo.setText(" Undo ");
        BtnUndo.setToolTipText("Undo a Lambda conversion");
        BtnUndo.addSelectionListener(this.startMenuUndoConversion());
        ToolItem BtnAuto = new ToolItem(this.toolBar, 8);
        BtnAuto.setText(" Auto ");
        BtnAuto.setToolTipText("Start Automatic Lambda Conversion");
        BtnAuto.addSelectionListener(this.startMenuLambdaConversionAuto());
        ToolItem BtnChurch = new ToolItem(this.toolBar, 8);
        BtnChurch.setText("Church");
        BtnChurch.setToolTipText("Convert a Church Numeral");
        BtnChurch.addSelectionListener(this.startMenuLambdaConvertChurchNumeral());
        ToolItem BtnClear = new ToolItem(this.toolBar, 8);
        BtnClear.setText("Clear");
        BtnClear.setToolTipText("Clear Lambda Input");
        BtnClear.addSelectionListener(this.startMenuLambdaClear());
        ToolItem BtnExit = new ToolItem(this.toolBar, 8);
        BtnExit.setText(" Exit ");
        BtnExit.setToolTipText("Exit LambdaRed");
        BtnExit.addSelectionListener(this.startMenuFileExit());
        GridData gridDataToolBar = new GridData(768);
        gridDataToolBar.horizontalSpan = 2;
        this.toolBar.setLayoutData(gridDataToolBar);
        BtnOpen.setImage(new Image((Device)Display.getCurrent(), this.getClass().getResourceAsStream("/Ressource/open.gif")));
        BtnSave.setImage(new Image((Device)Display.getCurrent(), this.getClass().getResourceAsStream("/Ressource/save.gif")));
        BtnGo.setImage(new Image((Device)Display.getCurrent(), this.getClass().getResourceAsStream("/Ressource/run.gif")));
        BtnUndo.setImage(new Image((Device)Display.getCurrent(), this.getClass().getResourceAsStream("/Ressource/undo.gif")));
        BtnAuto.setImage(new Image((Device)Display.getCurrent(), this.getClass().getResourceAsStream("/Ressource/auto_run.gif")));
        BtnChurch.setImage(new Image((Device)Display.getCurrent(), this.getClass().getResourceAsStream("/Ressource/convert.gif")));
        BtnClear.setImage(new Image((Device)Display.getCurrent(), this.getClass().getResourceAsStream("/Ressource/clear.gif")));
        BtnExit.setImage(new Image((Device)Display.getCurrent(), this.getClass().getResourceAsStream("/Ressource/exit.gif")));
    }

    private void createCurrentLambda() {
        currentLambda = new Composite(this.sShell, 0);
        currentLambda.setLayout(new RowLayout());
        currentLambda.setLayoutData(new GridData(2));
    }

    private void createSShell() {
        this.sShell = new Shell(3312);
        this.sShell.setText("LambdaRed - Version 0.83");
        this.sShell.setSize(new Point(640, 480));
        GridLayout gridLayoutMain = new GridLayout();
        gridLayoutMain.numColumns = 2;
        gridLayoutMain.makeColumnsEqualWidth = false;
        this.sShell.setLayout(gridLayoutMain);
        this.createMenu();
        this.createToolBar();
        this.labelInputLambda = new Label(this.sShell, 0);
        this.labelInputLambda.setText("Lambda-Ausdruck:");
        this.textInputLambda = new Text(this.sShell, 2048);
        this.textInputLambda.setLayoutData(new GridData(768));
        this.textInputLambda.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\r') {
                    MainForm.this.startLambdaConversion();
                }
            }
        });
        this.labelCurrentLambda = new Label(this.sShell, 0);
        this.labelCurrentLambda.setText("Aktueller-Ausdruck:");
        this.labelCurrentLambda.setFont(new Font(Display.getDefault(), "Lucida Grande", 10, 0));
        this.createCurrentLambda();
        this.libList = new List(this.sShell, 2304);
        this.libList.setLayoutData(new GridData(1296));
        Menu popupMenu = new Menu(this.sShell, 8);
        this.menuItemDescription = new MenuItem(popupMenu, 0);
        this.menuItemDescription.setText("<<Description>>");
        MenuItem menuItemSeperator = new MenuItem(popupMenu, 2);
        MenuItem menuItemNewFunction = new MenuItem(popupMenu, 8);
        menuItemNewFunction.setText("Add Function");
        menuItemNewFunction.addSelectionListener(this.startMenuLibraryAddFunction());
        MenuItem menuItemEditFunction = new MenuItem(popupMenu, 8);
        menuItemEditFunction.setText("Edit Function");
        menuItemEditFunction.addSelectionListener(this.startMenuLibraryEditFunction());
        MenuItem menuItemDeleteFunction = new MenuItem(popupMenu, 8);
        menuItemDeleteFunction.setText("Remove Function");
        menuItemDeleteFunction.addSelectionListener(this.startMenuLibraryRemoveFunction());
        popupMenu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
                int i = MainForm.this.libList.getSelectionIndex();
                if (i >= 0) {
                    MainForm.this.menuItemDescription.setEnabled(true);
                    MainForm.this.menuItemDescription.setText(MainForm.this.myLib.getFunction(i).getDescription());
                } else {
                    MainForm.this.menuItemDescription.setEnabled(false);
                }
            }

            public void menuHidden(MenuEvent e) {
            }
        });
        this.libList.setMenu(popupMenu);
        this.libList.addMouseListener(new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                int i;
                if (e.button == 1 && (i = MainForm.this.libList.getSelectionIndex()) >= 0) {
                    if (MainForm.this.textInputLambda.getText().compareTo("") == 0) {
                        MainForm.this.textInputLambda.insert("$" + MainForm.this.libList.getItem(i));
                    } else {
                        MainForm.this.textInputLambda.insert("($" + MainForm.this.libList.getItem(i) + ")");
                    }
                    MainForm.this.textInputLambda.setFocus();
                }
            }
        });
        this.loadLibrary("standard.lib");
        termList = new List(this.sShell, 2816);
        termList.setLayoutData(new GridData(1808));
        this.sShell.setMaximized(true);
    }
}

