/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.Visual;
import org.eclipse.swt.internal.motif.XCharStruct;
import org.eclipse.swt.internal.motif.XColor;
import org.eclipse.swt.internal.motif.XFontStruct;
import org.eclipse.swt.internal.motif.XGCValues;
import org.eclipse.swt.internal.motif.XImage;
import org.eclipse.swt.internal.motif.XRectangle;

public final class GC {
    public int handle;
    Drawable drawable;
    GCData data;

    GC() {
    }

    public GC(Drawable drawable) {
        this(drawable, 0);
    }

    public GC(Drawable drawable, int style) {
        if (drawable == null) {
            SWT.error(4);
        }
        GCData data = new GCData();
        data.style = GC.checkStyle(style);
        int xGC = drawable.internal_new_GC(data);
        Device device = data.device;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        data.device = device;
        this.init(drawable, data, xGC);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    static int checkStyle(int style) {
        if ((style & 0x2000000) != 0) {
            style &= 0xFBFFFFFF;
        }
        return style & 0x6000000;
    }

    public void copyArea(int x, int y, int width, int height, int destX, int destY) {
        boolean disjoint;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        int deltaX = destX - x;
        int deltaY = destY - y;
        if (deltaX == 0 && deltaY == 0) {
            return;
        }
        int xDisplay = this.data.display;
        int xDrawable = this.data.drawable;
        OS.XSetGraphicsExposures(xDisplay, this.handle, true);
        OS.XCopyArea(xDisplay, xDrawable, xDrawable, this.handle, x, y, width, height, destX, destY);
        OS.XSetGraphicsExposures(xDisplay, this.handle, false);
        if (this.data.image != null) {
            return;
        }
        boolean bl = disjoint = destX + width < x || x + width < destX || destY + height < y || y + height < destY;
        if (disjoint) {
            OS.XClearArea(xDisplay, xDrawable, x, y, width, height, true);
        } else {
            if (deltaX != 0) {
                int newX = destX - deltaX;
                if (deltaX < 0) {
                    newX = destX + width;
                }
                OS.XClearArea(xDisplay, xDrawable, newX, y, Math.abs(deltaX), height, true);
            }
            if (deltaY != 0) {
                int newY = destY - deltaY;
                if (deltaY < 0) {
                    newY = destY + height;
                }
                OS.XClearArea(xDisplay, xDrawable, x, newY, width, Math.abs(deltaY), true);
            }
        }
    }

    public void copyArea(Image image, int x, int y) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.type != 0 || image.isDisposed()) {
            SWT.error(5);
        }
        Rectangle rect = image.getBounds();
        int xDisplay = this.data.display;
        int xGC = OS.XCreateGC(xDisplay, image.pixmap, 0, null);
        if (xGC == 0) {
            SWT.error(2);
        }
        OS.XSetSubwindowMode(xDisplay, xGC, 1);
        OS.XCopyArea(xDisplay, this.data.drawable, image.pixmap, xGC, x, y, rect.width, rect.height, 0, 0);
        OS.XFreeGC(xDisplay, xGC);
    }

    public void dispose() {
        int xmMnemonic;
        int xmText;
        int xmString;
        int renderTable;
        Image image;
        if (this.handle == 0) {
            return;
        }
        if (this.data.device.isDisposed()) {
            return;
        }
        int clipRgn = this.data.clipRgn;
        if (clipRgn != 0) {
            OS.XDestroyRegion(clipRgn);
        }
        if ((image = this.data.image) != null) {
            image.memGC = null;
            if (image.transparentPixel != -1) {
                image.createMask();
            }
        }
        if ((renderTable = this.data.renderTable) != 0) {
            OS.XmRenderTableFree(renderTable);
        }
        if ((xmString = this.data.xmString) != 0) {
            OS.XmStringFree(xmString);
        }
        if ((xmText = this.data.xmText) != 0) {
            OS.XmStringFree(xmText);
        }
        if ((xmMnemonic = this.data.xmMnemonic) != 0) {
            OS.XmStringFree(xmMnemonic);
        }
        Device device = this.data.device;
        if (this.drawable != null) {
            this.drawable.internal_dispose_GC(this.handle, this.data);
        }
        this.data.xmMnemonic = 0;
        this.data.xmText = 0;
        this.data.xmString = 0;
        this.data.renderTable = 0;
        this.data.clipRgn = 0;
        this.data.colormap = 0;
        this.data.drawable = 0;
        this.data.display = 0;
        this.data.font = null;
        this.drawable = null;
        this.handle = 0;
        this.data.image = null;
        if (device.tracking) {
            device.dispose_Object(this);
        }
        this.data.device = null;
        this.data = null;
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (width == 0 || height == 0 || arcAngle == 0) {
            return;
        }
        OS.XDrawArc(this.data.display, this.data.drawable, this.handle, x, y, width, height, startAngle * 64, arcAngle * 64);
    }

    public void drawFocus(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int xDisplay = this.data.display;
        int xDrawable = this.data.drawable;
        int highlightColor = 0;
        int widget = OS.XtWindowToWidget(xDisplay, xDrawable);
        if (widget != 0) {
            int[] nArray = new int[2];
            nArray[0] = OS.XmNhighlightColor;
            int[] argList = nArray;
            OS.XtGetValues(widget, argList, argList.length / 2);
            highlightColor = argList[1];
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        XGCValues values = new XGCValues();
        OS.XGetGCValues(xDisplay, this.handle, 4, values);
        OS.XSetForeground(xDisplay, this.handle, highlightColor);
        OS.XDrawRectangle(xDisplay, xDrawable, this.handle, x, y, width - 1, height - 1);
        OS.XSetForeground(xDisplay, this.handle, values.foreground);
    }

    public void drawImage(Image image, int x, int y) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, 0, 0, -1, -1, x, y, -1, -1, true);
    }

    public void drawImage(Image image, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (srcWidth == 0 || srcHeight == 0 || destWidth == 0 || destHeight == 0) {
            return;
        }
        if (srcX < 0 || srcY < 0 || srcWidth < 0 || srcHeight < 0 || destWidth < 0 || destHeight < 0) {
            SWT.error(5);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, false);
    }

    void drawImage(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple) {
        int[] width = new int[1];
        int[] height = new int[1];
        int[] depth = new int[1];
        int[] unused = new int[1];
        OS.XGetGeometry(this.data.display, srcImage.pixmap, unused, unused, unused, width, height, unused, depth);
        int imgWidth = width[0];
        int imgHeight = height[0];
        if (simple) {
            srcWidth = destWidth = imgWidth;
            srcHeight = destHeight = imgHeight;
        } else {
            boolean bl = simple = srcX == 0 && srcY == 0 && srcWidth == destWidth && destWidth == imgWidth && srcHeight == destHeight && destHeight == imgHeight;
            if (srcX + srcWidth > imgWidth || srcY + srcHeight > imgHeight) {
                SWT.error(5);
            }
        }
        if (srcImage.alpha != -1 || srcImage.alphaData != null) {
            this.drawImageAlpha(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, imgWidth, imgHeight, depth[0]);
        } else if (srcImage.transparentPixel != -1 || srcImage.mask != 0) {
            this.drawImageMask(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, imgWidth, imgHeight, depth[0]);
        } else {
            this.drawImage(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, imgWidth, imgHeight, depth[0]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void drawImageAlpha(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, int imgWidth, int imgHeight, int depth) {
        int xSrcImagePtr;
        int xDestImagePtr;
        block22: {
            block20: {
                block18: {
                    block19: {
                        if (srcImage.alpha == 0) {
                            return;
                        }
                        if (srcImage.alpha == 255) {
                            this.drawImage(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, imgWidth, imgHeight, depth);
                            return;
                        }
                        Rectangle rect = this.getClipping();
                        if ((rect = rect.intersection(new Rectangle(destX, destY, destWidth, destHeight))).isEmpty()) {
                            return;
                        }
                        int sx1 = srcX + (rect.x - destX) * srcWidth / destWidth;
                        int sx2 = srcX + (rect.x + rect.width - destX) * srcWidth / destWidth;
                        int sy1 = srcY + (rect.y - destY) * srcHeight / destHeight;
                        int sy2 = srcY + (rect.y + rect.height - destY) * srcHeight / destHeight;
                        destX = rect.x;
                        destY = rect.y;
                        destWidth = rect.width;
                        destHeight = rect.height;
                        srcX = sx1;
                        srcY = sy1;
                        srcWidth = Math.max(1, sx2 - sx1);
                        srcHeight = Math.max(1, sy2 - sy1);
                        int xDisplay = this.data.display;
                        int xDrawable = this.data.drawable;
                        xDestImagePtr = 0;
                        xSrcImagePtr = 0;
                        try {
                            byte[] destData;
                            XImage xDestImage;
                            block21: {
                                xDestImagePtr = OS.XGetImage(xDisplay, xDrawable, destX, destY, destWidth, destHeight, -1, 2);
                                if (xDestImagePtr == 0) {
                                    Object var35_23 = null;
                                    if (xSrcImagePtr == 0) break block18;
                                    break block19;
                                }
                                xDestImage = new XImage();
                                OS.memmove(xDestImage, xDestImagePtr, 88);
                                destData = new byte[xDestImage.bytes_per_line * xDestImage.height];
                                OS.memmove(destData, xDestImage.data, destData.length);
                                xSrcImagePtr = OS.XGetImage(xDisplay, srcImage.pixmap, srcX, srcY, srcWidth, srcHeight, -1, 2);
                                if (xSrcImagePtr == 0) {
                                    break block20;
                                }
                                XImage xSrcImage = new XImage();
                                OS.memmove(xSrcImage, xSrcImagePtr, 88);
                                byte[] srcData = new byte[xSrcImage.bytes_per_line * xSrcImage.height];
                                OS.memmove(srcData, xSrcImage.data, srcData.length);
                                if (xSrcImage.depth <= 8) {
                                    XColor[] xcolors = this.data.device.xcolors;
                                    if (xcolors == null) {
                                        SWT.error(38);
                                    }
                                    byte[] reds = new byte[xcolors.length];
                                    byte[] greens = new byte[xcolors.length];
                                    byte[] blues = new byte[xcolors.length];
                                    int i = 0;
                                    while (true) {
                                        if (i >= xcolors.length) {
                                            ImageData.blit(2, srcData, xSrcImage.bits_per_pixel, xSrcImage.bytes_per_line, xSrcImage.byte_order, 0, 0, srcWidth, srcHeight, reds, greens, blues, srcImage.alpha, srcImage.alphaData, imgWidth, srcX, srcY, destData, xDestImage.bits_per_pixel, xDestImage.bytes_per_line, xDestImage.byte_order, 0, 0, destWidth, destHeight, reds, greens, blues, false, false);
                                            break block21;
                                        }
                                        XColor color = xcolors[i];
                                        if (color != null) {
                                            reds[i] = (byte)(color.red >> 8 & 0xFF);
                                            greens[i] = (byte)(color.green >> 8 & 0xFF);
                                            blues[i] = (byte)(color.blue >> 8 & 0xFF);
                                        }
                                        ++i;
                                    }
                                }
                                int srcRedMask = xSrcImage.red_mask;
                                int srcGreenMask = xSrcImage.green_mask;
                                int srcBlueMask = xSrcImage.blue_mask;
                                int destRedMask = xDestImage.red_mask;
                                int destGreenMask = xDestImage.green_mask;
                                int destBlueMask = xDestImage.blue_mask;
                                int visual = OS.XDefaultVisual(xDisplay, OS.XDefaultScreen(xDisplay));
                                Visual xVisual = new Visual();
                                OS.memmove(xVisual, visual, 32);
                                if (srcRedMask == 0 && srcGreenMask == 0 && srcBlueMask == 0) {
                                    srcRedMask = xVisual.red_mask;
                                    srcGreenMask = xVisual.green_mask;
                                    srcBlueMask = xVisual.blue_mask;
                                }
                                if (destRedMask == 0 && destGreenMask == 0 && destBlueMask == 0) {
                                    destRedMask = xVisual.red_mask;
                                    destGreenMask = xVisual.green_mask;
                                    destBlueMask = xVisual.blue_mask;
                                }
                                ImageData.blit(2, srcData, xSrcImage.bits_per_pixel, xSrcImage.bytes_per_line, xSrcImage.byte_order, 0, 0, srcWidth, srcHeight, srcRedMask, srcGreenMask, srcBlueMask, srcImage.alpha, srcImage.alphaData, imgWidth, srcX, srcY, destData, xDestImage.bits_per_pixel, xDestImage.bytes_per_line, xDestImage.byte_order, 0, 0, destWidth, destHeight, destRedMask, destGreenMask, destBlueMask, false, false);
                            }
                            OS.memmove(xDestImage.data, destData, destData.length);
                            OS.XPutImage(xDisplay, xDrawable, this.handle, xDestImagePtr, 0, 0, destX, destY, destWidth, destHeight);
                            break block22;
                        }
                        catch (Throwable throwable) {
                            Object var35_25 = null;
                            if (xSrcImagePtr != 0) {
                                OS.XDestroyImage(xSrcImagePtr);
                            }
                            if (xDestImagePtr == 0) throw throwable;
                            OS.XDestroyImage(xDestImagePtr);
                            throw throwable;
                        }
                    }
                    OS.XDestroyImage(xSrcImagePtr);
                }
                if (xDestImagePtr == 0) return;
                OS.XDestroyImage(xDestImagePtr);
                return;
            }
            Object var35_24 = null;
            if (xSrcImagePtr != 0) {
                OS.XDestroyImage(xSrcImagePtr);
            }
            if (xDestImagePtr == 0) return;
            OS.XDestroyImage(xDestImagePtr);
            return;
        }
        Object var35_26 = null;
        if (xSrcImagePtr != 0) {
            OS.XDestroyImage(xSrcImagePtr);
        }
        if (xDestImagePtr == 0) return;
        OS.XDestroyImage(xDestImagePtr);
    }

    void drawImageMask(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, int imgWidth, int imgHeight, int depth) {
        int xDisplay = this.data.display;
        int xDrawable = this.data.drawable;
        if (srcImage.transparentPixel != -1) {
            srcImage.createMask();
        }
        int colorPixmap = 0;
        int maskPixmap = 0;
        int foreground = 0;
        if (simple || srcWidth == destWidth && srcHeight == destHeight) {
            colorPixmap = srcImage.pixmap;
            maskPixmap = srcImage.mask;
        } else {
            int xImagePtr = GC.scalePixmap(xDisplay, srcImage.pixmap, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, false, false);
            if (xImagePtr != 0) {
                int xMaskPtr = GC.scalePixmap(xDisplay, srcImage.mask, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, false, false);
                if (xMaskPtr != 0) {
                    colorPixmap = OS.XCreatePixmap(xDisplay, xDrawable, destWidth, destHeight, depth);
                    int tempGC = OS.XCreateGC(xDisplay, colorPixmap, 0, null);
                    OS.XPutImage(xDisplay, colorPixmap, tempGC, xImagePtr, 0, 0, 0, 0, destWidth, destHeight);
                    OS.XFreeGC(xDisplay, tempGC);
                    maskPixmap = OS.XCreatePixmap(xDisplay, xDrawable, destWidth, destHeight, 1);
                    tempGC = OS.XCreateGC(xDisplay, maskPixmap, 0, null);
                    OS.XPutImage(xDisplay, maskPixmap, tempGC, xMaskPtr, 0, 0, 0, 0, destWidth, destHeight);
                    OS.XFreeGC(xDisplay, tempGC);
                    OS.XDestroyImage(xMaskPtr);
                }
                OS.XDestroyImage(xImagePtr);
            }
            srcY = 0;
            srcX = 0;
            srcWidth = destWidth;
            srcHeight = destHeight;
            foreground ^= 0xFFFFFFFF;
        }
        if (colorPixmap != 0 && maskPixmap != 0) {
            XGCValues values = new XGCValues();
            OS.XGetGCValues(xDisplay, this.handle, 13, values);
            OS.XSetFunction(xDisplay, this.handle, 6);
            OS.XCopyArea(xDisplay, colorPixmap, xDrawable, this.handle, srcX, srcY, srcWidth, srcHeight, destX, destY);
            OS.XSetForeground(xDisplay, this.handle, foreground);
            OS.XSetBackground(xDisplay, this.handle, ~foreground);
            OS.XSetFunction(xDisplay, this.handle, 1);
            OS.XCopyPlane(xDisplay, maskPixmap, xDrawable, this.handle, srcX, srcY, srcWidth, srcHeight, destX, destY, 1);
            OS.XSetFunction(xDisplay, this.handle, 6);
            OS.XCopyArea(xDisplay, colorPixmap, xDrawable, this.handle, srcX, srcY, srcWidth, srcHeight, destX, destY);
            OS.XSetForeground(xDisplay, this.handle, values.foreground);
            OS.XSetBackground(xDisplay, this.handle, values.background);
            OS.XSetFunction(xDisplay, this.handle, values.function);
        }
        if (colorPixmap != 0 && srcImage.pixmap != colorPixmap) {
            OS.XFreePixmap(xDisplay, colorPixmap);
        }
        if (maskPixmap != 0 && srcImage.mask != maskPixmap) {
            OS.XFreePixmap(xDisplay, maskPixmap);
        }
        if (srcImage.transparentPixel != -1 && srcImage.memGC != null) {
            srcImage.destroyMask();
        }
    }

    void drawImage(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, int imgWidth, int imgHeight, int depth) {
        int xDisplay = this.data.display;
        int xDrawable = this.data.drawable;
        if (srcWidth == destWidth && srcHeight == destHeight) {
            OS.XCopyArea(xDisplay, srcImage.pixmap, xDrawable, this.handle, srcX, srcY, srcWidth, srcHeight, destX, destY);
            return;
        }
        int xImagePtr = GC.scalePixmap(xDisplay, srcImage.pixmap, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, false, false);
        if (xImagePtr != 0) {
            OS.XPutImage(xDisplay, xDrawable, this.handle, xImagePtr, 0, 0, destX, destY, destWidth, destHeight);
            OS.XDestroyImage(xImagePtr);
        }
    }

    static int scalePixmap(int display, int pixmap, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean flipX, boolean flipY) {
        int xSrcImagePtr = OS.XGetImage(display, pixmap, srcX, srcY, srcWidth, srcHeight, -1, 2);
        if (xSrcImagePtr == 0) {
            return 0;
        }
        XImage xSrcImage = new XImage();
        OS.memmove(xSrcImage, xSrcImagePtr, 88);
        byte[] srcData = new byte[xSrcImage.bytes_per_line * xSrcImage.height];
        OS.memmove(srcData, xSrcImage.data, srcData.length);
        OS.XDestroyImage(xSrcImagePtr);
        int xImagePtr = 0;
        int visual = OS.XDefaultVisual(display, OS.XDefaultScreen(display));
        switch (xSrcImage.bits_per_pixel) {
            case 1: 
            case 4: 
            case 8: {
                int bufPtr;
                int format = xSrcImage.bits_per_pixel == 1 ? 0 : 2;
                xImagePtr = OS.XCreateImage(display, visual, xSrcImage.depth, format, 0, 0, destWidth, destHeight, xSrcImage.bitmap_pad, 0);
                if (xImagePtr == 0) {
                    return 0;
                }
                XImage xImage = new XImage();
                OS.memmove(xImage, xImagePtr, 88);
                int bufSize = xImage.bytes_per_line * xImage.height;
                if (bufSize < 0) {
                    OS.XDestroyImage(xImagePtr);
                    return 0;
                }
                xImage.data = bufPtr = OS.XtMalloc(bufSize);
                OS.memmove(xImagePtr, xImage, 88);
                byte[] buf = new byte[bufSize];
                int srcOrder = xSrcImage.bits_per_pixel == 1 ? xSrcImage.bitmap_bit_order : xSrcImage.byte_order;
                int destOrder = xImage.bits_per_pixel == 1 ? xImage.bitmap_bit_order : xImage.byte_order;
                ImageData.blit(1, srcData, xSrcImage.bits_per_pixel, xSrcImage.bytes_per_line, srcOrder, 0, 0, srcWidth, srcHeight, null, null, null, 255, null, 0, 0, 0, buf, xImage.bits_per_pixel, xImage.bytes_per_line, destOrder, 0, 0, destWidth, destHeight, null, null, null, flipX, flipY);
                OS.memmove(bufPtr, buf, bufSize);
                break;
            }
            case 16: 
            case 24: 
            case 32: {
                int bufPtr;
                xImagePtr = OS.XCreateImage(display, visual, xSrcImage.depth, 2, 0, 0, destWidth, destHeight, xSrcImage.bitmap_pad, 0);
                if (xImagePtr == 0) {
                    return 0;
                }
                XImage xImage = new XImage();
                OS.memmove(xImage, xImagePtr, 88);
                int bufSize = xImage.bytes_per_line * xImage.height;
                if (bufSize < 0) {
                    OS.XDestroyImage(xImagePtr);
                    return 0;
                }
                xImage.data = bufPtr = OS.XtMalloc(bufSize);
                OS.memmove(xImagePtr, xImage, 88);
                byte[] buf = new byte[bufSize];
                ImageData.blit(1, srcData, xSrcImage.bits_per_pixel, xSrcImage.bytes_per_line, xSrcImage.byte_order, 0, 0, srcWidth, srcHeight, 0, 0, 0, 255, null, 0, 0, 0, buf, xImage.bits_per_pixel, xImage.bytes_per_line, xImage.byte_order, 0, 0, destWidth, destHeight, 0, 0, 0, flipX, flipY);
                OS.memmove(bufPtr, buf, bufSize);
            }
        }
        return xImagePtr;
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        OS.XDrawLine(this.data.display, this.data.drawable, this.handle, x1, y1, x2, y2);
    }

    public void drawOval(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        OS.XDrawArc(this.data.display, this.data.drawable, this.handle, x, y, width, height, 0, 23040);
    }

    public void drawPoint(int x, int y) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        OS.XDrawPoint(this.data.display, this.data.drawable, this.handle, x, y);
    }

    public void drawPolygon(int[] pointArray) {
        int length;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        if ((length = pointArray.length) < 4) {
            this.drawPolyline(pointArray);
            return;
        }
        if (pointArray[0] == pointArray[length - 2] && pointArray[1] == pointArray[length - 1]) {
            this.drawPolyline(pointArray);
            return;
        }
        int[] newPoints = new int[length + 2];
        int i = 0;
        while (i < length) {
            newPoints[i] = pointArray[i];
            ++i;
        }
        newPoints[length] = pointArray[0];
        newPoints[length + 1] = pointArray[1];
        this.drawPolyline(newPoints);
    }

    public void drawPolyline(int[] pointArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        short[] xPoints = new short[pointArray.length];
        int i = 0;
        while (i < pointArray.length) {
            xPoints[i] = (short)pointArray[i];
            ++i;
        }
        OS.XDrawLines(this.data.display, this.data.drawable, this.handle, xPoints, xPoints.length / 2, 0);
    }

    public void drawRectangle(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        OS.XDrawRectangle(this.data.display, this.data.drawable, this.handle, x, y, width, height);
    }

    public void drawRectangle(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        this.drawRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void drawRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int nx = x;
        int ny = y;
        int nw = width;
        int nh = height;
        int naw = arcWidth;
        int nah = arcHeight;
        if (nw < 0) {
            nw = 0 - nw;
            nx -= nw;
        }
        if (nh < 0) {
            nh = 0 - nh;
            ny -= nh;
        }
        if (naw < 0) {
            naw = 0 - naw;
        }
        if (nah < 0) {
            nah = 0 - nah;
        }
        int naw2 = naw / 2;
        int nah2 = nah / 2;
        int xDisplay = this.data.display;
        int xDrawable = this.data.drawable;
        if (nw > naw) {
            if (nh > nah) {
                OS.XDrawArc(xDisplay, xDrawable, this.handle, nx, ny, naw, nah, 5760, 5760);
                OS.XDrawLine(xDisplay, xDrawable, this.handle, nx + naw2, ny, nx + nw - naw2, ny);
                OS.XDrawArc(xDisplay, xDrawable, this.handle, nx + nw - naw, ny, naw, nah, 0, 5760);
                OS.XDrawLine(xDisplay, xDrawable, this.handle, nx + nw, ny + nah2, nx + nw, ny + nh - nah2);
                OS.XDrawArc(xDisplay, xDrawable, this.handle, nx + nw - naw, ny + nh - nah, naw, nah, 17280, 5760);
                OS.XDrawLine(xDisplay, xDrawable, this.handle, nx + naw2, ny + nh, nx + nw - naw2, ny + nh);
                OS.XDrawArc(xDisplay, xDrawable, this.handle, nx, ny + nh - nah, naw, nah, 11520, 5760);
                OS.XDrawLine(xDisplay, xDrawable, this.handle, nx, ny + nah2, nx, ny + nh - nah2);
            } else {
                OS.XDrawArc(xDisplay, xDrawable, this.handle, nx, ny, naw, nh, 5760, 11520);
                OS.XDrawLine(xDisplay, xDrawable, this.handle, nx + naw2, ny, nx + nw - naw2, ny);
                OS.XDrawArc(xDisplay, xDrawable, this.handle, nx + nw - naw, ny, naw, nh, 17280, 11520);
                OS.XDrawLine(xDisplay, xDrawable, this.handle, nx + naw2, ny + nh, nx + nw - naw2, ny + nh);
            }
        } else if (nh > nah) {
            OS.XDrawArc(xDisplay, xDrawable, this.handle, nx, ny, nw, nah, 0, 11520);
            OS.XDrawLine(xDisplay, xDrawable, this.handle, nx + nw, ny + nah2, nx + nw, ny + nh - nah2);
            OS.XDrawArc(xDisplay, xDrawable, this.handle, nx, ny + nh - nah, nw, nah, 11520, 11520);
            OS.XDrawLine(xDisplay, xDrawable, this.handle, nx, ny + nah2, nx, ny + nh - nah2);
        } else {
            OS.XDrawArc(xDisplay, xDrawable, this.handle, nx, ny, nw, nh, 0, 23040);
        }
    }

    public void drawString(String string, int x, int y) {
        this.drawString(string, x, y, false);
    }

    public void drawString(String string, int x, int y, boolean isTransparent) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if (string.length() == 0) {
            return;
        }
        this.setString(string);
        if (isTransparent) {
            OS.XmStringDraw(this.data.display, this.data.drawable, this.data.font.handle, this.data.xmString, this.handle, x, y, Integer.MAX_VALUE, 0, 0, null);
        } else {
            OS.XmStringDrawImage(this.data.display, this.data.drawable, this.data.font.handle, this.data.xmString, this.handle, x, y, Integer.MAX_VALUE, 0, 0, null);
        }
    }

    void createRenderTable() {
        int xDisplay = this.data.display;
        int fontList = this.data.font.handle;
        byte[] byArray = new byte[2];
        byArray[0] = 32;
        byte[] buffer = byArray;
        int xmString = OS.XmStringCreate(buffer, OS.XmFONTLIST_DEFAULT_TAG);
        int tabWidth = OS.XmStringWidth(fontList, xmString) * 8;
        OS.XmStringFree(xmString);
        int[] tabs = new int[16];
        int tab = OS.XmTabCreate(tabWidth, (byte)0, (byte)1, (byte)0, null);
        int i = 0;
        while (i < tabs.length) {
            tabs[i] = tab;
            ++i;
        }
        int tabList = OS.XmTabListInsertTabs(0, tabs, tabs.length, 0);
        int[] fontBuffer = new int[1];
        if (!OS.XmFontListInitFontContext(fontBuffer, fontList)) {
            SWT.error(2);
        }
        int context = fontBuffer[0];
        int fontListEntry = 0;
        int widgetClass = OS.topLevelShellWidgetClass();
        int[] renditions = new int[4];
        int renditionCount = 0;
        int shellHandle = OS.XtAppCreateShell(null, null, widgetClass, xDisplay, null, 0);
        while ((fontListEntry = OS.XmFontListNextEntry(context)) != 0) {
            int fontType;
            int fontPtr = OS.XmFontListEntryGetFont(fontListEntry, fontBuffer);
            int n = fontType = fontBuffer[0] == 0 ? 0 : 1;
            if (fontPtr == 0) {
                SWT.error(2);
            }
            int[] argList = new int[]{OS.XmNtabList, tabList, OS.XmNfont, fontPtr, OS.XmNfontType, fontType};
            int rendition = OS.XmRenditionCreate(shellHandle, OS.XmFONTLIST_DEFAULT_TAG, argList, argList.length / 2);
            renditions[renditionCount++] = rendition;
            if (renditionCount != renditions.length) continue;
            int[] newArray = new int[renditions.length + 4];
            System.arraycopy(newArray, 0, renditions, 0, renditionCount);
            renditions = newArray;
        }
        OS.XmFontListFreeFontContext(context);
        OS.XmTabFree(tab);
        OS.XmTabListFree(tabList);
        OS.XtDestroyWidget(shellHandle);
        this.data.renderTable = OS.XmRenderTableAddRenditions(0, renditions, renditionCount, 1);
        int i2 = 0;
        while (i2 < renditionCount) {
            OS.XmRenditionFree(renditions[i2]);
            ++i2;
        }
    }

    public void drawText(String string, int x, int y) {
        this.drawText(string, x, y, 6);
    }

    public void drawText(String string, int x, int y, boolean isTransparent) {
        int flags = 6;
        if (isTransparent) {
            flags |= 1;
        }
        this.drawText(string, x, y, flags);
    }

    public void drawText(String string, int x, int y, int flags) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if (string.length() == 0) {
            return;
        }
        this.setText(string, flags);
        int xmMnemonic = this.data.xmMnemonic;
        if (xmMnemonic != 0) {
            OS.XmStringDrawUnderline(this.data.display, this.data.drawable, this.data.renderTable, this.data.xmText, this.handle, x, y, Integer.MAX_VALUE, 0, 0, null, xmMnemonic);
        } else if ((flags & 1) != 0) {
            OS.XmStringDraw(this.data.display, this.data.drawable, this.data.renderTable, this.data.xmText, this.handle, x, y, Integer.MAX_VALUE, 0, 0, null);
        } else {
            OS.XmStringDrawImage(this.data.display, this.data.drawable, this.data.renderTable, this.data.xmText, this.handle, x, y, Integer.MAX_VALUE, 0, 0, null);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GC)) {
            return false;
        }
        return this.handle == ((GC)object).handle;
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (width == 0 || height == 0 || arcAngle == 0) {
            return;
        }
        int xDisplay = this.data.display;
        XGCValues values = new XGCValues();
        OS.XGetGCValues(xDisplay, this.handle, 12, values);
        OS.XSetForeground(xDisplay, this.handle, values.background);
        OS.XFillArc(xDisplay, this.data.drawable, this.handle, x, y, width, height, startAngle * 64, arcAngle * 64);
        OS.XSetForeground(xDisplay, this.handle, values.foreground);
    }

    public void fillGradientRectangle(int x, int y, int width, int height, boolean vertical) {
        int blueBits;
        int greenBits;
        int redBits;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width == 0 || height == 0) {
            return;
        }
        int xDisplay = this.data.display;
        int xScreenNum = OS.XDefaultScreen(xDisplay);
        XGCValues values = new XGCValues();
        OS.XGetGCValues(xDisplay, this.handle, 12, values);
        int fromColor = values.foreground;
        int toColor = values.background;
        boolean swapColors = false;
        if (width < 0) {
            x += width;
            width = -width;
            if (!vertical) {
                swapColors = true;
            }
        }
        if (height < 0) {
            y += height;
            height = -height;
            if (vertical) {
                swapColors = true;
            }
        }
        if (swapColors) {
            int t = fromColor;
            fromColor = toColor;
            toColor = t;
        }
        if (fromColor == toColor) {
            OS.XFillRectangle(xDisplay, this.data.drawable, this.handle, x, y, width, height);
            return;
        }
        int xScreen = OS.XDefaultScreenOfDisplay(xDisplay);
        int xVisual = OS.XDefaultVisual(xDisplay, xScreenNum);
        Visual visual = new Visual();
        OS.memmove(visual, xVisual, 32);
        int depth = OS.XDefaultDepthOfScreen(xScreen);
        boolean directColor = depth > 8;
        XColor xColor = new XColor();
        xColor.pixel = fromColor;
        OS.XQueryColor(xDisplay, this.data.colormap, xColor);
        RGB fromRGB = new RGB((xColor.red & 0xFFFF) >>> 8, (xColor.green & 0xFFFF) >>> 8, (xColor.blue & 0xFFFF) >>> 8);
        xColor.pixel = toColor;
        OS.XQueryColor(xDisplay, this.data.colormap, xColor);
        RGB toRGB = new RGB((xColor.red & 0xFFFF) >>> 8, (xColor.green & 0xFFFF) >>> 8, (xColor.blue & 0xFFFF) >>> 8);
        if (directColor) {
            redBits = GC.getChannelWidth(visual.red_mask);
            greenBits = GC.getChannelWidth(visual.green_mask);
            blueBits = GC.getChannelWidth(visual.blue_mask);
        } else {
            blueBits = 0;
            greenBits = 0;
            redBits = 0;
        }
        ImageData.fillGradientRectangle(this, this.data.device, x, y, width, height, vertical, fromRGB, toRGB, redBits, greenBits, blueBits);
    }

    static int getChannelWidth(int mask) {
        int width = 0;
        while (mask != 0) {
            width += mask & 1;
            mask >>>= 1;
        }
        return width;
    }

    public void fillOval(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        int display = this.data.display;
        XGCValues values = new XGCValues();
        OS.XGetGCValues(display, this.handle, 12, values);
        OS.XSetForeground(display, this.handle, values.background);
        OS.XFillArc(display, this.data.drawable, this.handle, x, y, width, height, 0, 23040);
        OS.XSetForeground(display, this.handle, values.foreground);
    }

    public void fillPolygon(int[] pointArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        short[] xPoints = new short[pointArray.length];
        int i = 0;
        while (i < pointArray.length) {
            xPoints[i] = (short)pointArray[i];
            ++i;
        }
        int xDisplay = this.data.display;
        XGCValues values = new XGCValues();
        OS.XGetGCValues(xDisplay, this.handle, 12, values);
        OS.XSetForeground(xDisplay, this.handle, values.background);
        OS.XFillPolygon(xDisplay, this.data.drawable, this.handle, xPoints, xPoints.length / 2, 0, 0);
        OS.XSetForeground(xDisplay, this.handle, values.foreground);
    }

    public void fillRectangle(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        int xDisplay = this.data.display;
        XGCValues values = new XGCValues();
        OS.XGetGCValues(xDisplay, this.handle, 12, values);
        OS.XSetForeground(xDisplay, this.handle, values.background);
        OS.XFillRectangle(xDisplay, this.data.drawable, this.handle, x, y, width, height);
        OS.XSetForeground(xDisplay, this.handle, values.foreground);
    }

    public void fillRectangle(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        this.fillRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void fillRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int nx = x;
        int ny = y;
        int nw = width;
        int nh = height;
        int naw = arcWidth;
        int nah = arcHeight;
        if (nw < 0) {
            nw = 0 - nw;
            nx -= nw;
        }
        if (nh < 0) {
            nh = 0 - nh;
            ny -= nh;
        }
        if (naw < 0) {
            naw = 0 - naw;
        }
        if (nah < 0) {
            nah = 0 - nah;
        }
        int naw2 = naw / 2;
        int nah2 = nah / 2;
        int xDisplay = this.data.display;
        int xDrawable = this.data.drawable;
        XGCValues values = new XGCValues();
        OS.XGetGCValues(xDisplay, this.handle, 12, values);
        OS.XSetForeground(xDisplay, this.handle, values.background);
        if (nw > naw) {
            if (nh > nah) {
                OS.XFillArc(xDisplay, xDrawable, this.handle, nx, ny, naw, nah, 5760, 5760);
                OS.XFillRectangle(xDisplay, xDrawable, this.handle, nx + naw2, ny, nw - naw2 * 2, nah2);
                OS.XFillArc(xDisplay, xDrawable, this.handle, nx + nw - naw, ny, naw, nah, 0, 5760);
                OS.XFillRectangle(xDisplay, xDrawable, this.handle, nx, ny + nah2, nw, nh - nah2 * 2);
                OS.XFillArc(xDisplay, xDrawable, this.handle, nx + nw - naw, ny + nh - nah, naw, nah, 17280, 5760);
                OS.XFillRectangle(xDisplay, xDrawable, this.handle, nx + naw2, ny + nh - nah2, nw - naw2 * 2, nah2);
                OS.XFillArc(xDisplay, xDrawable, this.handle, nx, ny + nh - nah, naw, nah, 11520, 5760);
            } else {
                OS.XFillArc(xDisplay, xDrawable, this.handle, nx, ny, naw, nh, 5760, 11520);
                OS.XFillRectangle(xDisplay, xDrawable, this.handle, nx + naw2, ny, nw - naw2 * 2, nh);
                OS.XFillArc(xDisplay, xDrawable, this.handle, nx + nw - naw, ny, naw, nh, 17280, 11520);
            }
        } else if (nh > nah) {
            OS.XFillArc(xDisplay, xDrawable, this.handle, nx, ny, nw, nah, 0, 11520);
            OS.XFillRectangle(xDisplay, xDrawable, this.handle, nx, ny + nah2, nw, nh - nah2 * 2);
            OS.XFillArc(xDisplay, xDrawable, this.handle, nx, ny + nh - nah, nw, nah, 11520, 11520);
        } else {
            OS.XFillArc(xDisplay, xDrawable, this.handle, nx, ny, nw, nh, 0, 23040);
        }
        OS.XSetForeground(xDisplay, this.handle, values.foreground);
    }

    char fixMnemonic(char[] text) {
        char mnemonic = '\u0000';
        int i = 0;
        int j = 0;
        while (i < text.length) {
            if ((text[j++] = text[i++]) != '&' || i == text.length) continue;
            if (text[i] == '&') {
                ++i;
                continue;
            }
            if (mnemonic == '\u0000') {
                mnemonic = text[i];
            }
            --j;
        }
        while (j < text.length) {
            text[j++] = '\u0000';
        }
        return mnemonic;
    }

    public int getAdvanceWidth(char ch) {
        int fontListEntry;
        if (this.handle == 0) {
            SWT.error(44);
        }
        int fontList = this.data.font.handle;
        byte[] charBuffer = Converter.wcsToMbcs(this.getCodePage(), new char[]{ch}, false);
        int val = charBuffer[0] & 0xFF;
        int[] buffer = new int[1];
        if (!OS.XmFontListInitFontContext(buffer, fontList)) {
            SWT.error(2);
        }
        int context = buffer[0];
        XFontStruct fontStruct = new XFontStruct();
        XCharStruct charStruct = new XCharStruct();
        int[] fontStructPtr = new int[1];
        int[] fontNamePtr = new int[1];
        while ((fontListEntry = OS.XmFontListNextEntry(context)) != 0) {
            int perCharPtr;
            short charWidth;
            int fontPtr = OS.XmFontListEntryGetFont(fontListEntry, buffer);
            if (buffer[0] == 0) {
                OS.memmove(fontStruct, fontPtr, 80);
                if (fontStruct.min_byte1 == 0 && fontStruct.max_byte1 == 0) {
                    if (fontStruct.min_char_or_byte2 > val || val > fontStruct.max_char_or_byte2) continue;
                    short charWidth2 = 0;
                    int perCharPtr2 = fontStruct.per_char;
                    if (perCharPtr2 == 0) {
                        charWidth2 = fontStruct.max_bounds_width;
                    } else {
                        OS.memmove(charStruct, perCharPtr2 + (val - fontStruct.min_char_or_byte2) * 12, 12);
                        charWidth2 = charStruct.width;
                    }
                    if (charWidth2 == 0) continue;
                    OS.XmFontListFreeFontContext(context);
                    return charWidth2;
                }
                int charsPerRow = fontStruct.max_char_or_byte2 - fontStruct.min_char_or_byte2 + 1;
                int row = 0;
                if (charBuffer.length > 1) {
                    row = charBuffer[1] - fontStruct.min_byte1;
                }
                int col = charBuffer[0] - fontStruct.min_char_or_byte2;
                if (row > fontStruct.max_byte1 || col > fontStruct.max_char_or_byte2) continue;
                charWidth = 0;
                perCharPtr = fontStruct.per_char;
                if (perCharPtr == 0) {
                    charWidth = fontStruct.max_bounds_width;
                } else {
                    int offset = row * charsPerRow + col;
                    OS.memmove(charStruct, perCharPtr + offset * 12, 12);
                    charWidth = charStruct.width;
                }
                if (charWidth == 0) continue;
                OS.XmFontListFreeFontContext(context);
                return charWidth;
            }
            int nFonts = OS.XFontsOfFontSet(fontPtr, fontStructPtr, fontNamePtr);
            int[] fontStructs = new int[nFonts];
            OS.memmove(fontStructs, fontStructPtr[0], nFonts * 4);
            int i = 0;
            while (i < nFonts) {
                OS.memmove(fontStruct, fontStructs[i], 80);
                if (fontStruct.min_byte1 == 0 && fontStruct.max_byte1 == 0) {
                    if (fontStruct.min_char_or_byte2 <= val && val <= fontStruct.max_char_or_byte2) {
                        charWidth = 0;
                        perCharPtr = fontStruct.per_char;
                        if (perCharPtr == 0) {
                            charWidth = fontStruct.max_bounds_width;
                        } else {
                            OS.memmove(charStruct, perCharPtr + (val - fontStruct.min_char_or_byte2 * 12), 12);
                            charWidth = charStruct.width;
                        }
                        if (charWidth != 0) {
                            OS.XmFontListFreeFontContext(context);
                            return charWidth;
                        }
                    }
                } else {
                    int charsPerRow = fontStruct.max_char_or_byte2 - fontStruct.min_char_or_byte2 + 1;
                    int row = 0;
                    if (charBuffer.length > 1) {
                        row = charBuffer[1] - fontStruct.min_byte1;
                    }
                    int col = charBuffer[0] - fontStruct.min_char_or_byte2;
                    if (row <= fontStruct.max_byte1 && col <= fontStruct.max_char_or_byte2) {
                        short charWidth3 = 0;
                        int perCharPtr3 = fontStruct.per_char;
                        if (perCharPtr3 == 0) {
                            charWidth3 = fontStruct.max_bounds_width;
                        } else {
                            int offset = row * charsPerRow + col;
                            OS.memmove(charStruct, perCharPtr3 + offset * 12, 12);
                            charWidth3 = charStruct.width;
                        }
                        if (charWidth3 != 0) {
                            OS.XmFontListFreeFontContext(context);
                            return charWidth3;
                        }
                    }
                }
                ++i;
            }
        }
        OS.XmFontListFreeFontContext(context);
        return 0;
    }

    public Color getBackground() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int xDisplay = this.data.display;
        XGCValues values = new XGCValues();
        OS.XGetGCValues(xDisplay, this.handle, 8, values);
        XColor xColor = new XColor();
        xColor.pixel = values.background;
        OS.XQueryColor(xDisplay, this.data.colormap, xColor);
        return Color.motif_new(this.data.device, xColor);
    }

    public int getCharWidth(char ch) {
        int fontListEntry;
        if (this.handle == 0) {
            SWT.error(44);
        }
        int fontList = this.data.font.handle;
        byte[] charBuffer = Converter.wcsToMbcs(this.getCodePage(), new char[]{ch}, false);
        int val = charBuffer[0] & 0xFF;
        int[] buffer = new int[1];
        if (!OS.XmFontListInitFontContext(buffer, fontList)) {
            SWT.error(2);
        }
        int context = buffer[0];
        XFontStruct fontStruct = new XFontStruct();
        XCharStruct charStruct = new XCharStruct();
        int[] fontStructPtr = new int[1];
        int[] fontNamePtr = new int[1];
        while ((fontListEntry = OS.XmFontListNextEntry(context)) != 0) {
            int perCharPtr;
            short rBearing;
            short lBearing;
            short charWidth;
            int fontPtr = OS.XmFontListEntryGetFont(fontListEntry, buffer);
            if (buffer[0] == 0) {
                OS.memmove(fontStruct, fontPtr, 80);
                if (fontStruct.min_byte1 == 0 && fontStruct.max_byte1 == 0) {
                    if (fontStruct.min_char_or_byte2 > val || val > fontStruct.max_char_or_byte2) continue;
                    short charWidth2 = 0;
                    short lBearing2 = 0;
                    short rBearing2 = 0;
                    int perCharPtr2 = fontStruct.per_char;
                    if (perCharPtr2 == 0) {
                        charWidth2 = fontStruct.max_bounds_width;
                        lBearing2 = fontStruct.min_bounds_lbearing;
                        rBearing2 = fontStruct.max_bounds_rbearing;
                    } else {
                        OS.memmove(charStruct, perCharPtr2 + (val - fontStruct.min_char_or_byte2) * 12, 12);
                        charWidth2 = charStruct.width;
                        lBearing2 = charStruct.lbearing;
                        rBearing2 = charStruct.rbearing;
                    }
                    if (charWidth2 == 0) continue;
                    OS.XmFontListFreeFontContext(context);
                    return rBearing2 - lBearing2;
                }
                int charsPerRow = fontStruct.max_char_or_byte2 - fontStruct.min_char_or_byte2 + 1;
                int row = 0;
                if (charBuffer.length > 1) {
                    row = charBuffer[1] - fontStruct.min_byte1;
                }
                int col = charBuffer[0] - fontStruct.min_char_or_byte2;
                if (row > fontStruct.max_byte1 || col > fontStruct.max_char_or_byte2) continue;
                charWidth = 0;
                lBearing = 0;
                rBearing = 0;
                perCharPtr = fontStruct.per_char;
                if (perCharPtr == 0) {
                    charWidth = fontStruct.max_bounds_width;
                    lBearing = fontStruct.min_bounds_lbearing;
                    rBearing = fontStruct.max_bounds_rbearing;
                } else {
                    int offset = row * charsPerRow + col;
                    OS.memmove(charStruct, perCharPtr + offset * 12, 12);
                    charWidth = charStruct.width;
                    lBearing = charStruct.lbearing;
                    rBearing = charStruct.rbearing;
                }
                if (charWidth == 0) continue;
                OS.XmFontListFreeFontContext(context);
                return rBearing - lBearing;
            }
            int nFonts = OS.XFontsOfFontSet(fontPtr, fontStructPtr, fontNamePtr);
            int[] fontStructs = new int[nFonts];
            OS.memmove(fontStructs, fontStructPtr[0], nFonts * 4);
            int i = 0;
            while (i < nFonts) {
                OS.memmove(fontStruct, fontStructs[i], 80);
                if (fontStruct.min_byte1 == 0 && fontStruct.max_byte1 == 0) {
                    if (fontStruct.min_char_or_byte2 <= val && val <= fontStruct.max_char_or_byte2) {
                        charWidth = 0;
                        lBearing = 0;
                        rBearing = 0;
                        perCharPtr = fontStruct.per_char;
                        if (perCharPtr == 0) {
                            charWidth = fontStruct.max_bounds_width;
                            lBearing = fontStruct.min_bounds_lbearing;
                            rBearing = fontStruct.max_bounds_rbearing;
                        } else {
                            OS.memmove(charStruct, perCharPtr + (val - fontStruct.min_char_or_byte2 * 12), 12);
                            charWidth = charStruct.width;
                            lBearing = charStruct.lbearing;
                            rBearing = charStruct.rbearing;
                        }
                        if (charWidth != 0) {
                            OS.XmFontListFreeFontContext(context);
                            return rBearing - lBearing;
                        }
                    }
                } else {
                    int charsPerRow = fontStruct.max_char_or_byte2 - fontStruct.min_char_or_byte2 + 1;
                    int row = 0;
                    if (charBuffer.length > 1) {
                        row = charBuffer[1] - fontStruct.min_byte1;
                    }
                    int col = charBuffer[0] - fontStruct.min_char_or_byte2;
                    if (row <= fontStruct.max_byte1 && col <= fontStruct.max_char_or_byte2) {
                        short charWidth3 = 0;
                        short lBearing3 = 0;
                        short rBearing3 = 0;
                        int perCharPtr3 = fontStruct.per_char;
                        if (perCharPtr3 == 0) {
                            charWidth3 = fontStruct.max_bounds_width;
                            lBearing3 = fontStruct.min_bounds_lbearing;
                            rBearing3 = fontStruct.max_bounds_rbearing;
                        } else {
                            int offset = row * charsPerRow + col;
                            OS.memmove(charStruct, perCharPtr3 + offset * 12, 12);
                            charWidth3 = charStruct.width;
                            lBearing3 = charStruct.lbearing;
                            rBearing3 = charStruct.rbearing;
                        }
                        if (charWidth3 != 0) {
                            OS.XmFontListFreeFontContext(context);
                            return rBearing3 - lBearing3;
                        }
                    }
                }
                ++i;
            }
        }
        OS.XmFontListFreeFontContext(context);
        return 0;
    }

    public Rectangle getClipping() {
        int clipRgn;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((clipRgn = this.data.clipRgn) == 0) {
            int[] width = new int[1];
            int[] height = new int[1];
            int[] unused = new int[1];
            OS.XGetGeometry(this.data.display, this.data.drawable, unused, unused, unused, width, height, unused, unused);
            return new Rectangle(0, 0, width[0], height[0]);
        }
        XRectangle rect = new XRectangle();
        OS.XClipBox(clipRgn, rect);
        return new Rectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void getClipping(Region region) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        int hRegion = region.handle;
        int clipRgn = this.data.clipRgn;
        if (clipRgn == 0) {
            int[] width = new int[1];
            int[] height = new int[1];
            int[] unused = new int[1];
            OS.XGetGeometry(this.data.display, this.data.drawable, unused, unused, unused, width, height, unused, unused);
            OS.XSubtractRegion(hRegion, hRegion, hRegion);
            XRectangle rect = new XRectangle();
            rect.x = 0;
            rect.y = 0;
            rect.width = (short)width[0];
            rect.height = (short)height[0];
            OS.XUnionRectWithRegion(rect, hRegion, hRegion);
            return;
        }
        OS.XSubtractRegion(hRegion, hRegion, hRegion);
        OS.XUnionRegion(clipRgn, hRegion, hRegion);
    }

    String getCodePage() {
        return this.data.font.codePage;
    }

    public Font getFont() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return Font.motif_new(this.data.device, this.data.font.handle);
    }

    int getFontHeight() {
        int fontListEntry;
        int[] buffer = new int[1];
        int fontList = this.data.font.handle;
        if (!OS.XmFontListInitFontContext(buffer, fontList)) {
            SWT.error(2);
        }
        int context = buffer[0];
        int height = 0;
        XFontStruct fontStruct = new XFontStruct();
        int[] fontStructPtr = new int[1];
        int[] fontNamePtr = new int[1];
        while ((fontListEntry = OS.XmFontListNextEntry(context)) != 0) {
            int fontPtr = OS.XmFontListEntryGetFont(fontListEntry, buffer);
            if (buffer[0] == 0) {
                OS.memmove(fontStruct, fontPtr, 80);
                int fontHeight = fontStruct.ascent + fontStruct.descent;
                height = Math.max(height, fontHeight);
                continue;
            }
            int nFonts = OS.XFontsOfFontSet(fontPtr, fontStructPtr, fontNamePtr);
            int[] fontStructs = new int[nFonts];
            OS.memmove(fontStructs, fontStructPtr[0], nFonts * 4);
            int i = 0;
            while (i < nFonts) {
                OS.memmove(fontStruct, fontStructs[i], 80);
                int fontHeight = fontStruct.ascent + fontStruct.descent;
                height = Math.max(height, fontHeight);
                ++i;
            }
        }
        OS.XmFontListFreeFontContext(context);
        return height;
    }

    public FontMetrics getFontMetrics() {
        int fontListEntry;
        if (this.handle == 0) {
            SWT.error(44);
        }
        int xDisplay = this.data.display;
        Font font = this.data.font;
        int[] buffer = new int[1];
        int fontList = font.handle;
        if (!OS.XmFontListInitFontContext(buffer, fontList)) {
            SWT.error(2);
        }
        int context = buffer[0];
        int ascent = 0;
        int descent = 0;
        int averageCharWidth = 0;
        int numAverageCharWidth = 0;
        int leading = 0;
        int height = 0;
        XFontStruct fontStruct = new XFontStruct();
        int[] fontStructPtr = new int[1];
        int[] fontNamePtr = new int[1];
        block6: while ((fontListEntry = OS.XmFontListNextEntry(context)) != 0) {
            int i;
            int fontPtr = OS.XmFontListEntryGetFont(fontListEntry, buffer);
            if (buffer[0] == 0) {
                OS.memmove(fontStruct, fontPtr, 80);
                ascent = Math.max(ascent, fontStruct.ascent);
                descent = Math.max(descent, fontStruct.descent);
                int fontHeight = fontStruct.ascent + fontStruct.descent;
                height = Math.max(height, fontHeight);
                int propPtr = fontStruct.properties;
                i = 0;
                while (i < fontStruct.n_properties) {
                    int[] prop = new int[2];
                    OS.memmove(prop, propPtr, 8);
                    if (prop[0] == 18) {
                        int ptr = OS.XmGetAtomName(xDisplay, prop[1]);
                        int length = OS.strlen(ptr);
                        byte[] nameBuf = new byte[length];
                        OS.memmove(nameBuf, ptr, length);
                        OS.XFree(ptr);
                        String xlfd = new String(Converter.mbcsToWcs(null, nameBuf)).toLowerCase();
                        int avg = 0;
                        try {
                            avg = FontData.motif_new((String)xlfd).averageWidth / 10;
                        }
                        catch (Exception exception) {}
                        if (avg == 0) {
                            int perCharPtr = fontStruct.per_char;
                            if (perCharPtr == 0) {
                                averageCharWidth = fontStruct.max_bounds_width;
                            } else {
                                int sum = 0;
                                int count = 0;
                                int cols = fontStruct.max_char_or_byte2 - fontStruct.min_char_or_byte2 + 1;
                                XCharStruct struct = new XCharStruct();
                                int index = 0;
                                while (index < cols) {
                                    OS.memmove(struct, perCharPtr + index * 12, 12);
                                    short w = struct.width;
                                    if (w != 0) {
                                        sum += w;
                                        ++count;
                                    }
                                    ++index;
                                }
                                averageCharWidth += sum / count;
                            }
                        } else {
                            averageCharWidth += avg;
                        }
                        ++numAverageCharWidth;
                        continue block6;
                    }
                    propPtr += 8;
                    ++i;
                }
                continue;
            }
            int nFonts = OS.XFontsOfFontSet(fontPtr, fontStructPtr, fontNamePtr);
            int[] fontStructs = new int[nFonts];
            OS.memmove(fontStructs, fontStructPtr[0], nFonts * 4);
            i = 0;
            while (i < nFonts) {
                OS.memmove(fontStruct, fontStructs[i], 80);
                ascent = Math.max(ascent, fontStruct.ascent);
                descent = Math.max(descent, fontStruct.descent);
                int fontHeight = fontStruct.ascent + fontStruct.descent;
                height = Math.max(height, fontHeight);
                int propPtr = fontStruct.properties;
                int j = 0;
                while (j < fontStruct.n_properties) {
                    int[] prop = new int[2];
                    OS.memmove(prop, propPtr, 8);
                    if (prop[0] == 18) {
                        int avg;
                        block27: {
                            int ptr = OS.XmGetAtomName(xDisplay, prop[1]);
                            int length = OS.strlen(ptr);
                            byte[] nameBuf = new byte[length];
                            OS.memmove(nameBuf, ptr, length);
                            OS.XFree(ptr);
                            String xlfd = new String(Converter.mbcsToWcs(null, nameBuf)).toLowerCase();
                            avg = 0;
                            try {
                                avg = FontData.motif_new((String)xlfd).averageWidth / 10;
                            }
                            catch (Exception exception) {
                                int[] fontName = new int[1];
                                OS.memmove(fontName, fontNamePtr[0] + i * 4, 4);
                                ptr = fontName[0];
                                if (ptr == 0) break block27;
                                length = OS.strlen(ptr);
                                nameBuf = new byte[length];
                                OS.memmove(nameBuf, ptr, length);
                                xlfd = new String(Converter.mbcsToWcs(null, nameBuf)).toLowerCase();
                                try {
                                    avg = FontData.motif_new((String)xlfd).averageWidth / 10;
                                }
                                catch (Exception exception2) {}
                            }
                        }
                        if (avg == 0) {
                            int perCharPtr = fontStruct.per_char;
                            if (perCharPtr == 0) {
                                averageCharWidth = fontStruct.max_bounds_width;
                            } else {
                                int sum = 0;
                                int count = 0;
                                int cols = fontStruct.max_char_or_byte2 - fontStruct.min_char_or_byte2 + 1;
                                XCharStruct struct = new XCharStruct();
                                int index = 0;
                                while (index < cols) {
                                    OS.memmove(struct, perCharPtr + index * 12, 12);
                                    short w = struct.width;
                                    if (w != 0) {
                                        sum += w;
                                        ++count;
                                    }
                                    ++index;
                                }
                                averageCharWidth += sum / count;
                            }
                        } else {
                            averageCharWidth += avg;
                        }
                        ++numAverageCharWidth;
                        break;
                    }
                    propPtr += 8;
                    ++j;
                }
                ++i;
            }
        }
        OS.XmFontListFreeFontContext(context);
        return FontMetrics.motif_new(ascent, descent, averageCharWidth / numAverageCharWidth, leading, height);
    }

    public Color getForeground() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int xDisplay = this.data.display;
        XGCValues values = new XGCValues();
        OS.XGetGCValues(xDisplay, this.handle, 4, values);
        XColor xColor = new XColor();
        xColor.pixel = values.foreground;
        OS.XQueryColor(xDisplay, this.data.colormap, xColor);
        return Color.motif_new(this.data.device, xColor);
    }

    public int getLineStyle() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.lineStyle;
    }

    public int getLineWidth() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        XGCValues values = new XGCValues();
        OS.XGetGCValues(this.data.display, this.handle, 16, values);
        return values.line_width;
    }

    public int getStyle() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.style;
    }

    public boolean getXORMode() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        XGCValues values = new XGCValues();
        OS.XGetGCValues(this.data.display, this.handle, 1, values);
        return values.function == 6;
    }

    public int hashCode() {
        return this.handle;
    }

    void init(Drawable drawable, GCData data, int xGC) {
        Image image;
        int background;
        int xDisplay = data.display;
        int foreground = data.foreground;
        if (foreground != -1) {
            OS.XSetForeground(xDisplay, xGC, foreground);
        }
        if ((background = data.background) != -1) {
            OS.XSetBackground(xDisplay, xGC, background);
        }
        if ((image = data.image) != null) {
            image.memGC = this;
            if (image.transparentPixel != -1) {
                image.destroyMask();
            }
        }
        this.drawable = drawable;
        this.data = data;
        this.handle = xGC;
    }

    public boolean isClipped() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.clipRgn != 0;
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public static GC motif_new(Drawable drawable, GCData data) {
        GC gc = new GC();
        int xGC = drawable.internal_new_GC(data);
        gc.init(drawable, data, xGC);
        return gc;
    }

    public static GC motif_new(int xGC, GCData data) {
        GC gc = new GC();
        gc.init(null, data, xGC);
        return gc;
    }

    public void setBackground(Color color) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        OS.XSetBackground(this.data.display, this.handle, color.handle.pixel);
    }

    public void setClipping(int x, int y, int width, int height) {
        int clipRgn;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((clipRgn = this.data.clipRgn) == 0) {
            this.data.clipRgn = clipRgn = OS.XCreateRegion();
        } else {
            OS.XSubtractRegion(clipRgn, clipRgn, clipRgn);
        }
        XRectangle rect = new XRectangle();
        rect.x = (short)x;
        rect.y = (short)y;
        rect.width = (short)width;
        rect.height = (short)height;
        OS.XSetClipRectangles(this.data.display, this.handle, 0, 0, rect, 1, 0);
        OS.XUnionRectWithRegion(rect, clipRgn, clipRgn);
    }

    public void setClipping(Rectangle rect) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (rect == null) {
            OS.XSetClipMask(this.data.display, this.handle, 0);
            int clipRgn = this.data.clipRgn;
            if (clipRgn != 0) {
                OS.XDestroyRegion(clipRgn);
                this.data.clipRgn = 0;
            }
            return;
        }
        this.setClipping(rect.x, rect.y, rect.width, rect.height);
    }

    public void setClipping(Region region) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int clipRgn = this.data.clipRgn;
        if (region == null) {
            OS.XSetClipMask(this.data.display, this.handle, 0);
            if (clipRgn != 0) {
                OS.XDestroyRegion(clipRgn);
                this.data.clipRgn = 0;
            }
        } else {
            if (clipRgn == 0) {
                this.data.clipRgn = clipRgn = OS.XCreateRegion();
            } else {
                OS.XSubtractRegion(clipRgn, clipRgn, clipRgn);
            }
            OS.XUnionRegion(region.handle, clipRgn, clipRgn);
            OS.XSetRegion(this.data.display, this.handle, region.handle);
        }
    }

    public void setFont(Font font) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (font == null) {
            font = this.data.device.systemFont;
        }
        if (font.isDisposed()) {
            SWT.error(5);
        }
        this.data.font = font;
        if (this.data.renderTable != 0) {
            OS.XmRenderTableFree(this.data.renderTable);
        }
        this.data.renderTable = 0;
        this.data.textHeight = -1;
        this.data.textWidth = -1;
        this.data.stringHeight = -1;
        this.data.stringWidth = -1;
    }

    public void setForeground(Color color) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        OS.XSetForeground(this.data.display, this.handle, color.handle.pixel);
    }

    public void setLineStyle(int lineStyle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int xDisplay = this.data.display;
        int line_style = 1;
        switch (lineStyle) {
            case 1: {
                line_style = 0;
                break;
            }
            case 2: {
                OS.XSetDashes(xDisplay, this.handle, 0, new byte[]{6, 2}, 2);
                break;
            }
            case 3: {
                OS.XSetDashes(xDisplay, this.handle, 0, new byte[]{3, 1}, 2);
                break;
            }
            case 4: {
                OS.XSetDashes(xDisplay, this.handle, 0, new byte[]{6, 2, 3, 1}, 4);
                break;
            }
            case 5: {
                OS.XSetDashes(xDisplay, this.handle, 0, new byte[]{6, 2, 3, 1, 3, 1}, 6);
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineStyle = lineStyle;
        XGCValues values = new XGCValues();
        OS.XGetGCValues(xDisplay, this.handle, 16, values);
        OS.XSetLineAttributes(xDisplay, this.handle, values.line_width, line_style, 2, 0);
    }

    public void setLineWidth(int width) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int line_style = this.data.lineStyle == 1 ? 0 : 1;
        OS.XSetLineAttributes(this.data.display, this.handle, width, line_style, 2, 0);
    }

    void setString(String string) {
        if (string == this.data.string) {
            return;
        }
        if (this.data.xmString != 0) {
            OS.XmStringFree(this.data.xmString);
        }
        byte[] buffer = Converter.wcsToMbcs(this.getCodePage(), string, true);
        this.data.xmString = OS.XmStringCreate(buffer, OS.XmFONTLIST_DEFAULT_TAG);
        this.data.string = string;
        this.data.stringHeight = -1;
        this.data.stringWidth = -1;
    }

    void setText(String string, int flags) {
        if (this.data.renderTable == 0) {
            this.createRenderTable();
        }
        if (string == this.data.text && (flags & 0xFFFFFFFE) == (this.data.drawFlags & 0xFFFFFFFE)) {
            return;
        }
        if (this.data.xmText != 0) {
            OS.XmStringFree(this.data.xmText);
        }
        if (this.data.xmMnemonic != 0) {
            OS.XmStringFree(this.data.xmMnemonic);
        }
        char mnemonic = '\u0000';
        int tableLength = 0;
        Device device = this.data.device;
        int[] parseTable = new int[2];
        char[] text = new char[string.length()];
        string.getChars(0, text.length, text, 0);
        if ((flags & 2) != 0) {
            parseTable[tableLength++] = device.crMapping;
        }
        if ((flags & 4) != 0) {
            parseTable[tableLength++] = device.tabMapping;
        }
        if ((flags & 8) != 0) {
            mnemonic = this.fixMnemonic(text);
        }
        String codePage = this.getCodePage();
        byte[] buffer = Converter.wcsToMbcs(codePage, text, true);
        this.data.xmText = OS.XmStringParseText(buffer, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, parseTable, tableLength, 0);
        if (mnemonic != '\u0000') {
            byte[] buffer1 = Converter.wcsToMbcs(codePage, new char[]{mnemonic}, true);
            this.data.xmMnemonic = OS.XmStringCreate(buffer1, OS.XmFONTLIST_DEFAULT_TAG);
        } else {
            this.data.xmMnemonic = 0;
        }
        this.data.text = string;
        this.data.textHeight = -1;
        this.data.textWidth = -1;
        this.data.drawFlags = flags;
    }

    public void setXORMode(boolean xor) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        OS.XSetFunction(this.data.display, this.handle, xor ? 6 : 3);
    }

    public Point stringExtent(String string) {
        int height;
        int width;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        this.setString(string);
        if (this.data.stringWidth != -1) {
            return new Point(this.data.stringWidth, this.data.stringHeight);
        }
        if (string.length() == 0) {
            width = 0;
            height = this.getFontHeight();
        } else {
            int fontList = this.data.font.handle;
            int xmString = this.data.xmString;
            width = OS.XmStringWidth(fontList, xmString);
            height = OS.XmStringHeight(fontList, xmString);
        }
        this.data.stringWidth = width;
        this.data.stringHeight = height;
        return new Point(this.data.stringWidth, this.data.stringHeight);
    }

    public Point textExtent(String string) {
        return this.textExtent(string, 6);
    }

    public Point textExtent(String string, int flags) {
        int height;
        int width;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        this.setText(string, flags);
        if (this.data.textWidth != -1) {
            return new Point(this.data.textWidth, this.data.textHeight);
        }
        if (string.length() == 0) {
            width = 0;
            height = this.getFontHeight();
        } else {
            int fontList = this.data.font.handle;
            int xmText = this.data.xmText;
            width = OS.XmStringWidth(fontList, xmText);
            height = OS.XmStringHeight(fontList, xmText);
        }
        this.data.textWidth = width;
        this.data.textHeight = height;
        return new Point(this.data.textWidth, this.data.textHeight);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "GC {*DISPOSED*}";
        }
        return "GC {" + this.handle + "}";
    }
}

