/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;

class Header
extends Canvas {
    private static final int DEFAULT_WIDTH = 64;
    private static final int DEFAULT_HEIGHT = 64;
    private static final int VERTICAL_MARGIN = 6;
    private static final int DEFAULT_ITEM_WIDTH = 9;
    private static final int HORIZONTAL_MARGIN = 6;
    Table parent;

    Header(Table parent) {
        super(parent, 0x180000);
        this.parent = parent;
        this.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                Header.this.paint(event);
            }
        });
        this.setHeaderHeight();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < this.getItemCount()) {
            width += this.getBounds((int)i).width;
            if (height == 0) {
                height = this.getBounds((int)i).height;
            }
            ++i;
        }
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    void drawHighlightShadow(GC gc, int itemIndex) {
        Rectangle bounds = this.getBounds(itemIndex);
        Color oldForeground = this.getForeground();
        gc.setForeground(this.display.getSystemColor(20));
        gc.drawLine(bounds.x, bounds.y, bounds.x + bounds.width - 1, bounds.y);
        gc.drawLine(bounds.x, bounds.y, bounds.x, bounds.y + bounds.height - 1);
        gc.setForeground(oldForeground);
    }

    void drawLowlightShadows(GC gc, int itemIndex) {
        Rectangle bounds = this.getBounds(itemIndex);
        Point bottomShadowStart = new Point(bounds.x + 1, bounds.height - 2);
        Point bottomShadowStop = new Point(bottomShadowStart.x + bounds.width - 2, bottomShadowStart.y);
        Point rightShadowStart = null;
        Point rightShadowStop = null;
        Color oldForeground = this.getForeground();
        gc.setForeground(this.display.getSystemColor(18));
        gc.drawLine(bottomShadowStart.x, bottomShadowStart.y, bottomShadowStop.x, bottomShadowStop.y);
        if (itemIndex != -1) {
            rightShadowStart = new Point(bounds.x + bounds.width - 2, bounds.y + 1);
            rightShadowStop = new Point(rightShadowStart.x, bounds.height - 2);
            gc.drawLine(rightShadowStart.x, rightShadowStart.y, rightShadowStop.x, rightShadowStop.y);
        }
        --bottomShadowStart.x;
        ++bottomShadowStart.y;
        ++bottomShadowStop.y;
        gc.setForeground(this.display.getSystemColor(17));
        gc.drawLine(bottomShadowStart.x, bottomShadowStart.y, bottomShadowStop.x, bottomShadowStop.y);
        if (itemIndex != -1) {
            ++rightShadowStart.x;
            --rightShadowStart.y;
            ++rightShadowStop.y;
            ++rightShadowStop.x;
            gc.drawLine(rightShadowStart.x, rightShadowStart.y, rightShadowStop.x, rightShadowStop.y);
        }
        gc.setForeground(oldForeground);
    }

    Rectangle getBounds(int itemIndex) {
        Rectangle bounds = null;
        int itemCount = this.getItemCount();
        if (itemIndex >= 0 && itemIndex < itemCount) {
            bounds = this.parent.internalGetColumn(itemIndex).getBounds();
            bounds.y = 0;
            bounds.height = this.getBounds().height;
        } else if (itemIndex == -1) {
            if (itemCount > 0) {
                bounds = this.parent.internalGetColumn(itemCount - 1).getBounds();
                bounds.x += bounds.width;
            } else {
                bounds = new Rectangle(0, 0, 0, 0);
            }
            bounds.width = Math.max(0, this.getBounds().width - bounds.x);
            bounds.y = 0;
            bounds.height = this.getBounds().height;
        }
        return bounds;
    }

    Image getImage(int itemIndex) {
        if (itemIndex >= 0 && itemIndex < this.getItemCount()) {
            return this.parent.internalGetColumn(itemIndex).getImage();
        }
        return null;
    }

    Point getImageExtent() {
        Image image = null;
        int labelCount = this.getItemCount();
        int i = 0;
        while (i < labelCount && image == null) {
            image = this.getImage(i);
            ++i;
        }
        if (image != null) {
            return new Point(image.getBounds().width, image.getBounds().height);
        }
        return new Point(0, 0);
    }

    int getItemCount() {
        return this.parent.internalGetColumnCount();
    }

    int getPreferredWidth(int index) {
        Image image = this.getImage(index);
        String text = this.getText(index);
        int headerWidth = 6;
        if (image != null) {
            headerWidth += this.getImageExtent().x + 6;
        }
        if (text != null) {
            headerWidth += this.getTextWidth(text) + 6;
        }
        return headerWidth;
    }

    String getText(int itemIndex) {
        String itemLabel = null;
        if (itemIndex >= 0 && itemIndex < this.getItemCount()) {
            itemLabel = this.parent.internalGetColumn(itemIndex).getText();
        }
        return itemLabel;
    }

    int getTextWidth(String text) {
        int textWidth = 0;
        if (text != null) {
            GC gc = new GC(this.parent);
            textWidth = gc.stringExtent((String)text).x;
            gc.dispose();
        }
        return textWidth;
    }

    void paint(GC gc, int itemIndex) {
        gc.setFont(this.parent.getFont());
        Rectangle bounds = this.getBounds(itemIndex);
        gc.fillRectangle(bounds.x, bounds.y + 1, bounds.width, bounds.height - 3);
        if (itemIndex != -1) {
            String label;
            int extent = Math.min(bounds.width - 12, this.getPreferredWidth(itemIndex));
            int x = bounds.x;
            int alignment = this.parent.internalGetColumn(itemIndex).getAlignment();
            x = (alignment & 0x1000000) != 0 ? (x += (bounds.width - extent) / 2) : ((alignment & 0x20000) != 0 ? (x += bounds.width - extent - 6) : (x += 6));
            Image image = this.getImage(itemIndex);
            if (image != null) {
                Rectangle imageBounds = image.getBounds();
                Point imageExtent = this.getImageExtent();
                int y = bounds.y + (bounds.height - imageExtent.y) / 2;
                gc.drawImage(image, 0, 0, imageBounds.width, imageBounds.height, x, y, imageExtent.x, imageExtent.y);
                x += imageExtent.x + 6;
            }
            if ((label = this.getText(itemIndex)) != null) {
                int maxWidth = bounds.x + bounds.width - x - 6;
                String trimLabel = this.parent.trimItemText(label, maxWidth, gc);
                Point textExtent = gc.stringExtent(trimLabel);
                int y = bounds.y + (bounds.height - textExtent.y) / 2;
                gc.drawString(trimLabel, x, y);
            }
        }
        this.drawHighlightShadow(gc, itemIndex);
        this.drawLowlightShadows(gc, itemIndex);
    }

    void paint(Event event) {
        int labelCount = this.getItemCount();
        int i = 0;
        while (i < labelCount) {
            this.paint(event.gc, i);
            ++i;
        }
        this.paint(event.gc, -1);
    }

    void redraw(int itemIndex) {
        Rectangle bounds = this.getBounds(itemIndex);
        if (bounds != null) {
            this.redraw(bounds.x, 0, bounds.width, bounds.height, false);
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.equals(this.getFont())) {
            return;
        }
        super.setFont(font);
        this.setHeaderHeight();
        this.redraw();
    }

    void setHeaderHeight() {
        int textHeight = this.parent.getFontHeight() + 6;
        int imageHeight = this.getImageExtent().y + 6;
        Rectangle bounds = this.getBounds();
        bounds.height = Math.max(textHeight, imageHeight);
        this.setBounds(bounds);
    }

    void widthChange(int itemIndex, int widthDiff) {
        Rectangle bounds = this.getBounds(itemIndex);
        Rectangle headerBounds = this.getBounds();
        if (bounds != null && itemIndex != -1) {
            this.scroll(bounds.x + bounds.width + widthDiff, 0, bounds.x + bounds.width, 0, headerBounds.width + widthDiff, headerBounds.height, false);
            this.redraw(bounds.x, 0, bounds.width, bounds.height, false);
        }
        headerBounds.width += widthDiff;
        this.setBounds(headerBounds);
    }
}

