package Lambda;

public class Conversion {
	
	private static boolean optimize(Term workTerm)
	{
		boolean changes = false;
		//1. Schritt: checke ob Term reduzierbar ist, wenn nicht dann probiere was
		
		//Mglichkeit 1
		//Term besitzt keine Argumente und keine freien Variablen mehr.
		//zB ( (\x.x y z) (arg1 arg2) ) 
		//Mglichkeit 2
		//Term besitzt keine freien Variablen mehr.
		//zB ( (\x.x) ) (arg1 arg2) oder ((\x.u (u x))) v
		
		
		if (	(workTerm.getParent() != null) 
			 && (workTerm.countArg() == 0) 
			 && (workTerm.getParent().countTerm() == 1))
		{
			//Klammern reduzieren
			int i;
			for (i = 0; i < workTerm.countVar(); i++)
			{
				workTerm.getParent().addVar(workTerm.getVar(i));
			}
			
			for (i = 0; i < workTerm.countTerm(); i++)
			{
				workTerm.getTerm(i).setParent(workTerm.getParent());
				workTerm.getParent().addTerm(workTerm.getTerm(i));
			}
			workTerm.getParent().removeTerm(0);
			changes = true;
		}
		return changes;
	}
	
	public static boolean beta(Term inputTerm)
	{
		boolean changes = false;
		
		Term inputParentTerm = inputTerm.getParent();
		Term workTerm = null;
		
		if (optimize(inputTerm))
		{
			//inputTerm wurde verndert
			workTerm = inputParentTerm;
		}
		else
		{
			//inputTerm wurde nicht verndert
			workTerm = inputTerm;
		}
		
		if ((workTerm.countVar() > 0) && (workTerm.countArg() == 0))
		{		
			//freie Variablen sind vorhanden, aber keine Argumente mehr
			if (workTerm.getParent() != null)
			{
				//Vater-Term vorhanden
				int i = workTerm.getPosition()+1;
				while ((i < workTerm.getParent().countTerm()) && (i != 0))
				{
					((Term) workTerm).addArg(workTerm.getParent().removeTerm(i));
				}
				
			}
		}

		if ((workTerm.countVar() > 0) && (workTerm.countArg() > 0))
		{		
			//Alle Vorraussetzungen fr Reduktion gegeben
			//Term besitzt Variablen, auf die diese Argumente angewendet werden knnen
			
			//ermittle zu ersetzende Variable und lsche sie
			String var = workTerm.removeVar(0);
			
			//ermittle Argument und lsche es
			Expression arg = workTerm.removeArg(0);	
			
			//fhre Ersetzung durch
			workTerm.replaceExp(var,arg);
			
			changes = true;
		}		
		
		Term outputParentTerm = workTerm.getParent();
		
		if (optimize(workTerm))
		{
			workTerm = outputParentTerm;	
		}
		
		//Optimiert doppelte Klammern die unter dem Term liegen
		if ((workTerm.countTerm() == 1) && (workTerm.getTerm(0).getClass() == workTerm.getClass()))
		{
			int j;
			for (j = 0; j < workTerm.getTerm(0).countVar(); j++)
			{
				workTerm.addVar(workTerm.getTerm(0).getVar(j));
			}
			
			for (j = 0; j < workTerm.getTerm(0).countTerm(); j++)
			{
				workTerm.getTerm(0).getTerm(j).setParent(workTerm.getTerm(0).getParent());
				workTerm.addTerm(workTerm.getTerm(0).getTerm(j));
			}
			workTerm.removeTerm(0);
		}
		
		return changes;
	}
	
	public static int churchNumeral(Expression workTerm)
	{
		int result = -1;
		int count = 0;
		boolean foundEnd = false;

		if ((workTerm != null) && (workTerm.countArg() == 0) && (workTerm.countVar() == 2) && 
			(workTerm.getVar(0).compareTo("f") == 0) && (workTerm.getVar(1).compareTo("x") == 0))
		{
			//eingegebene Term fngt richtig an
			Expression tmp = workTerm;
			
			while (!foundEnd)
			{
				if ((tmp.countTerm() == 2) && (tmp.getTerm(0).toString().compareTo("f") == 0) && (tmp.getTerm(1).countTerm() == 2))
				{
					count++;
					tmp = tmp.getTerm(1);
				}
				else
				{
					//Church Numeral zu ende oder Fehler
					if ((tmp.countTerm() == 2) && (tmp.getTerm(0).toString().compareTo("f") == 0) && (tmp.getTerm(1).toString().compareTo("x") == 0))
					{
						//Church erkannt!!!
						count++;
						result = count;
						foundEnd = true;
					}
					else
					{
						//Fehler!
						foundEnd = true;
					}
				}
			}
			
			
		}
		
		return result;
	}
	

}
