
package Source;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

import Lambda.Conversion;
import Lambda.Expression;
import Lambda.Function;
import Lambda.Library;
import Lambda.Parser;
import Lambda.Term;
public class MainForm {
	
	private static org.eclipse.swt.widgets.Display display = null;
	private org.eclipse.swt.widgets.Shell sShell = null;
	private org.eclipse.swt.widgets.Shell functionShell = null;
	private org.eclipse.swt.widgets.Shell aboutBoxShell = null;
	private Label labelInputLambda = null;
	private Label labelCurrentLambda = null;
	private Text textInputLambda = null;
	private ToolBar toolBar = null;
	private MenuItem menuItemDescription = null;
	private static Composite currentLambda = null;
	private static List termList = null;
	private List libList = null;
	public static Term fullWorkTerm;
	private Library myLib = null;
	private final String standardLibrary = "standard.lib";
	private final int maxAutoSteps = 10000;
	private final String version = "0.83";
	
	//Startet das Programm
    public static void main(String[] args) 
    {
    	System.setProperty("java.library.path",System.getProperty("user.dir"));
    	org.eclipse.swt.widgets.Display display = org.eclipse.swt.widgets.Display.getDefault();		
		MainForm thisClass = new MainForm();
		thisClass.createSShell();
		thisClass.sShell.open();
		while (!thisClass.sShell.isDisposed()) {
			if (!display.readAndDispatch()) display.sleep ();
		}
		display.dispose();		
	}
	
    //Stt den Parser an und wertet das Ergebnis aus
	private boolean parseInput()
	{
		//Term-Verlaufsliste lschen
		termList.removeAll();
		//Term einlesen
		Parser p = new Parser();
		fullWorkTerm = p.strToTerm(textInputLambda.getText(),myLib);
		
		//Fehler auswerten
		if (fullWorkTerm != null)
		{
			return true;
		}
		else
		{
			switch(Parser.getLastError())
			{
				case 0: 	showErrorBox(sShell,"Unknown Error");
							break;			
				case -1: 	showErrorBox(sShell,"PreparseError: Unknown Expressions in use (Library entry not found)");
							break;			
				case -2: 	showErrorBox(sShell,"PreparseError: Unknown Error");
							break;
				case 1: 	showErrorBox(sShell,"ParseError: Expression have to start with '('");
							break;
				case 2: 	showErrorBox(sShell,"ParseError: Wrong Parenthesis");
							break;
				case 3: 	showErrorBox(sShell,"ParseError: Wrong Parenthesis");
							break;
				case 4: 	showErrorBox(sShell,"ParseError: Expression ending expected");
							break;
				case 5: 	showErrorBox(sShell,"ParseError: Add Term or Variables");
							break;
				case 6: 	showErrorBox(sShell,"ParseError: Dot or Space between and behind variables expected");
							break;
				case 7: 	showErrorBox(sShell,"ParseError: Space expected");
							break;
				case 8: 	showErrorBox(sShell,"ParseError: Replace '#' with real Arguments");
							break;
				case 9: 	showErrorBox(sShell,"ParseError: Wrong parenthesis in Argument-List");
							break;
				case 10: 	showErrorBox(sShell,"ParseError: Unexpected Token");
							break;
				case 11: 	showErrorBox(sShell,"Please enter a Term");
							break;
			}
			
			return false;
		}
	}
	
	//Gibt eine Fehlermeldung aus
	private void showErrorBox(Shell myShell, String errorMsg) 
	{
		MessageBox mb = new MessageBox(myShell, SWT.ICON_ERROR);
		mb.setMessage(errorMsg);
		mb.setText("LambdaRed Error");
		mb.open();
	}
	
	//zentriert ein Dialog auf dem Hauptfenster
	public static void placeDialogInCenter(Shell parent, Shell shell)
	{
		Rectangle parentSize = parent.getBounds();
		Rectangle mySize = shell.getBounds();


		int locationX, locationY;
		locationX = (parentSize.width - mySize.width)/2+parentSize.x;
		locationY = (parentSize.height - mySize.height)/2+parentSize.y;


		shell.setLocation(new Point(locationX, locationY));
	}
	
	//Edititer eine Funktion
	private boolean editFunction(final Function myFunction)
	{
		functionShell = new Shell(SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
		functionShell.setSize(new org.eclipse.swt.graphics.Point(640,480));
		
		GridLayout gridLayoutFunction = new GridLayout();
		gridLayoutFunction.numColumns = 2;
		
		gridLayoutFunction.makeColumnsEqualWidth = false;
		functionShell.setLayout(gridLayoutFunction);
		
		//Name
		Label labelFunctionName = new Label(functionShell, SWT.NONE);
		labelFunctionName.setText("Name:");
		final Text textFunctionName = new Text(functionShell, SWT.BORDER);
		GridData gridDataFunctionName = new GridData(GridData.FILL_HORIZONTAL);
		gridDataFunctionName.widthHint = 300;
		textFunctionName.setLayoutData(gridDataFunctionName);
		
		//Anzahl Argumente
		Label labelFunctionArgs = new Label(functionShell, SWT.NONE);
		labelFunctionArgs.setText("Number of Arguments:");
		final Text textFunctionArgs = new Text(functionShell, SWT.BORDER);
		textFunctionArgs.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		//Funktion Lambda Term
		Label labelFunctionLambda = new Label(functionShell, SWT.NONE);
		labelFunctionLambda.setText("Lambda-Term:");
		final Text textFunctionLambda = new Text(functionShell, SWT.BORDER);
		textFunctionLambda.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		//Beschreibung
		Label labelFunctionDescription = new Label(functionShell, SWT.NONE);
		labelFunctionDescription.setText("Description:");
		final Text textFunctionDescription = new Text(functionShell, SWT.BORDER);
		textFunctionDescription.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		if (myFunction != null)
		{
			functionShell.setText("Edit Function");
			textFunctionName.setText(myFunction.getName());
			textFunctionArgs.setText(String.valueOf(myFunction.countArgs()));
			textFunctionLambda.setText(myFunction.getLambdaExp());
			textFunctionDescription.setText(myFunction.getDescription());
		}
		else
		{
			functionShell.setText("New Function");
		}
		
		final Button ok = new Button (functionShell, SWT.PUSH);
		ok.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		ok.setText ("Ok");
		
		Button cancel = new Button (functionShell, SWT.PUSH);
		cancel.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		cancel.setText ("Cancel");
		
		Listener listener = new Listener () {
			public void handleEvent (Event event) {
				if (event.widget == ok)
					{
						try
						{
							int i = Integer.parseInt(textFunctionArgs.getText());
							//OK wurde gedrckt
							if (myFunction == null)
							{
								//neue Funktion
								myLib.addFunction(new Function(textFunctionName.getText(),
															   i,
															   textFunctionLambda.getText(),
															   textFunctionDescription.getText()));
							}
							else
							{
								//edit Funktion
								myFunction.setName(textFunctionName.getText());
								myFunction.setCountArgs(i);
								myFunction.setLambdaExp(textFunctionLambda.getText());
								myFunction.setDescription(textFunctionDescription.getText());
							}
							writeLibList();
							functionShell.close ();
						}
						catch (NumberFormatException error) 
						{
							showErrorBox(functionShell,"Number of Arguments has to be an Integer!");
						}
						
						
					
					}
				else
				{
					functionShell.close ();
				}
				
			}
		};
		ok.addListener (SWT.Selection, listener);
		cancel.addListener (SWT.Selection, listener);	
		
		functionShell.pack ();
		functionShell.open ();
		placeDialogInCenter(sShell,functionShell);
		return true;
	}
	
	//AboutBox
	private void aboutBox()
	{
		aboutBoxShell = new Shell(SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
		aboutBoxShell.setText("About LambdaRed");	
		GridLayout gridLayoutFunction = new GridLayout();
		gridLayoutFunction.numColumns = 1;
		
		gridLayoutFunction.makeColumnsEqualWidth = false;
		aboutBoxShell.setLayout(gridLayoutFunction);
		
		Label labelLine1 = new Label(aboutBoxShell, SWT.NONE);
		labelLine1.setText("LambdaRed");
		labelLine1.setForeground(new org.eclipse.swt.graphics.Color(org.eclipse.swt.widgets.Display.getDefault(), 255, 0, 0));
		labelLine1.setFont(new org.eclipse.swt.graphics.Font(org.eclipse.swt.widgets.Display.getDefault(), "Lucida Grande", 12, org.eclipse.swt.SWT.BOLD));
		
		
		Label labelLine2 = new Label(aboutBoxShell, SWT.NONE);
		labelLine2.setText("TI Project 2005 by");
		
		Label labelLine3 = new Label(aboutBoxShell, SWT.NONE);
		labelLine3.setText("David Sonnabend (david.sonnabend@student.hpi.uni-potsdam.de)");
		
		Label labelLine4 = new Label(aboutBoxShell, SWT.NONE);
		labelLine4.setText("Lars Schneider (lars.schneider@hpi.uni-potsdam.de)");
		
		Button ok = new Button (aboutBoxShell, SWT.PUSH);
		ok.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		ok.setText ("Ok");
		
		Listener listener = new Listener () {
			public void handleEvent (Event event) {
				aboutBoxShell.close ();
			}
		};
		
		ok.addListener (SWT.Selection, listener);
		
		aboutBoxShell.pack ();
		aboutBoxShell.open ();
		placeDialogInCenter(sShell,aboutBoxShell);
	}
	
	//Startet eine manuelle Lambda Reduktion
	private void startLambdaConversion()
	{
		if (parseInput() == true)
		{
			buildInteractiveTerm();
		}
	}
	
	//Ld eine Library aus "filename"
	private void loadLibrary(String filename)
	{
		myLib = new Library();
		myLib.loadFromFile(filename);
		writeLibList();
	}
	
	//Schreibt die Library in die Liste
	private void writeLibList()
	{
		libList.removeAll();
		for (int i=0; i < myLib.countFunction(); i++)
		{
			libList.add(myLib.getFunction(i).getNameArgs());
		}
	}
	
	//baut einen neuen "Klick-Term" und ergnzt die LambdaListe
	public static void buildInteractiveTerm()
	{	
		//Term wird der Lamba-Reduzier-Liste hinzugefgt
		termList.add(fullWorkTerm.toString());
		//Lscht alle Elemente aus dem "Klick-Term" Kontainter
		while (currentLambda.getChildren().length > 0)
		{
			currentLambda.getChildren()[0].dispose();
		}
		//Fllt den Kontainer neu
		fullWorkTerm.toComposite(currentLambda);
		currentLambda.pack();
	}
	
	//erstetzt Zeichen in einem String
	private static String replaceAll(String source, String search, String replace) 
	{
		if(search.equals(replace)) 
		{
			return source;
		}

		StringBuffer result = new StringBuffer();
		int len = search.length();
		if(len == 0) 
		{
			return source; //verhindert Endlosschleife bei search.equals("");
		}

		int pos = 0; //position
		int nPos;    //next position
		do 
		{
			nPos = source.indexOf(search, pos);
			if(nPos != -1) 
			{ //gefunden
				result.append(source.substring(pos, nPos));
				result.append(replace);
				pos = nPos+len;
			} 
			else 
			{ //nicht gefunden
				result.append(source.substring(pos)); //letzter abschnitt
			}
		} while(nPos!= -1);

		return result.toString();
	}
	
	//Speichert die LambdaListe in einer Datei
	public void saveConversionToFile(String filename)
	{
		File outputFile; 
		FileWriter fw; 
		BufferedWriter bw; 
		String newline = System.getProperty("line.separator"); 
	
		try { 
		      outputFile = new File(filename); 
		      fw = new FileWriter(outputFile); 
		      bw = new BufferedWriter(fw); 

		      for (int i=0; i < termList.getItemCount(); i++)
		      {
		      		String s = replaceAll(termList.getItem(i), "\u03BB", "\\");
		  
		      		bw.write(s+newline) ;
		      }

		      bw.close(); 
		    } 
		    catch (ArrayIndexOutOfBoundsException aioobe) { 
		      System.out.println("Array Error!"); 
		    } 
		    catch (FileNotFoundException fnfe) { 
		      System.out.println("Catch Error: "+fnfe); 
		    } 
		    catch (IOException ioe) { 
		      System.out.println("Catch Error: "+ioe); 
		    } 
	}
	
	/*
	 * Button Funktionen
	 */
	
	//ffnet die Library
	private org.eclipse.swt.events.SelectionListener startMenuFileOpenLibrary()
	{
		return new org.eclipse.swt.events.SelectionListener()
		{ 
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) 
			{    
				final FileDialog fileOpener = new FileDialog(sShell, SWT.OPEN|SWT.MULTI);
				fileOpener.setText("Open Library Files...");
				fileOpener.setFilterExtensions(new String[] { "*.lib; *.txt;" });
				fileOpener.setFilterNames(new String[] {"Library Files (*.lib; *.txt)", "all (*.*)" });
				
				String filename = fileOpener.open();
				if (filename != null) 
				{
					loadLibrary(fileOpener.getFilterPath()+"\\"+fileOpener.getFileName());
				}
			}
			public void widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent e) {} 
		};
	}
	
	//Speichert die Library
	private org.eclipse.swt.events.SelectionListener startMenuFileSaveLibrary()
	{
		return new org.eclipse.swt.events.SelectionListener()
		{ 
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) 
			{    
				final FileDialog fileSaver = new FileDialog(sShell, SWT.SAVE|SWT.MULTI);
				fileSaver.setText("Save Library Files...");
				fileSaver.setFilterExtensions(new String[] { "*.lib; *.txt;" });
				fileSaver.setFilterNames(new String[] {"Library Files (*.lib; *.txt)", "all (*.*)" });
				
				String filename = fileSaver.open();
				if (filename != null) 
				{
					myLib.saveToFile(fileSaver.getFilterPath()+"\\"+fileSaver.getFileName());
				}
			}
			public void widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent e) {} 
		};
	}
	
	//Beendet das Programm
	private org.eclipse.swt.events.SelectionListener startMenuFileExit()
	{
		return new org.eclipse.swt.events.SelectionListener()
		{ 
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) 
			{    
				//Beendet Programm
				System.exit(0);
			}
			public void widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent e) {} 
		};
	}
	
	//Fgt der Library eine neue Funktion hinzu
	private org.eclipse.swt.events.SelectionListener startMenuLibraryAddFunction()
	{
		return new org.eclipse.swt.events.SelectionListener()
		{ 
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) 
			{    
				editFunction(null);
			}
			public void widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent e) {} 
		};
	}
	
	//Editiert die aktuelle Funktion
	private org.eclipse.swt.events.SelectionListener startMenuLibraryEditFunction()
	{
		return new org.eclipse.swt.events.SelectionListener()
		{ 
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) 
			{    
				int i = libList.getSelectionIndex();
				if (i >= 0)
				{
					editFunction(myLib.getFunction(i));
				}
			}
			public void widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent e) {} 
		};
	}
	
	//Lscht Funktion aus der Library
	private org.eclipse.swt.events.SelectionListener startMenuLibraryRemoveFunction()
	{
		return new org.eclipse.swt.events.SelectionListener()
		{ 
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) 
			{    
				int i = libList.getSelectionIndex();
				if (i >= 0)
				{
					myLib.removeFunction(i);
					writeLibList();
				}
			}
			public void widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent e) {} 
		};
	}
	
	//Setzt die aktuelle Library als Standard Library
	private org.eclipse.swt.events.SelectionListener startMenuLibrarySetAsDefault()
	{
		return new org.eclipse.swt.events.SelectionListener()
		{ 
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) 
			{    
				myLib.saveToFile(standardLibrary);
			}
			public void widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent e) {} 
		};
	}
	
	//Ld die aktuelle Standard Library
	private org.eclipse.swt.events.SelectionListener startMenuLibraryLoadDefault()
	{
		return new org.eclipse.swt.events.SelectionListener()
		{ 
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) 
			{    
				loadLibrary(standardLibrary);
			}
			public void widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent e) {} 
		};
	}
	
	//Importiert eine Library
	private org.eclipse.swt.events.SelectionListener startMenuLibraryImport()
	{
		return new org.eclipse.swt.events.SelectionListener()
		{ 
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) 
			{    
				final FileDialog fileOpener = new FileDialog(sShell, SWT.OPEN|SWT.MULTI);
				fileOpener.setText("Import Library Files...");
				fileOpener.setFilterExtensions(new String[] { "*.lib; *.txt;" });
				fileOpener.setFilterNames(new String[] {"Library Files (*.lib; *.txt)", "all (*.*)" });
				
				String filename = fileOpener.open();
				if (filename != null) 
				{
					Library myImportLib = new Library();
					myImportLib.loadFromFile(filename);
					
					for (int i=0; i<myImportLib.countFunction(); i++)
					{
						myLib.addFunction(myImportLib.getFunction(i));
					}
					writeLibList();
				}
			}
			public void widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent e) {} 
		};
	}
	
	//Startet eine manuelle Lambda Reduktion
	private org.eclipse.swt.events.SelectionListener startMenuLambdaConversion()
	{
		return new org.eclipse.swt.events.SelectionListener()
		{ 
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) 
			{    
				startLambdaConversion();
			}
			public void widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent e) {} 
		};
	}
	
	private Expression searchForConvertableTerm(Expression checkTerm)
	{
		Expression result = null;
		if ((checkTerm.countVar() > 0) && !((checkTerm.countArg() == 0) && (checkTerm.getParent() == null)) )
		{
			result = checkTerm;
		}
		else
		{
			if (checkTerm.countTerm() > 0)
			{
				int i=0;
				while ((i < checkTerm.countTerm()) && (result == null))
				{
					result = searchForConvertableTerm(checkTerm.getTerm(i));
					i++;
				}
			}
		}
	
		return result;
	}
	
	//Startet eine automatische Lambda Reduktion
	private org.eclipse.swt.events.SelectionListener startMenuLambdaConversionAuto()
	{
		return new org.eclipse.swt.events.SelectionListener()
		{ 
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) 
			{    
				
				if (parseInput() == true)
				{
					termList.add(fullWorkTerm.toString());
					int i=0;
					//Reduziert den Hauptterm bis alle Argumente aufgebraucht sind
					while ((Conversion.beta(fullWorkTerm)) && (i < maxAutoSteps)) 
					{
						termList.add(fullWorkTerm.toString());	
						i++;
					};
					
					//durchsuche Term und reduziere
					Expression exp = fullWorkTerm;
					while ((exp != null) && (i < maxAutoSteps))
					{		
						Conversion.beta((Term) exp);
						termList.add(fullWorkTerm.toString());
		
						exp = searchForConvertableTerm((Expression) fullWorkTerm);
						i++;
					}	
					
					if (i == maxAutoSteps)
					{
						showErrorBox(sShell,"Maximum step count has been reached. The formula may contain mistakes.");
					}
					}
			}
			public void widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent e) {} 
		};
	}
	
	//Wandelt ein Church Numeral um
	private org.eclipse.swt.events.SelectionListener startMenuLambdaConvertChurchNumeral()
	{
		return new org.eclipse.swt.events.SelectionListener()
		{ 
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) 
			{    
				int i = Conversion.churchNumeral(fullWorkTerm);
				if (i != -1)
				{
					termList.add("Number: "+i);
				}
				else
				{
					termList.add("No Church Numeral identified!");
				}
			}
			public void widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent e) {} 
		};
	}
	
	//Speichert die Liste in einer Datei
	private org.eclipse.swt.events.SelectionListener startMenuLambdaSaveToFile()
	{
		return new org.eclipse.swt.events.SelectionListener()
		{ 
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) 
			{    
				
				final FileDialog fileSaver = new FileDialog(sShell, SWT.SAVE|SWT.MULTI);
				fileSaver.setText("Save Conversion History...");
				fileSaver.setFilterExtensions(new String[] { "*.txt" });
				fileSaver.setFilterNames(new String[] {"Conversion History Files (*.txt)", "all (*.*)" });
				
				String filename = fileSaver.open();
				if (filename != null) 
				{
					saveConversionToFile(fileSaver.getFilterPath()+"\\"+fileSaver.getFileName());
				}
				
			}
			public void widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent e) {} 
		};
	}
	
	//Subert die Lambda-Eingabe
	private org.eclipse.swt.events.SelectionListener startMenuLambdaClear()
	{
		return new org.eclipse.swt.events.SelectionListener()
		{ 
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) 
			{    
				//Lscht alle Elemente aus dem "Klick-Term" Kontainter
				while (currentLambda.getChildren().length > 0)
				{
					currentLambda.getChildren()[0].dispose();
				}
				textInputLambda.setText("");
				termList.removeAll();
			}
			public void widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent e) {} 
		};
	}
	
	//ffnet die AboutBox
	private org.eclipse.swt.events.SelectionListener startMenuAboutBox()
	{
		return new org.eclipse.swt.events.SelectionListener()
		{ 
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) 
			{    
				aboutBox();
			}
			public void widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent e) {} 
		};
	}
	
	/*
	 * GUI Aufbau
	 */
	
	//Baut das Menu
	private void createMenu()
	{
		Menu menu = new Menu(sShell, SWT.BAR);
		sShell.setMenuBar(menu);
		
		//File Menu
		MenuItem menuFileItem = new MenuItem(menu, SWT.CASCADE);
		menuFileItem.setText("File");
		Menu menuFile = new Menu(sShell, SWT.DROP_DOWN);
		menuFileItem.setMenu(menuFile);
		//Open Library
		MenuItem menuFileOpenLibraryBtn = new MenuItem(menuFile, SWT.PUSH);
		menuFileOpenLibraryBtn.setText("Open Library");
		menuFileOpenLibraryBtn.addSelectionListener(startMenuFileOpenLibrary());
		//Save Library
		MenuItem menuFileSaveLibraryBtn = new MenuItem(menuFile, SWT.PUSH);
		menuFileSaveLibraryBtn.setText("Save Library");
		menuFileSaveLibraryBtn.addSelectionListener(startMenuFileSaveLibrary());
		//Trenner
		new MenuItem(menuFile, SWT.SEPARATOR);
		//Exit
		MenuItem menuFileExitBtn = new MenuItem(menuFile, SWT.PUSH);
		menuFileExitBtn.setText("Exit");
		menuFileExitBtn.addSelectionListener(startMenuFileExit());
		
		//Library Menu
		MenuItem menuLibraryItem = new MenuItem(menu, SWT.CASCADE);
		menuLibraryItem.setText("Library");
		Menu menuLibrary = new Menu(sShell, SWT.DROP_DOWN);
		menuLibraryItem.setMenu(menuLibrary);
		//Add function
		MenuItem menuLibraryAddFunctionBtn = new MenuItem(menuLibrary, SWT.PUSH);
		menuLibraryAddFunctionBtn.setText("Add Function");
		menuLibraryAddFunctionBtn.addSelectionListener(startMenuLibraryAddFunction());	
		//Edit function
		MenuItem menuLibraryEditFunctionBtn = new MenuItem(menuLibrary, SWT.PUSH);
		menuLibraryEditFunctionBtn.setText("Edit Function");
		menuLibraryEditFunctionBtn.addSelectionListener(startMenuLibraryEditFunction());	
		//Remove function
		MenuItem menuLibraryRemoveFunctionBtn = new MenuItem(menuLibrary, SWT.PUSH);
		menuLibraryRemoveFunctionBtn.setText("Remove Function");
		menuLibraryRemoveFunctionBtn.addSelectionListener(startMenuLibraryRemoveFunction());	
		//Trenner
		new MenuItem(menuLibrary, SWT.SEPARATOR);
		//Set library as default
		MenuItem menuLibrarySetDefaultBtn = new MenuItem(menuLibrary, SWT.PUSH);
		menuLibrarySetDefaultBtn.setText("Set Library as Standard");
		menuLibrarySetDefaultBtn.addSelectionListener(startMenuLibrarySetAsDefault());	
		//Load default Library
		MenuItem menuLibraryLoadDefaultBtn = new MenuItem(menuLibrary, SWT.PUSH);
		menuLibraryLoadDefaultBtn.setText("Load Standard Library");
		menuLibraryLoadDefaultBtn.addSelectionListener(startMenuLibraryLoadDefault());			
		//Trenner
		new MenuItem(menuLibrary, SWT.SEPARATOR);		
		//Import library
		MenuItem menuLibraryImportBtn = new MenuItem(menuLibrary, SWT.PUSH);
		menuLibraryImportBtn.setText("Import Library");
		menuLibraryImportBtn.addSelectionListener(startMenuLibraryImport());
		
		//Lambda Menu
		MenuItem menuLambdaItem = new MenuItem(menu, SWT.CASCADE);
		menuLambdaItem.setText("Lambda");
		Menu menuLambda = new Menu(sShell, SWT.DROP_DOWN);
		menuLambdaItem.setMenu(menuLambda);
		//Start Lambda conversion
		MenuItem menuLambdaStartBtn = new MenuItem(menuLambda, SWT.PUSH);
		menuLambdaStartBtn.setText("Start Lambda Conversion");
		menuLambdaStartBtn.addSelectionListener(startMenuLambdaConversion());
		//Start Automatic Lambda Conversion
		MenuItem menuLambdaStartAutoBtn = new MenuItem(menuLambda, SWT.PUSH);
		menuLambdaStartAutoBtn.setText("Start Automatic Lambda Conversion");
		menuLambdaStartAutoBtn.addSelectionListener(startMenuLambdaConversion());
		//Trenner
		new MenuItem(menuLambda, SWT.SEPARATOR);
		//Convert church numeral
		MenuItem menuLambdaConvertChurchBtn = new MenuItem(menuLambda, SWT.PUSH);
		menuLambdaConvertChurchBtn.setText("Convert Church Numeral");
		menuLambdaConvertChurchBtn.addSelectionListener(startMenuLambdaConvertChurchNumeral());
		new MenuItem(menuLambda, SWT.SEPARATOR);
		//Save Conversion To File
		MenuItem menuLambdaSaveToFileBtn = new MenuItem(menuLambda, SWT.PUSH);
		menuLambdaSaveToFileBtn.setText("Save Conversion to File");
		menuLambdaSaveToFileBtn.addSelectionListener(startMenuLambdaSaveToFile());
		//Clear
		MenuItem menuLambdaClearBtn = new MenuItem(menuLambda, SWT.PUSH);
		menuLambdaClearBtn.setText("Clear Lambda");
		menuLambdaClearBtn.addSelectionListener(startMenuLambdaClear());
		
		//Help Menu
		MenuItem menuHelpItem = new MenuItem(menu, SWT.CASCADE);
		menuHelpItem.setText("Help");
		Menu menuHelp = new Menu(sShell, SWT.DROP_DOWN);
		menuHelpItem.setMenu(menuHelp);
		//About
		MenuItem menuHelpAboutBtn = new MenuItem(menuHelp, SWT.PUSH);
		menuHelpAboutBtn.setText("About");
		menuHelpAboutBtn.addSelectionListener(startMenuAboutBox());
	}
 
	//Baut die ToolBar
	private void createToolBar() 
	{
		toolBar = new ToolBar(sShell, SWT.HORIZONTAL | SWT.FLAT);	
		
		ToolItem BtnOpen = new ToolItem(toolBar, SWT.PUSH);
		BtnOpen.setText(" Open ");
		BtnOpen.setToolTipText("Open Library");	
		BtnOpen.addSelectionListener(startMenuFileOpenLibrary());
		BtnOpen.setWidth(50);
		
		ToolItem BtnSave = new ToolItem(toolBar, SWT.PUSH);
		BtnSave.setText(" Save ");
		BtnSave.setToolTipText("Save Library");
		BtnSave.addSelectionListener(startMenuFileSaveLibrary());
		
		ToolItem BtnGo = new ToolItem(toolBar, SWT.PUSH);
		BtnGo.setText("  Go  ");
		BtnGo.setToolTipText("Start Lambda conversion");
		BtnGo.addSelectionListener(startMenuLambdaConversion());
		
		ToolItem BtnAuto = new ToolItem(toolBar, SWT.PUSH);
		BtnAuto.setText(" Auto ");
		BtnAuto.setToolTipText("Start Automatic Lambda Conversion");
		BtnAuto.addSelectionListener(startMenuLambdaConversionAuto());
		
		ToolItem BtnChurch = new ToolItem(toolBar, SWT.PUSH);
		BtnChurch.setText("Church");
		BtnChurch.setToolTipText("Convert a Church Numeral");
		BtnChurch.addSelectionListener(startMenuLambdaConvertChurchNumeral());
		
		ToolItem BtnClear = new ToolItem(toolBar, SWT.PUSH);
		BtnClear.setText("Clear");
		BtnClear.setToolTipText("Clear Lambda Input");
		BtnClear.addSelectionListener(startMenuLambdaClear());
		
		ToolItem BtnExit = new ToolItem(toolBar, SWT.PUSH);		
		BtnExit.setText(" Exit ");
		BtnExit.setToolTipText("Exit LambdaRed");
		BtnExit.addSelectionListener(startMenuFileExit());
		
		GridData gridDataToolBar = new GridData(GridData.FILL_HORIZONTAL);
		gridDataToolBar.horizontalSpan = 2;
		toolBar.setLayoutData(gridDataToolBar);
		BtnOpen.setImage(new Image(Display.getCurrent(), getClass().getResourceAsStream("/Ressource/open.gif")));
		BtnSave.setImage(new Image(Display.getCurrent(), getClass().getResourceAsStream("/Ressource/save.gif")));
		BtnGo.setImage(new Image(Display.getCurrent(), getClass().getResourceAsStream("/Ressource/run.gif")));
		BtnAuto.setImage(new Image(Display.getCurrent(), getClass().getResourceAsStream("/Ressource/auto_run.gif")));
		BtnChurch.setImage(new Image(Display.getCurrent(), getClass().getResourceAsStream("/Ressource/convert.gif")));
		BtnClear.setImage(new Image(Display.getCurrent(), getClass().getResourceAsStream("/Ressource/clear.gif")));
		BtnExit.setImage(new Image(Display.getCurrent(), getClass().getResourceAsStream("/Ressource/exit.gif")));
		
	}

	//Baut den Container fr den interaktiven LambdaTerm
	private void createCurrentLambda() 
	{
		currentLambda = new Composite(sShell, SWT.NONE);		   
		currentLambda.setLayout(new RowLayout());
		currentLambda.setLayoutData(new GridData(GridData.CENTER));
	}

	//Fgt alles zusammen
	private void createSShell() {
		sShell = new Shell(SWT.BORDER | SWT.SHELL_TRIM);
		sShell.setText("LambdaRed - Version "+version);
		sShell.setSize(new org.eclipse.swt.graphics.Point(640,480));
		
		GridLayout gridLayoutMain = new GridLayout();
		gridLayoutMain.numColumns = 2;
		
		gridLayoutMain.makeColumnsEqualWidth = false;
		sShell.setLayout(gridLayoutMain);
		
		createMenu();
		createToolBar();
		
		labelInputLambda = new Label(sShell, SWT.NONE);
		labelInputLambda.setText("Lambda-Ausdruck:");
		
		textInputLambda = new Text(sShell, SWT.BORDER);
		textInputLambda.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		textInputLambda.addKeyListener(new org.eclipse.swt.events.KeyAdapter() 
		{ 
			public void keyReleased(org.eclipse.swt.events.KeyEvent e) 
			{ 
//				TODO auto reduktion shortcut
				//Checkt ob "Enter" gedrckt wurde...
				if (e.character == 13)
				{
					startLambdaConversion();
				}
			}
		});
		
		labelCurrentLambda = new Label(sShell, SWT.NONE);
		labelCurrentLambda.setText("Aktueller-Ausdruck:");
		labelCurrentLambda.setFont(new org.eclipse.swt.graphics.Font(org.eclipse.swt.widgets.Display.getDefault(), "Lucida Grande", 10, org.eclipse.swt.SWT.NORMAL));
		
		createCurrentLambda();
		
		libList = new List(sShell, SWT.H_SCROLL | SWT.BORDER);
		libList.setLayoutData(new GridData(GridData.FILL_VERTICAL | GridData.HORIZONTAL_ALIGN_FILL));
		Menu popupMenu = new Menu(sShell, SWT.POP_UP);
		
		menuItemDescription = new MenuItem(popupMenu, SWT.NONE);
		menuItemDescription.setText("<<Description>>");
		
		MenuItem menuItemSeperator = new MenuItem(popupMenu, SWT.SEPARATOR);
		
		MenuItem menuItemNewFunction = new MenuItem(popupMenu, SWT.PUSH);
		menuItemNewFunction.setText("Add Function");
		menuItemNewFunction.addSelectionListener(startMenuLibraryAddFunction());
		
		MenuItem menuItemEditFunction = new MenuItem(popupMenu, SWT.PUSH);
		menuItemEditFunction.setText("Edit Function");
		menuItemEditFunction.addSelectionListener(startMenuLibraryEditFunction());
		
		MenuItem menuItemDeleteFunction = new MenuItem(popupMenu, SWT.PUSH);
		menuItemDeleteFunction.setText("Remove Function");
		menuItemDeleteFunction.addSelectionListener(startMenuLibraryRemoveFunction());
			
		popupMenu.addMenuListener(new MenuListener() 
		{
			public void menuShown(MenuEvent e) 
			{
				int i = libList.getSelectionIndex();
				if (i >= 0)
				{
					menuItemDescription.setEnabled(true);
					menuItemDescription.setText(myLib.getFunction(i).getDescription());
				}
				else
				{
					menuItemDescription.setEnabled(false);
				}
			}
			public void menuHidden(MenuEvent e) {}
		});
		
		libList.setMenu(popupMenu);
		
		libList.addMouseListener(new org.eclipse.swt.events.MouseAdapter() 
				{ 
					public void mouseDown(org.eclipse.swt.events.MouseEvent e) 
					{    
						if (e.button == 1)
						{	//Linker Maus-Btn wurde gedrckt
							int i = libList.getSelectionIndex();
							if (i >= 0)
							{
								if (textInputLambda.getText().compareTo("") == 0)
								{
									textInputLambda.insert("$"+libList.getItem(i));
								}
								else
								{
									textInputLambda.insert("($"+libList.getItem(i)+")");
								}
								textInputLambda.setFocus();
							}
						}
					}
				});
		//Ld Standard-Bibliothek wenn vorhanden
		loadLibrary(standardLibrary);
		
		termList = new List(sShell, SWT.BORDER | SWT.V_SCROLL | SWT.H_SCROLL);		
		termList.setLayoutData(new GridData(GridData.FILL_HORIZONTAL | GridData.FILL_VERTICAL));		
		
	}
}
