#!/usr/bin/python -W ignore

import re
import os
import sys
import time
import os.path
import shutil
import tempfile
import optparse
import subprocess
import sys

grounder = "gringo"
xml2lp   = "./xml2lp.py"
as2sbml  = "./as2sbml.py"
solver   = "clasp"
#solver2  = "clasp-sl"
solver2  = "clasp"
bin      = "programs/"
encodings= "encodings/"
solutions= "solutions/"
labeling = "labeling.lp"
useadds  = "useadds.lp"
symmetry = "symmetry.lp"
splitting= "splitting.lp"
ordering = "ordering.lp"
maxR     = "maxReactions.lp"
outputf  = "solution.as"
reactionsPerResponse = "reactionsPerResponse.lp"
approximateReactions = "approximateReactions.lp"
maximizeReactions    = "maximizeReactions.lp"
minimizeSpecies      = "minimizeChanges.lp"
showReactions        = "showReactions.lp"
setChanges           = "setChanges.lp"

class A:
	def __init__(self, fehler):
		self.fehler = fehler


def maxNumberOfReactions(maxAdds, instance):
	#collect all responses in instance
	instance.seek(0)
	instance.flush()
	allResponses = []
	for i in instance:
		if (i.find("response") != -1):
			allResponses.append(i.replace(" ",""))
	instance.seek(0)
	instance.flush()
	numReaction=1
	responsesArray = []
	responses = []
	responses.append(allResponses)
	while (numReaction!=-1):
		instance.seek(0)
		instance.flush()
		proc = subprocess.Popen([bin+grounder, "-", "-c maxAdds="+maxAdds,"-c numberReaction="+str(numReaction), encodings+useadds, encodings+reactionsPerResponse], stdin=instance, stdout=subprocess.PIPE)
		proc2= subprocess.Popen([bin+solver,  "--project", "--heur=Vmtf", "0"], stdin=proc.stdout, stdout=subprocess.PIPE)
		output = proc2.communicate()[0].split("\n")
		if (numReaction == 0):
			for i in output:
				if (i.find("Model") != -1):
					start = i.find(":")+len(": ")
					if (int(i[start:]) != len(allResponses)):
						return (-1,0,[])
						#raise A("Found a response that can not be explained")
		else:
			allResponses = []
			for i in output:
				if (i.find("chosen") != -1):
					string = (i.replace("chosen","response")+".\n").replace(" ","")
					allResponses.append(string)
					responses[numReaction-1].remove(string)
		if (proc2.returncode == 20):
			break
		responses.append(allResponses)
		numReaction+=1

	instance.seek(0)
	instance.flush()
	extendedInstance = tempfile.TemporaryFile("w+r+b")
	extendedInstance.write(instance.read())
	sum = 0
	for i in xrange(0,len(responses)):
		sum += len(responses[i])*(i+1)

	extendedInstance.seek(0,os.SEEK_END)
	extendedInstance.flush()
	for i in xrange(0,len(responses)):
		for r in responses[i]:
			extendedInstance.write(r.replace(").", ","+str(i+1)+")."))
#			print r.replace(").", ","+str(i+1)+").")
	
	extendedInstance.seek(0)
	extendedInstance.flush()
	print "\tApproximate reactions"
	proc = subprocess.Popen([bin+grounder, "-", "-c maxAdds="+maxAdds, encodings+useadds, encodings+approximateReactions], stdin=extendedInstance, stdout=subprocess.PIPE)
	proc2= subprocess.Popen([bin+solver2,  "--restart-on-model", "0"], stdin=proc.stdout, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
	output = proc2.communicate()[0].split("\n")
	if (proc2.returncode==20):
		return (-1,0,[])
	for out in output:
		if (out.find("result") != -1):
			start = out.find("result")+len("result(")
			sum = int(out[start:out.find(")",start)])

	extendedInstance.seek(0)
	extendedInstance.flush()
	minChanges = 0
	if (int(maxAdds)!=0):
		print "\tSearching for minimal number of changes (" + str(sum) + " reactions)"
		proc = subprocess.Popen([bin+grounder, encodings+useadds, "-c maxAdds="+maxAdds, encodings+maxR, "-c maxReaction="+str(sum), "-", encodings+splitting, encodings+ordering, encodings+symmetry, encodings+minimizeSpecies], stdin=extendedInstance, stdout=subprocess.PIPE)
		proc2= subprocess.Popen([bin+solver2,  "--sat-prepro", "--restart-on-model", "--back", "0", "--project"], stdin=proc.stdout, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
		output = proc2.communicate()[0].split("\n")
		if (proc2.returncode==20):
			return (-1,0,[])
		for out in output:
			if (out.find("Optimization") != -1):
				start = out.find("Optimization")+len("Optimization: ")
				minChanges = int(out[start:])
		extendedInstance.seek(0)
		extendedInstance.flush()

		print "\tApproximate reactions"
		proc = subprocess.Popen([bin+grounder, "-", "-c maxAdds="+maxAdds, encodings+useadds, encodings+setChanges, "-c numChanges="+str(minChanges), encodings+approximateReactions], stdin=extendedInstance, stdout=subprocess.PIPE)
		proc2= subprocess.Popen([bin+solver2, "--sat-prepro", "--back", "--restarts=512", "--solu", "--restart-on-model", "0"], stdin=proc.stdout, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
		output = proc2.communicate()[0].split("\n")
		if (proc2.returncode==20):
			return (-1,0,[])
		for out in output:
			if (out.find("result") != -1):
				start = out.find("result")+len("result(")
				sum = int(out[start:out.find(")",start)])

		extendedInstance.seek(0)
		extendedInstance.flush()

	print "\tSearching for maximal number of reactions (" + str(minChanges) + " changes and "+str(sum)+" reactions)"

	proc = subprocess.Popen([bin+grounder, encodings+useadds, "-c maxAdds="+maxAdds, encodings+maxR, "-c maxReaction="+str(sum), "-", encodings+splitting, encodings+ordering, encodings+symmetry, encodings+setChanges, "-c numChanges="+str(minChanges), encodings+maximizeReactions], stdin=extendedInstance, stdout=subprocess.PIPE)
	proc2= subprocess.Popen([bin+solver,  "--sat-prepro", "--restart-on-model", "--back", "0", "--project"], stdin=proc.stdout, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
	output = proc2.communicate()[0].split("\n")
	if (proc2.returncode==20):
		return (-1,0,[])
	for out in output:
		if (out.find("Optimization") != -1):
			start = out.find("Optimization")+len("Optimization: ")
			numReaction = int(out[start:])
	sum-=numReaction

	extendedInstance.seek(0)
	extendedInstance.flush()
	return (minChanges, sum, extendedInstance)
					

def checkNum(option, opt, value, parser):
	try:
		assert(value > 0)
		setattr(parser.values, option.dest, value)
	except:
		parser.error("positive number for " + opt + " expected")

usage  = "usage: %prog -t <target> [options] [files...]"
parser = optparse.OptionParser(usage=usage)
#parser.add_option("-t", "--target", dest="file", type="string", help="a file", default=None)
#parser.add_option("-n", "--minimum", dest="min", type="int", action="callback", callback=checkNum, metavar="<num>", help="the minimum", default=2)
#parser.add_option("-r", "--reactions", dest="numReactions", type="int", action="callback", callback=checkNum, metavar="<num>", help="the maximum number of reactions", default=0)

opts, files = parser.parse_args(sys.argv[1:])

if len(files) > 1:
	parser.error("error: only one sbml file expected -> "+ files[1])

if len(files) == 0:
	parser.error("error: exactly one sbml file expected")
print "Given Parameter: " + files[0]
problem = files[0][0:files[0].rfind(".")]
problem = problem[problem.rfind("/")+1:len(problem)]

try:
	shutil.rmtree(solutions+problem)
	os.rmdir(solutions+problem)
except: pass
try:
	os.mkdir(solutions+problem)
except EnvironmentError as x:
	print x

print "Converting " + problem + " to logic program..."
instance = tempfile.TemporaryFile("w+r+b")
proc = subprocess.Popen([xml2lp, files[0]], stdout=instance, stderr=subprocess.PIPE)
proc.communicate()
if (proc.returncode!=0):
	instance.close()
	instance = open(files[0], 'r')

#TODO: check filesize or whatever, if the file does not exsist, the instance is empty
instance.seek(0)
start = instance.tell()
instance.seek(0,os.SEEK_END)
if (instance.tell()==start):
	print "Error: Couldn't convert xml file to logic program"
	try:
		shutil.rmtree(solutions+problem)
		os.rmdir(solutions+problem)
	except: pass
	sys.exit(1)
instance.seek(0)
instance.flush()


print "\tCalculating minimal number of additional species..."
proc = subprocess.Popen([bin+grounder, "-", encodings+labeling, encodings+symmetry], stdin=instance, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
proc2= subprocess.Popen([bin+solver,   "--heur=Vmtf", "0"], stdin=proc.stdout, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
output = proc2.communicate()[0].split("\n")
number = 0
if (proc2.returncode==20):
	print "No valid labeling found"
	sys.exit(0)
for i in output:
	if (i.find("Optimization") != -1):
		start = i.find("Optimization")+len("Optimization: ")
		number = i[start:i.find(" ",start)]
print "\t"+number + " additional specie(s) added"

problem +="/"
minChanges = -1
while minChanges == -1:
	(minChanges, maxReactions, extendedFile) = maxNumberOfReactions(number, instance)
	instance.seek(0)
	instance.flush()
	if (minChanges != -1):
		print "\tComputing all models with "+number+" additional species and a maximum of "+str(maxReactions) + " reactions and " + str(minChanges) + " changes"
		outfile = open(solutions+problem+outputf, "w")
		proc = subprocess.Popen([bin+grounder, "-", "--verbose=5", "-c maxAdds="+number, "-c maxReaction="+str(maxReactions), "-c numChanges="+str(minChanges), encodings+setChanges, encodings+showReactions, encodings+maxR, encodings+splitting, encodings+ordering, encodings+useadds, encodings+symmetry], stdin=extendedFile, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
		proc2= subprocess.Popen([bin+solver, "--stats", "--opt-all",  "--project", "--restart-on-model", "0"], stdin=proc.stdout, stderr=subprocess.PIPE, stdout=outfile)
		proc2.communicate()
		outfile.close()
		number = str(int(number)+1)
		if (proc2.returncode == 20):
			print "\t\tNo model found, try to increase number of additional species"
			sys.exit(0)
	else:
		number = str(int(number)+1)
		print "\t" + number + " additional specie(s) added"
	
print "\tConverting models to sbml files"

proc = subprocess.Popen([as2sbml, solutions+problem+outputf, solutions+problem])
proc.communicate()
instance.close()
print "\tDone"

#gringo-banane encodings/useadds.lp -c maxAdds=2 encodings/maxReactions.lp -c maxReaction=39 temp  encodings/splitting.lp encodings/ordering.lp encodings/symmetry.lp encodings/setChanges.lp -c numChanges=10  encodings/maximizeReactions.lp | /home/wv/bin/linux/32/clasp-banane 0 --sat-prepro --stats=2 --restart-on-model --back --project

