#!/usr/bin/env python

# simple visualization of the chords found by the program
# showing one chord complete chord per beat with chord symbols

def main(path, length, key, mode, chords, notes):
	chordfile= open(path + "/chords.ly","w")
	chordfile.write('\\version "2.16.2"\n')
	chordfile.write("\n")
	chordfile.write("melody = \\relative c' {\n")
	chordfile.write("	\\clef treble\n")
	chordfile.write("	\\key " + key + " \\" + mode +"\n")
	chordfile.write("	\\time " + length + "/4\n")
	chordfile.write("\n")

	temp= []
	for c in notes:
		chordfile.write("	\\relative c' {")
		for n in c:
			chordfile.write(" <" + str(n[0]) + " " + str(n[1]) + " " + str(n[2]) + " " + str(n[3]) + ">4")
		chordfile.write(" }\n")

	chordfile.write("}\n")
	chordfile.write("\n\n")
	chordfile.write("harmonies = \\chordmode {\n")

	for c in chords:
		for chord in c:
			if str(chord[1]) == "maj" and str(chord[2]) == "0":
				chordfile.write(str(chord[0]) + "4 ")
			elif str(chord[1]) == "maj" and str(chord[2]) == "7":
				chordfile.write(str(chord[0]) + "4:7 ")
			if str(chord[1]) == "min" and str(chord[2]) == "0":
				chordfile.write(str(chord[0]) + "4:m ")
			elif str(chord[1]) == "min" and str(chord[2]) == "7":
				chordfile.write(str(chord[0]) + "4:m7 ")
			if str(chord[1]) == "aug" and str(chord[2]) == "0":
				chordfile.write(str(chord[0]) + "4:aug ")
			elif str(chord[1]) == "aug" and str(chord[2]) == "7":
				chordfile.write(str(chord[0]) + "4:aug7 ")
			if str(chord[1]) == "dim" and str(chord[2]) == "0":
				chordfile.write(str(chord[0]) + "4:dim ")
			elif str(chord[1]) == "dim" and str(chord[2]) == "7":
				chordfile.write(str(chord[0]) + "4:dim7 ")					

	chordfile.write("}\n")
	chordfile.write("\n")
	chordfile.write("\\score {\n")
	chordfile.write("<<\n")
	chordfile.write("	\\new ChordNames {\n")
	chordfile.write("		\\set chordChanges = ##f\n")
	chordfile.write("		\\harmonies\n")
	chordfile.write("	}\n")
	chordfile.write("\n ")
	chordfile.write('	\\new Voice = "one" { \\autoBeamOff \\melody }\n')
	chordfile.write(">>\n")
	chordfile.write("\n")
	chordfile.write("\\layout { }\n")
	chordfile.write("\\midi { }\n")
	chordfile.write("}\n")
	chordfile.close
