#!/usr/bin/env python

# imitation of Prelude No. 1 in C major, BWV 846, from Bach's Well-tempered Clavier
# copying rhythm and distribution of the notes and using the programms chord progressions
# the program is able to reproduce at least the first 5 measures of the original

def main(path, length, key, mode, chords, notes):
	bachfile= open(path + "/bach.ly","w")
	bachfile.write('\\version "2.16.2"\n')
	bachfile.write("\n")
	bachfile.write("global = {\n")
	bachfile.write("	\\key " + key + " \\" + mode +"\n")
	bachfile.write("	\\time 4/4\n")
	bachfile.write("	\\tempo 4 = 100\n")
	bachfile.write("}\n")
	bachfile.write("\n")

	temp= []
	temp2= []
	a= 0
	for c in notes:
		bachfile.write("\\parallelMusic #'(voiceA voiceB voiceC) {\n")
		b= 0
		for temp in c:
			if b == 0 or b == int(length)-1:
				if str(temp[2]) not in ("c", "cis", "des", "d", "dis", "es", "e", "f", "fis"):
# and str(temp[1]) not in ("g", "ges")
					bachfile.write("	\\relative c'' { r8 "
						+ str(temp[2]) + "16 " + str(temp[3]) + " " + str(temp[1]) + " "
						+ str(temp[2]) + ", " + str(temp[3]) + " " + str(temp[1]) + " r8 "
						+ str(temp[2]) + ",16 " + str(temp[3]) + " " + str(temp[1]) + " "
						+ str(temp[2]) + ", " + str(temp[3]) + " " + str(temp[1]) + " } |\n")
				else:
					bachfile.write("	\\relative c' { r8 "
						+ str(temp[2]) + "16 " + str(temp[3]) + " " + str(temp[1]) + " "
						+ str(temp[2]) + ", " + str(temp[3]) + " " + str(temp[1]) + " r8 "
						+ str(temp[2]) + ",16 " + str(temp[3]) + " " + str(temp[1]) + " "
						+ str(temp[2]) + ", " + str(temp[3]) + " " + str(temp[1]) + " } |\n")
				bachfile.write("	\\relative c' { r16 "
					+ str(temp[1]) + "8.~ " + str(temp[1]) + "4 r16 "
					+ str(temp[1]) + "8.~ " + str(temp[1]) + "4} |\n")
				if str(temp[0]) not in ("f", "fis"):
					bachfile.write("	\\relative c' { "
						+ str(temp[0]) + "2 " + str(temp[0]) + " } |\n")
				else:
					bachfile.write("	\\relative c { "
						+ str(temp[0]) + "2 " + str(temp[0]) + " } |\n")
				bachfile.write("\n")
			else:
				if str(chords[a][b][2]) == "0":
					if str(temp[0]) not in ("c", "cis", "des", "d", "dis", "es", "e", "f", "fis"):
						bachfile.write("	\\relative c'' { r8 "
							+ str(temp[0]) + "16 " + str(temp[2]) + "' " + str(temp[0]) + " "
							+ str(temp[0]) + ", " + str(temp[2]) + "' " + str(temp[0]) + " r8 "
							+ str(temp[0]) + ",16 " + str(temp[2]) + "' " + str(temp[0]) + " "
							+ str(temp[0]) + ", " + str(temp[2]) + "' " + str(temp[0]) + " } |\n")
					else:
						bachfile.write("	\\relative c' { r8 "
							+ str(temp[0]) + "16 " + str(temp[2]) + "' " + str(temp[0]) + " "
							+ str(temp[0]) + ", " + str(temp[2]) + "' " + str(temp[0]) + " r8 "
							+ str(temp[0]) + ",16 " + str(temp[2]) + "' " + str(temp[0]) + " "
							+ str(temp[0]) + ", " + str(temp[2]) + "' " + str(temp[0]) + " } |\n")
					bachfile.write("	\\relative c' { r16 "
						+ str(temp[2]) + "8.~ " + str(temp[2]) + "4 r16 "
						+ str(temp[2]) + "8.~ " + str(temp[2]) + "4} |\n")
					if str(temp[1]) not in ("f", "fis"):
						bachfile.write("	\\relative c' { "
							+ str(temp[1]) + "2 " + str(temp[1]) + " } |\n")
					else:
						bachfile.write("	\\relative c { "
							+ str(temp[1]) + "2 " + str(temp[1]) + " } |\n")
					bachfile.write("\n")
				else:
					if str(temp[1]) not in ("c", "cis", "des", "d", "dis", "es", "e", "f", "fis"):
						bachfile.write("	\\relative c'' { r8 "
							+ str(temp[1]) + "16 " + str(temp[2]) + " " + str(temp[0]) + " "
							+ str(temp[1]) + ", " + str(temp[2]) + " " + str(temp[0]) + " r8 "
							+ str(temp[1]) + ",16 " + str(temp[2]) + " " + str(temp[0]) + " "
							+ str(temp[1]) + ", " + str(temp[2]) + " " + str(temp[0]) + " } |\n")
					else:
						bachfile.write("	\\relative c' { r8 "
							+ str(temp[1]) + "16 " + str(temp[2]) + " " + str(temp[0]) + " "
							+ str(temp[1]) + ", " + str(temp[2]) + " " + str(temp[0]) + " r8 "
							+ str(temp[1]) + ",16 " + str(temp[2]) + " " + str(temp[0]) + " "
							+ str(temp[1]) + ", " + str(temp[2]) + " " + str(temp[0]) + " } |\n")
					bachfile.write("	\\relative c' { r16 "
						+ str(temp[0]) + "8.~ " + str(temp[0]) + "4 r16 "
						+ str(temp[0]) + "8.~ " + str(temp[0]) + "4} |\n")
					if str(temp[3]) not in ("f", "fis"):
						bachfile.write("	\\relative c' { "
							+ str(temp[3]) + "2 " + str(temp[3]) + " } |\n")
					else:
						bachfile.write("	\\relative c { "
							+ str(temp[3]) + "2 " + str(temp[3]) + " } |\n")
					bachfile.write("\n")
			if b == int(length)-1:
				b= 0
			else:
				b= b+1
		bachfile.write(" }\n")
		a= a+1

	bachfile.write("\n\n")

	bachfile.write("harmonies = \\chordmode {\n")

	for c in chords:
		for chord in c:
			if str(chord[1]) == "maj" and str(chord[2]) == "0":
				bachfile.write(str(chord[0]) + "1 ")
			elif str(chord[1]) == "maj" and str(chord[2]) == "7":
				bachfile.write(str(chord[0]) + "1:7 ")
			if str(chord[1]) == "min" and str(chord[2]) == "0":
				bachfile.write(str(chord[0]) + "1:m ")
			elif str(chord[1]) == "min" and str(chord[2]) == "7":
				bachfile.write(str(chord[0]) + "1:m7 ")
			if str(chord[1]) == "aug" and str(chord[2]) == "0":
				bachfile.write(str(chord[0]) + "1:aug ")
			elif str(chord[1]) == "aug" and str(chord[2]) == "7":
				bachfile.write(str(chord[0]) + "1:aug7 ")
			if str(chord[1]) == "dim" and str(chord[2]) == "0":
				bachfile.write(str(chord[0]) + "1:dim ")
			elif str(chord[1]) == "dim" and str(chord[2]) == "7":
				bachfile.write(str(chord[0]) + "1:dim7 ")					
	bachfile.write("\n")
	bachfile.write("}\n")
	bachfile.write("\n")
	bachfile.write("\\score {\n")
	bachfile.write("<<\n")
	bachfile.write("	\\new ChordNames {\n")
	bachfile.write("		\\set chordChanges = ##f\n")
	bachfile.write("		\\harmonies\n")
	bachfile.write("	}\n")
	bachfile.write("\n ")
	bachfile.write('	\\new StaffGroup <<\n')
	bachfile.write("		\\new Staff << \\relative c'' \\voiceA \\\\ \\relative c' \\voiceB >>\n")
	bachfile.write("		\\new Staff \\relative c' { \\clef bass \\voiceC }\n")
	bachfile.write("	>>\n")
	bachfile.write(">>\n")
	bachfile.write("\n")
	bachfile.write("\\layout { }\n")
	bachfile.write("\\midi { }\n")
	bachfile.write("}\n")
	bachfile.close
