#!/usr/bin/env python

# arranging the notes for a homophonic 4 voices choire piece
# homophonic meaning all voices change notes at the same time
# this results in the voices simply performing chords
# but unlike 'lilychords.py' some additional rules concerning voice leading and range and chord inversions ensure the sound of a proper choir piece

def main(path, length, key, mode, chords, soprano, alto, tenor, basso):
	voicefile= open(path + "/voices.ly","w")
	voicefile.write('\\version "2.16.2"\n')
	voicefile.write("\n")
	voicefile.write("\\paper {\n")
	voicefile.write("	top-system-spacing #'basic-distance = #10\n")
	voicefile.write("	score-system-spacing #'basic-distance = #20\n")
	voicefile.write("	system-system-spacing #'basic-distance = #20\n")
	voicefile.write("	last-bottom-spacing #'basic-distance = #10\n")
	voicefile.write("}\n")
	voicefile.write("\n")
	voicefile.write("global = {\n")
	voicefile.write("	\\key " + key + " \\" + mode +"\n")
	voicefile.write("	\\time " + length + "/4\n")
	voicefile.write("}\n")
	voicefile.write("\n")

	voicefile.write("sopMusic = {\n")
	voicefile.write('\set Staff.midiInstrument = #"choir aahs"\n')
	for s in soprano:
		for ss in s:
			if str(ss[1]) == "1":
				voicefile.write("	" + str(ss[0]) + "'4 ")
			else:
				voicefile.write("	" + str(ss[0]) + "''4 ")
		voicefile.write("\n")

	voicefile.write("}\n")
	voicefile.write("\n")

	voicefile.write("altoMusic = {\n")
	voicefile.write('\set Staff.midiInstrument = #"choir aahs"\n')
	for a in alto:
		for aa in a:
			if str(aa[1]) == "0":
				voicefile.write("	" + str(aa[0]) + "4 ")
			elif str(aa[1]) == "1":
				voicefile.write("	" + str(aa[0]) + "'4 ")
			else:
				voicefile.write("	" + str(aa[0]) + "''4 ")
		voicefile.write("\n")
	voicefile.write("}\n")
	voicefile.write("\n")

	voicefile.write("tenorMusic = {\n")
	voicefile.write('\set Staff.midiInstrument = #"choir aahs"\n')
	for t in tenor:
		for tt in t:
			if str(tt[1]) == "0":
				voicefile.write("	" + str(tt[0]) + "4 ")
			else:
				voicefile.write("	" + str(tt[0]) + "'4 ")
		voicefile.write("\n")
	voicefile.write("}\n")
	voicefile.write("\n")

	voicefile.write("bassMusic = {\n")
	voicefile.write('\set Staff.midiInstrument = #"choir aahs"\n')
	for b in basso:
		for bb in b:
			if str(bb[1]) == "-1":
				voicefile.write("	" + str(bb[0]) + ",4 ")
			elif str(bb[1]) == "0":
				voicefile.write("	" + str(bb[0]) + "4 ")
			else:
				voicefile.write("	" + str(bb[0]) + "'4 ")
		voicefile.write("\n")
	voicefile.write("}\n")
	voicefile.write("\n")

	voicefile.write("harmonies = \\chordmode {\n")
	for c in chords:
		for chord in c:
			if str(chord[1]) == "maj" and str(chord[2]) == "0":
				voicefile.write(str(chord[0]) + "4 ")
			elif str(chord[1]) == "maj" and str(chord[2]) == "7":
				voicefile.write(str(chord[0]) + "4:7 ")
			if str(chord[1]) == "min" and str(chord[2]) == "0":
				voicefile.write(str(chord[0]) + "4:m ")
			elif str(chord[1]) == "min" and str(chord[2]) == "7":
				voicefile.write(str(chord[0]) + "4:m7 ")
			if str(chord[1]) == "aug" and str(chord[2]) == "0":
				voicefile.write(str(chord[0]) + "4:aug ")
			elif str(chord[1]) == "aug" and str(chord[2]) == "7":
				voicefile.write(str(chord[0]) + "4:aug7 ")
			if str(chord[1]) == "dim" and str(chord[2]) == "0":
				voicefile.write(str(chord[0]) + "4:dim ")
			elif str(chord[1]) == "dim" and str(chord[2]) == "7":
				voicefile.write(str(chord[0]) + "4:dim7 ")					

	voicefile.write("}\n")
	voicefile.write("\n")
	voicefile.write("\score {\n")
	voicefile.write("	\\new ChoirStaff <<\n")
	voicefile.write('		\\new Staff = "women" <<\n')
	voicefile.write('			\\new Voice = "sopranos" {\n')
	voicefile.write("			        \\voiceOne\n")
	voicefile.write("				<< \\global \\sopMusic >>\n")
	voicefile.write("			}\n")
	voicefile.write('			\\new Voice = "altos" {\n')
	voicefile.write("				\\voiceTwo\n")
	voicefile.write("				<< \\global \\altoMusic >>\n")
	voicefile.write("			}\n")
	voicefile.write("		>>\n")
	voicefile.write('		\\new Staff = "men" <<\n')
	voicefile.write("			\\clef bass\n")
	voicefile.write('			\\new Voice = "tenors" {\n')
	voicefile.write("				\\voiceOne\n")
	voicefile.write("				<< \\global \\tenorMusic >>\n")
	voicefile.write("			}\n")
	voicefile.write('			\\new Voice = "basses" {\n')
	voicefile.write("				\\voiceTwo\n")
	voicefile.write("				<< \\global \\bassMusic >>\n")
	voicefile.write("			}\n")
	voicefile.write("		>>\n")
	voicefile.write("	>>\n")
	voicefile.write("\n")
	voicefile.write("\\layout { }\n")
	voicefile.write("\\midi { }\n")
	voicefile.write("}\n")
	voicefile.close
