#!/usr/bin/env python

import gringo
from optparse import OptionParser 
from subprocess import call
import sys
import os

from lilystyles import *

#managing options
parser = OptionParser()

parser.add_option("-a", "--clasp", dest="clasp", default= "0", help= "set number of solutions (models)")
parser.add_option("-g", "--grounding-only", action= "store_true", dest= "grounding_only", help= "show grounding")
parser.add_option("-l", "--length", dest="cadenza_length", default= "4", help= "set cadenza length")
parser.add_option("-k", "--key", dest="cadenza_key", default= "c", help= "set key")
parser.add_option("-m", "--mode", dest="cadenza_mode", default= "maj", help= "set mode (maj or min)")
parser.add_option("-c", "--chords", action="store_true", dest="print_chords", help= "show chords")
parser.add_option("-n", "--notes", action="store_true", dest="print_notes", help= "show notes")
parser.add_option("-v", "--voices", action="store_true", dest="print_voices", help= "show voices")
parser.add_option("-i", "--lilypond", dest="lilypond", default= "none", help= "generate pdf and midi output with lilypond (possible options are 'chords', 'voices', 'bach', 'foxtrot', 'rumba', 'raggae', 'pop', 'tango')")

(options, args) = parser.parse_args()

# asp files
encoding_files= ["./asp/notes.lp", "./asp/scales.lp", "./asp/functions.lp", "./asp/chords.lp", "./asp/chordprogressions.lp", "./asp/cadenza.lp", "./asp/voices.lp"]

# converting content of asp files to one single string
encoding= ""
for ef in encoding_files:
	f= open(ef)
	encoding+= f.read()
	f.close()

# grounding after adding constants for cadenza length and key
if options.grounding_only == True:
	prg= gringo.Control(["--text"])
else:
	prg= gringo.Control(["-n " + options.clasp])
prg.add("music", [], encoding)
prg.add("music", [], "#const defaultlength = " + options.cadenza_length + ".")
prg.add("music", [], "#const defaultkey =  " + options.cadenza_key + ".")
prg.add("music", [], "#const defaultmode = " + options.cadenza_mode + ".")

prg.ground( [("music", [])] )

# just some variables that are used later
key= ""
mode= ""
models= []
chords= []
notes= []
soprano= []
alto= []
tenor= []
basso= []
chords_short= []
notes_short= []

# parsing the model and adding each predicate's arguments to its respective list
def addModel(m):
	chords_temp= []
	notes_temp= []
	soprano_temp= []
	alto_temp= []
	tenor_temp= []
	basso_temp= []
	models.append(m.atoms())
	for a in m.atoms():
		if a.name() == "thiskey":
			global key
			global mode
			key= str(a.args()[0])
			if str(a.args()[1]) == "maj":
				mode= "major"
			else:
				mode= "minor"
		if a.name() == "cadenza_chord":
			chords_temp.append(a.args())
		if a.name() == "cadenza_notes":
			notes_temp.append(a.args())
		if a.name() == "voice":
			if str(a.args()[0]) == "soprano":
				soprano_temp.append(a.args()[1:])
			elif str(a.args()[0]) == "alto":
				alto_temp.append(a.args()[1:])
			elif str(a.args()[0]) == "tenor":
				tenor_temp.append(a.args()[1:])
			else:
				basso_temp.append(a.args()[1:])

	chords_temp.sort()
	notes_temp.sort()
	soprano_temp.sort()
	alto_temp.sort()
	tenor_temp.sort()
	basso_temp.sort()
	
	temp= []
	for c in chords_temp:
		temp.append(c[1:])
		chords.append(temp)

	temp= []
	for n in notes_temp:
		temp.append(n[1:])
		notes.append(temp)

	temp= []
	for s in soprano_temp:
		temp.append(s[1])
	soprano.append(temp)

	temp= []
	for a in alto_temp:
		temp.append(a[1])
	alto.append(temp)

	temp= []
	for t in tenor_temp:
		temp.append(t[1])
	tenor.append(temp)

	temp= []
	for b in basso_temp:
		temp.append(b[1])
	basso.append(temp)

# solving and parsing models
prg.solve(on_model= addModel)

# getting rid of multiple identic chord progressions
for c in chords:
	if c not in chords_short:
		chords_short.append(c)
	else:
		pass

for n in notes:
	if n not in notes_short:
		notes_short.append(n)
	else:
		pass

# output genreal information
print "\nkey: " + key + " " + mode
print "cadenza length: " + options.cadenza_length + " chords"
print "found " + str(len(chords_short)) + " chord progression(s)\n"
print "models: "
for line in models:
	print line
	print ""

# output mostly for debugging
if options.print_chords == True:
	print "chords: "
	for line in chords_short:
		print line
	print ""
if options.print_notes == True:
	print "notes: "
	for line in notes_short:
		print line
	print ""
if options.print_voices == True:
	print "voices:\n"
	print "soprano: "
	for line in soprano:
		print line
	print " "
	print "alto: "
	for line in alto:
		print line
	print " "
	print "tenor: "
	for line in tenor:
		print line
	print " "
	print "basso: "
	for line in basso:
		print line
	print ""

# output for lilypond (pdf and midi)
if options.lilypond != "none":
	if not os.path.exists("out"):
    		os.mkdir("out")
	lilyfilespath= os.path.join(os.path.dirname(os.path.abspath(__file__)), "out")

	if options.lilypond == "chords":
		lilychords.main(lilyfilespath, options.cadenza_length, key, mode, chords_short, notes_short)
	elif options.lilypond == "voices":
		lilyvoices.main(lilyfilespath, options.cadenza_length, key, mode, chords_short, soprano, alto, tenor, basso)
	elif options.lilypond == "bach":
		lilybach.main(lilyfilespath, options.cadenza_length, key, mode, chords_short, notes_short)
	elif options.lilypond == "foxtrot":
		lilyfoxtrot.main(lilyfilespath, options.cadenza_length, key, mode, chords_short, notes_short)
	elif options.lilypond == "rumba":
		lilyrumba.main(lilyfilespath, options.cadenza_length, key, mode, chords_short, notes_short)
	elif options.lilypond == "raggae":
		lilyraggae.main(lilyfilespath, options.cadenza_length, key, mode, chords_short, notes_short)
	elif options.lilypond == "pop":
		lilypop.main(lilyfilespath, options.cadenza_length, key, mode, chords_short, notes_short)
	elif options.lilypond == "tango":
		lilytango.main(lilyfilespath, options.cadenza_length, key, mode, chords_short, notes_short)
	else:
		raise Exception("wrong argument for '-i' given. must be 'chords' or 'voices' or 'bach' or 'foxtrot' or 'rumba' or 'raggae' or 'pop' or 'tango'.")

	call(["lilypond", "-o", "out/"+options.lilypond, "out/"+options.lilypond + ".ly"])
