 #const mv = 20000.
$domain(0..mv).
 
%already_scheduled(J) :- curr_job_start(J,ST).
already_completed(J) :- curr_job_start(J,ST), job_len(J,L), curr_time(T), T >= ST+L.

remains_same(J) :- curr_job_start(J,ST), curr_on_instance(J,I), job_device(J,D), not offline_instance(D,I), curr_time(T),
                  ST<=T, not already_completed(J).

rescheduled(J) :- curr_on_instance(J,I), curr_job_start(J,ST), curr_time(T), ST<=T, job_device(J,D), 
                 not already_completed(J), offline_instance(D,I).

willschedule(J) :- job(J), not already_completed(J), not remains_same(J).

%start(J,T) :- curr_job_start(J,T), not willschedule(J).
start(J) $== T :- curr_job_start(J,T), not willschedule(J).
on_instance(J,I) :- curr_on_instance(J,I), not willschedule(J).


%start(J,T) :- curr_job_start(J,T), not rescheduled(J).
%start(J) $== T   :- curr_job_start(J,T), not rescheduled(J).
%on_instance(J,I) :- curr_on_instance(J,I), not rescheduled(J).

%1 { start(J,T):T := CT..MV-L } 1 :- willschedule(J), curr_time(CT), job_len(J,L), max_value(MV).
start(J) $>= CT  :- willschedule(J), curr_time(CT).
start(J) $<= MV-L  :- willschedule(J), curr_time(CT), job_len(J,L), max_value(MV).


%{ start(J,T) } :- willschedule(J), curr_time(CT), job_len(J,L), T := CT..MV-L, max_value(MV).
%:- start(J,T1), start(J,T2), T1 != T2.
%started(J) :- start(J,T).
%:- job(J), not started(J).


online_inst(D,I) :- instances(D,Inum), I = 1..Inum, not offline_instance(D,I).
1 { on_instance(J,I) : online_inst(D,I) } 1 :- willschedule(J), job_device(J,D).
%1 { on_instance(J,I):instances(D,Inum) : I:=1..Inum : not offline_instance(D,I) } 1 :- willschedule(J), job_device(J,D).


% only one job is done on a device instance
%:- on_instance(J1,I), on_instance(J2,I), J1!=J2, job_device(J1,D), job_device(J2,D),
%   start(J1,T1), start(J2,T2), T1 <= T2, job_len(J1,L1), T2 < T1+L1.
:- on_instance(J1,I), on_instance(J2,I), J1!=J2, job_device(J1,D), job_device(J2,D),
   start(J1) $<= start(J2), start(J2) $< start(J1)$+L1, job_len(J1,L1).

% precedence
%:- precedes(J1,J2), start(J1,T1), start(J2,T2), job_len(J1,L1), T2 < T1+L1.
:- precedes(J1,J2), start(J2) $< start(J1)$+L1, job_len(J1,L1).

imp(J,I) :- importance(J,I).
has_importance(J) :- importance(J,I).
imp(J,1) :- job(J), not has_importance(J).

% this can be done more efficiently by one rule using lua call
%penalty(J,P) :- start(J,T), job_len(J,L), deadline(J,D), imp(J,I), TD := (T+L)-D, TD >= 0, P := TD*I.
tard(J) $== (start(J)$+L)$-D :- job_len(J,L), deadline(J,D), (start(J)$+L) $>= D. %positive
penalty(J) $== tard(J)$*I :- job_len(J,L), deadline(J,D), imp(J,I).
%penalty(J) $== tard(J)*I :- job_len(J,L), deadline(J,D), imp(J,I), tard(J) $== (start(J)+L)-D.
%penalty(J,0) :- start(J,T), job_len(J,L), deadline(J,D), D > T+L.
penalty(J) $== 0 :- job_len(J,L), deadline(J,D), D $> start(J)$+L.

% this won't ground since the weight literal is so fat because of many possible penalty values
%tot_penalty(TP) :- TP := #sum [ penalty(J,P):deadline(J,D) = P ].


pjob(J) :- deadline(J,D).
%*
next(J1,J2) :- pjob(J1;J2), J1<J2, not pjob(J3):pjob(J3):J3<J2:J1<J3.
first(J) :- pjob(J), not next(J1,J):pjob(J1).
last(J) :- pjob(J), not next(J,J1):pjob(J1).
order(J,1) :- first(J).
numJobs(X) :- X = {job(B) : job(B)}.
order(J,I+1) :- next(JP,J), order(JP,I), I = 1..X-1, numJobs(X).
*%
%ptotal(1) $== penalty(J) :- first(J).
%ptotal(I) $== ptotal(I-1) $+ penalty(J) :- order(J,I).

%tot_penalty $== ptotal(I) :- last(J), order(J,I).

tot_penalty $== $sum{penalty(J) : pjob(J)}.

:- tot_penalty $> MP, max_total_penalty(MP).
%:- tot_penalty(TP), max_total_penalty(MP), TP > MP.

%#hide.
#show start/2.
#show on_instance/2.
#show penalty/2.
#show tot_penalty/1.
#show rescheduled/1.
device(1).
job(2).
instances(1,2).
device(2).
instances(2,1).
device(3).
instances(3,2).
job(5).
device(4).
instances(4,1).
device(5).
instances(5,1).
job(1).
job(3).
job(4).
precedes(1,2).
precedes(2,3).
precedes(4,5).
job(6).
job(7).
job(8).
job(9).
job(10).
job(11).
job(12).
deadline(9,14).
deadline(12,22).
precedes(5,6).
precedes(7,8).
precedes(8,9).
precedes(10,11).
precedes(11,12).
importance(12,1).
importance(11,3).
importance(10,1).
importance(9,2).
importance(8,2).
importance(7,1).
importance(6,3).
importance(5,3).
importance(4,2).
importance(3,3).
importance(2,2).
importance(1,3).
job_device(1,2).
job_device(4,2).
job_device(7,2).
job_device(10,2).
job_device(2,3).
job_device(5,3).
job_device(8,3).
job_device(11,4).
job_device(3,5).
job_device(6,5).
job_device(9,5).
job_device(12,5).
job_len(12,19).
job_len(11,12).
job_len(10,20).
job_len(9,19).
job_len(8,7).
job_len(7,11).
job_len(6,11).
job_len(5,5).
job_len(4,6).
job_len(3,12).
job_len(2,3).
job_len(1,14).
deadline(3,11).
deadline(6,39).
max_total_penalty(2).
curr_time(0).
max_value(480).

