 #const mv = 20000.
$domain(0..mv).
 
%already_scheduled(J) :- curr_job_start(J,ST).
already_completed(J) :- curr_job_start(J,ST), job_len(J,L), curr_time(T), T >= ST+L.

remains_same(J) :- curr_job_start(J,ST), curr_on_instance(J,I), job_device(J,D), not offline_instance(D,I), curr_time(T),
                  ST<=T, not already_completed(J).

rescheduled(J) :- curr_on_instance(J,I), curr_job_start(J,ST), curr_time(T), ST<=T, job_device(J,D), 
                 not already_completed(J), offline_instance(D,I).

willschedule(J) :- job(J), not already_completed(J), not remains_same(J).

%start(J,T) :- curr_job_start(J,T), not willschedule(J).
start(J) $== T :- curr_job_start(J,T), not willschedule(J).
on_instance(J,I) :- curr_on_instance(J,I), not willschedule(J).


%start(J,T) :- curr_job_start(J,T), not rescheduled(J).
%start(J) $== T   :- curr_job_start(J,T), not rescheduled(J).
%on_instance(J,I) :- curr_on_instance(J,I), not rescheduled(J).

%1 { start(J,T):T := CT..MV-L } 1 :- willschedule(J), curr_time(CT), job_len(J,L), max_value(MV).
start(J) $>= CT  :- willschedule(J), curr_time(CT).
start(J) $<= MV-L  :- willschedule(J), curr_time(CT), job_len(J,L), max_value(MV).


%{ start(J,T) } :- willschedule(J), curr_time(CT), job_len(J,L), T := CT..MV-L, max_value(MV).
%:- start(J,T1), start(J,T2), T1 != T2.
%started(J) :- start(J,T).
%:- job(J), not started(J).


online_inst(D,I) :- instances(D,Inum), I = 1..Inum, not offline_instance(D,I).
1 { on_instance(J,I) : online_inst(D,I) } 1 :- willschedule(J), job_device(J,D).
%1 { on_instance(J,I):instances(D,Inum) : I:=1..Inum : not offline_instance(D,I) } 1 :- willschedule(J), job_device(J,D).


% only one job is done on a device instance
%:- on_instance(J1,I), on_instance(J2,I), J1!=J2, job_device(J1,D), job_device(J2,D),
%   start(J1,T1), start(J2,T2), T1 <= T2, job_len(J1,L1), T2 < T1+L1.
:- on_instance(J1,I), on_instance(J2,I), J1!=J2, job_device(J1,D), job_device(J2,D),
   start(J1) $<= start(J2), start(J2) $< start(J1)$+L1, job_len(J1,L1).

% precedence
%:- precedes(J1,J2), start(J1,T1), start(J2,T2), job_len(J1,L1), T2 < T1+L1.
:- precedes(J1,J2), start(J2) $< start(J1)$+L1, job_len(J1,L1).

imp(J,I) :- importance(J,I).
has_importance(J) :- importance(J,I).
imp(J,1) :- job(J), not has_importance(J).

% this can be done more efficiently by one rule using lua call
%penalty(J,P) :- start(J,T), job_len(J,L), deadline(J,D), imp(J,I), TD := (T+L)-D, TD >= 0, P := TD*I.
tard(J) $== (start(J)$+L)$-D :- job_len(J,L), deadline(J,D), (start(J)$+L) $>= D. %positive
penalty(J) $== tard(J)$*I :- job_len(J,L), deadline(J,D), imp(J,I).
%penalty(J) $== tard(J)*I :- job_len(J,L), deadline(J,D), imp(J,I), tard(J) $== (start(J)+L)-D.
%penalty(J,0) :- start(J,T), job_len(J,L), deadline(J,D), D > T+L.
penalty(J) $== 0 :- job_len(J,L), deadline(J,D), D $> start(J)$+L.

% this won't ground since the weight literal is so fat because of many possible penalty values
%tot_penalty(TP) :- TP := #sum [ penalty(J,P):deadline(J,D) = P ].


pjob(J) :- deadline(J,D).
%*
next(J1,J2) :- pjob(J1;J2), J1<J2, not pjob(J3):pjob(J3):J3<J2:J1<J3.
first(J) :- pjob(J), not next(J1,J):pjob(J1).
last(J) :- pjob(J), not next(J,J1):pjob(J1).
order(J,1) :- first(J).
numJobs(X) :- X = {job(B) : job(B)}.
order(J,I+1) :- next(JP,J), order(JP,I), I = 1..X-1, numJobs(X).
*%
%ptotal(1) $== penalty(J) :- first(J).
%ptotal(I) $== ptotal(I-1) $+ penalty(J) :- order(J,I).

%tot_penalty $== ptotal(I) :- last(J), order(J,I).

tot_penalty $== $sum{penalty(J) : pjob(J)}.

:- tot_penalty $> MP, max_total_penalty(MP).
%:- tot_penalty(TP), max_total_penalty(MP), TP > MP.

%#hide.
#show start/2.
#show on_instance/2.
#show penalty/2.
#show tot_penalty/1.
#show rescheduled/1.
device(1).
job(29).
instances(1,2).
device(2).
instances(2,1).
device(3).
instances(3,2).
device(4).
instances(4,1).
device(5).
instances(5,1).
job(1).
job(30).
job(31).
job(32).
job(2).
job(3).
job(4).
job(5).
job(6).
job(7).
job(8).
job(9).
job(10).
job(11).
job(12).
job(13).
job(14).
job(15).
job(16).
job(17).
job(18).
job(19).
job(20).
job(21).
job(22).
job(23).
job(24).
job(25).
job(26).
job(27).
job(28).
job(33).
job(34).
job(35).
job(36).
job_device(31,2).
job_device(34,2).
job_device(2,4).
job_device(5,3).
job_device(8,4).
job_device(11,3).
job_device(14,3).
job_device(17,3).
job_device(20,4).
job_device(23,4).
job_device(26,4).
precedes(1,2).
precedes(2,3).
precedes(4,5).
precedes(5,6).
precedes(7,8).
precedes(8,9).
precedes(10,11).
precedes(11,12).
precedes(13,14).
precedes(14,15).
precedes(16,17).
precedes(17,18).
precedes(19,20).
precedes(20,21).
precedes(22,23).
precedes(23,24).
precedes(25,26).
precedes(26,27).
precedes(28,29).
precedes(29,30).
precedes(31,32).
precedes(32,33).
precedes(34,35).
precedes(35,36).
importance(36,1).
importance(35,1).
importance(34,3).
importance(33,3).
importance(32,3).
importance(31,2).
importance(30,1).
importance(29,3).
importance(28,1).
importance(27,3).
importance(26,1).
importance(25,1).
importance(24,3).
importance(23,1).
importance(22,2).
importance(21,3).
importance(20,1).
importance(19,1).
importance(18,3).
importance(17,2).
importance(16,1).
importance(15,2).
importance(14,2).
importance(13,3).
importance(12,3).
importance(11,2).
importance(10,1).
importance(9,2).
importance(8,2).
importance(7,1).
importance(6,3).
importance(5,1).
importance(4,3).
importance(3,1).
importance(2,1).
importance(1,2).
job_device(1,2).
job_device(4,2).
job_device(7,2).
job_device(10,2).
job_device(13,2).
job_device(16,1).
job_device(19,1).
job_device(22,1).
job_device(25,1).
job_device(28,1).
job_device(29,4).
job_device(32,3).
job_device(35,4).
job_device(3,5).
job_device(6,5).
job_device(9,5).
job_device(12,5).
job_device(15,5).
job_device(18,5).
job_device(21,5).
job_device(24,5).
job_device(27,5).
job_device(30,5).
job_device(33,5).
job_device(36,5).
job_len(36,11).
job_len(35,15).
job_len(34,10).
job_len(33,9).
job_len(32,8).
job_len(31,7).
job_len(30,19).
job_len(29,5).
job_len(28,7).
job_len(27,8).
job_len(26,19).
job_len(25,13).
job_len(24,16).
job_len(23,15).
job_len(22,20).
job_len(21,10).
job_len(20,13).
job_len(19,4).
job_len(18,5).
job_len(17,4).
job_len(16,4).
job_len(15,9).
job_len(14,10).
job_len(13,9).
job_len(12,7).
job_len(11,20).
job_len(10,7).
job_len(9,3).
job_len(8,4).
job_len(7,18).
job_len(6,3).
job_len(5,15).
job_len(4,15).
job_len(3,9).
job_len(2,10).
job_len(1,16).
deadline(3,19).
deadline(6,16).
deadline(9,18).
deadline(12,26).
deadline(15,35).
deadline(18,33).
deadline(21,13).
deadline(24,16).
deadline(27,11).
deadline(30,30).
deadline(33,39).
deadline(36,16).
max_total_penalty(1310).
curr_job_start(36,88).
curr_job_start(33,40).
curr_job_start(21,17).
curr_job_start(12,27).
curr_job_start(9,67).
curr_job_start(6,37).
curr_job_start(3,55).
curr_job_start(35,73).
curr_job_start(20,4).
curr_job_start(8,63).
curr_job_start(2,45).
curr_job_start(32,29).
curr_job_start(11,7).
curr_job_start(5,22).
curr_job_start(34,63).
curr_job_start(31,22).
curr_job_start(10,0).
curr_job_start(7,45).
curr_job_start(4,7).
curr_job_start(1,29).
curr_job_start(19,0).
curr_on_instance(36,1).
curr_on_instance(35,1).
curr_on_instance(34,1).
curr_on_instance(33,1).
curr_on_instance(32,2).
curr_on_instance(31,1).
curr_on_instance(21,1).
curr_on_instance(20,1).
curr_on_instance(19,1).
curr_on_instance(12,1).
curr_on_instance(11,2).
curr_on_instance(10,1).
curr_on_instance(9,1).
curr_on_instance(8,1).
curr_on_instance(7,1).
curr_on_instance(6,1).
curr_on_instance(5,1).
curr_on_instance(4,1).
curr_on_instance(3,1).
curr_on_instance(2,1).
curr_on_instance(1,1).
curr_time(80).
max_value(1539).

