#const mv=100.
$domain(0..mv).
color(red).
color(blue).
color(green).

leaf(L) :- leafWeightCardinality(L,W,C).

% We mostly care about the lesser of weight and cardinality.
% Just call it leafWeight
%leafCost(L) $== W :- leafWeightCardinality(L,W,C), W <= C.
%leafCost(L) $== C :- leafWeightCardinality(L,W,C), C < W.
leafCost(L,W) :- leafWeightCardinality(L,W,C), W <= C.
leafCost(L,C) :- leafWeightCardinality(L,W,C), C < W.

coloredPos(X) :- X=1..N-1, num(N).

% Each leaf will have a location in our sequence
location(X) :- X=0..N-1, num(N).

% Give each leaf a location in the sequence

1{ leafPos(L,N) : location(N) }1 :- leaf(L).
%leafPos(L,N) :- leaf(L), location(N), not nleafPos(L,N).
%nleafPos(L,N) :- leaf(L), location(N), not leafPos(L,N).
% no two locations
:- leafPos(L,N), leafPos(L,M), N != M.
% at least one location
%:- nleafPos(L,N) : location(N), leaf(L).

% No sharing locations
:- leafPos(L1, N), leafPos(L2, N), location(N), L1 != L2.


%%%% COLORS %%%%



% coloredPos(1) has a special case, look at locations 1 and 2 in leafPos to
% to determine color

% green if (weight(right) + card(right)) < (weight(left) + leafCost(right))
posColor(1,green) :- leafPos(L1,0), leafPos(L2,1), leafWeightCardinality(L1,WL,CL),
		leafWeightCardinality(L2,WR,CR), leafCost(L2,W3), W1=WR+CR, W2=WL+W3, W1 < W2.
% blue if not green and card(right) < weight(right)
posColor(1,blue) :- leafPos(L2,1), leafWeightCardinality(L2,W,C), C < W, 
		not posColor(1,green).
% red if not green and weight(right) < card(right)
posColor(1,red) :- leafPos(L2,1), leafWeightCardinality(L2,W,C), W < C, 
		not posColor(1,green).
			
% Decide colors for all other nodes
%{test}.
%:- test.
%posColor(N,green) :- N>1, coloredPos(N), leafPos(L,N), leafWeightCardinality(L,WR,CR), leafCost(L,W),
% 		weight(N-1)$> WR+CR-W.
posColor(N,green) :- N>1, coloredPos(N), leafPos(L,N), leafWeightCardinality(L,WR,CR), leafCost(L,C),
			weight(N-1)$> WR+CR-C.
		
posColor(N,blue) :- N>1, coloredPos(N), leafPos(L,N), leafWeightCardinality(L,W,C), C < W, 
		not posColor(N,green).

% If it's not blue or green it must be red
posColor(N,red) :- N>1, coloredPos(N), not posColor(N,green), 
		not posColor(N,blue).
	
	%#hide.
	%#show leafPos/2.
	%*
:- not posColor(1,green).
:- not posColor(5,blue).
:- not posColor(4,green).
:- not posColor(3,red).
:- not posColor(2,red).
*%
%*:- not leafPos(1,1).
:- not leafPos(2,6).
:- not leafPos(3,0).
:- not leafPos(4,2).
:- not leafPos(5,3).
:- not leafPos(6,4).
:- not leafPos(7,7).
:- not leafPos(8,5).
*%	
	
%%%% WEIGHTS %%%%

% nWeight for first coloredPos
weight(1)$==WR+CR:- posColor(1,green), leafPos(L,1), leafWeightCardinality(L,WR,CR),
		WR+CR<=mv.
weight(1)$==WL+W  :- not posColor(1,green), leafPos(L1,0), leafPos(L2,1), leafCost(L2,W),
		leafWeightCardinality(L1,WL,CL).
	
% define nWeight/2
% green
weight(N)$==WR+CR :- coloredPos(N), N>1, posColor(N,green), leafPos(L,N), 
		leafWeightCardinality(L,WR,CR), WR+CR<=mv.
	
% not green
%weight(N)$==weight(N-1)+leafCost(L)  :- coloredPos(N), N>1, not posColor(N,green), leafPos(L,N).
weight(N)$==weight(N-1)$+W  :- coloredPos(N), N>1, not posColor(N,green), leafPos(L,N), leafCost(L,W).


tWeight $== $sum{weight(N) : coloredPos(N)}.

exists :- tWeight$<=mv, num(N).
:- not exists.

$minimize{tWeight}.
%*
%% "+" constraints
:-not posColor(N,green), not posColor(N-1,green), coloredPos(N-1), 
leafPos(L1,N-1),  leafPos(L2,N), leafCost(L1,C1), leafCost(L2,C2), C1>C2.

:-not posColor(N,green), not posColor(N-1,green), coloredPos(N-1),coloredPos(N),
leafPos(L1,N-1),  leafPos(L2,N), leafCost(L1,C), leafCost(L2,C), L1>L2.


%% ++ enforcing sorted green nodes (sorting by ids)
%%
:- leafPos(L1,P1),  leafPos(L2,P2), 
   posColor(P1,green), posColor(P2,green), 
   L1<L2, P1>P2.

   *%
   %*
:- not leafPos(1,1).
:- not leafPos(2,5).
:- not leafPos(3,4).
:- not leafPos(4,3).
:- not leafPos(5,2).
:- not leafPos(6,7).
:- not leafPos(7,0).
:- not leafPos(8,6).
*%
%*

leafWeightCardinality(1,5,0).
leafWeightCardinality(2,5,9).
leafWeightCardinality(3,7,7).
leafWeightCardinality(4,2,7).
leafWeightCardinality(5,7,8).
leafWeightCardinality(6,7,1).
leafWeightCardinality(7,4,7).
leafWeightCardinality(8,8,5).
innerNode(1).
innerNode(2).
innerNode(3).
innerNode(4).
innerNode(5).
innerNode(6).
innerNode(7).
num(8).
%num(6).
%num(4).
max_total_weight(66).*%
leafWeightCardinality(1,7,5).
leafWeightCardinality(2,5,4).
leafWeightCardinality(3,2,3).
leafWeightCardinality(4,5,3).
leafWeightCardinality(5,6,1).
leafWeightCardinality(6,7,3).
leafWeightCardinality(7,4,4).
leafWeightCardinality(8,6,6).
leafWeightCardinality(9,9,2).
leafWeightCardinality(10,0,5).
innerNode(1).
innerNode(2).
innerNode(3).
innerNode(4).
innerNode(5).
innerNode(6).
innerNode(7).
innerNode(8).
innerNode(9).
num(10).
max_total_weight(62).
