// Increm sched

include <table_utils>

procedure printfacts(name,table) {
	for t in tuples(table) do
		local fact = name
		fact = fact .. "("
		local i = 1
		while i < #t do 
			fact = fact .. t[i]
			fact = fact .. ","
			i = i + 1
		end
		fact = fact .. t[#t] .. "). "
		io.write(fact)
	end
}

procedure preprocess(struc){
  clean(struc)
  struc[input::curr_on_instance].cf = struc[input::curr_on_instance].pf
  struc[input::curr_job_start].cf = struc[input::curr_job_start].pf
  struc[input::offline_instance].cf = struc[input::offline_instance].pf
  for e in tuples(struc[input::max_value].ct) do
      maxval = e[1]
  end
  struc[V::time.type] = range(0,maxval)
  struc[V::integer.type] = range(0,maxval)
  for e in tuples(struc[input::max_total_penalty].ct) do
      maxpen = e[1]
  end
  struc[V::typepenalty.type] = range(0,maxpen)
  
  setvocabulary(struc,V)
}

procedure main(){
  preprocess(S)
  setoptions()
  
  local sols = modelexpand(solution,S)
  return postprocess(sols)
}

procedure postprocess(models) {
  if models == nil or models[1] == nil then
    print("INCONSISTENT")
    return 20
  else
    print("ANSWER")
    printfacts("start",models[1][V::start].graph.ct)
    printfacts("on_instance",models[1][V::on_instance].graph.ct)
// TODO printfacts("penalty",models[1][V::penalty].ct)
    printfacts("tot_penalty",models[1][V::tot_penalty].graph.ct)
    printfacts("rescheduled",models[1][V::rescheduled].ct)
    print("")
    return 10
  end
}

procedure setoptions(){

  //TODO tweak options
//  stdoptions.symmetrybreaking="static"
  stdoptions.xsb=true
  stdoptions.cpsupport=true
}


vocabulary input {
  type device
  type job
  type integer isa int
  type instance isa int
  type length isa int
  type time isa int
  type import isa int

  type typepenalty isa int

  max_total_penalty(integer)
  max_value(time)

  instances(device,instance) // device d has instances 1..instance
  offline_instance(device,instance)
  job_device(job,device)
  job_len(job,length)
  deadline(job,time)
  importance(job, import)
  precedes(job,job)

  //Current PARTIAL schedule
  curr_job_start(job,time)
  curr_on_instance(job,instance)
  curr_time(time)
}
vocabulary V {
  extern vocabulary input
  
  //output
    // search
  start(job): time
  on_instance(job): instance
  tot_penalty:integer
// TODO  penalty(job): typepenalty
    // completely calculatable with xsb
  rescheduled(job)
  
  //new voc (all completely calculatable with xsb)
  curr_time_f:time
  max_total_penalty_f:integer
  job_len_f(job):length
  job_device_f(job):device
  instances_f(device):instance
  deadline_f(job):time
  earliestStartingTime(job,time)
  completed_job(job,time,instance)
  currently_online_job(job,time,instance)
  job_to_plan(job)
  real_importance(job,import)
}

theory solution : V {
//   Define things as functions
  { job_len_f(j) = l <- job_len(j,l). }
  { job_device_f(j) = d <- job_device(j,d). }
  { instances_f(d) = i <- instances(d,i). }
  { curr_time_f = t <- curr_time(t). }
  { max_total_penalty_f = t <- max_total_penalty(t). }
  { deadline_f(j) = dl <- deadline(j,dl).
    deadline_f(j) = v <- max_value(v) & (~?dl2 : deadline(j,dl2)). }
    
  {
    earliestStartingTime(j,t) <- curr_job_start(j,t) & curr_on_instance(j,i) & job_device(j,d) & ~offline_instance(d,i).
    earliestStartingTime(j,ct) <- curr_time(ct) & (~?t:curr_job_start(j,t)) & (~?j2 : precedes(j2,j)).
    earliestStartingTime(j,t) <- precedes(j2,j) & job_len(j2,len) & earliestStartingTime(j2,t2) & t = t2 + len.
  }
      
  { completed_job(j,t,i) <- curr_job_start(j,t) & curr_on_instance(j,i) & job_len(j,len) & curr_time(ct) & t + len =< ct. }
  
  { currently_online_job(j,t,i) <- curr_job_start(j,t) & curr_on_instance(j,i) & job_len(j,len) & curr_time(ct) & t=<ct=<t+len & job_device(j,d) & ~(offline_instance(d,i)). }
  
  { job_to_plan(j) <- curr_job_start(j,t) & curr_time(ct) & ct=<t.
    job_to_plan(j) <- rescheduled(j).
    job_to_plan(j) <- ~?t: curr_job_start(j,t). }
    
//   A job is rescheduled if it is already running before the current time AND its instance has gone offline
  { rescheduled(j) <- curr_job_start(j,t) & job_len(j,l) & curr_on_instance(j,i) & t=<curr_time_f =<(t+l) & job_device(j,d) & offline_instance(d,i). }
  
  {
  	real_importance(j,i) <- importance(j,i).
  	real_importance(j,1) <- (~?i: importance(j,i)).
  }
    
  // No-xsb  
  max_value(v) & job_len(j,len) => start(j) =< (v - len).
  
  earliestStartingTime(j,est) => start(j) >= est.
  
  max_total_penalty_f >= sum{j len dl i: job_len(j,len) & deadline(j,dl) & start(j) + len > dl & real_importance(j,i) : (start(j) + len-dl)*i}.
  
  // Completed jobs are copied into the new schedule
  !j t i: completed_job(j,t,i) => start(j)=t & on_instance(j)=i.
  
  // Currently running jobs on online instances are copied into the new schedule
  !j t i: currently_online_job(j,t,i) => start(j)=t & on_instance(j)=i & ~rescheduled(j).
  
  // No job that is running or still has to start can be scheduled on offline instances
  ! j in : job_to_plan(j) & offline_instance(job_device_f(j),in) => ~on_instance(j) = in.
  
  
  // Precedences are respected
  !j1 j2: precedes(j1,j2) => start(j1)+job_len_f(j1)=<start(j2).
  
  // Jobs that had a previous schedule, but were rescheduled or still had to start, have to start at the current time at the earliest
  !j: job_to_plan(j) => curr_time_f=<start(j).
  
  // Jobs that were not schedule previously, should start at the current time at the earliest 
  !j: ~(?t: curr_job_start(j,t)) => curr_time_f=<start(j).

  // Having a correct schedule also has the constraints:
  // An instance is only used by one job at a time
  !j1 j2: j1<j2 & on_instance(j1)=on_instance(j2) & job_device_f(j1)=job_device_f(j2) => (start(j1)+job_len_f(j1)=<start(j2) | start(j2)+job_len_f(j2)=<start(j1)).

  // All jobs are scheduled is implied by using functions
  
  // Every job runs on an instance of the correct device
  !j: on_instance(j)=<instances_f(job_device_f(j)).
}
factlist S : input {
device(1).
instances(1,2).
device(2).
instances(2,1).
device(3).
instances(3,2).
device(4).
instances(4,1).
device(5).
instances(5,1).
job(1).
job(2).
job(3).
job(4).
job(5).
job(6).
job(7).
job(8).
job(9).
job(10).
job(11).
job(12).
job(13).
job(14).
job(15).
job(16).
job(17).
job(18).
job(19).
job(20).
job(21).
job(22).
job(23).
job(24).
job(25).
job(26).
job(27).
job(28).
job(29).
job(30).
precedes(1,2).
precedes(2,3).
precedes(4,5).
precedes(5,6).
precedes(7,8).
precedes(8,9).
precedes(10,11).
precedes(11,12).
precedes(13,14).
precedes(14,15).
precedes(16,17).
precedes(17,18).
precedes(19,20).
precedes(20,21).
precedes(22,23).
precedes(23,24).
precedes(25,26).
precedes(26,27).
precedes(28,29).
precedes(29,30).
importance(30,2).
importance(29,1).
importance(28,1).
importance(27,1).
importance(26,1).
importance(25,1).
importance(24,1).
importance(23,1).
importance(22,3).
importance(21,3).
importance(20,2).
importance(19,2).
importance(18,2).
importance(17,1).
importance(16,2).
importance(15,2).
importance(14,2).
importance(13,2).
importance(12,3).
importance(11,1).
importance(10,3).
importance(9,2).
importance(8,3).
importance(7,2).
importance(6,3).
importance(5,1).
importance(4,2).
importance(3,1).
importance(2,1).
importance(1,2).
job_device(1,2).
job_device(4,2).
job_device(7,1).
job_device(10,2).
job_device(13,1).
job_device(16,2).
job_device(19,1).
job_device(22,1).
job_device(25,2).
job_device(28,1).
job_device(2,4).
job_device(5,3).
job_device(8,3).
job_device(11,3).
job_device(14,4).
job_device(17,4).
job_device(20,3).
job_device(23,4).
job_device(26,4).
job_device(29,4).
job_device(3,5).
job_device(6,5).
job_device(9,5).
job_device(12,5).
job_device(15,5).
job_device(18,5).
job_device(21,5).
job_device(24,5).
job_device(27,5).
job_device(30,5).
job_len(30,18).
job_len(29,6).
job_len(28,5).
job_len(27,9).
job_len(26,6).
job_len(25,17).
job_len(24,3).
job_len(23,6).
job_len(22,19).
job_len(21,4).
job_len(20,5).
job_len(19,8).
job_len(18,14).
job_len(17,12).
job_len(16,19).
job_len(15,6).
job_len(14,8).
job_len(13,18).
job_len(12,19).
job_len(11,11).
job_len(10,14).
job_len(9,14).
job_len(8,5).
job_len(7,10).
job_len(6,13).
job_len(5,13).
job_len(4,19).
job_len(3,9).
job_len(2,7).
job_len(1,10).
deadline(3,25).
deadline(6,13).
deadline(9,27).
deadline(12,38).
deadline(15,22).
deadline(18,24).
deadline(21,22).
deadline(24,15).
deadline(27,35).
deadline(30,31).
max_total_penalty(1129).
curr_job_start(9,68).
curr_job_start(30,50).
curr_job_start(15,44).
curr_job_start(12,25).
curr_job_start(29,5).
curr_job_start(14,18).
curr_job_start(8,15).
curr_job_start(11,14).
curr_job_start(10,0).
curr_job_start(7,5).
curr_job_start(28,0).
curr_job_start(13,0).
curr_on_instance(9,1).
curr_on_instance(8,2).
curr_on_instance(7,2).
curr_on_instance(30,1).
curr_on_instance(29,1).
curr_on_instance(28,2).
curr_on_instance(15,1).
curr_on_instance(14,1).
curr_on_instance(13,1).
curr_on_instance(12,1).
curr_on_instance(11,1).
curr_on_instance(10,1).
curr_time(15).
max_value(1282).

}
