// Increm sched

include <table_utils>

procedure printfacts(name,table) {
	for t in tuples(table) do
		local fact = name
		fact = fact .. "("
		local i = 1
		while i < #t do 
			fact = fact .. t[i]
			fact = fact .. ","
			i = i + 1
		end
		fact = fact .. t[#t] .. "). "
		io.write(fact)
	end
}

procedure preprocess(struc){
  clean(struc)
  struc[input::curr_on_instance].cf = struc[input::curr_on_instance].pf
  struc[input::curr_job_start].cf = struc[input::curr_job_start].pf
  struc[input::offline_instance].cf = struc[input::offline_instance].pf
  for e in tuples(struc[input::max_value].ct) do
      maxval = e[1]
  end
  struc[V::time.type] = range(0,maxval)
  struc[V::integer.type] = range(0,maxval)
  for e in tuples(struc[input::max_total_penalty].ct) do
      maxpen = e[1]
  end
  struc[V::typepenalty.type] = range(0,maxpen)
  
  setvocabulary(struc,V)
}

procedure main(){
  preprocess(S)
  setoptions()
  
  local sols = modelexpand(solution,S)
  return postprocess(sols)
}

procedure postprocess(models) {
  if models == nil or models[1] == nil then
    print("INCONSISTENT")
    return 20
  else
    print("ANSWER")
    printfacts("start",models[1][V::start].graph.ct)
    printfacts("on_instance",models[1][V::on_instance].graph.ct)
// TODO printfacts("penalty",models[1][V::penalty].ct)
    printfacts("tot_penalty",models[1][V::tot_penalty].graph.ct)
    printfacts("rescheduled",models[1][V::rescheduled].ct)
    print("")
    return 10
  end
}

procedure setoptions(){

  //TODO tweak options
//  stdoptions.symmetrybreaking="static"
  stdoptions.xsb=true
  stdoptions.cpsupport=true
}


vocabulary input {
  type device
  type job
  type integer isa int
  type instance isa int
  type length isa int
  type time isa int
  type import isa int

  type typepenalty isa int

  max_total_penalty(integer)
  max_value(time)

  instances(device,instance) // device d has instances 1..instance
  offline_instance(device,instance)
  job_device(job,device)
  job_len(job,length)
  deadline(job,time)
  importance(job, import)
  precedes(job,job)

  //Current PARTIAL schedule
  curr_job_start(job,time)
  curr_on_instance(job,instance)
  curr_time(time)
}
vocabulary V {
  extern vocabulary input
  
  //output
    // search
  start(job): time
  on_instance(job): instance
  tot_penalty:integer
// TODO  penalty(job): typepenalty
    // completely calculatable with xsb
  rescheduled(job)
  
  //new voc (all completely calculatable with xsb)
  curr_time_f:time
  max_total_penalty_f:integer
  job_len_f(job):length
  job_device_f(job):device
  instances_f(device):instance
  deadline_f(job):time
  earliestStartingTime(job,time)
  completed_job(job,time,instance)
  currently_online_job(job,time,instance)
  job_to_plan(job)
  real_importance(job,import)
}

theory solution : V {
//   Define things as functions
  { job_len_f(j) = l <- job_len(j,l). }
  { job_device_f(j) = d <- job_device(j,d). }
  { instances_f(d) = i <- instances(d,i). }
  { curr_time_f = t <- curr_time(t). }
  { max_total_penalty_f = t <- max_total_penalty(t). }
  { deadline_f(j) = dl <- deadline(j,dl).
    deadline_f(j) = v <- max_value(v) & (~?dl2 : deadline(j,dl2)). }
    
  {
    earliestStartingTime(j,t) <- curr_job_start(j,t) & curr_on_instance(j,i) & job_device(j,d) & ~offline_instance(d,i).
    earliestStartingTime(j,ct) <- curr_time(ct) & (~?t:curr_job_start(j,t)) & (~?j2 : precedes(j2,j)).
    earliestStartingTime(j,t) <- precedes(j2,j) & job_len(j2,len) & earliestStartingTime(j2,t2) & t = t2 + len.
  }
      
  { completed_job(j,t,i) <- curr_job_start(j,t) & curr_on_instance(j,i) & job_len(j,len) & curr_time(ct) & t + len =< ct. }
  
  { currently_online_job(j,t,i) <- curr_job_start(j,t) & curr_on_instance(j,i) & job_len(j,len) & curr_time(ct) & t=<ct=<t+len & job_device(j,d) & ~(offline_instance(d,i)). }
  
  { job_to_plan(j) <- curr_job_start(j,t) & curr_time(ct) & ct=<t.
    job_to_plan(j) <- rescheduled(j).
    job_to_plan(j) <- ~?t: curr_job_start(j,t). }
    
//   A job is rescheduled if it is already running before the current time AND its instance has gone offline
  { rescheduled(j) <- curr_job_start(j,t) & job_len(j,l) & curr_on_instance(j,i) & t=<curr_time_f =<(t+l) & job_device(j,d) & offline_instance(d,i). }
  
  {
  	real_importance(j,i) <- importance(j,i).
  	real_importance(j,1) <- (~?i: importance(j,i)).
  }
    
  // No-xsb  
  max_value(v) & job_len(j,len) => start(j) =< (v - len).
  
  earliestStartingTime(j,est) => start(j) >= est.
  
  max_total_penalty_f >= sum{j len dl i: job_len(j,len) & deadline(j,dl) & start(j) + len > dl & real_importance(j,i) : (start(j) + len-dl)*i}.
  
  // Completed jobs are copied into the new schedule
  !j t i: completed_job(j,t,i) => start(j)=t & on_instance(j)=i.
  
  // Currently running jobs on online instances are copied into the new schedule
  !j t i: currently_online_job(j,t,i) => start(j)=t & on_instance(j)=i & ~rescheduled(j).
  
  // No job that is running or still has to start can be scheduled on offline instances
  ! j in : job_to_plan(j) & offline_instance(job_device_f(j),in) => ~on_instance(j) = in.
  
  
  // Precedences are respected
  !j1 j2: precedes(j1,j2) => start(j1)+job_len_f(j1)=<start(j2).
  
  // Jobs that had a previous schedule, but were rescheduled or still had to start, have to start at the current time at the earliest
  !j: job_to_plan(j) => curr_time_f=<start(j).
  
  // Jobs that were not schedule previously, should start at the current time at the earliest 
  !j: ~(?t: curr_job_start(j,t)) => curr_time_f=<start(j).

  // Having a correct schedule also has the constraints:
  // An instance is only used by one job at a time
  !j1 j2: j1<j2 & on_instance(j1)=on_instance(j2) & job_device_f(j1)=job_device_f(j2) => (start(j1)+job_len_f(j1)=<start(j2) | start(j2)+job_len_f(j2)=<start(j1)).

  // All jobs are scheduled is implied by using functions
  
  // Every job runs on an instance of the correct device
  !j: on_instance(j)=<instances_f(job_device_f(j)).
}
factlist S : input {
device(1).
instances(1,2).
device(2).
instances(2,1).
device(3).
instances(3,2).
device(4).
instances(4,1).
device(5).
instances(5,1).
job(1).
job(2).
job(3).
job(4).
job(5).
job(6).
job(7).
job(8).
job(9).
job(10).
job(11).
job(12).
job(13).
job(14).
job(15).
job(16).
job(17).
job(18).
job(19).
job(20).
job(21).
job(22).
job(23).
job(24).
job(25).
job(26).
job(27).
job(28).
job(29).
job(30).
job(31).
job(32).
job(33).
job(34).
job(35).
job(36).
precedes(1,2).
precedes(2,3).
precedes(4,5).
precedes(5,6).
precedes(7,8).
precedes(8,9).
precedes(10,11).
precedes(11,12).
precedes(13,14).
precedes(14,15).
precedes(16,17).
precedes(17,18).
precedes(19,20).
precedes(20,21).
precedes(22,23).
precedes(23,24).
precedes(25,26).
precedes(26,27).
precedes(28,29).
precedes(29,30).
precedes(31,32).
precedes(32,33).
precedes(34,35).
precedes(35,36).
importance(36,3).
importance(35,3).
importance(34,2).
importance(33,1).
importance(32,3).
importance(31,2).
importance(30,1).
importance(29,1).
importance(28,1).
importance(27,1).
importance(26,2).
importance(25,2).
importance(24,3).
importance(23,3).
importance(22,3).
importance(21,1).
importance(20,3).
importance(19,1).
importance(18,2).
importance(17,2).
importance(16,2).
importance(15,1).
importance(14,2).
importance(13,2).
importance(12,1).
importance(11,3).
importance(10,2).
importance(9,3).
importance(8,3).
importance(7,1).
importance(6,1).
importance(5,3).
importance(4,3).
importance(3,1).
importance(2,2).
importance(1,3).
job_device(1,1).
job_device(4,2).
job_device(7,2).
job_device(10,2).
job_device(13,1).
job_device(16,1).
job_device(19,2).
job_device(22,2).
job_device(25,2).
job_device(28,2).
job_device(31,1).
job_device(34,1).
job_device(2,3).
job_device(5,3).
job_device(8,3).
job_device(11,3).
job_device(14,4).
job_device(17,4).
job_device(20,4).
job_device(23,3).
job_device(26,3).
job_device(29,3).
job_device(32,3).
job_device(35,3).
job_device(3,5).
job_device(6,5).
job_device(9,5).
job_device(12,5).
job_device(15,5).
job_device(18,5).
job_device(21,5).
job_device(24,5).
job_device(27,5).
job_device(30,5).
job_device(33,5).
job_device(36,5).
job_len(36,6).
job_len(35,15).
job_len(34,10).
job_len(33,3).
job_len(32,9).
job_len(31,6).
job_len(30,8).
job_len(29,17).
job_len(28,5).
job_len(27,4).
job_len(26,6).
job_len(25,14).
job_len(24,17).
job_len(23,17).
job_len(22,13).
job_len(21,9).
job_len(20,20).
job_len(19,4).
job_len(18,6).
job_len(17,17).
job_len(16,16).
job_len(15,4).
job_len(14,3).
job_len(13,6).
job_len(12,17).
job_len(11,15).
job_len(10,11).
job_len(9,5).
job_len(8,19).
job_len(7,4).
job_len(6,11).
job_len(5,13).
job_len(4,19).
job_len(3,18).
job_len(2,5).
job_len(1,15).
deadline(3,17).
deadline(6,21).
deadline(9,29).
deadline(12,14).
deadline(15,10).
deadline(18,26).
deadline(21,26).
deadline(24,11).
deadline(27,39).
deadline(30,37).
deadline(33,20).
deadline(36,30).
max_total_penalty(1358).
curr_job_start(30,73).
curr_job_start(27,69).
curr_job_start(24,52).
curr_job_start(21,43).
curr_job_start(12,26).
curr_job_start(20,15).
curr_job_start(29,47).
curr_job_start(26,42).
curr_job_start(23,28).
curr_job_start(11,11).
curr_job_start(28,42).
curr_job_start(25,28).
curr_job_start(22,15).
curr_job_start(19,11).
curr_job_start(10,0).
curr_on_instance(30,1).
curr_on_instance(29,1).
curr_on_instance(28,1).
curr_on_instance(27,1).
curr_on_instance(26,2).
curr_on_instance(25,1).
curr_on_instance(24,1).
curr_on_instance(23,1).
curr_on_instance(22,1).
curr_on_instance(21,1).
curr_on_instance(20,1).
curr_on_instance(19,1).
curr_on_instance(12,1).
curr_on_instance(11,1).
curr_on_instance(10,1).
curr_time(0).
max_value(1521).

}
