// Increm sched

include <table_utils>

procedure printfacts(name,table) {
	for t in tuples(table) do
		local fact = name
		fact = fact .. "("
		local i = 1
		while i < #t do 
			fact = fact .. t[i]
			fact = fact .. ","
			i = i + 1
		end
		fact = fact .. t[#t] .. "). "
		io.write(fact)
	end
}

procedure preprocess(struc){
  clean(struc)
  struc[input::curr_on_instance].cf = struc[input::curr_on_instance].pf
  struc[input::curr_job_start].cf = struc[input::curr_job_start].pf
  struc[input::offline_instance].cf = struc[input::offline_instance].pf
  for e in tuples(struc[input::max_value].ct) do
      maxval = e[1]
  end
  struc[V::time.type] = range(0,maxval)
  struc[V::integer.type] = range(0,maxval)
  for e in tuples(struc[input::max_total_penalty].ct) do
      maxpen = e[1]
  end
  struc[V::typepenalty.type] = range(0,maxpen)
  
  setvocabulary(struc,V)
}

procedure main(){
  preprocess(S)
  setoptions()
  
  local sols = modelexpand(solution,S)
  return postprocess(sols)
}

procedure postprocess(models) {
  if models == nil or models[1] == nil then
    print("INCONSISTENT")
    return 20
  else
    print("ANSWER")
    printfacts("start",models[1][V::start].graph.ct)
    printfacts("on_instance",models[1][V::on_instance].graph.ct)
// TODO printfacts("penalty",models[1][V::penalty].ct)
    printfacts("tot_penalty",models[1][V::tot_penalty].graph.ct)
    printfacts("rescheduled",models[1][V::rescheduled].ct)
    print("")
    return 10
  end
}

procedure setoptions(){

  //TODO tweak options
//  stdoptions.symmetrybreaking="static"
  stdoptions.xsb=true
  stdoptions.cpsupport=true
}


vocabulary input {
  type device
  type job
  type integer isa int
  type instance isa int
  type length isa int
  type time isa int
  type import isa int

  type typepenalty isa int

  max_total_penalty(integer)
  max_value(time)

  instances(device,instance) // device d has instances 1..instance
  offline_instance(device,instance)
  job_device(job,device)
  job_len(job,length)
  deadline(job,time)
  importance(job, import)
  precedes(job,job)

  //Current PARTIAL schedule
  curr_job_start(job,time)
  curr_on_instance(job,instance)
  curr_time(time)
}
vocabulary V {
  extern vocabulary input
  
  //output
    // search
  start(job): time
  on_instance(job): instance
  tot_penalty:integer
// TODO  penalty(job): typepenalty
    // completely calculatable with xsb
  rescheduled(job)
  
  //new voc (all completely calculatable with xsb)
  curr_time_f:time
  max_total_penalty_f:integer
  job_len_f(job):length
  job_device_f(job):device
  instances_f(device):instance
  deadline_f(job):time
  earliestStartingTime(job,time)
  completed_job(job,time,instance)
  currently_online_job(job,time,instance)
  job_to_plan(job)
  real_importance(job,import)
}

theory solution : V {
//   Define things as functions
  { job_len_f(j) = l <- job_len(j,l). }
  { job_device_f(j) = d <- job_device(j,d). }
  { instances_f(d) = i <- instances(d,i). }
  { curr_time_f = t <- curr_time(t). }
  { max_total_penalty_f = t <- max_total_penalty(t). }
  { deadline_f(j) = dl <- deadline(j,dl).
    deadline_f(j) = v <- max_value(v) & (~?dl2 : deadline(j,dl2)). }
    
  {
    earliestStartingTime(j,t) <- curr_job_start(j,t) & curr_on_instance(j,i) & job_device(j,d) & ~offline_instance(d,i).
    earliestStartingTime(j,ct) <- curr_time(ct) & (~?t:curr_job_start(j,t)) & (~?j2 : precedes(j2,j)).
    earliestStartingTime(j,t) <- precedes(j2,j) & job_len(j2,len) & earliestStartingTime(j2,t2) & t = t2 + len.
  }
      
  { completed_job(j,t,i) <- curr_job_start(j,t) & curr_on_instance(j,i) & job_len(j,len) & curr_time(ct) & t + len =< ct. }
  
  { currently_online_job(j,t,i) <- curr_job_start(j,t) & curr_on_instance(j,i) & job_len(j,len) & curr_time(ct) & t=<ct=<t+len & job_device(j,d) & ~(offline_instance(d,i)). }
  
  { job_to_plan(j) <- curr_job_start(j,t) & curr_time(ct) & ct=<t.
    job_to_plan(j) <- rescheduled(j).
    job_to_plan(j) <- ~?t: curr_job_start(j,t). }
    
//   A job is rescheduled if it is already running before the current time AND its instance has gone offline
  { rescheduled(j) <- curr_job_start(j,t) & job_len(j,l) & curr_on_instance(j,i) & t=<curr_time_f =<(t+l) & job_device(j,d) & offline_instance(d,i). }
  
  {
  	real_importance(j,i) <- importance(j,i).
  	real_importance(j,1) <- (~?i: importance(j,i)).
  }
    
  // No-xsb  
  max_value(v) & job_len(j,len) => start(j) =< (v - len).
  
  earliestStartingTime(j,est) => start(j) >= est.
  
  max_total_penalty_f >= sum{j len dl i: job_len(j,len) & deadline(j,dl) & start(j) + len > dl & real_importance(j,i) : (start(j) + len-dl)*i}.
  
  // Completed jobs are copied into the new schedule
  !j t i: completed_job(j,t,i) => start(j)=t & on_instance(j)=i.
  
  // Currently running jobs on online instances are copied into the new schedule
  !j t i: currently_online_job(j,t,i) => start(j)=t & on_instance(j)=i & ~rescheduled(j).
  
  // No job that is running or still has to start can be scheduled on offline instances
  ! j in : job_to_plan(j) & offline_instance(job_device_f(j),in) => ~on_instance(j) = in.
  
  
  // Precedences are respected
  !j1 j2: precedes(j1,j2) => start(j1)+job_len_f(j1)=<start(j2).
  
  // Jobs that had a previous schedule, but were rescheduled or still had to start, have to start at the current time at the earliest
  !j: job_to_plan(j) => curr_time_f=<start(j).
  
  // Jobs that were not schedule previously, should start at the current time at the earliest 
  !j: ~(?t: curr_job_start(j,t)) => curr_time_f=<start(j).

  // Having a correct schedule also has the constraints:
  // An instance is only used by one job at a time
  !j1 j2: j1<j2 & on_instance(j1)=on_instance(j2) & job_device_f(j1)=job_device_f(j2) => (start(j1)+job_len_f(j1)=<start(j2) | start(j2)+job_len_f(j2)=<start(j1)).

  // All jobs are scheduled is implied by using functions
  
  // Every job runs on an instance of the correct device
  !j: on_instance(j)=<instances_f(job_device_f(j)).
}
factlist S : input {
device(1).
instances(1,2).
device(2).
instances(2,1).
device(3).
instances(3,2).
device(4).
instances(4,1).
device(5).
instances(5,1).
job(1).
job(2).
job(3).
job(4).
job(5).
job(6).
job(7).
job(8).
job(9).
job(10).
job(11).
job(12).
job(13).
job(14).
job(15).
job(16).
job(17).
job(18).
job(19).
job(20).
job(21).
job(22).
job(23).
job(24).
job(25).
job(26).
job(27).
job(28).
job(29).
job(30).
job(31).
job(32).
job(33).
job(34).
job(35).
job(36).
job(37).
job(38).
job(39).
job(40).
job(41).
job(42).
job(43).
job(44).
job(45).
job(46).
job(47).
job(48).
job(49).
job(50).
job(51).
job(52).
job(53).
job(54).
job(55).
job(56).
job(57).
job(58).
job(59).
job(60).
precedes(1,2).
precedes(2,3).
precedes(4,5).
precedes(5,6).
precedes(7,8).
precedes(8,9).
precedes(10,11).
precedes(11,12).
precedes(13,14).
precedes(14,15).
precedes(16,17).
precedes(17,18).
precedes(19,20).
precedes(20,21).
precedes(22,23).
precedes(23,24).
precedes(25,26).
precedes(26,27).
precedes(28,29).
precedes(29,30).
precedes(31,32).
precedes(32,33).
precedes(34,35).
precedes(35,36).
precedes(37,38).
precedes(38,39).
precedes(40,41).
precedes(41,42).
precedes(43,44).
precedes(44,45).
precedes(46,47).
precedes(47,48).
precedes(49,50).
precedes(50,51).
precedes(52,53).
precedes(53,54).
precedes(55,56).
precedes(56,57).
precedes(58,59).
precedes(59,60).
importance(60,1).
importance(59,1).
importance(58,2).
importance(57,2).
importance(56,3).
importance(55,2).
importance(54,3).
importance(53,2).
importance(52,1).
importance(51,1).
importance(50,1).
importance(49,2).
importance(48,1).
importance(47,1).
importance(46,1).
importance(45,3).
importance(44,3).
importance(43,2).
importance(42,1).
importance(41,1).
importance(40,2).
importance(39,3).
importance(38,2).
importance(37,3).
importance(36,2).
importance(35,3).
importance(34,1).
importance(33,1).
importance(32,1).
importance(31,3).
importance(30,1).
importance(29,3).
importance(28,2).
importance(27,1).
importance(26,1).
importance(25,3).
importance(24,2).
importance(23,2).
importance(22,2).
importance(21,1).
importance(20,3).
importance(19,2).
importance(18,2).
importance(17,2).
importance(16,3).
importance(15,2).
importance(14,1).
importance(13,2).
importance(12,2).
importance(11,3).
importance(10,2).
importance(9,3).
importance(8,1).
importance(7,2).
importance(6,1).
importance(5,1).
importance(4,2).
importance(3,1).
importance(2,1).
importance(1,3).
job_device(1,2).
job_device(4,2).
job_device(7,1).
job_device(10,1).
job_device(13,2).
job_device(16,2).
job_device(19,2).
job_device(22,1).
job_device(25,2).
job_device(28,1).
job_device(31,2).
job_device(34,2).
job_device(37,1).
job_device(40,1).
job_device(43,2).
job_device(46,2).
job_device(49,2).
job_device(52,2).
job_device(55,1).
job_device(58,1).
job_device(2,3).
job_device(5,4).
job_device(8,4).
job_device(11,4).
job_device(14,3).
job_device(17,4).
job_device(20,3).
job_device(23,4).
job_device(26,3).
job_device(29,3).
job_device(32,4).
job_device(35,4).
job_device(38,3).
job_device(41,4).
job_device(44,4).
job_device(47,4).
job_device(50,4).
job_device(53,3).
job_device(56,3).
job_device(59,4).
job_device(3,5).
job_device(6,5).
job_device(9,5).
job_device(12,5).
job_device(15,5).
job_device(18,5).
job_device(21,5).
job_device(24,5).
job_device(27,5).
job_device(30,5).
job_device(33,5).
job_device(36,5).
job_device(39,5).
job_device(42,5).
job_device(45,5).
job_device(48,5).
job_device(51,5).
job_device(54,5).
job_device(57,5).
job_device(60,5).
job_len(60,17).
job_len(59,20).
job_len(58,5).
job_len(57,13).
job_len(56,15).
job_len(55,16).
job_len(54,12).
job_len(53,9).
job_len(52,11).
job_len(51,18).
job_len(50,14).
job_len(49,15).
job_len(48,16).
job_len(47,6).
job_len(46,7).
job_len(45,20).
job_len(44,11).
job_len(43,11).
job_len(42,15).
job_len(41,13).
job_len(40,19).
job_len(39,6).
job_len(38,10).
job_len(37,8).
job_len(36,17).
job_len(35,8).
job_len(34,6).
job_len(33,13).
job_len(32,16).
job_len(31,3).
job_len(30,8).
job_len(29,19).
job_len(28,4).
job_len(27,16).
job_len(26,20).
job_len(25,6).
job_len(24,5).
job_len(23,4).
job_len(22,12).
job_len(21,12).
job_len(20,14).
job_len(19,17).
job_len(18,13).
job_len(17,17).
job_len(16,9).
job_len(15,7).
job_len(14,15).
job_len(13,5).
job_len(12,13).
job_len(11,15).
job_len(10,11).
job_len(9,4).
job_len(8,15).
job_len(7,20).
job_len(6,9).
job_len(5,19).
job_len(4,18).
job_len(3,13).
job_len(2,5).
job_len(1,3).
deadline(3,39).
deadline(6,16).
deadline(9,20).
deadline(12,29).
deadline(15,12).
deadline(18,14).
deadline(21,36).
deadline(24,26).
deadline(27,38).
deadline(30,15).
deadline(33,36).
deadline(36,33).
deadline(39,25).
deadline(42,10).
deadline(45,36).
deadline(48,39).
deadline(51,40).
deadline(54,38).
deadline(57,33).
deadline(60,27).
max_total_penalty(2161).
curr_time(0).
max_value(2400).

}
