#theory csp {
    linear_term {
    + : 5, unary;
    - : 5, unary;
    * : 4, binary, left;
    + : 3, binary, left;
    - : 3, binary, left
    };
    dom_term {
    + : 5, unary;
    - : 5, unary;
    .. : 1, binary, left
    };
    show_term {
    / : 1, binary, left
    };
    minimize_term {
    + : 5, unary;
    - : 5, unary;
    * : 4, binary, left;
    + : 3, binary, left;
    - : 3, binary, left;
    @ : 0, binary, left
    };

    &dom/0 : dom_term, {=}, linear_term, any;
    &sum/0 : linear_term, {<=,=,>=,<,>,!=}, linear_term, any;
    &show/0 : show_term, directive;
    &distinct/0 : linear_term, any;
    &minimize/0 : minimize_term, directive
}.

%#include "csp.lp".
color(red).
color(blue).
color(green).

leafCost(X,red,W)   :- leafWeightCardinality(X,W,C), 0 < W.
leafCost(X,blue,C)  :- leafWeightCardinality(X,W,C), 0 < C, C < W.
leafCost(X,green,D) :- leafWeightCardinality(X,W,C), D = W+C, 0 < D.

leafMin(X,W) :- leafWeightCardinality(X,W,C), W < C.
leafMin(X,C) :- leafWeightCardinality(X,W,C), C < W.

repeat(C,M/C)   :- max_total_weight(M), leafCost(X,L,C), L != green.
repeat(D-C,M/D) :- max_total_weight(M), leafCost(X,green,D), leafMin(X,C).
repeat(D,M/D)   :- max_total_weight(M), leafCost(X,green,D), leafWeightCardinality(X,C,C).

assign(C)  :- repeat(C,S).
maxim(C,R) :- assign(C), #max{ S : repeat(C,S) } = R.

assigned :- assign(C).
limit(R) :- assigned, #max{ S : maxim(C,S) } = R.

coloredPos(N-1) :- num(N), 1 < N.
coloredPos(P-1) :- coloredPos(P), 1 < P.

location(0) :- num(N), 0 < N.
location(P) :- coloredPos(P).

%{ lt(X,P) } :- leafWeightCardinality(X,W,C), coloredPos(P).
%:- lt(X,P-1), coloredPos(P), not lt(X,P).
&dom {0..Max} = var(X) :- num(N), leafWeightCardinality(X,_,_), Max=N-1.

dom(X,P) :- num(N), leafWeightCardinality(X,_,_), P=0..N-1.
%leafPos(X,P-1) :- lt(X,P), not lt(X,P-1).
%leafPos(X,N-1) :- leafWeightCardinality(X,W,C), num(N), not lt(X,N-1).
%:- location(P), 2 <= #count{ X : leafPos(X,P) }.
&distinct{var(X) : leafWeightCardinality(X,_,_)}.

{ posColor(P,green) } :- coloredPos(P).
posColor(P,blue)  :- dom(X,P), &sum{var(X)}=P, not posColor(P,green), leafWeightCardinality(X,W,C), C < W.
posColor(P,red)   :- dom(X,P), &sum{var(X)}=P, not posColor(P,green), leafWeightCardinality(X,W,C), W <= C.

iterate(0,1)     :- not posColor(1,green).
iterate(0,I+1)   :- not posColor(1,green), limit(I), iterate(1,I).
iterate(P-1,1)   :- coloredPos(P), not posColor(P,green), not limit(0).
iterate(P-1,I+1) :- coloredPos(P), not posColor(P,green), not limit(I), iterate(P,I).

cost(0,W,0)   :- &sum{var(X)}=0, leafCost(X,red,W).
cost(P,C,0)   :- &sum{var(X)}=P, dom(X,P), leafMin(X,C), 0 < C.
cost(P,D-C,0) :- &sum{var(X)}=P, dom(X,P), leafMin(X,C), leafCost(X,green,D), posColor(P,green).
cost(P,C,0)   :- &sum{var(X)}=P, dom(X,P), leafWeightCardinality(X,C,C), 0 < C, not posColor(P,green).
cost(P,2*C,0) :- &sum{var(X)}=P, dom(X,P), leafWeightCardinality(X,C,C), 0 < C, posColor(P,green).
cost(P,C,I)   :- iterate(P,I), cost(P,C,I-1), not maxim(C,I-1).
cost(0,C,I)   :- iterate(0,I), cost(0,C,I-1), maxim(C,I-1).

scost(C,P,I) :- cost(P,C,I), P+I > 0.
:- max_total_weight(M), M < #sum{ C,P,I : scost(C,P,I) }. 

starting(X) :- &sum{var(X)}=P, posColor(P,green), dom(X,P+1), leafWeightCardinality(X-1,W,C).

started(X-1,P) :- starting(X), &sum{var(X)}<P, coloredPos(P).
started(X-1,P) :- started(X,P), leafWeightCardinality(X-1,W,C).

:- started(X,P), &sum{var(X)}=P, posColor(P,green).

leafPos(X,P) :- &sum{var(X)}=P, dom(X,P),  leafWeightCardinality(X,_,_).
&show{var(X) : leafWeightCardinality(X,_,_)}.
leafWeightCardinality(1,79,81).
leafWeightCardinality(2,13,82).
leafWeightCardinality(3,80,79).
leafWeightCardinality(4,38,66).
leafWeightCardinality(5,65,31).
leafWeightCardinality(6,84,29).
leafWeightCardinality(7,11,91).
leafWeightCardinality(8,62,31).
innerNode(1).
innerNode(2).
innerNode(3).
innerNode(4).
innerNode(5).
innerNode(6).
innerNode(7).
num(8).
max_total_weight(661).
