
/** INPUT AND TRANSLATION **/

vocabulary inputTypes{
	type leaf 
	type weight isa int
	type cardi isa int

	type mwt isa int//useless but for avoiding int
}

vocabulary usefulInput{
	extern vocabulary inputTypes
	leafWeightCardinality(leaf,weight,cardi)
	max_total_weight(mwt)
}

vocabulary uselessInput{
	extern vocabulary inputTypes
	num(int) 
	innerNode(int) 
}

vocabulary input{
	extern vocabulary usefulInput
	extern vocabulary uselessInput
}

vocabulary translatedInput{
	extern vocabulary inputTypes
	weightOf(leaf) : weight
	cardOf(leaf) : cardi
	max_weight:mwt
}

vocabulary translationVoc{
	extern vocabulary usefulInput
	extern vocabulary translatedInput
}

theory translationTheo : translationVoc{
	{
		weightOf(l) = w <- leafWeightCardinality(l,w,c).
		cardOf(l) = c <- leafWeightCardinality(l,w,c).
		max_weight = w <- max_total_weight(w).
	}
}

/** EXTRA INPUT **/
vocabulary extraInput{
	type color isa string
	type position isa int
	type possibleCost isa int
}

structure extraStruc: extraInput{
	color={"none";"red";"blue";"green"}
}

/** PROBLEM SPECIFICATION **/
vocabulary problemInput{
	extern vocabulary translatedInput
	extern vocabulary extraInput
}

vocabulary problemVoc{
	extern vocabulary problemInput
	//NEEDED FOR COMPETITION
	leafPos(leaf) : position 

	//EXTRA
	colorOf(leaf):color

	neighbours(leaf,leaf)

	costOf(leaf) : possibleCost
	
}

theory solution : problemVoc{
	//Only the first leaf is uncolored
	!l : colorOf(l) = "none" <=> leafPos(l) = 0.
	
	//Cost of leaves can be calculated in terms of their color.
	!l : colorOf(l) = "none" => costOf(l) = weightOf(l).
	!l : colorOf(l) = "green" => costOf(l) = weightOf(l) + cardOf(l).
	!l l': colorOf(l) = "red" &  neighbours(l',l) => costOf(l) = costOf(l') + weightOf(l).
	!l l': colorOf(l) = "blue" & neighbours(l',l) => costOf(l) = costOf(l') + cardOf(l).
	
	//shared tseitin
	!l l': neighbours(l',l) <=>  leafPos(l') = leafPos(l) - 1.

	//TOTAL COST IS SMALL ENOUGH
	sum{l:colorOf(l) ~= "none":costOf(l)} =< max_weight.

	//leafpos is a bijection
	!p: #{l: leafPos(l)=p} = 1.


	//REDUNDANT CONSTRAINTS

	//You can always color a node green. If this reduces its cost, do so!
	!l: costOf(l) =< weightOf(l) + cardOf(l).

	//cost has minimum value
	!l: costOf(l) >= weightOf(l) | costOf(l) >= cardOf(l).
}

vocabulary postprocessVoc{
	extern vocabulary problemVoc
	partial posColor(position): color
	leafAt(position):leaf

}

theory postprocessTheo : postprocessVoc{
//leafAt and leafPos are each other's inverse
	{
		! l p : leafAt(p) = l <- leafPos(l) = p.
	}

	{
		posColor(p) = c <- p>0 & colorOf(leafAt(p)) = c.
	}
}
include<table_utils>

procedure preprocess(struc){
	setvocabulary(struc,translationVoc)
	struc = modelexpand(translationTheo,struc)[1]
	setvocabulary(struc,problemInput)
	setvocabulary(extraStruc,problemInput)
	struc = merge(struc,extraStruc)
	local nb = #totable(struc[input::leaf.type])
	inter = range(0,nb-1)
	struc[extraInput::position.type]=inter
	local maxcost = struc[translatedInput::max_weight]()
	costinter = range(0,maxcost)
	struc[extraInput::possibleCost.type]=costinter
	setvocabulary(struc,problemVoc)
	return struc
}

procedure postprocess(struc){
	if struc == nil then
		print("INCONSISTENT")
		return 20
	else
		setvocabulary(struc,postprocessVoc)
		local newStruc = modelexpand(postprocessTheo,struc)[1]
		printfacts("leafPos", newStruc[problemVoc::leafPos].graph.ct)
		printfacts("posColor", newStruc[postprocessVoc::posColor].graph.ct)
		print("")
		return 10
	end

}

procedure main(){
	newS = preprocess(S)
	setoptions()	
	sol = modelexpand(solution,newS)[1]
	return postprocess(sol)

}

procedure printfacts(name,table) {
	for t in tuples(table) do
		local fact = name
		fact = fact .. "("
		local i = 1
		while i < #t do 
			fact = fact .. t[i]
			fact = fact .. ","
			i = i + 1
		end
		fact = fact .. t[#t] .. "). "
		io.write(fact)
	end
}

procedure setoptions(){
	stdoptions.groundwithbounds=false
	stdoptions.liftedunitpropagation=false
	stdoptions.cpsupport=true
}
factlist S : input {
leafWeightCardinality(1,8,33).
leafWeightCardinality(2,53,60).
leafWeightCardinality(3,27,94).
leafWeightCardinality(4,14,88).
leafWeightCardinality(5,42,90).
leafWeightCardinality(6,88,23).
leafWeightCardinality(7,28,91).
leafWeightCardinality(8,18,27).
innerNode(1).
innerNode(2).
innerNode(3).
innerNode(4).
innerNode(5).
innerNode(6).
innerNode(7).
num(8).
max_total_weight(456).
}
