# Benchmarks for Multi-shot ASP solving with clingo

To run a benchmark instance use the `scripts/clingo-4.5.4.py` script. It
produces JSON output including computed answer sets and per step statistics.

The script requires python 2.7 and the gringo 4.5.4 module. Python is available
in most linux distributions and the gringo python module should be compiled
from source:

    https://sourceforge.net/projects/potassco/files/clingo/4.5.4/

For example to run the `pddl/blocks-probblocks-09-0.lp` instance in multi mode,
run

    ./scripts/clingo-4.5.4.py multi options/pddl/blocks-probblocks-09-0.lp

Note that the actual encodings and instances reside in the benchmarks folder
and the necessary information to run a benchmark in the files in options. For
information how to call the script, run

    ./scripts/clingo-4.5.4.py --help

The following configurations where used in the paper (run with a timeout of
3000s):
- single
  -  `./scripts/clingo-4.5.4.py single <instance>`
- multi
  -  `./scripts/clingo-4.5.4.py multi <instance> -- --forget-on-step=0`
- multi -heuristic
  -  `./scripts/clingo-4.5.4.py multi <instance> -- --forget-on-step=3`
- multi -nogoods
  -  `./scripts/clingo-4.5.4.py multi <instance> -- --forget-on-step=8`
- multi -heuristic -nogoods
  -  `./scripts/clingo-4.5.4.py multi <instance> -- --forget-on-step=11`

The `--forget-on-step` option is actually a clasp option, to get more
information check the help output of clingo-4.5.4 or clasp-3.1.4.
