/***************************************************************************
                          ctodo.cpp  -  description
                             -------------------
    begin                : Fri Dec 19 2003
    copyright            : (C) 2003 by nomore-dg
    email                : nomore-dg@cs.uni-potsdam.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ctodo.h"
#include "cgraph.h"

namespace NS_NOMORE {
  
/***************************************************************************
 * CColorNode                                                              *
 ***************************************************************************/
CColorNode::CColorNode() {
  CREATEOBJECT("CColorNode");

  _pignore = new CComputeNode();
}

CColorNode::~CColorNode() {
  
  if(_pignore != NULL)
    delete _pignore;

  DELETEOBJECT("CColorNode");
  
}

TTypeEnum CColorNode::GetEnabled() const {
  
  TTypeEnum e = 0;

  if(_pignore->GetType() != type_cn_none)
    e |= type_cn_ignore;

  return e;
  
}

void CColorNode::Enable(TTypeEnum _type) {
  
  if(_pignore != NULL)
    delete _pignore;
    
  if(_type & type_cn_ignore)
    _pignore = new CIgnore();
  else
    _pignore = new CComputeNode();

}

void CColorNode::Disable(TTypeEnum _type) {
  
  TTypeEnum e = GetEnabled();

  if(_pignore != NULL)  delete _pignore;

  if(_type & type_cn_ignore || !(e & type_cn_ignore))
    _pignore = new CComputeNode();
  else
    _pignore = new CIgnore;

}

bool CColorNode::HandleHeadZeroSuccessor(CHeadNode* node, TColor old_color, TColor new_color,
      CGraph* grp, CStack* stack, CTodoLists *todo, CStatusInformation *status, bool secure) {
  CHECK_POINTER("CColorNode::HandleHeadZeroSuccessor(node)" , node);
  CHECK_POINTER("CColorNode::HandleHeadZeroSuccessor(grp)"  , grp);
  CHECK_POINTER("CColorNode::HandleHeadZeroSuccessor(stack)", stack);
  CHECK_POINTER("CColorNode::HandleHeadZeroSuccessor(todo)" , todo);

  TBodyNodeSetIterator ite = node->GetZeroSuccessors().begin();
  TBodyNodeSetIterator end = node->GetZeroSuccessors().end();

  for(; ite!=end; ite++) {
    CBodyNode *bodynode = static_cast<CBodyNode*>(*ite);
  
    // insert into todo-list
    todo->PushProp(bodynode);
    if(new_color == color_plus) {
      bodynode->ModifySupportedCounter(-1);
      if(old_color == color_none)
        bodynode->ModifyWeakSupportedCounter(-1);

      // handle jumping
      if(bodynode->GetColor() == color_minus)
        todo->PushBackProp(bodynode);
    } else 
    if(new_color == color_minus) {
      bodynode->ModifyUnsupportedCounter(-1);
        
      // if the head node is color from weak+ to -
      if(old_color == color_weak_plus)
        bodynode->ModifyWeakSupportedCounter(1);
    } else
    if(new_color == color_weak_plus) {
      bodynode->ModifyWeakSupportedCounter(-1);
      
      // handle jumping
      if(bodynode->GetColor() == color_minus)
        todo->PushBackProp(bodynode);
    } else {
      // if the head node is color from weak+ to ignore
      if(old_color == color_weak_plus)
        bodynode->ModifyWeakSupportedCounter(1);
    } // if
  } // for

  return true;
}

bool CColorNode::HandleHeadOneSuccessor(CHeadNode* node, TColor old_color, TColor new_color,
      CGraph* grp, CStack* stack, CTodoLists *todo, CStatusInformation *status, bool secure) {
  CHECK_POINTER("CColorNode::HandleHeadOneSuccessor(node)" , node);
  CHECK_POINTER("CColorNode::HandleHeadOneSuccessor(grp)"  , grp);
  CHECK_POINTER("CColorNode::HandleHeadOneSuccessor(stack)", stack);
  CHECK_POINTER("CColorNode::HandleHeadOneSuccessor(todo)" , todo);

  TBodyNodeSetIterator ite = node->GetOneSuccessors().begin();
  TBodyNodeSetIterator end = node->GetOneSuccessors().end();

  for(; ite!=end; ite++) {
    CBodyNode *bodynode = *ite;

    // insert into todo-list
    todo->PushProp(bodynode);    
    if(new_color == color_plus) {
      if(old_color != color_weak_plus)
        bodynode->ModifyBlockedCounter(-1);
    } else 
    if(new_color == color_minus) {
      bodynode->ModifyUnblockedCounter(-1);
      // handle jumping
      if(bodynode->GetColor() == color_minus)
        todo->PushBackProp(bodynode);
                             
      // if the head node is color from weak+ to -
      if(old_color == color_weak_plus)
        bodynode->ModifyBlockedCounter(1);
    } else 
    if(new_color == color_weak_plus) {
      if(old_color == color_none)
        bodynode->ModifyBlockedCounter(-1);
    } // if
  } // for

  return true;
}

bool CColorNode::HandleHeadPredecessor(CHeadNode* node, TColor old_color, TColor new_color,
      CGraph* grp, CStack* stack, CTodoLists *todo, CStatusInformation *status, bool secure) {
  CHECK_POINTER("CColorNode::HandleHeadPredecessor(node)" , node);
  CHECK_POINTER("CColorNode::HandleHeadPredecessor(grp)"  , grp);
  CHECK_POINTER("CColorNode::HandleHeadPredecessor(stack)", stack);
  CHECK_POINTER("CColorNode::HandleHeadPredecessor(todo)" , todo);

  TBodyNodeSetIterator ite = node->GetPredecessors().begin();
  TBodyNodeSetIterator end = node->GetPredecessors().end();

  for(; ite!=end; ite++) {    
    CBodyNode *bodynode = static_cast<CBodyNode*>(*ite);

    // if node is colored to + or - dec allsuccscounter
    if(new_color == color_plus || new_color == color_minus)
      bodynode->ModifyAllSuccsColoredCounter(-1);
      
/*    if(bodynode->GetColor() == color_none && bodynode->AllSuccsColored()) { 
      if(!_pignore->Compute(bodynode, old_color, new_color, grp, stack, todo, status, secure))
        return false;        
    } // if
    */
  } // for

  return true;
}

bool CColorNode::HandleBodyZeroPredecessor(CBodyNode* node, TColor old_color, TColor new_color,
      CGraph* grp, CStack* stack, CTodoLists *todo, CStatusInformation *status, bool secure) {
  CHECK_POINTER("CColorNode::HandleBodyZeroPredecessor(node)" , node);
  CHECK_POINTER("CColorNode::HandleBodyZeroPredecessor(grp)"  , grp);
  CHECK_POINTER("CColorNode::HandleBodyZeroPredecessor(stack)", stack);
  CHECK_POINTER("CColorNode::HandleBodyZeroPredecessor(todo)" , todo);

  return false;
}

bool CColorNode::HandleBodyOnePredecessor(CBodyNode* node, TColor old_color, TColor new_color,
      CGraph* grp, CStack* stack, CTodoLists *todo, CStatusInformation *status, bool secure) {
  CHECK_POINTER("CColorNode::HandleBodyOnePredecessor(node)" , node);
  CHECK_POINTER("CColorNode::HandleBodyOnePredecessor(grp)"  , grp);
  CHECK_POINTER("CColorNode::HandleBodyOnePredecessor(stack)", stack);
  CHECK_POINTER("CColorNode::HandleBodyOnePredecessor(todo)" , todo);

  return false;  
}

bool CColorNode::HandleBodySuccessor(CBodyNode* node, TColor old_color, TColor new_color,
      CGraph* grp, CStack* stack, CTodoLists *todo, CStatusInformation *status, bool secure) {
  CHECK_POINTER("CColorNode::HandleBodySuccessor(node)" , node);
  CHECK_POINTER("CColorNode::HandleBodySuccessor(grp)"  , grp);
  CHECK_POINTER("CColorNode::HandleBodySuccessor(stack)", stack);
  CHECK_POINTER("CColorNode::HandleBodySuccessor(todo)" , todo);

  THeadNodeSetIterator ite = node->GetSuccessors().begin();
  THeadNodeSetIterator end = node->GetSuccessors().end();

  for(; ite!=end; ite++) {
    CHeadNode *headnode = *ite;

    if(new_color == color_plus) {
      if(!grp->ColorNode(headnode, new_color, stack, false, color_none, todo, status, secure))
        return false;
    } else 
    if(new_color == color_minus) {
      headnode->ModifyUnsupportedCounter(-1);
      if(headnode->Unsupported()) {
        if(!grp->ColorNode(headnode, new_color, stack, false, color_none, todo, status, secure))
          return false;
      }
      
      // handle jumping
      if(headnode->GetColor() == color_plus || headnode->GetColor() == color_weak_plus)
        todo->PushBackProp(headnode);
    } else
    if(new_color == color_weak_plus) {
      if(!grp->ColorNode(headnode, new_color, stack, false, color_none, todo, status, secure))
        return false;
    } // if    
  } // for
    
  return true;
}

/***************************************************************************
 * CComputeNode                                                            *
 ***************************************************************************/
CComputeNode::CComputeNode() {
  
  CREATEOBJECT("CComputeNode");
  
}

CComputeNode::~CComputeNode() {
  
  DELETEOBJECT("CComputeNode");
  
}

/***************************************************************************
 * CTodo                                                                   *
 ***************************************************************************/
CTodo::CTodo() : CComputeNode() {
  
  CREATEOBJECT("CTodo");
  
}

CTodo::~CTodo() {
  
  DELETEOBJECT("CTodo");
  
}

/***************************************************************************
 * CJumping                                                                *
 ***************************************************************************/
CJumping::CJumping() : CComputeNode() {
  
  CREATEOBJECT("CJumping");
  
}

CJumping::~CJumping() {
  
  DELETEOBJECT("CJumping");
  
}

/***************************************************************************
 * CIgnore                                                                 *
 ***************************************************************************/
CIgnore::CIgnore() : CComputeNode() {
  
  CREATEOBJECT("CIgnore");
  
}

CIgnore::~CIgnore() {
  
  DELETEOBJECT("CIgnore");
  
}

} // NS_NOMORE
