/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#ifndef LIBNOMORE_ATOM_H
#define LIBNOMORE_ATOM_H

#include <string>

//! Contains the types and functions of the NoMoRe++ library.
namespace NS_NOMORE {

//! Atom class representing an atom of a logic program.
class Atom {
public:
  //! Constructs an atom with unique identifier and a name.
  /*! \param id A unique identifier, e.g. created by the grounding program lparse.
   *  \param name atom's name as known by the logic program.
   *  \pre The id must be unique for the logic program. */
  explicit Atom(long id, const std::string& name = "");

  //! Returns the atom's unique identifier.
  /*! The unique identifier is typicaly generated by the lparse grounder. */
  long getId() const;

  //! Returns the current name of the atom.
  /*! The name is the grounded name of the atom in the logic program. */
  const std::string& getName() const;

  //! Sets the atom's name.
  /*! The name is the grounded name of the atom in the logic program. */
  void setName(const std::string& name);

  //! Id-based less-then-comparison.
  /*! \return Returns true, iff id < other.id. */
  bool operator<(const Atom& other) const;

  //! Id-based equality-comparison.
  /*! \return Returns true, iff id == other.id. */
  bool operator==(const Atom& other) const;

private:
  //! The unique identifier of the atom.
  /*! The unique identifier is typicaly generated by the lparse grounder. */
  long id_;

  //! The name of the atom.
  /*! The name is the grounded name of the atom in the logic program. */
  std::string name_;
};

} // NS_NOMORE

#endif
