/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#ifndef LIBNOMORE_GENERIC_VALUE_H_INCLUDED
#define LIBNOMORE_GENERIC_VALUE_H_INCLUDED
#if defined (_MSC_VER) && _MSC_VER <= 1300
#pragma warning (disable : 4786)
#endif
#include <stdexcept>
namespace NS_NOMORE {

/*!
 * base class that represents a "generic" value.
 */
class ValueBase {
public:
  ValueBase();
  virtual ~ValueBase() = 0;
private:
  ValueBase(const ValueBase&);
  ValueBase& operator=(const ValueBase&);
};

/*!
 * wraps a value of type T
 */
template <class T>
class ValueHolder : public ValueBase {
public:
  ValueHolder(const T& v = T())
    : value_(v) {
  }
  T& value() {
    return value_;
  }
  const T& value() const {
    return value_;
  }
private:
  T value_;
};

/*!
 * tries to downcast val to V.
 * If the downcast fails a std::bad_cast exception is thrown
 * \param val pointer to the value that should be casted
 * \note the second parameter is a dummy-parameter used to workaround
 * a bug in the VC 6.0-Compiler.
 */
template <class V>
inline V& value_cast(ValueBase* val, V* = 0) {
  if (ValueHolder<V>* rv = dynamic_cast<ValueHolder<V>*>(val))
    return rv->value();
  throw std::bad_cast();
}

/*!
 * const overload of value_cast(ValueBase* val, V*)
 */
template <class V>
inline const V& value_cast(const ValueBase* val, V* = 0) {
  return value_cast<V>(const_cast<ValueBase*>(val));
}

}
#endif
