/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#include <atom.h>

namespace NS_NOMORE {

Atom::Atom(long id, const std::string& name) : id_(id), name_(name) {
}

long Atom::getId() const {
  return id_;
}
 
const std::string& Atom::getName() const {
  return name_;
}

void Atom::setName(const std::string& name) {
  name_ = name;
}

bool Atom::operator<(const Atom& a) const {
  return id_ < a.getId();
}

bool Atom::operator==(const Atom& a) const {
  return id_ == a.getId();
}

} // NS_NOMORE
