/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#include <operator_string_parser.h>
#include <cctype>
#include <sstream>
using namespace std;
namespace NS_NOMORE {

OperatorStringParser::SyntaxError::SyntaxError(const std::string& str)
  : std::runtime_error(str) {

}

  

OperatorStringParser::OperatorStringParser()
  : currentToken_(T_EOF)
  , tokenVal_("")
  , p_(0) {
}

OperatorStringParser::~OperatorStringParser() {

}

bool OperatorStringParser::parse(const std::string& str) {
  p_ = str.c_str();
  currentToken_ = nextToken();
  while (currentToken_ != T_EOF) {
    opStr();
  }
  return true;
}

///////////////////////////////////////////////////////////////////////////////
// Parsing
///////////////////////////////////////////////////////////////////////////////

void OperatorStringParser::opStr() {
  if (currentToken_ == OP) {
    addOperator(tokenVal_);
    match(OP);
  }
  else {
    seq();
  }
}

void OperatorStringParser::seq() {
  match(LPARAN);
  startSequence();
  seqList();
  match(RPARAN);
  bool cl = false;
  if (currentToken_ == CLOSURE) {
    match(CLOSURE);
    cl = true;
  }
  endSequence(cl);
}

void OperatorStringParser::seqList() {
  if (currentToken_ == LPARAN){
    seq();
    match(COMMA);
    seqOptList();
  }
  else {
    optList();
  }
}

void OperatorStringParser::seqOptList() {
  if (currentToken_ == LPARAN) {
    seq();
    if (currentToken_ == COMMA) {
      match(COMMA);
      seqOptList();
    }
  }
  else {
    optList();
  }
}

void OperatorStringParser::optList() {
  std::string op = tokenVal_;
  match(OP);
  addOperator(op);
  if (currentToken_ == COMMA) {
    match(COMMA);
    if (currentToken_ == LPARAN)
      seq();
    else
    optList();
  }
}

void OperatorStringParser::match(Token t) {
  if (currentToken_ == t) {
    currentToken_ = nextToken();
  }
  else {
    error(t);
  }
}

///////////////////////////////////////////////////////////////////////////////
// Error Handling
///////////////////////////////////////////////////////////////////////////////
void OperatorStringParser::error(const char* msg) {
  throw SyntaxError(msg);
}

void OperatorStringParser::error(Token expected) {
  
  std::stringstream err;
  std::string expStr, actStr;
 
  if (expected != OP)
    expStr += char(expected);
  else
    expStr += "Operator";

  if (currentToken_ == OP)
    actStr = "Operator";
  else if (currentToken_ == T_EOF)
    actStr = "EOS";
  else
    actStr += char(currentToken_);

  err << "parse error: missing '"
      << expStr << "' before '"
      << actStr << "'";
  if (currentToken_ == OP)
    err << "(" << tokenVal_ << ")";
  err << '\n';
  throw SyntaxError(err.str());
}

///////////////////////////////////////////////////////////////////////////////
// Lexing
///////////////////////////////////////////////////////////////////////////////
OperatorStringParser::Token OperatorStringParser::nextToken() {
  tokenVal_ = "";
  for (; *p_ && isspace(static_cast<unsigned char>(*p_)); ++p_)
    ;
  switch(*p_) {
  case LPARAN:  // intentionally
  case RPARAN:  // fall
  case COMMA:   // through
  case CLOSURE: // 
    return static_cast<Token>(*p_++);
  case T_EOF:
    return T_EOF;
  default:
    if (isalnum(static_cast<unsigned char>(*p_))) {
      do {
        tokenVal_ += *p_++;
      } while (*p_ && isalnum(static_cast<unsigned char>(*p_)));
      return OP;
    }
    else {
      error("unrecognized token!");
    }
  }
  return T_EOF;
}

}
