/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#if defined (_MSC_VER) && _MSC_VER <= 1300
#pragma warning (disable : 4786)
#endif

#include <operators/post_operator.h>
#include <operators/unfounded_set.h>
#include <body_node.h>
#include <head_node.h>
#include <graph.h>
namespace NS_NOMORE {

PostOperator::PostOperator(Graph& grp) : GraphOperator(PostOperator::getOpName(), grp) {
}

bool PostOperator::execute() {
  if (getGraph().countWeakColoredNodes() != 0)
    throw ColorError();
  bool changed = colorBodyNodes();
  return changed | colorHeadNodes();
}

bool PostOperator::colorHeadNodes() {
  bool value = false;
  Graph& g = getGraph();
  for (HeadNode* n = 0; (n = g.getFirstUncoloredHeadNode()) != 0; )
    value |= g.color(*n, Color::minus);
  return value;
}
 
bool PostOperator::colorBodyNodes() {
  bool value = false;
  Graph& g = getGraph();
  for (BodyNode* n = 0; (n = g.getFirstUncoloredBodyNode()) != 0; )
    value |= g.color(*n, Color::minus);
  return value;
}

bool PostOperator::validate(const OpSet& ops) const {
  return ops.count(UnfoundedSetOperator::getOpName()) == 0;
}

}
