/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#if defined (_MSC_VER) && _MSC_VER <= 1300
#pragma warning (disable : 4786)
#endif

#include <operators/unfounded_set_original.h>
#include <operators/unfounded_set.h>
#include <body_node.h>
#include <head_node.h>
#include <graph.h>
#ifdef KDEVELOP
  #include "functors.h"
#else
  #include "../detail/functors.h"
#endif
#if defined (_MSC_VER) && _MSC_VER <= 1300
#define for if(0); else for
#endif

namespace NS_NOMORE {

OriginalUnfoundedSetOperator::OriginalUnfoundedSetOperator(Graph& grp) 
  : GraphOperator(OriginalUnfoundedSetOperator::getOpName(), grp) {
  
  event::ChannelManager &em = grp.getEventManager();

  em.getChannelFor(event::Event<GraphConstructionFinished>()).connect(*this);
}

bool OriginalUnfoundedSetOperator::execute() {
  initExecution();
  while(propagateHeadNodes() || propagateBodyNodes());
  return colorMaxUnsuppedHeadNode() | colorMaxUnsuppedBodyNode();
}

void OriginalUnfoundedSetOperator::handle(const GraphConstructionFinished&) {  
  for(Graph::BodyNodeIterator it = getGraph().bodyNodesBegin(); it != getGraph().bodyNodesEnd(); ++it) {
    BodyNode *node = *it;
    if(node->zeroPredecessorsBegin() == node->zeroPredecessorsEnd()) {
      bodyNodeWithoutPositivePreconditions_.push_back(node);

      for(BodyNode::HeadNodeIterator hit = node->successorsBegin(); hit != node->successorsEnd(); ++hit)
        headNodeWithoutPositivePreconditions_.push_back(*hit);
    }
  }
}

void OriginalUnfoundedSetOperator::postExecute() {
  reachedNodes_.clear();
}

bool OriginalUnfoundedSetOperator::isReached(long id) {
  return reachedNodes_.find(id) != reachedNodes_.end();
}

bool OriginalUnfoundedSetOperator::isSupported(const BodyNode& node) {
  for(BodyNode::HeadNodeIterator it = node.zeroPredecessorsBegin(); it != node.zeroPredecessorsEnd(); ++it) {
    if(!isReached( (*it)->getId() ))
      return false;
  }
  return true;
}

bool OriginalUnfoundedSetOperator::isSupported(const HeadNode& node) {
  for(HeadNode::BodyNodeIterator it = node.predecessorsBegin(); it != node.predecessorsEnd(); ++it) {
    if(isReached( (*it)->getId() ))
      return true;
  }
  return false;
}

void OriginalUnfoundedSetOperator::initExecution() {

  for(BodyNodeVector::const_iterator it = bodyNodeWithoutPositivePreconditions_.begin(); it != bodyNodeWithoutPositivePreconditions_.end(); ++it) {
    if((*it)->getColor() != Color::minus)
      bodyNodes_.push(*it);
  }

  for(HeadNodeVector::const_iterator it = headNodeWithoutPositivePreconditions_.begin(); it != headNodeWithoutPositivePreconditions_.end(); ++it) {
    if((*it)->getColor() != Color::minus)
      headNodes_.push(*it);
  }
}

bool OriginalUnfoundedSetOperator::propagateHeadNodes() {
  bool res = false;
  while(!headNodes_.empty()) {
    HeadNode *node = headNodes_.front();
    headNodes_.pop();

    if(!isReached(node->getId()) && isSupported(*node) && node->getColor() != Color::minus) {
      reachedNodes_.insert(node->getId());
      addSuccessors(*node);
      res = true;
    }
  }
  return res;
}

bool OriginalUnfoundedSetOperator::propagateBodyNodes() {
  bool res = false;
  while(!bodyNodes_.empty()) {
    BodyNode *node = bodyNodes_.front();
    bodyNodes_.pop();

    if(!isReached(node->getId()) && isSupported(*node) && node->getColor() != Color::minus) {
      reachedNodes_.insert(node->getId());
      addSuccessors(*node);
      res = true;
    }
  }
  return res;
}

void OriginalUnfoundedSetOperator::addSuccessors(const HeadNode& node) {
  for(HeadNode::BodyNodeIterator it = node.zeroSuccessorsBegin(); it != node.zeroSuccessorsEnd(); ++it) {
    bodyNodes_.push(*it);
  }
}

void OriginalUnfoundedSetOperator::addSuccessors(const BodyNode& node) {
  for(BodyNode::HeadNodeIterator it = node.successorsBegin(); it != node.successorsEnd(); ++it) {
    headNodes_.push(*it);
  }
}

bool OriginalUnfoundedSetOperator::colorMaxUnsuppedBodyNode() {
  bool res = false;
  for(Graph::BodyNodeIterator it = getGraph().bodyNodesBegin(); it != getGraph().bodyNodesEnd();++it) {
    if(!isReached((*it)->getId())) {      
      res |= getGraph().color(**it, Color::minus);
    }
  }
  return res;
}

bool OriginalUnfoundedSetOperator::colorMaxUnsuppedHeadNode() {
  bool res = false;
  for(Graph::HeadNodeIterator it = getGraph().headNodesBegin(); it != getGraph().headNodesEnd();++it) {
    if(!isReached((*it)->getId())) {      
      res |= getGraph().color(**it, Color::minus);
    }
  } 
  return res;
}

bool OriginalUnfoundedSetOperator::validate(const OpSet& ops) const {
  return ops.count(UnfoundedSetOperator::getOpName()) == 0;
}

}
