#include "atom_test.h"
#include <atom.h>
using namespace NS_NOMORE;
namespace NS_NOMORE_TESTS {

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( AtomTest );

void AtomTest::setUp() {
}

void AtomTest::tearDown() {
}

void AtomTest::testAtomEquality() {
  Atom atom1(1);
  Atom atom2(2);
  Atom atom3(3);

  CPPUNIT_ASSERT_EQUAL(  true, atom1 == atom1);
  CPPUNIT_ASSERT_EQUAL( false, atom1 == atom2);
  CPPUNIT_ASSERT_EQUAL( false, atom1 == atom3);

  CPPUNIT_ASSERT_EQUAL( false, atom2 == atom1);
  CPPUNIT_ASSERT_EQUAL(  true, atom2 == atom2);
  CPPUNIT_ASSERT_EQUAL( false, atom2 == atom3);

  CPPUNIT_ASSERT_EQUAL( false, atom3 == atom1);
  CPPUNIT_ASSERT_EQUAL( false, atom3 == atom2);
  CPPUNIT_ASSERT_EQUAL(  true, atom3 == atom3);
}

void AtomTest::testAtomLessComparison() {
  Atom atom1(1);
  Atom atom2(2);
  Atom atom3(3);

  CPPUNIT_ASSERT_EQUAL( false, atom1 < atom1);
  CPPUNIT_ASSERT_EQUAL(  true, atom1 < atom2);
  CPPUNIT_ASSERT_EQUAL(  true, atom1 < atom3);

  CPPUNIT_ASSERT_EQUAL( false, atom2 < atom1);
  CPPUNIT_ASSERT_EQUAL( false, atom2 < atom2);
  CPPUNIT_ASSERT_EQUAL(  true, atom2 < atom3);

  CPPUNIT_ASSERT_EQUAL( false, atom3 < atom1);
  CPPUNIT_ASSERT_EQUAL( false, atom3 < atom2);
  CPPUNIT_ASSERT_EQUAL( false, atom3 < atom3);
}

} // NS_NOMORE_TESTS
