#if defined (_MSC_VER) && _MSC_VER <= 1200
#define for if(0);else for
#endif
#include <cppunit/TestFixture.h>
#include <cppunit/TestAssert.h>
#include <cppunit/extensions/HelperMacros.h>
#include <event/channel_manager.h>
using namespace event;
namespace {
	struct MultiHandler
	{
		MultiHandler()
			: events_(0)
		{}
		template <class T>
		void handle(const T&)
		{
			++events_;
		}
		int events_;
	};
}
class TestChannelManager : public CppUnit::TestFixture
{
public:
	void testConnect()
	{
		ChannelManager m;
		MultiHandler h;
		connectTo<EventList<int, double, float> >(m, h);

		CPPUNIT_ASSERT_EQUAL(1u, m.getChannelFor(Event<int>()).numHandlers());
		CPPUNIT_ASSERT_EQUAL(1u, m.getChannelFor(Event<double>()).numHandlers());
		CPPUNIT_ASSERT_EQUAL(1u, m.getChannelFor(Event<float>()).numHandlers());

		m.getChannelFor(Event<int>()).dispatch(1);
		m.getChannelFor(Event<double>()).dispatch(2.0);
		m.getChannelFor(Event<float>()).dispatch(3.0);

		CPPUNIT_ASSERT_EQUAL(3, h.events_);
	}
	void testDisconnect()
	{
		ChannelManager m;
		MultiHandler h;
		connectTo<EventList<int, double, float> >(m, h);
		disconnectFrom<EventList<int, double> >(m, h);
		CPPUNIT_ASSERT_EQUAL(0u, m.getChannelFor(Event<int>()).numHandlers());
		CPPUNIT_ASSERT_EQUAL(0u, m.getChannelFor(Event<double>()).numHandlers());
		CPPUNIT_ASSERT_EQUAL(1u, m.getChannelFor(Event<float>()).numHandlers());

		m.getChannelFor(Event<int>()).dispatch(1);
		m.getChannelFor(Event<double>()).dispatch(2.0);
		m.getChannelFor(Event<float>()).dispatch(3.0);

		CPPUNIT_ASSERT_EQUAL(1, h.events_);

		disconnectFrom<EventList<float> >(m, h);
		CPPUNIT_ASSERT_EQUAL(0u, m.getChannelFor(Event<float>()).numHandlers());
	}

	void testDestroy()
	{
		ChannelManager m;
		MultiHandler h;
		m.getChannelFor(Event<int>()).connect(h);
		m.destroyChannelFor(Event<int>());
		CPPUNIT_ASSERT_EQUAL(0u, m.getChannelFor(Event<int>()).numHandlers());
	}
	void testDispatch()
	{
		ChannelManager m;
		MultiHandler h;
		m.getChannelFor(Event<int>()).connect(h);
		m.dispatch(1);
		CPPUNIT_ASSERT_EQUAL(1, h.events_);
	}
	CPPUNIT_TEST_SUITE( TestChannelManager );
		CPPUNIT_TEST(testConnect);
		CPPUNIT_TEST(testDisconnect);
		CPPUNIT_TEST(testDestroy);
		CPPUNIT_TEST(testDispatch);
	CPPUNIT_TEST_SUITE_END();
private:
};

CPPUNIT_TEST_SUITE_REGISTRATION( TestChannelManager );

