#include "graph_test.h"
#include <graph.h>
#include <head_node.h>
#include <body_node.h>
#include "test_common.h"
using namespace NS_NOMORE;
using namespace std;

namespace NS_NOMORE_TESTS {

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( GraphTest );

void GraphTest::setUp() {
  graph = new Graph();
}

void GraphTest::tearDown() {
  delete graph;
}

void GraphTest::testEmpty() {
	
	CPPUNIT_ASSERT_EQUAL( 0u, graph->countNodes() );
	CPPUNIT_ASSERT_EQUAL( 0u, graph->countUncoloredNodes() );
}

void GraphTest::testInsertBodyNode() {
  
  
  BodyNode* bodynode1 = graph->insertBodyNode();
  
  CPPUNIT_ASSERT_EQUAL( bodynode1,      graph->getBodyNode(bodynode1->getId()) );
  CPPUNIT_ASSERT_EQUAL( 1u, graph->countNodes());
  CPPUNIT_ASSERT_EQUAL( 1u, graph->countUncoloredNodes());

  BodyNode* bodynode2 = graph->insertBodyNode();

  CPPUNIT_ASSERT_EQUAL( bodynode2,      graph->getBodyNode(bodynode2->getId()) );
  CPPUNIT_ASSERT_EQUAL( 2u, graph->countNodes());
  CPPUNIT_ASSERT_EQUAL( 2u, graph->countUncoloredNodes());
  
}

void GraphTest::testInsertHeadNode() {
  
  
  HeadNode* headnode1 = graph->insertHeadNode(1);
  CPPUNIT_ASSERT_EQUAL( headnode1,      graph->getHeadNode(1) );
  CPPUNIT_ASSERT_EQUAL( 1u, graph->countNodes());
  CPPUNIT_ASSERT_EQUAL( 1u, graph->countUncoloredNodes());

  HeadNode* headnode2 = graph->insertHeadNode(2);
  CPPUNIT_ASSERT_EQUAL( headnode2,      graph->getHeadNode(2) );
  CPPUNIT_ASSERT_EQUAL( 2u, graph->countNodes());
  CPPUNIT_ASSERT_EQUAL( 2u, graph->countUncoloredNodes());

  HeadNode* headnode3 = graph->insertHeadNode(1);	// reinsert
  CPPUNIT_ASSERT_EQUAL( 2u, graph->countNodes());
  CPPUNIT_ASSERT_EQUAL( 2u, graph->countUncoloredNodes());
  CPPUNIT_ASSERT(headnode3 == headnode1);
}

void GraphTest::testSetColor() {
  
  /* (1) none -> ignore
     (2) none -> weak_plus
     (3) none -> plus
     (4) none -> minus
  
     (5) ignore -> weak_plus
     (6) ignore -> plus
     (7) ignore -> minus

     (8) weak_plus -> plus
  */

  
  HeadNode* headnode1 = graph->insertHeadNode(1);
  HeadNode* headnode2 = graph->insertHeadNode(2);
  BodyNode* bodynode3 = graph->insertBodyNode();
  BodyNode* bodynode4 = graph->insertBodyNode();
  BodyNode* bodynode5 = graph->insertBodyNode();
  BodyNode* bodynode6 = graph->insertBodyNode();
  BodyNode* bodynode7 = graph->insertBodyNode();
  BodyNode* bodynode8 = graph->insertBodyNode();
  
  CPPUNIT_ASSERT_EQUAL( 8u, graph->countUncoloredNodes() );
  
  
  CPPUNIT_ASSERT_EQUAL( true, graph->color(*headnode1, Color::ignore) );

  CPPUNIT_ASSERT_EQUAL( 7u, graph->countUncoloredNodes() );
  CPPUNIT_ASSERT_EQUAL( Color::ignore, headnode1->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, headnode2->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode3->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode4->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode5->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode6->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode7->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode8->getColor() );

  CPPUNIT_ASSERT_EQUAL( true, graph->color(*headnode2, Color::weak_plus) );

  CPPUNIT_ASSERT_EQUAL( 7u, graph->countUncoloredNodes() );
  CPPUNIT_ASSERT_EQUAL( Color::ignore, headnode1->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, headnode2->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode3->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode4->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode5->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode6->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode7->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode8->getColor() );

  CPPUNIT_ASSERT_EQUAL( true, graph->color(*bodynode3, Color::plus) );

  CPPUNIT_ASSERT_EQUAL( 6u, graph->countUncoloredNodes() );
  CPPUNIT_ASSERT_EQUAL( Color::ignore, headnode1->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, headnode2->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus, bodynode3->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode4->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode5->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode6->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode7->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode8->getColor() );

  CPPUNIT_ASSERT_EQUAL( true, graph->color(*bodynode4, Color::minus) );

  CPPUNIT_ASSERT_EQUAL( 5u, graph->countUncoloredNodes() );
  CPPUNIT_ASSERT_EQUAL( Color::ignore, headnode1->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, headnode2->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus, bodynode3->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::minus, bodynode4->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode5->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode6->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode7->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode8->getColor() );

  CPPUNIT_ASSERT_EQUAL( true, graph->color(*bodynode5, Color::ignore) );

  CPPUNIT_ASSERT_EQUAL( 4u, graph->countUncoloredNodes() );
  CPPUNIT_ASSERT_EQUAL( Color::ignore, headnode1->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, headnode2->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus, bodynode3->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::minus, bodynode4->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::ignore, bodynode5->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode6->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode7->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode8->getColor() );

  CPPUNIT_ASSERT_EQUAL( true, graph->color(*bodynode5, Color::weak_plus) );

  CPPUNIT_ASSERT_EQUAL( 5u, graph->countUncoloredNodes() );
  CPPUNIT_ASSERT_EQUAL( Color::ignore, headnode1->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, headnode2->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus, bodynode3->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::minus, bodynode4->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, bodynode5->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode6->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode7->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode8->getColor() );

  CPPUNIT_ASSERT_EQUAL( true, graph->color(*bodynode6, Color::ignore) );

  CPPUNIT_ASSERT_EQUAL( 4u, graph->countUncoloredNodes() );
  CPPUNIT_ASSERT_EQUAL( Color::ignore, headnode1->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, headnode2->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus, bodynode3->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::minus, bodynode4->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, bodynode5->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::ignore, bodynode6->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode7->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode8->getColor() );

  CPPUNIT_ASSERT_EQUAL( true, graph->color(*bodynode6, Color::plus) );

  CPPUNIT_ASSERT_EQUAL( 4u, graph->countUncoloredNodes() );
  CPPUNIT_ASSERT_EQUAL( Color::ignore, headnode1->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, headnode2->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus, bodynode3->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::minus, bodynode4->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, bodynode5->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus, bodynode6->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode7->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode8->getColor() );

  CPPUNIT_ASSERT_EQUAL( true, graph->color(*bodynode7, Color::ignore) );

  CPPUNIT_ASSERT_EQUAL( 3u, graph->countUncoloredNodes() );
  CPPUNIT_ASSERT_EQUAL( Color::ignore, headnode1->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, headnode2->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus, bodynode3->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::minus, bodynode4->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, bodynode5->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus, bodynode6->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::ignore, bodynode7->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode8->getColor() );

  CPPUNIT_ASSERT_EQUAL( true, graph->color(*bodynode7, Color::minus) );

  CPPUNIT_ASSERT_EQUAL( 3u, graph->countUncoloredNodes() );
  CPPUNIT_ASSERT_EQUAL( Color::ignore, headnode1->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, headnode2->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus, bodynode3->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::minus, bodynode4->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, bodynode5->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus, bodynode6->getColor() );  
  CPPUNIT_ASSERT_EQUAL( Color::minus, bodynode7->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode8->getColor() );

  CPPUNIT_ASSERT_EQUAL( true, graph->color(*bodynode8, Color::weak_plus) );

  CPPUNIT_ASSERT_EQUAL( 3u, graph->countUncoloredNodes() );
  CPPUNIT_ASSERT_EQUAL( Color::ignore, headnode1->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, headnode2->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus, bodynode3->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::minus, bodynode4->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, bodynode5->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus, bodynode6->getColor() );  
  CPPUNIT_ASSERT_EQUAL( Color::minus, bodynode7->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, bodynode8->getColor() );

  CPPUNIT_ASSERT_EQUAL( true, graph->color(*bodynode8, Color::plus) );

  CPPUNIT_ASSERT_EQUAL( 2u, graph->countUncoloredNodes() );
  CPPUNIT_ASSERT_EQUAL( Color::ignore, headnode1->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, headnode2->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus, bodynode3->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::minus, bodynode4->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, bodynode5->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus, bodynode6->getColor() );  
  CPPUNIT_ASSERT_EQUAL( Color::minus, bodynode7->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus, bodynode8->getColor() );

}

void GraphTest::testRestoreColor() {
  
  /* (1) none <- ignore
     (2) none <- weak_plus
     (3) none <- plus
     (4) none <- minus
  
     (5) ignore <- weak_plus
     (6) ignore <- plus
     (7) ignore <- minus

     (8) weak_plus <-> plus
  */

  
  HeadNode* headnode1 = graph->insertHeadNode(1);
  HeadNode* headnode2 = graph->insertHeadNode(2);
  BodyNode* bodynode3 = graph->insertBodyNode();
  BodyNode* bodynode4 = graph->insertBodyNode();
  BodyNode* bodynode5 = graph->insertBodyNode();
  BodyNode* bodynode6 = graph->insertBodyNode();
  BodyNode* bodynode7 = graph->insertBodyNode();
  BodyNode* bodynode8 = graph->insertBodyNode();
  

  CPPUNIT_ASSERT_EQUAL( true, graph->color(*headnode1, Color::ignore) );
  CPPUNIT_ASSERT_EQUAL( true, graph->color(*headnode2, Color::weak_plus) );
  CPPUNIT_ASSERT_EQUAL( true, graph->color(*bodynode3, Color::plus) );
  CPPUNIT_ASSERT_EQUAL( true, graph->color(*bodynode4, Color::minus) );
  CPPUNIT_ASSERT_EQUAL( true, graph->color(*bodynode5, Color::weak_plus) );
  CPPUNIT_ASSERT_EQUAL( true, graph->color(*bodynode6, Color::plus) );
  CPPUNIT_ASSERT_EQUAL( true, graph->color(*bodynode7, Color::minus) );
  CPPUNIT_ASSERT_EQUAL( true, graph->color(*bodynode8, Color::plus) );

  /* 
     (2) none <- weak_plus
     (3) none <- plus
     (4) none <- minus
  
     (5) ignore <- weak_plus
     (6) ignore <- plus
     (7) ignore <- minus

     (8) weak_plus <-> plus
  */

  CPPUNIT_ASSERT_EQUAL( 2u, graph->countUncoloredNodes() );
  CPPUNIT_ASSERT_EQUAL( Color::ignore   , headnode1->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, headnode2->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus     , bodynode3->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::minus    , bodynode4->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, bodynode5->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus     , bodynode6->getColor() );  
  CPPUNIT_ASSERT_EQUAL( Color::minus    , bodynode7->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus     , bodynode8->getColor() );

  graph->restore(*headnode1, Color::none);

  CPPUNIT_ASSERT_EQUAL( 3u, graph->countUncoloredNodes() );
  CPPUNIT_ASSERT_EQUAL( Color::none     , headnode1->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, headnode2->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus     , bodynode3->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::minus    , bodynode4->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, bodynode5->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus     , bodynode6->getColor() );  
  CPPUNIT_ASSERT_EQUAL( Color::minus    , bodynode7->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus     , bodynode8->getColor() );

  graph->restore(*headnode2, Color::none);

  CPPUNIT_ASSERT_EQUAL( 3u, graph->countUncoloredNodes() );
  CPPUNIT_ASSERT_EQUAL( Color::none     , headnode1->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none     , headnode2->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus     , bodynode3->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::minus    , bodynode4->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, bodynode5->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus     , bodynode6->getColor() );  
  CPPUNIT_ASSERT_EQUAL( Color::minus    , bodynode7->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus     , bodynode8->getColor() );

  graph->restore(*bodynode3, Color::none);

  CPPUNIT_ASSERT_EQUAL( 4u, graph->countUncoloredNodes() );
  CPPUNIT_ASSERT_EQUAL( Color::none     , headnode1->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none     , headnode2->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none     , bodynode3->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::minus    , bodynode4->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, bodynode5->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus     , bodynode6->getColor() );  
  CPPUNIT_ASSERT_EQUAL( Color::minus    , bodynode7->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus     , bodynode8->getColor() );

  graph->restore(*bodynode4, Color::none);

  CPPUNIT_ASSERT_EQUAL( 5u, graph->countUncoloredNodes() );
  CPPUNIT_ASSERT_EQUAL( Color::none     , headnode1->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none     , headnode2->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none     , bodynode3->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none     , bodynode4->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, bodynode5->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus     , bodynode6->getColor() );  
  CPPUNIT_ASSERT_EQUAL( Color::minus    , bodynode7->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus     , bodynode8->getColor() );

  graph->restore(*bodynode5, Color::ignore);

  CPPUNIT_ASSERT_EQUAL( 4u, graph->countUncoloredNodes() );
  CPPUNIT_ASSERT_EQUAL( Color::none     , headnode1->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none     , headnode2->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none     , bodynode3->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none     , bodynode4->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::ignore   , bodynode5->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus     , bodynode6->getColor() );  
  CPPUNIT_ASSERT_EQUAL( Color::minus    , bodynode7->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus     , bodynode8->getColor() );

  graph->restore(*bodynode6, Color::ignore);

  CPPUNIT_ASSERT_EQUAL( 4u, graph->countUncoloredNodes() );
  CPPUNIT_ASSERT_EQUAL( Color::none     , headnode1->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none     , headnode2->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none     , bodynode3->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none     , bodynode4->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::ignore   , bodynode5->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::ignore   , bodynode6->getColor() );  
  CPPUNIT_ASSERT_EQUAL( Color::minus    , bodynode7->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus     , bodynode8->getColor() );

  graph->restore(*bodynode7, Color::ignore);

  CPPUNIT_ASSERT_EQUAL( 4u, graph->countUncoloredNodes() );
  CPPUNIT_ASSERT_EQUAL( Color::none     , headnode1->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none     , headnode2->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none     , bodynode3->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none     , bodynode4->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::ignore   , bodynode5->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::ignore   , bodynode6->getColor() );  
  CPPUNIT_ASSERT_EQUAL( Color::ignore   , bodynode7->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus     , bodynode8->getColor() );

  graph->restore(*bodynode8, Color::weak_plus);

  CPPUNIT_ASSERT_EQUAL( 5u, graph->countUncoloredNodes() );
  CPPUNIT_ASSERT_EQUAL( Color::none     , headnode1->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none     , headnode2->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none     , bodynode3->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none     , bodynode4->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::ignore   , bodynode5->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::ignore   , bodynode6->getColor() );  
  CPPUNIT_ASSERT_EQUAL( Color::ignore   , bodynode7->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, bodynode8->getColor() );
}

void GraphTest::testClear() {
	long bid = graph->insertBodyNode()->getId();
	graph->insertHeadNode(1);
	graph->clear();
	CPPUNIT_ASSERT_EQUAL(false, graph->hasBodyNode(bid));
	CPPUNIT_ASSERT_EQUAL(false, graph->hasHeadNode(1));
  CPPUNIT_ASSERT_EQUAL(0u, graph->countUncoloredNodes());

}

} // NS_NOMORE_TESTS
