#include <cppunit/TestFixture.h>
#include <cppunit/TestAssert.h>
#include <cppunit/extensions/HelperMacros.h>
#include <heuristics/hybrid_lookahead_heuristic.h>
#include <operators/hybrid_lookahead.h>
#include <head_node.h>
#include <body_node.h>
#include <graph.h>
#include "test_common.h"
using namespace NS_NOMORE;

namespace NS_NOMORE_TESTS {

class HybridLookaheadHeuristicTest : public CppUnit::TestFixture {

  CPPUNIT_TEST_SUITE(HybridLookaheadHeuristicTest);
  CPPUNIT_TEST(testNoChoices);
  CPPUNIT_TEST(testNoValue);
  CPPUNIT_TEST(testMixedValues);
  CPPUNIT_TEST_SUITE_END();

public:
  void setUp() {
    graph = new Graph();
    heu = new HybridLookaheadHeuristic();
    heu->setGraph(*graph);
  }

  void tearDown() {
    delete heu;
    delete graph;
  }

  void testNoChoices() {
    CPPUNIT_ASSERT_EQUAL( (BodyNode*)0, heu->selectBodyNode(noConstraint) );
  }

  void testNoValue() {
    graph->insertBodyNode();
    graph->insertBodyNode();
    graph->insertBodyNode();
    
    CPPUNIT_ASSERT( 0 != heu->selectBodyNode(noConstraint) );
  }

  void testMixedValues() {
    BodyNode* bn[4];
    for (int i = 0; i != 4; ++i)
      bn[i] = graph->insertBodyNode();

    
    bn[0]->installValue(new ValueHolder<HybridLookahead::ResultType>(2));
    bn[2]->installValue(new ValueHolder<HybridLookahead::ResultType>(1));
    bn[3]->installValue(new ValueHolder<HybridLookahead::ResultType>(3));

    CPPUNIT_ASSERT_EQUAL( bn[3], heu->selectBodyNode(noConstraint) );
  }

private:
  NoConstraint noConstraint;
  Graph* graph;
  HybridLookaheadHeuristic* heu;
  
};

CPPUNIT_TEST_SUITE_REGISTRATION(HybridLookaheadHeuristicTest);

} // end namespace NS_NOMORE_TESTS
