#include <cppunit/TestFixture.h>
#include <cppunit/TestAssert.h>
#include <cppunit/extensions/HelperMacros.h>
#include <heuristics/neg_arcs_count.h>
#include <head_node.h>
#include <body_node.h>
#include <graph.h>
#include "test_common.h"
using namespace NS_NOMORE;

namespace NS_NOMORE_TESTS {

class NegativeWeightArcsCountHeuristicsTest : public CppUnit::TestFixture {

  CPPUNIT_TEST_SUITE(NegativeWeightArcsCountHeuristicsTest);
  CPPUNIT_TEST(testCheck1);
  CPPUNIT_TEST(testCheck2);
  CPPUNIT_TEST(testCheck3);
  CPPUNIT_TEST_SUITE_END();

public:
  void setUp() {
    graph = new Graph();
    
    body1 = graph->insertBodyNode();
    body2 = graph->insertBodyNode();
    body3 = graph->insertBodyNode();
    body4 = graph->insertBodyNode();
    
    head1 = graph->insertHeadNode(4);
    head2 = graph->insertHeadNode(5);
    head3 = graph->insertHeadNode(6);
    head4 = graph->insertHeadNode(7);
    head5 = graph->insertHeadNode(7);

    heu = new NegativeWeightArcsCount();
    heu->setGraph(*graph);
  }

  void tearDown() {
    delete graph;
    delete heu;
  }

  void testCheck1() {
    head4->insertOneSuccessor(*body4);
    head5->insertOneSuccessor(*body4);

    head1->insertOneSuccessor(*body1);
    head2->insertOneSuccessor(*body1);
    body1->insertSuccessor(*head4);
    
    head1->insertOneSuccessor(*body2);
    body2->insertSuccessor(*head4);
    body2->insertSuccessor(*head5);

    head1->insertOneSuccessor(*body3);
    head2->insertOneSuccessor(*body3);
    head3->insertOneSuccessor(*body3);
    body3->insertSuccessor(*head4);
    
    graph->finishConstruction();
    CPPUNIT_ASSERT_EQUAL( body2, heu->selectBodyNode(noConstraint) );
  }

  void testCheck2() {
    head4->insertOneSuccessor(*body4);
    head5->insertOneSuccessor(*body4);

    head1->insertOneSuccessor(*body1);
    head2->insertOneSuccessor(*body1);
    body1->insertSuccessor(*head4);
    body1->insertSuccessor(*head5);
    
    head1->insertOneSuccessor(*body2);
    body2->insertSuccessor(*head4);
    body2->insertSuccessor(*head5);

    head1->insertOneSuccessor(*body3);
    head2->insertOneSuccessor(*body3);
    head3->insertOneSuccessor(*body3);
    body3->insertSuccessor(*head4);

    graph->finishConstruction();
    CPPUNIT_ASSERT_EQUAL( body1, heu->selectBodyNode(noConstraint) );
  }

  void testCheck3() {
    head4->insertOneSuccessor(*body4);
    head5->insertOneSuccessor(*body4);

    head1->insertOneSuccessor(*body1);
    head2->insertOneSuccessor(*body1);
    body1->insertSuccessor(*head4);
    body1->insertSuccessor(*head5);
    
    head1->insertOneSuccessor(*body2);
    body2->insertSuccessor(*head4);
    body2->insertSuccessor(*head5);

    head1->insertOneSuccessor(*body3);
    head2->insertOneSuccessor(*body3);
    head3->insertOneSuccessor(*body3);
    body3->insertSuccessor(*head4);
    body3->insertSuccessor(*head5);

    graph->finishConstruction();
    CPPUNIT_ASSERT_EQUAL( body3, heu->selectBodyNode(noConstraint) );
  }

private:
  BodyNode* body1;
  BodyNode* body2;
  BodyNode* body3;
  BodyNode* body4;
  
  HeadNode* head1;
  HeadNode* head2;
  HeadNode* head3;
  HeadNode* head4;
  HeadNode* head5;

  NegativeWeightArcsCount *heu;
  Graph* graph;

  NoConstraint noConstraint;
};

CPPUNIT_TEST_SUITE_REGISTRATION(NegativeWeightArcsCountHeuristicsTest);

} // end namespace NS_NOMORE_TESTS
